/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.StreamTokenizer;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.Behavior;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.TransformGroup;
import org.scijava.java3d.loaders.lw3d.LightIntensityPathInterpolator;
import org.scijava.java3d.loaders.lw3d.LwsEnvelope;
import org.scijava.java3d.loaders.lw3d.LwsEnvelopeFrame;
import org.scijava.vecmath.Point3d;

class LwsEnvelopeLightIntensity
extends LwsEnvelope {
    LwsEnvelopeLightIntensity(StreamTokenizer st, int frames, float time) {
        super(st, frames, time);
    }

    void createJava3dBehaviors(Object target) {
        if (this.numFrames <= 1) {
            this.behaviors = null;
        } else {
            long alphaAtOne = 0L;
            int loopCount = this.loop ? -1 : 1;
            loopCount = -1;
            this.debugOutputLn(2, "totalTime = " + this.totalTime);
            this.debugOutputLn(2, "loopCount = " + loopCount);
            float animTime = 1000.0f * this.totalTime * (float)(this.frames[this.numFrames - 1].getFrameNum() / (double)this.totalFrames);
            this.debugOutputLn(2, " anim time: " + animTime);
            this.debugOutputLn(2, " totalFrames = " + this.totalFrames);
            this.debugOutputLn(2, " lastFrame = " + this.frames[this.numFrames - 1].getFrameNum());
            if (!this.loop) {
                alphaAtOne = (long)(1000.0 * (double)this.totalTime - (double)animTime);
            }
            Alpha theAlpha = new Alpha(loopCount, 1, 0L, 0L, (long)animTime, 0L, alphaAtOne, 0L, 0L, 0L);
            float[] knots = new float[this.numFrames];
            float[] values = new float[this.numFrames];
            for (int i = 0; i < this.numFrames; ++i) {
                values[i] = (float)this.frames[i].getValue();
                knots[i] = (float)this.frames[i].getFrameNum() / (float)this.frames[this.numFrames - 1].getFrameNum();
                this.debugOutputLn(2, "value, knot = " + values[i] + ", " + knots[i]);
            }
            LightIntensityPathInterpolator l = new LightIntensityPathInterpolator(theAlpha, knots, values, target);
            if (l != null) {
                this.behaviors = l;
                BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
                this.behaviors.setSchedulingBounds(bounds);
                ((TransformGroup)target).setCapability(18);
                ((TransformGroup)target).addChild(this.behaviors);
            }
        }
    }

    @Override
    Behavior getBehaviors() {
        return this.behaviors;
    }

    @Override
    LwsEnvelopeFrame getFirstFrame() {
        if (this.numFrames > 0) {
            return this.frames[0];
        }
        return null;
    }

    @Override
    void printVals() {
        this.debugOutputLn(2, "   name = " + this.name);
        this.debugOutputLn(2, "   numChannels = " + this.numChannels);
        this.debugOutputLn(2, "   numFrames = " + this.numFrames);
        this.debugOutputLn(2, "   loop = " + this.loop);
        for (int i = 0; i < this.numFrames; ++i) {
            this.debugOutputLn(2, "       FRAME " + i);
            this.frames[i].printVals();
        }
    }
}

