/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Function;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

public class ImageCalculator<S extends Type<S>, T extends Type<T>, U extends Type<U>>
implements OutputAlgorithm<U>,
MultiThreaded,
Benchmark {
    final Image<S> image1;
    final Image<T> image2;
    final Image<U> output;
    final Function<S, T, U> function;
    long processingTime;
    int numThreads;
    String errorMessage = "";

    public ImageCalculator(Image<S> image1, Image<T> image2, Image<U> output, Function<S, T, U> function) {
        this.image1 = image1;
        this.image2 = image2;
        this.output = output;
        this.function = function;
        this.setNumThreads();
    }

    public ImageCalculator(Image<S> image1, Image<T> image2, ImageFactory<U> factory, Function<S, T, U> function) {
        this(image1, image2, ImageCalculator.createImageFromFactory(factory, image1.getDimensions()), function);
    }

    @Override
    public Image<U> getResult() {
        return this.output;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image1 == null) {
            this.errorMessage = "ImageCalculator: [Image<S> image1] is null.";
            return false;
        }
        if (this.image2 == null) {
            this.errorMessage = "ImageCalculator: [Image<T> image2] is null.";
            return false;
        }
        if (this.output == null) {
            this.errorMessage = "ImageCalculator: [Image<U> output] is null.";
            return false;
        }
        if (this.function == null) {
            this.errorMessage = "ImageCalculator: [Function<S,T,U>] is null.";
            return false;
        }
        if (!this.image1.getContainer().compareStorageContainerDimensions(this.image2.getContainer()) || !this.image1.getContainer().compareStorageContainerDimensions(this.output.getContainer())) {
            this.errorMessage = "ImageCalculator: Images have different dimensions, not supported: Image1: " + Util.printCoordinates(this.image1.getDimensions()) + " Image2: " + Util.printCoordinates(this.image2.getDimensions()) + " Output: " + Util.printCoordinates(this.output.getDimensions());
            return false;
        }
        return true;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        long imageSize = this.image1.getNumPixels();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
        final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, this.numThreads);
        final boolean isCompatible = this.image1.getContainer().compareStorageContainerCompatibility(this.image2.getContainer()) && this.image1.getContainer().compareStorageContainerCompatibility(this.output.getContainer());
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    if (isCompatible) {
                        ImageCalculator.this.computeSimple(myChunk.getStartPosition(), myChunk.getLoopSize());
                    } else {
                        ImageCalculator.this.computeAdvanced(myChunk.getStartPosition(), myChunk.getLoopSize());
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected void computeSimple(long startPos, long loopSize) {
        Cursor<S> cursor1 = this.image1.createCursor();
        Cursor<T> cursor2 = this.image2.createCursor();
        Cursor<U> cursorOut = this.output.createCursor();
        cursor1.fwd(startPos);
        cursor2.fwd(startPos);
        cursorOut.fwd(startPos);
        for (long j = 0L; j < loopSize; ++j) {
            cursor1.fwd();
            cursor2.fwd();
            cursorOut.fwd();
            this.function.compute(cursor1.getType(), cursor2.getType(), cursorOut.getType());
        }
        cursor1.close();
        cursor2.close();
        cursorOut.close();
    }

    protected void computeAdvanced(long startPos, long loopSize) {
        System.out.println(startPos + " -> " + (startPos + loopSize));
        LocalizableByDimCursor<S> cursor1 = this.image1.createLocalizableByDimCursor();
        LocalizableByDimCursor<T> cursor2 = this.image2.createLocalizableByDimCursor();
        LocalizableCursor<U> cursorOut = this.output.createLocalizableCursor();
        cursorOut.fwd(startPos);
        for (long j = 0L; j < loopSize; ++j) {
            cursorOut.fwd();
            cursor1.setPosition(cursorOut);
            cursor2.setPosition(cursorOut);
            this.function.compute(cursor1.getType(), cursor2.getType(), cursorOut.getType());
        }
        cursor1.close();
        cursor2.close();
        cursorOut.close();
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    protected static <U extends Type<U>> Image<U> createImageFromFactory(ImageFactory<U> factory, int[] size) {
        if (factory == null || size == null) {
            return null;
        }
        return factory.createImage(size);
    }
}

