/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.roi;

import mpicbg.imglib.algorithm.ROIAlgorithm;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.special.RegionOfInterestCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.ShortType;

public class DirectConvolution<T extends RealType<T>, R extends RealType<R>, S extends RealType<S>>
extends ROIAlgorithm<T, S> {
    private final Image<R> kernel;
    private final int[] kernelSize;
    private LocalizableByDimCursor<S> outputImageCursor;
    private final LocalizableByDimCursor<R> kernelCursor;
    private final boolean doInvert;

    protected static void quickKernel2D(short[][] vals, Image<ShortType> kern) {
        LocalizableByDimCursor<ShortType> cursor = kern.createLocalizableByDimCursor();
        int[] pos = new int[2];
        for (int i = 0; i < vals.length; ++i) {
            for (int j = 0; j < vals[i].length; ++j) {
                pos[0] = i;
                pos[1] = j;
                cursor.setPosition(pos);
                ((ShortType)cursor.getType()).set(vals[i][j]);
            }
        }
        cursor.close();
    }

    public static Image<ShortType> sobelVertical() {
        ImageFactory<ShortType> factory = new ImageFactory<ShortType>(new ShortType(), new ArrayContainerFactory());
        Image<ShortType> sobel = factory.createImage(new int[]{3, 3}, "Vertical Sobel");
        short[][] vals = new short[][]{{-1, -2, -1}, {0, 0, 0}, {1, 2, 1}};
        DirectConvolution.quickKernel2D(vals, sobel);
        return sobel;
    }

    public static Image<ShortType> sobelHorizontal() {
        ImageFactory<ShortType> factory = new ImageFactory<ShortType>(new ShortType(), new ArrayContainerFactory());
        Image<ShortType> sobel = factory.createImage(new int[]{3, 3}, "Horizontal Sobel");
        short[][] vals = new short[][]{{1, 0, -1}, {2, 0, -2}, {1, 0, -1}};
        DirectConvolution.quickKernel2D(vals, sobel);
        return sobel;
    }

    public DirectConvolution(S type, Image<T> inputImage, Image<R> kernel) {
        this(type, inputImage, kernel, null);
    }

    public DirectConvolution(S type, Image<T> inputImage, Image<R> kernel, OutOfBoundsStrategyFactory<T> outsideFactory) {
        this(type, inputImage, kernel, outsideFactory, true);
    }

    protected DirectConvolution(S type, Image<T> inputImage, Image<R> kernel, OutOfBoundsStrategyFactory<T> outsideFactory, boolean isconv) {
        super(type, inputImage, kernel.getDimensions(), outsideFactory);
        this.kernel = kernel;
        this.outputImageCursor = null;
        this.kernelSize = kernel.getDimensions();
        this.kernelCursor = kernel.createLocalizableByDimCursor();
        this.setName(inputImage.getName() + " * " + kernel.getName());
        this.doInvert = isconv;
    }

    private LocalizableByDimCursor<S> getOutputCursor() {
        if (this.outputImageCursor == null) {
            this.outputImageCursor = this.getOutputImage().createLocalizableByDimCursor();
        }
        return this.outputImageCursor;
    }

    private void invertPosition(int[] pos, int[] invPos) {
        for (int i = 0; i < this.kernel.getNumDimensions(); ++i) {
            invPos[i] = this.kernelSize[i] - pos[i] - 1;
        }
    }

    @Override
    protected boolean patchOperation(int[] position, RegionOfInterestCursor<T> roiCursor) {
        LocalizableByDimCursor<S> outCursor = this.getOutputCursor();
        int[] pos = new int[outCursor.getNumDimensions()];
        int[] invPos = new int[outCursor.getNumDimensions()];
        RealType accum = (RealType)outCursor.getImage().createType();
        RealType mul = (RealType)outCursor.getImage().createType();
        RealType temp = (RealType)outCursor.getImage().createType();
        accum.setZero();
        outCursor.setPosition(position);
        while (roiCursor.hasNext()) {
            mul.setOne();
            roiCursor.fwd();
            roiCursor.getPosition(pos);
            if (this.doInvert) {
                this.invertPosition(pos, invPos);
                this.kernelCursor.setPosition(invPos);
            } else {
                this.kernelCursor.setPosition(pos);
            }
            temp.setReal(((RealType)this.kernelCursor.getType()).getRealDouble());
            temp.setComplex(-((RealType)this.kernelCursor.getType()).getComplexDouble());
            mul.mul(temp);
            temp.setReal(((RealType)roiCursor.getType()).getRealDouble());
            temp.setComplex(((RealType)roiCursor.getType()).getComplexDouble());
            mul.mul(temp);
            accum.add(mul);
        }
        ((RealType)outCursor.getType()).set(accum);
        return true;
    }

    @Override
    public boolean checkInput() {
        if (super.checkInput()) {
            if (this.kernel.getNumDimensions() == this.getOutputImage().getNumActiveCursors()) {
                this.setErrorMessage("Kernel has different dimensionality than the Image");
                return false;
            }
            return true;
        }
        return false;
    }
}

