/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose;

import java.nio.ByteBuffer;
import org.apposed.appose.shm.Shms;

public interface SharedMemory
extends AutoCloseable {
    public static SharedMemory create(long rsize) {
        return SharedMemory.createOrAttach(null, true, rsize);
    }

    public static SharedMemory create(String name, long rsize) {
        return SharedMemory.createOrAttach(name, true, rsize);
    }

    public static SharedMemory attach(String name, long rsize) {
        return SharedMemory.createOrAttach(name, false, rsize);
    }

    public static SharedMemory createOrAttach(String name, boolean create, long rsize) {
        if (rsize < 0L) {
            throw new IllegalArgumentException("'rsize' must be a positive integer");
        }
        if (create && rsize == 0L) {
            throw new IllegalArgumentException("'rsize' must be a positive number different from zero");
        }
        if (!create && name == null) {
            throw new IllegalArgumentException("'name' can only be null if create=true");
        }
        return Shms.create(name, create, rsize);
    }

    public String name();

    public long rsize();

    public long size();

    default public ByteBuffer buf() {
        return this.buf(0L, this.rsize());
    }

    public ByteBuffer buf(long var1, long var3);

    public void unlinkOnClose(boolean var1);

    public void unlink();

    @Override
    public void close();

    public String toString();
}

