/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.function.IntFunction;
import net.imglib2.KDTree;
import net.imglib2.RealLocalizable;
import net.imglib2.Sampler;

public class KDTreeNode<T>
implements RealLocalizable,
Sampler<T> {
    private final KDTree<T> tree;
    private int nodeIndex;
    private IntFunction<T> values;

    KDTreeNode(KDTree<T> tree) {
        this.tree = tree;
    }

    public KDTreeNode<T> setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
        return this;
    }

    public int nodeIndex() {
        return this.nodeIndex;
    }

    @Deprecated
    public KDTreeNode<T> left() {
        return this.tree.left(this);
    }

    @Deprecated
    public KDTreeNode<T> right() {
        return this.tree.right(this);
    }

    public final int getSplitDimension() {
        return this.tree.impl.splitDimension(this.nodeIndex);
    }

    public final double getSplitCoordinate() {
        return this.getDoublePosition(this.getSplitDimension());
    }

    @Override
    public int numDimensions() {
        return this.tree.numDimensions();
    }

    @Override
    public double getDoublePosition(int d) {
        return this.tree.impl.getDoublePosition(this.nodeIndex, d);
    }

    @Override
    public T get() {
        if (this.values == null) {
            this.values = this.tree.treeData().valuesSupplier().get();
        }
        return this.values.apply(this.nodeIndex);
    }

    @Override
    public T getType() {
        return this.tree.getType();
    }

    @Override
    public KDTreeNode<T> copy() {
        KDTreeNode<T> copy = new KDTreeNode<T>(this.tree);
        copy.setNodeIndex(this.nodeIndex);
        return copy;
    }

    public final float squDistanceTo(float[] p) {
        return this.tree.impl.squDistance(this.nodeIndex, p);
    }

    public double squDistanceTo(double[] p) {
        return this.tree.impl.squDistance(this.nodeIndex, p);
    }

    public final double squDistanceTo(RealLocalizable p) {
        return this.tree.impl.squDistance(this.nodeIndex, p);
    }
}

