/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractLocalizingCursor;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;

public class CellLocalizingCursor<T extends NativeType<T>, C extends Cell<?>>
extends AbstractLocalizingCursor<T>
implements AbstractCellImg.CellImgSampler<C> {
    protected final T type;
    protected final Index typeIndex;
    protected final Cursor<C> cursorOnCells;
    protected int lastIndexInCell;
    protected long[] currentCellMin;
    protected long[] currentCellMax;
    protected int index;
    protected boolean isNotLastCell;

    protected CellLocalizingCursor(CellLocalizingCursor<T, C> cursor) {
        super(cursor.numDimensions());
        this.type = cursor.type.duplicateTypeOnSameNativeImg();
        this.typeIndex = this.type.index();
        this.cursorOnCells = cursor.cursorOnCells.copy();
        this.currentCellMin = cursor.currentCellMin;
        this.currentCellMax = (long[])cursor.currentCellMax.clone();
        this.isNotLastCell = cursor.isNotLastCell;
        this.lastIndexInCell = cursor.lastIndexInCell;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = cursor.position[d];
        }
        this.index = cursor.index;
        this.type.updateContainer(this);
        this.typeIndex.set(this.index);
    }

    public CellLocalizingCursor(AbstractCellImg<T, ?, C, ?> img) {
        super(img.numDimensions());
        this.type = img.createLinkedType();
        this.typeIndex = this.type.index();
        this.cursorOnCells = ((IterableInterval)img.getCells()).cursor();
        this.currentCellMin = null;
        this.currentCellMax = new long[this.n];
        this.reset();
    }

    @Override
    public C getCell() {
        return (C)((Cell)this.cursorOnCells.get());
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public CellLocalizingCursor<T, C> copy() {
        return new CellLocalizingCursor<T, C>(this);
    }

    @Override
    public boolean hasNext() {
        return this.isNotLastCell || this.index < this.lastIndexInCell;
    }

    @Override
    public void jumpFwd(long steps) {
        long newIndex;
        for (newIndex = (long)this.index + steps; newIndex > (long)this.lastIndexInCell; newIndex -= (long)(this.lastIndexInCell + 1)) {
            this.cursorOnCells.fwd();
            this.isNotLastCell = this.cursorOnCells.hasNext();
            this.lastIndexInCell = (int)(((Cell)this.getCell()).size() - 1L);
        }
        Object cell = this.getCell();
        this.currentCellMin = ((Cell)cell).min;
        cell.max(this.currentCellMax);
        this.index = (int)newIndex;
        ((Cell)cell).indexToGlobalPosition(this.index, this.position);
        this.typeIndex.set(this.index);
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (++this.index > this.lastIndexInCell) {
            this.moveToNextCell();
            this.index = 0;
        }
        this.typeIndex.set(this.index);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1L;
            if (this.position[n] <= this.currentCellMax[d]) break;
            this.position[d] = this.currentCellMin[d];
        }
    }

    @Override
    public void reset() {
        this.cursorOnCells.reset();
        this.moveToNextCell();
        this.index = -1;
        this.typeIndex.set(this.index);
    }

    private void moveToNextCell() {
        this.cursorOnCells.fwd();
        this.isNotLastCell = this.cursorOnCells.hasNext();
        Object cell = this.getCell();
        this.lastIndexInCell = (int)(((Cell)cell).size() - 1L);
        this.currentCellMin = ((Cell)cell).min;
        cell.max(this.currentCellMax);
        this.position[0] = this.currentCellMin[0] - 1L;
        for (int d = 1; d < this.n; ++d) {
            this.position[d] = this.currentCellMin[d];
        }
        this.type.updateContainer(this);
    }
}

