/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.sparse;

import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.sparse.Ntree;
import net.imglib2.img.sparse.NtreeAccess;

public final class ByteNtree
implements ByteAccess,
NtreeAccess<Byte, ByteNtree> {
    private final long[] position;
    private final Ntree<Byte> data;

    public ByteNtree(long[] dimensions, long[] position, byte value) {
        this.data = new Ntree<Byte>(dimensions, value);
        this.position = position;
    }

    private ByteNtree(Ntree<Byte> data, long[] position) {
        this.data = data;
        this.position = position;
    }

    @Override
    public byte getValue(int index) {
        return this.data.getNode(this.position).getValue();
    }

    @Override
    public void setValue(int index, byte value) {
        this.data.createNodeWithValue(this.position, value);
    }

    @Override
    public Ntree<Byte> getCurrentStorageNtree() {
        return this.data;
    }

    @Override
    public ByteNtree createInstance(long[] pos) {
        return new ByteNtree(this.data, pos);
    }
}

