/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import java.util.StringJoiner;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.FinalRealInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.util.Localizables;
import net.imglib2.view.ViewTransforms;

public class Intervals {
    public static FinalInterval createMinSize(long ... minsize) {
        return FinalInterval.createMinSize(minsize);
    }

    public static FinalInterval createMinMax(long ... minmax) {
        return FinalInterval.createMinMax(minmax);
    }

    @Deprecated
    public static FinalRealInterval createMinSizeReal(double ... minsize) {
        return FinalRealInterval.createMinSize(minsize);
    }

    public static FinalRealInterval createMinMaxReal(double ... minmax) {
        return FinalRealInterval.createMinMax(minmax);
    }

    public static FinalInterval expand(Interval interval, long border) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        int d = 0;
        while (d < n) {
            int n2 = d;
            min[n2] = min[n2] - border;
            int n3 = d++;
            max[n3] = max[n3] + border;
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval expand(Interval interval, long ... border) {
        return Intervals.expand(interval, new FinalDimensions(border));
    }

    public static FinalInterval expand(Interval interval, Dimensions border) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            min[n2] = min[n2] - border.dimension(d);
            int n3 = d;
            max[n3] = max[n3] + border.dimension(d);
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval expand(Interval interval, long border, int d) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        int n2 = d;
        min[n2] = min[n2] - border;
        int n3 = d;
        max[n3] = max[n3] + border;
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval translate(Interval interval, long t, int d) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        int n2 = d;
        min[n2] = min[n2] + t;
        int n3 = d;
        max[n3] = max[n3] + t;
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval translate(Interval interval, long ... translation) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            min[n2] = min[n2] + translation[d];
            int n3 = d;
            max[n3] = max[n3] + translation[d];
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval translateInverse(Interval interval, long ... translation) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        for (int d = 0; d < n; ++d) {
            int n2 = d;
            min[n2] = min[n2] - translation[d];
            int n3 = d;
            max[n3] = max[n3] - translation[d];
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval addDimension(Interval interval, long minOfNewDim, long maxOfNewDim) {
        int m = interval.numDimensions();
        long[] min = new long[m + 1];
        long[] max = new long[m + 1];
        for (int d = 0; d < m; ++d) {
            min[d] = interval.min(d);
            max[d] = interval.max(d);
        }
        min[m] = minOfNewDim;
        max[m] = maxOfNewDim;
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval invertAxis(Interval interval, int d) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        long tmp = min[d];
        min[d] = -max[d];
        max[d] = -tmp;
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval hyperSlice(Interval interval, int d) {
        int m = interval.numDimensions();
        int n = m - 1;
        long[] min = new long[n];
        long[] max = new long[n];
        for (int e = 0; e < m; ++e) {
            if (e < d) {
                min[e] = interval.min(e);
                max[e] = interval.max(e);
                continue;
            }
            if (e <= d) continue;
            min[e - 1] = interval.min(e);
            max[e - 1] = interval.max(e);
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval moveAxis(Interval interval, int fromAxis, int toAxis) {
        int n = interval.numDimensions();
        MixedTransform t = ViewTransforms.moveAxis(n, fromAxis, toAxis);
        int[] newAxisIndices = new int[n];
        t.getComponentMapping(newAxisIndices);
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[newAxisIndices[d]] = interval.min(d);
            max[newAxisIndices[d]] = interval.max(d);
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval permuteAxes(Interval interval, int fromAxis, int toAxis) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        long fromMinNew = min[toAxis];
        long fromMaxNew = max[toAxis];
        min[toAxis] = min[fromAxis];
        max[toAxis] = max[fromAxis];
        min[fromAxis] = fromMinNew;
        max[fromAxis] = fromMaxNew;
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval rotate(Interval interval, int fromAxis, int toAxis) {
        int n = interval.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        interval.min(min);
        interval.max(max);
        if (fromAxis != toAxis) {
            long fromMinNew = -max[toAxis];
            long fromMaxNew = -min[toAxis];
            min[toAxis] = min[fromAxis];
            max[toAxis] = max[fromAxis];
            min[fromAxis] = fromMinNew;
            max[fromAxis] = fromMaxNew;
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval zeroMin(Interval interval) {
        return new FinalInterval(Intervals.dimensionsAsLongArray(interval));
    }

    public static RealInterval scale(RealInterval interval, double scale) {
        int n = interval.numDimensions();
        double[] min = Intervals.minAsDoubleArray(interval);
        double[] max = Intervals.maxAsDoubleArray(interval);
        int i = 0;
        while (i < n) {
            int n2 = i;
            min[n2] = min[n2] * scale;
            int n3 = i++;
            max[n3] = max[n3] * scale;
        }
        return new FinalRealInterval(min, max);
    }

    public static FinalInterval intersect(Interval intervalA, Interval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        int n = intervalA.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Math.max(intervalA.min(d), intervalB.min(d));
            max[d] = Math.min(intervalA.max(d), intervalB.max(d));
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalRealInterval intersect(RealInterval intervalA, RealInterval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        int n = intervalA.numDimensions();
        double[] min = new double[n];
        double[] max = new double[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Math.max(intervalA.realMin(d), intervalB.realMin(d));
            max[d] = Math.min(intervalA.realMax(d), intervalB.realMax(d));
        }
        return new FinalRealInterval(min, max);
    }

    public static FinalInterval unionUnsafe(Interval intervalA, Interval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        int n = intervalA.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Math.min(intervalA.min(d), intervalB.min(d));
            max[d] = Math.max(intervalA.max(d), intervalB.max(d));
        }
        return FinalInterval.wrap(min, max);
    }

    public static FinalInterval union(Interval intervalA, Interval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        if (Intervals.isEmpty(intervalA)) {
            return new FinalInterval(intervalB);
        }
        if (Intervals.isEmpty(intervalB)) {
            return new FinalInterval(intervalA);
        }
        return Intervals.unionUnsafe(intervalA, intervalB);
    }

    public static FinalRealInterval unionUnsafe(RealInterval intervalA, RealInterval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        int n = intervalA.numDimensions();
        double[] min = new double[n];
        double[] max = new double[n];
        for (int d = 0; d < n; ++d) {
            min[d] = Math.min(intervalA.realMin(d), intervalB.realMin(d));
            max[d] = Math.max(intervalA.realMax(d), intervalB.realMax(d));
        }
        return new FinalRealInterval(min, max);
    }

    public static FinalRealInterval union(RealInterval intervalA, RealInterval intervalB) {
        assert (intervalA.numDimensions() == intervalB.numDimensions());
        if (Intervals.isEmpty(intervalA)) {
            return new FinalRealInterval(intervalB);
        }
        if (Intervals.isEmpty(intervalB)) {
            return new FinalRealInterval(intervalA);
        }
        return Intervals.unionUnsafe(intervalA, intervalB);
    }

    public static Interval smallestContainingInterval(RealInterval ri) {
        int n = ri.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = (long)Math.floor(ri.realMin(d));
            max[d] = (long)Math.ceil(ri.realMax(d));
        }
        return FinalInterval.wrap(min, max);
    }

    public static Interval largestContainedInterval(RealInterval ri) {
        int n = ri.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            min[d] = (long)Math.ceil(ri.realMin(d));
            max[d] = (long)Math.floor(ri.realMax(d));
        }
        return FinalInterval.wrap(min, max);
    }

    public static boolean isEmpty(Interval interval) {
        int n = interval.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (interval.min(d) <= interval.max(d)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(RealInterval interval) {
        int n = interval.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (!(interval.realMin(d) > interval.realMax(d))) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Interval containing, Localizable contained) {
        assert (containing.numDimensions() == contained.numDimensions());
        int n = containing.numDimensions();
        for (int d = 0; d < n; ++d) {
            long p = contained.getLongPosition(d);
            if (p >= containing.min(d) && p <= containing.max(d)) continue;
            return false;
        }
        return true;
    }

    public static boolean contains(RealInterval containing, RealLocalizable contained) {
        assert (containing.numDimensions() == contained.numDimensions());
        int n = containing.numDimensions();
        for (int d = 0; d < n; ++d) {
            double p = contained.getDoublePosition(d);
            if (!(p < containing.realMin(d)) && !(p > containing.realMax(d))) continue;
            return false;
        }
        return true;
    }

    public static final boolean contains(Interval containing, Interval contained) {
        assert (containing.numDimensions() == contained.numDimensions());
        int n = containing.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (containing.min(d) <= contained.min(d) && containing.max(d) >= contained.max(d)) continue;
            return false;
        }
        return true;
    }

    public static final boolean contains(RealInterval containing, RealInterval contained) {
        assert (containing.numDimensions() == contained.numDimensions());
        int n = containing.numDimensions();
        for (int d = 0; d < n; ++d) {
            if (!(containing.realMin(d) > contained.realMin(d)) && !(containing.realMax(d) < contained.realMax(d))) continue;
            return false;
        }
        return true;
    }

    public static long numElements(Dimensions interval) {
        long numPixels = Math.max(interval.dimension(0), 0L);
        int n = interval.numDimensions();
        for (int d = 1; d < n; ++d) {
            numPixels *= Math.max(interval.dimension(d), 0L);
        }
        return numPixels;
    }

    public static long numElements(int ... dimensions) {
        long numPixels = Math.max(dimensions[0], 0);
        for (int d = 1; d < dimensions.length; ++d) {
            numPixels *= (long)Math.max(dimensions[d], 0);
        }
        return numPixels;
    }

    public static long numElements(long ... dimensions) {
        long numPixels = Math.max(dimensions[0], 0L);
        for (int d = 1; d < dimensions.length; ++d) {
            numPixels *= Math.max(dimensions[d], 0L);
        }
        return numPixels;
    }

    public static boolean equals(Interval a, Interval b) {
        if (a.numDimensions() != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < a.numDimensions(); ++d) {
            if (a.min(d) == b.min(d) && a.max(d) == b.max(d)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(RealInterval a, RealInterval b) {
        if (a.numDimensions() != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < a.numDimensions(); ++d) {
            if (a.realMin(d) == b.realMin(d) && a.realMax(d) == b.realMax(d)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(RealInterval a, RealInterval b, double tolerance) {
        if (a.numDimensions() != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < a.numDimensions(); ++d) {
            double differenceMin = Math.abs(a.realMin(d) - b.realMin(d));
            double differenceMax = Math.abs(a.realMax(d) - b.realMax(d));
            if (!(differenceMin > tolerance) && !(differenceMax > tolerance)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalDimensions(Dimensions a, Dimensions b) {
        if (a.numDimensions() != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < a.numDimensions(); ++d) {
            if (a.dimension(d) == b.dimension(d)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean equalDimensions(Interval a, Interval b) {
        return Intervals.equalDimensions((Dimensions)a, (Dimensions)b);
    }

    public static long[] dimensionsAsLongArray(Dimensions dimensions) {
        long[] dims = new long[dimensions.numDimensions()];
        dimensions.dimensions(dims);
        return dims;
    }

    public static int[] dimensionsAsIntArray(Dimensions dimensions) {
        int n = dimensions.numDimensions();
        int[] dims = new int[n];
        for (int d = 0; d < n; ++d) {
            dims[d] = (int)dimensions.dimension(d);
        }
        return dims;
    }

    public static long[] minAsLongArray(Interval interval) {
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        return min;
    }

    public static int[] minAsIntArray(Interval interval) {
        int n = interval.numDimensions();
        int[] min = new int[n];
        for (int d = 0; d < n; ++d) {
            min[d] = (int)interval.min(d);
        }
        return min;
    }

    public static long[] maxAsLongArray(Interval interval) {
        long[] max = new long[interval.numDimensions()];
        interval.max(max);
        return max;
    }

    public static int[] maxAsIntArray(Interval interval) {
        int n = interval.numDimensions();
        int[] max = new int[n];
        for (int d = 0; d < n; ++d) {
            max[d] = (int)interval.max(d);
        }
        return max;
    }

    public static double[] maxAsDoubleArray(RealInterval interval) {
        double[] max = new double[interval.numDimensions()];
        interval.realMax(max);
        return max;
    }

    public static double[] minAsDoubleArray(RealInterval interval) {
        double[] min = new double[interval.numDimensions()];
        interval.realMin(min);
        return min;
    }

    public static RandomAccessibleInterval<Localizable> positions(Interval interval) {
        return Localizables.randomAccessibleInterval(interval);
    }

    public static String toString(Interval value) {
        int d;
        StringBuilder sb = new StringBuilder();
        sb.append("[(");
        int n = value.numDimensions();
        for (d = 0; d < n; ++d) {
            sb.append(value.min(d));
            if (d >= n - 1) continue;
            sb.append(", ");
        }
        sb.append(") -- (");
        for (d = 0; d < n; ++d) {
            sb.append(value.max(d));
            if (d >= n - 1) continue;
            sb.append(", ");
        }
        sb.append(") = ");
        for (d = 0; d < n; ++d) {
            sb.append(value.dimension(d));
            if (d >= n - 1) continue;
            sb.append("x");
        }
        sb.append("]");
        return sb.toString();
    }

    public static String toString(RealInterval value) {
        int d;
        StringBuilder sb = new StringBuilder();
        sb.append("[(");
        int n = value.numDimensions();
        for (d = 0; d < n; ++d) {
            sb.append(value.realMin(d));
            if (d >= n - 1) continue;
            sb.append(", ");
        }
        sb.append(") -- (");
        for (d = 0; d < n; ++d) {
            sb.append(value.realMax(d));
            if (d >= n - 1) continue;
            sb.append(", ");
        }
        sb.append(")]");
        return sb.toString();
    }

    public static String toString(Dimensions value) {
        StringJoiner joiner = new StringJoiner("x");
        for (int d = 0; d < value.numDimensions(); ++d) {
            joiner.add(Long.toString(value.dimension(d)));
        }
        return joiner.toString();
    }
}

