/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.menu;

import org.scijava.menu.MenuCreator;
import org.scijava.menu.ShadowMenu;

public abstract class AbstractMenuCreator<T, M>
implements MenuCreator<T> {
    @Override
    public void createMenus(ShadowMenu root, T target) {
        double lastWeight = Double.NaN;
        for (ShadowMenu child : root.getChildren()) {
            double weight = child.getMenuEntry().getWeight();
            double difference = Math.abs(weight - lastWeight);
            if (difference > 1.0) {
                this.addSeparatorToTop(target);
            }
            lastWeight = weight;
            if (child.isLeaf()) {
                this.addLeafToTop(child, target);
                continue;
            }
            M nonLeaf = this.addNonLeafToTop(child, target);
            this.populateMenu(child, nonLeaf);
        }
    }

    protected abstract void addLeafToMenu(ShadowMenu var1, M var2);

    protected abstract void addLeafToTop(ShadowMenu var1, T var2);

    protected abstract M addNonLeafToMenu(ShadowMenu var1, M var2);

    protected abstract M addNonLeafToTop(ShadowMenu var1, T var2);

    protected abstract void addSeparatorToMenu(M var1);

    protected abstract void addSeparatorToTop(T var1);

    private void populateMenu(ShadowMenu shadow, M target) {
        double lastWeight = Double.NaN;
        for (ShadowMenu child : shadow.getChildren()) {
            double weight = child.getMenuEntry().getWeight();
            double difference = Math.abs(weight - lastWeight);
            if (difference > 1.0) {
                this.addSeparatorToMenu(target);
            }
            lastWeight = weight;
            if (child.isLeaf()) {
                this.addLeafToMenu(child, target);
                continue;
            }
            M nonLeaf = this.addNonLeafToMenu(child, target);
            this.populateMenu(child, nonLeaf);
        }
    }
}

