/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.fusion;

import ij.ImagePlus;
import java.util.ArrayList;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.spim.fusion.CombinedPixelWeightenerFactory;
import mpicbg.spim.fusion.IsolatedPixelWeightenerFactory;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.ImgLibSaver;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.ViewStructure;
import spim.vecmath.Point3f;

public abstract class SPIMImageFusion {
    protected SPIMConfiguration conf;
    protected final ArrayList<IsolatedPixelWeightenerFactory<?>> isolatedWeightenerFactories;
    protected final ArrayList<CombinedPixelWeightenerFactory<?>> combinedWeightenerFactories;
    protected Point3f min = null;
    protected Point3f max = null;
    protected Point3f size = null;
    protected Point3f location000 = null;
    protected int cropOffsetX;
    protected int cropOffsetY;
    protected int cropOffsetZ;
    protected int imgW;
    protected int imgH;
    protected int imgD;
    protected int scale;
    protected final ViewStructure viewStructure;

    public SPIMImageFusion(ViewStructure viewStructure, ViewStructure referenceViewStructure, ArrayList<IsolatedPixelWeightenerFactory<?>> isolatedWeightenerFactories, ArrayList<CombinedPixelWeightenerFactory<?>> combinedWeightenerFactories) {
        this.conf = viewStructure.getSPIMConfiguration();
        this.viewStructure = viewStructure;
        this.scale = this.conf.scale;
        this.isolatedWeightenerFactories = isolatedWeightenerFactories;
        this.combinedWeightenerFactories = combinedWeightenerFactories;
        this.computeFinalImageSize(referenceViewStructure.getViews());
        this.initFusion();
        this.location000 = new Point3f();
        this.location000.x = (float)(this.cropOffsetX * this.scale) + this.min.x;
        this.location000.y = (float)(this.cropOffsetY * this.scale) + this.min.y;
        this.location000.z = (float)(this.cropOffsetZ * this.scale) + this.min.z;
        if (viewStructure.getDebugLevel() <= 1) {
            IOFunctions.println("Location of pixel (0,0,0) in global coordinates is: " + this.location000);
        }
    }

    public abstract void fuseSPIMImages(int var1);

    public abstract Image<FloatType> getFusedImage();

    public ImagePlus getFusedImageCopy() {
        return ImageJFunctions.copyToImagePlus(this.getFusedImage());
    }

    public ImagePlus getFusedImageVirtual() {
        return ImageJFunctions.displayAsVirtualStack(this.getFusedImage());
    }

    public void closeImages() {
        this.getFusedImage().close();
    }

    public boolean saveAsTiffs(String dir, String name, int channelIndex) {
        return ImgLibSaver.saveAsTiffs(this.getFusedImage(), dir, name + "_ch" + this.viewStructure.getChannelNum(channelIndex), 2);
    }

    public Point3f getOutputImageMinCoordinate() {
        return this.min;
    }

    public Point3f getOutputImageMaxCoordinate() {
        return this.max;
    }

    public Point3f getOutputImageSize() {
        return this.size;
    }

    protected void initFusion() {
        this.cropOffsetX = this.conf.cropOffsetX / this.scale;
        this.cropOffsetY = this.conf.cropOffsetY / this.scale;
        this.cropOffsetZ = this.conf.cropOffsetZ / this.scale;
        this.imgW = this.conf.cropSizeX == 0 ? (Math.round((float)Math.ceil(this.size.x)) + 1) / this.scale : this.conf.cropSizeX / this.scale;
        this.imgH = this.conf.cropSizeY == 0 ? (Math.round((float)Math.ceil(this.size.y)) + 1) / this.scale : this.conf.cropSizeY / this.scale;
        this.imgD = this.conf.cropSizeZ == 0 ? (Math.round((float)Math.ceil(this.size.z)) + 1) / this.scale : this.conf.cropSizeZ / this.scale;
    }

    public void computeFinalImageSize(ArrayList<ViewDataBeads> views) {
        this.min = new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.max = new Point3f(-3.4028235E38f, -3.4028235E38f, -3.4028235E38f);
        this.size = new Point3f();
        SPIMImageFusion.computeImageSize(views, this.min, this.max, this.size, this.conf.scale, this.conf.cropSizeX, this.conf.cropSizeY, this.conf.cropSizeZ, this.viewStructure.getDebugLevel());
    }

    public static void computeImageSize(ArrayList<ViewDataBeads> views, Point3f min, Point3f max, Point3f size, int scale, int cropSizeX, int cropSizeY, int cropSizeZ, int debugLevel) {
        min.x = Float.MAX_VALUE;
        min.y = Float.MAX_VALUE;
        min.z = Float.MAX_VALUE;
        max.x = -3.4028235E38f;
        max.y = -3.4028235E38f;
        max.z = -3.4028235E38f;
        for (ViewDataBeads view : views) {
            if (Math.max(view.getViewErrorStatistics().getNumConnectedViews(), view.getTile().getConnectedTiles().size()) <= 0 && view.getViewStructure().getNumViews() > 1) {
                if (!view.getUseForRegistration() || debugLevel > 2) continue;
                IOFunctions.printErr("Cannot use view " + view + ", it is not connected to any other view!");
                continue;
            }
            if (view.getViewStructure().getNumViews() == 1 && debugLevel <= 2) {
                IOFunctions.printErr("Warning: Only one view given: " + view);
            }
            int[] dim = view.getImageSize();
            double[] minCoordinate = new double[]{0.0, 0.0, 0.0};
            double[] maxCoordinate = new double[]{dim[0], dim[1], dim[2]};
            ((AbstractAffineModel3D)view.getTile().getModel()).estimateBounds(minCoordinate, maxCoordinate);
            min.x = (float)Math.min(minCoordinate[0], (double)min.x);
            min.y = (float)Math.min(minCoordinate[1], (double)min.y);
            min.z = (float)Math.min(minCoordinate[2], (double)min.z);
            max.x = (float)Math.max(maxCoordinate[0], (double)max.x);
            max.y = (float)Math.max(maxCoordinate[1], (double)max.y);
            max.z = (float)Math.max(maxCoordinate[2], (double)max.z);
        }
        size.sub(max, min);
        if (debugLevel <= 1) {
            IOFunctions.println("Dimension of final output image:");
            IOFunctions.println("From : " + min + " to " + max);
            double ram = 4.0f * size.x * size.y * size.z / 1048576.0f;
            IOFunctions.println("Size: " + size + " needs " + Math.round(ram) + " MB of RAM");
            if (scale != 1) {
                ram = 4.0f * size.x / (float)scale * size.y / (float)scale * size.z / (float)scale / 1048576.0f;
                if (views.get((int)0).getViewStructure().getSPIMConfiguration().isDeconvolution) {
                    IOFunctions.println("Scaled size(" + scale + "): (" + Math.round(size.x / (float)scale) + ", " + Math.round(size.y / (float)scale) + ", " + Math.round(size.z / (float)scale) + ") needs " + Math.round(ram) + " MB of RAM x " + 2 * views.size() + " = " + Math.round(ram) * 2L * (long)views.size() + " MB");
                } else {
                    IOFunctions.println("Scaled size(" + scale + "): (" + Math.round(size.x / (float)scale) + ", " + Math.round(size.y / (float)scale) + ", " + Math.round(size.z / (float)scale) + ") needs " + Math.round(ram) + " MB of RAM");
                }
            }
            if (cropSizeX > 0 && cropSizeY > 0 && cropSizeZ > 0) {
                if (scale != 1) {
                    IOFunctions.println("Cropped & scaled(" + scale + ") image size: " + cropSizeX / scale + "x" + cropSizeY / scale + "x" + cropSizeZ / scale);
                } else {
                    IOFunctions.println("Cropped image size: " + cropSizeX + "x" + cropSizeY + "x" + cropSizeZ);
                }
                ram = 4L * (long)cropSizeX / (long)scale * (long)cropSizeY / (long)scale * (long)cropSizeZ / (long)scale / 0x100000L;
                if (views.get((int)0).getViewStructure().getSPIMConfiguration().isDeconvolution) {
                    IOFunctions.println("Needs " + Math.round(ram) + " MB of RAM x " + 2 * views.size() + " = " + Math.round(ram) * 2L * (long)views.size() + " MB");
                } else {
                    IOFunctions.println("Needs " + Math.round(ram) + " MB of RAM");
                }
            }
        }
    }
}

