/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.interestpoints;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;

public class ViewInterestPoints {
    protected final Map<ViewId, ViewInterestPointLists> interestPointCollectionLookup;

    public ViewInterestPoints() {
        this.interestPointCollectionLookup = new HashMap<ViewId, ViewInterestPointLists>();
    }

    public ViewInterestPoints(Map<ViewId, ViewInterestPointLists> interestPointCollectionLookup) {
        this.interestPointCollectionLookup = interestPointCollectionLookup;
    }

    public ViewInterestPoints(Collection<ViewInterestPointLists> interestPointCollection) {
        this.interestPointCollectionLookup = new HashMap<ViewId, ViewInterestPointLists>();
        for (ViewInterestPointLists v : interestPointCollection) {
            this.interestPointCollectionLookup.put(v, v);
        }
    }

    public Map<ViewId, ViewInterestPointLists> getViewInterestPoints() {
        return this.interestPointCollectionLookup;
    }

    public ViewInterestPointLists getViewInterestPointLists(int tp, int setupId) {
        return this.getViewInterestPointLists(new ViewId(tp, setupId));
    }

    public ViewInterestPointLists getViewInterestPointLists(ViewId viewId) {
        return this.interestPointCollectionLookup.get(viewId);
    }

    public void createViewInterestPoints(Map<ViewId, ViewDescription> viewDescriptions) {
        for (ViewDescription viewDescription : viewDescriptions.values()) {
            if (!viewDescription.isPresent()) continue;
            this.interestPointCollectionLookup.put((ViewId)viewDescription, new ViewInterestPointLists(viewDescription.getTimePointId(), viewDescription.getViewSetupId()));
        }
    }
}

