/*
 * Decompiled with CFR 0.152.
 */
package spim.process.interestpointregistration;

import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.process.interestpointregistration.ChannelProcess;
import spim.process.interestpointregistration.Detection;
import spim.process.interestpointregistration.MatchPointList;

public class PairwiseMatch {
    final MatchPointList listA;
    final MatchPointList listB;
    final ViewId viewIdA;
    final ViewId viewIdB;
    double error = -1.0;
    ArrayList<PointMatchGeneric<Detection>> candidates;
    ArrayList<PointMatchGeneric<Detection>> inliers;

    public PairwiseMatch(ViewId viewIdA, ViewId viewIdB, MatchPointList listA, MatchPointList listB) {
        this.listA = listA;
        this.listB = listB;
        this.viewIdA = viewIdA;
        this.viewIdB = viewIdB;
    }

    public MatchPointList getMatchPointListA() {
        return this.listA;
    }

    public MatchPointList getMatchPointListB() {
        return this.listB;
    }

    public ChannelProcess getChannelProcessedA() {
        return this.listA.getChannelProcessed();
    }

    public ChannelProcess getChannelProcessedB() {
        return this.listB.getChannelProcessed();
    }

    public List<InterestPoint> getListA() {
        return this.listA.getInterestpointList();
    }

    public List<InterestPoint> getListB() {
        return this.listB.getInterestpointList();
    }

    public ViewId getViewIdA() {
        return this.viewIdA;
    }

    public ViewId getViewIdB() {
        return this.viewIdB;
    }

    public int getNumInliers() {
        return this.inliers.size();
    }

    public int getNumCandidates() {
        return this.candidates.size();
    }

    public double getAvgError() {
        return this.error;
    }

    public ArrayList<PointMatchGeneric<Detection>> getCandidates() {
        return this.candidates;
    }

    public ArrayList<PointMatchGeneric<Detection>> getInliers() {
        return this.inliers;
    }

    public ArrayList<ViewId> getBothViewIds() {
        ArrayList<ViewId> l = new ArrayList<ViewId>();
        l.add(this.viewIdA);
        l.add(this.viewIdB);
        return l;
    }

    public void setCandidates(ArrayList<PointMatchGeneric<Detection>> candidates) {
        this.candidates = candidates;
    }

    public void setInliers(ArrayList<PointMatchGeneric<Detection>> inliers, double error) {
        this.inliers = inliers;
        this.error = error;
    }
}

