/*
 * Decompiled with CFR 0.152.
 */
package weka.core.expressionlanguage.common;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import weka.core.expressionlanguage.common.Primitives;
import weka.core.expressionlanguage.core.Macro;
import weka.core.expressionlanguage.core.MacroDeclarations;
import weka.core.expressionlanguage.core.Node;
import weka.core.expressionlanguage.core.SemanticException;

public class JavaMacro
implements MacroDeclarations,
Macro {
    private static final String JAVA_MACRO = "java";
    private static final String BOOLEAN = "boolean";
    private static final String DOUBLE = "double";
    private static final String STRING = "String";

    @Override
    public Node evaluate(Node ... nodes) throws SemanticException {
        Method m;
        if (nodes.length < 2) {
            throw new SemanticException("The java macro takes at least 2 arguments!");
        }
        if (!(nodes[0] instanceof Primitives.StringConstant) || !(nodes[1] instanceof Primitives.StringConstant)) {
            throw new SemanticException("java's first and second argument must be String constants!");
        }
        Node[] parameterNodes = Arrays.copyOfRange(nodes, 2, nodes.length);
        String className = ((Primitives.StringConstant)nodes[0]).evaluate();
        String signature = ((Primitives.StringConstant)nodes[1]).evaluate();
        ArrayList parameterTypes = new ArrayList();
        String name = this.parseSignature(signature, parameterTypes);
        Class returnType = (Class)parameterTypes.remove(0);
        try {
            m = Class.forName(className).getMethod(name, parameterTypes.toArray(new Class[0]));
        }
        catch (Exception e) {
            throw new SemanticException("Failed to load method '" + className + "." + name + "' in " + JAVA_MACRO + " macro!", e);
        }
        if (parameterTypes.size() != parameterNodes.length) {
            throw new SemanticException("Wrong amount of parameters given in java macro!");
        }
        for (int i = 0; i < parameterTypes.size() && i < parameterNodes.length; ++i) {
            if (((Class)parameterTypes.get(i)).equals(Boolean.TYPE) && parameterNodes[i] instanceof Primitives.BooleanExpression || ((Class)parameterTypes.get(i)).equals(Double.TYPE) && parameterNodes[i] instanceof Primitives.DoubleExpression || ((Class)parameterTypes.get(i)).equals(String.class) && parameterNodes[i] instanceof Primitives.StringExpression) continue;
            throw new SemanticException("Type error in java macro!");
        }
        if (returnType.equals(Boolean.TYPE)) {
            return new BooleanJavaMethod(m, parameterNodes);
        }
        if (returnType.equals(Double.TYPE)) {
            return new DoubleJavaMethod(m, parameterNodes);
        }
        if (returnType.equals(String.class)) {
            return new StringJavaMethod(m, parameterNodes);
        }
        assert (false);
        throw new SemanticException("Internal error in java macro!");
    }

    private String parseSignature(String signature, List<Class<?>> types) throws InvalidSignature {
        int i;
        List<String> tokens = this.tokenize(signature);
        if (tokens.size() < 4) {
            throw new InvalidSignature("Not enough tokens in '" + signature + "'");
        }
        types.add(this.getType(tokens.get(0)));
        if (!this.isJavaIdentifier(tokens.get(1))) {
            throw new InvalidSignature("Invalid function name '" + tokens.get(1) + "'");
        }
        String name = tokens.get(1);
        if (!"(".equals(tokens.get(2))) {
            throw new InvalidSignature("Missing opening bracket, got '" + tokens.get(2) + "' instead");
        }
        boolean first = true;
        for (i = 3; i < tokens.size() && !")".equals(tokens.get(i)); ++i) {
            if (!first && !",".equals(tokens.get(i))) {
                throw new InvalidSignature("Missing comma between parameters, got '" + tokens.get(i) + "' instead");
            }
            if (!first) {
                ++i;
            }
            if (i >= tokens.size()) {
                throw new InvalidSignature("No parameter after comma!");
            }
            types.add(this.getType(tokens.get(i)));
            first = false;
        }
        if (i < tokens.size() && !")".equals(tokens.get(i))) {
            System.out.println(i);
            System.out.println(tokens);
            throw new InvalidSignature("Missing closing bracket, got '" + tokens.get(i) + "' instead");
        }
        if (i != tokens.size() - 1) {
            throw new InvalidSignature("Failed parsing signature at token '" + tokens.get(i) + "'");
        }
        return name;
    }

    private List<String> tokenize(String signature) {
        String[] whiteSpaceTokens = signature.split("\\s+");
        ArrayList<String> tokens = new ArrayList<String>();
        for (String token : whiteSpaceTokens) {
            StringTokenizer tokenizer = new StringTokenizer(token, ",()", true);
            while (tokenizer.hasMoreElements()) {
                tokens.add(tokenizer.nextToken());
            }
        }
        return tokens;
    }

    private Class<?> getType(String type) throws InvalidSignature {
        if (type.equals(BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (type.equals(DOUBLE)) {
            return Double.TYPE;
        }
        if (type.equals(STRING)) {
            return String.class;
        }
        throw new InvalidSignature("Expected type, got '" + type + "' instead");
    }

    private boolean isJavaIdentifier(String identifier) {
        if (identifier.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            if (Character.isJavaIdentifierPart(identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasMacro(String name) {
        return JAVA_MACRO.equals(name);
    }

    @Override
    public Macro getMacro(String name) {
        if (this.hasMacro(name)) {
            return this;
        }
        throw new RuntimeException("Undefined macro '" + name + "'!");
    }

    private static class BooleanJavaMethod
    extends JavaMethod
    implements Primitives.BooleanExpression {
        public BooleanJavaMethod(Method method, Node ... params) {
            super(method, params);
            assert (Boolean.TYPE.equals(method.getReturnType()));
        }

        @Override
        public boolean evaluate() {
            try {
                this.evaluateArgs();
                return (Boolean)this.method.invoke(null, this.args);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute java function '" + this.method.getName() + "'!", e);
            }
        }
    }

    private static class DoubleJavaMethod
    extends JavaMethod
    implements Primitives.DoubleExpression {
        public DoubleJavaMethod(Method method, Node ... params) {
            super(method, params);
            assert (Double.TYPE.equals(method.getReturnType()));
        }

        @Override
        public double evaluate() {
            try {
                this.evaluateArgs();
                return (Double)this.method.invoke(null, this.args);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute java function '" + this.method.getName() + "'!", e);
            }
        }
    }

    private static class StringJavaMethod
    extends JavaMethod
    implements Primitives.StringExpression {
        public StringJavaMethod(Method method, Node ... params) {
            super(method, params);
            assert (String.class.equals(method.getReturnType()));
        }

        @Override
        public String evaluate() {
            try {
                this.evaluateArgs();
                return (String)this.method.invoke(null, this.args);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to execute java function '" + this.method.getName() + "'!", e);
            }
        }
    }

    private static class InvalidSignature
    extends SemanticException {
        private static final long serialVersionUID = -4198745015342335018L;

        public InvalidSignature(String reason) {
            super("Invalid function signature in java macro (" + reason + ")");
        }
    }

    private static abstract class JavaMethod
    implements Node {
        protected final Method method;
        protected final Node[] params;
        protected final Object[] args;

        public JavaMethod(Method method, Node ... params) {
            assert (Modifier.isStatic(method.getModifiers()));
            this.method = method;
            this.params = params;
            this.args = new Object[params.length];
        }

        protected void evaluateArgs() {
            for (int i = 0; i < this.params.length; ++i) {
                if (this.params[i] instanceof Primitives.BooleanExpression) {
                    this.args[i] = new Boolean(((Primitives.BooleanExpression)this.params[i]).evaluate());
                    continue;
                }
                if (this.params[i] instanceof Primitives.DoubleExpression) {
                    this.args[i] = new Double(((Primitives.DoubleExpression)this.params[i]).evaluate());
                    continue;
                }
                if (!(this.params[i] instanceof Primitives.StringExpression)) continue;
                this.args[i] = ((Primitives.StringExpression)this.params[i]).evaluate();
            }
        }
    }
}

