/*
 * Decompiled with CFR 0.152.
 */
package fiji.features;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import fiji.features.MultiTaskProgress;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.imglib.algorithm.gauss.GaussianConvolutionReal;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.ImagePlusAdapter;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.integer.ByteType;
import mpicbg.imglib.type.numeric.real.FloatType;

public class Frangi_<T extends RealType<T>>
implements PlugIn {
    protected Image<T> image;
    DecimalFormat f3 = new DecimalFormat("0.000E0");

    public static String intArrayToString(int[] array) {
        StringBuilder builder = new StringBuilder();
        boolean firstTime = true;
        for (int i : array) {
            if (firstTime) {
                firstTime = false;
            } else {
                builder.append(", ");
            }
            builder.append(i);
        }
        return builder.toString();
    }

    public ImagePlus process(ImagePlus input, int scales, double minimumScale, double maximumScale) {
        return this.process(input, scales, minimumScale, maximumScale, false, false, false, null);
    }

    public String formatReal(double n) {
        return this.f3.format(n);
    }

    public ImagePlus process(ImagePlus input, int scales, double minimumScale, double maximumScale, boolean showGaussianImages, boolean showFilteredImages, boolean showWhichScales, MultiTaskProgress progress) {
        int processors = Runtime.getRuntime().availableProcessors();
        this.image = ImagePlusAdapter.wrap((ImagePlus)input);
        float[] spacing = this.image.getCalibration();
        double range = maximumScale - minimumScale;
        double increment = 0.0;
        if (scales > 1) {
            increment = range / (double)(scales - 1);
        }
        ArrayList<Image<FloatType>> vesselImages = new ArrayList<Image<FloatType>>();
        ExecutorService es = Executors.newFixedThreadPool(processors);
        ArrayList calculators = new ArrayList();
        for (int scaleIndex = 0; scaleIndex < scales; ++scaleIndex) {
            double currentScale = minimumScale + (double)scaleIndex * increment;
            float[] fArray = new float[spacing.length];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = (float)((double)spacing[i] * (currentScale / (double)spacing[0]));
            }
            double[] sigmas = new double[fArray.length];
            for (int i = 0; i < fArray.length; ++i) {
                sigmas[i] = fArray[i] / spacing[i];
            }
            GaussianConvolutionReal gauss = new GaussianConvolutionReal(this.image, (OutOfBoundsStrategyFactory)new OutOfBoundsStrategyMirrorFactory(), sigmas);
            gauss.setNumThreads(processors);
            IJ.showStatus((String)("Running Gaussian convolution at scale " + this.formatReal(currentScale) + "..."));
            if (!gauss.checkInput() || !gauss.process()) {
                IJ.error((String)("Gaussian Convolution failed: " + gauss.getErrorMessage()));
                return null;
            }
            Image result = gauss.getResult();
            if (showGaussianImages) {
                ImagePlus gaussianSmoothedImage = ImageJFunctions.copyToImagePlus((Image)result);
                gaussianSmoothedImage.setTitle("Gaussian smoothed images at scale " + scaleIndex);
                gaussianSmoothedImage.show();
            }
            VesselnessCalculator calculator = new VesselnessCalculator(result, fArray, scaleIndex, progress);
            calculators.add(calculator);
        }
        List futures = null;
        try {
            futures = es.invokeAll(calculators);
        }
        catch (InterruptedException currentScale) {
            // empty catch block
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException currentScale) {
        }
        catch (Exception e) {
            IJ.error((String)("The following exception was thrown: " + e));
            e.printStackTrace();
            return null;
        }
        int scale = 0;
        for (VesselnessCalculator vesselnessCalculator : calculators) {
            Image<FloatType> image = vesselnessCalculator.getResult();
            vesselImages.add(image);
            if (showFilteredImages) {
                ImagePlus imagePlusVersion = ImageJFunctions.copyToImagePlus(image);
                imagePlusVersion.setTitle("Filtered image at scale " + scale);
                imagePlusVersion.setDisplayRange(vesselnessCalculator.getMinimumVesselness(), 0.5 * vesselnessCalculator.getMaximumVesselness());
                imagePlusVersion.show();
            }
            ++scale;
        }
        ImageFactory imageFactory = new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory());
        Image image = imageFactory.createImage(this.image.getDimensions());
        LocalizableCursor resultCursor = image.createLocalizableCursor();
        ImageFactory byteFactory = new ImageFactory((Type)new ByteType(), (ContainerFactory)new ArrayContainerFactory());
        Image whichImage = null;
        LocalizableCursor whichCursor = null;
        if (showWhichScales) {
            whichImage = imageFactory.createImage(this.image.getDimensions());
            whichCursor = whichImage.createLocalizableCursor();
        }
        ArrayList<LocalizableCursor> cursors = new ArrayList<LocalizableCursor>();
        for (Image image2 : vesselImages) {
            cursors.add(image2.createLocalizableCursor());
        }
        float maximumValueInResult = Float.MIN_VALUE;
        float f = Float.MAX_VALUE;
        while (resultCursor.hasNext()) {
            resultCursor.fwd();
            if (showWhichScales) {
                whichCursor.fwd();
            }
            int bestScale = 0;
            float largestValue = Float.MIN_VALUE;
            int scaleIndex = 0;
            for (LocalizableCursor cursor : cursors) {
                cursor.fwd();
                float v = ((FloatType)cursor.getType()).getRealFloat();
                if (v > largestValue) {
                    bestScale = scaleIndex + 1;
                    largestValue = v;
                }
                ++scaleIndex;
            }
            if (showWhichScales) {
                ((FloatType)whichCursor.getType()).set(bestScale == 0 ? 0.0f : (float)minimumScale + (float)(bestScale - 1) * (float)increment);
            }
            ((FloatType)resultCursor.getType()).set(largestValue);
            maximumValueInResult = Math.max(maximumValueInResult, largestValue);
            f = Math.min(f, largestValue);
        }
        for (LocalizableCursor cursor : cursors) {
            cursor.close();
        }
        if (showWhichScales) {
            whichCursor.close();
        }
        resultCursor.close();
        if (showWhichScales) {
            ImagePlus whichImagePlus = ImageJFunctions.copyToImagePlus((Image)whichImage, (int)2);
            whichImagePlus.setTitle("Scales used");
            whichImagePlus.getProcessor().setMinAndMax(0.0, maximumScale);
            whichImagePlus.show();
        }
        if (progress != null) {
            progress.done();
        }
        ImagePlus resultImagePlus = ImageJFunctions.copyToImagePlus((Image)image);
        resultImagePlus.setDisplayRange((double)f, 0.5 * (double)maximumValueInResult);
        resultImagePlus.setTitle("vesselness of " + input.getTitle());
        resultImagePlus.setCalibration(input.getCalibration());
        return resultImagePlus;
    }

    public void run(String ignored) {
        Progress progress;
        boolean showWhichScales;
        boolean showFilteredImages;
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"There's no image open to work on.");
            return;
        }
        Calibration c = imagePlus.getCalibration();
        double pixelWidth = Math.abs(c.pixelWidth);
        GenericDialog gd = new GenericDialog("Frangi Options");
        gd.addNumericField("Number of scales", 1.0, 0);
        gd.addNumericField("Minimum scale", pixelWidth, 6);
        gd.addNumericField("Maximum scale", pixelWidth, 6);
        gd.addCheckbox("Show Gaussian smoothed images:", false);
        gd.addCheckbox("Show filtered images at each scale:", false);
        gd.addCheckbox("Show which scales were used at each point:", false);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int scales = (int)Math.round(gd.getNextNumber());
        if (scales < 1) {
            IJ.error((String)"The minimum number of scales to try is 1");
            return;
        }
        double minimumScale = gd.getNextNumber();
        double maximumScale = gd.getNextNumber();
        if (maximumScale < minimumScale) {
            IJ.error((String)"The maximum scale cannot be less than the minimum scale");
            return;
        }
        boolean showGaussianImages = gd.getNextBoolean();
        ImagePlus result = this.process(imagePlus, scales, minimumScale, maximumScale, showGaussianImages, showFilteredImages = gd.getNextBoolean(), showWhichScales = gd.getNextBoolean(), progress = new Progress(scales));
        if (result != null) {
            result.show();
        }
    }

    public static class Progress
    implements MultiTaskProgress {
        ArrayList<Double> tasksProportionsDone = new ArrayList();
        int totalTasks;

        public Progress(int totalTasks) {
            this.totalTasks = totalTasks;
            for (int i = 0; i < totalTasks; ++i) {
                this.tasksProportionsDone.add(0.0);
            }
        }

        @Override
        public synchronized void updateProgress(double proportion, int taskIndex) {
            this.tasksProportionsDone.set(taskIndex, proportion);
            this.updateStatus();
        }

        protected void updateStatus() {
            double totalDone = 0.0;
            for (double p : this.tasksProportionsDone) {
                totalDone += p;
            }
            IJ.showProgress((double)(totalDone / (double)this.totalTasks));
        }

        @Override
        public void done() {
            IJ.showProgress((double)1.0);
        }
    }

    public static class VesselnessCalculator<T extends RealType<T>>
    implements Callable<Image<FloatType>> {
        protected double alpha = 0.5;
        protected double beta = 0.5;
        protected int scaleIndex;
        protected final Image<T> inputImage;
        protected final float[] spacing;
        protected MultiTaskProgress progress;
        protected double minimumVesselness = Double.MAX_VALUE;
        protected double maximumVesselness = Double.MIN_VALUE;
        protected volatile Image<FloatType> result;

        public double getMinimumVesselness() {
            return this.minimumVesselness;
        }

        public double getMaximumVesselness() {
            return this.maximumVesselness;
        }

        public long numberOfPoints(Image<T> image) {
            int[] dimensions;
            long totalPoints = 1L;
            for (int length : dimensions = image.getDimensions()) {
                totalPoints *= (long)length;
            }
            return totalPoints;
        }

        public VesselnessCalculator(Image<T> input, float[] spacing, int scaleIndex, MultiTaskProgress progress) {
            this.inputImage = input;
            this.spacing = spacing;
            this.scaleIndex = scaleIndex;
            this.progress = progress;
        }

        public Image<FloatType> getResult() {
            return this.result;
        }

        @Override
        public Image<FloatType> call() throws Exception {
            Image<T> input = this.inputImage;
            float[] spacing = this.spacing;
            double ad = 2.0 * this.alpha * this.alpha;
            double bd = 2.0 * this.beta * this.beta;
            OutOfBoundsStrategyMirrorFactory osmf = new OutOfBoundsStrategyMirrorFactory();
            LocalizableByDimCursor cursor = input.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)osmf);
            ImageFactory floatFactory = new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory());
            Image resultImage = floatFactory.createImage(input.getDimensions());
            LocalizableByDimCursor resultCursor = resultImage.createLocalizableByDimCursor();
            int numberOfDimensions = input.getDimensions().length;
            long totalPoints = this.numberOfPoints(input);
            long reportingInterval = totalPoints / 100L;
            Matrix hessian = new Matrix(numberOfDimensions, numberOfDimensions);
            LocalizableByDimCursor ahead = input.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)osmf);
            LocalizableByDimCursor behind = input.createLocalizableByDimCursor((OutOfBoundsStrategyFactory)osmf);
            AbsoluteFloatComparator comparator = new AbsoluteFloatComparator();
            long pointsDone = 0L;
            while (cursor.hasNext()) {
                double l2;
                double l1;
                double cd;
                double c;
                cursor.fwd();
                if (pointsDone % reportingInterval == 0L) {
                    double done = (double)pointsDone / (double)totalPoints;
                    this.progress.updateProgress(done, this.scaleIndex);
                }
                for (int m = 0; m < numberOfDimensions; ++m) {
                    for (int n = 0; n < numberOfDimensions; ++n) {
                        ahead.moveTo((Localizable)cursor);
                        behind.moveTo((Localizable)cursor);
                        ahead.fwd(m);
                        behind.bck(m);
                        ahead.fwd(n);
                        behind.fwd(n);
                        float firstDerivativeA = (((RealType)ahead.getType()).getRealFloat() - ((RealType)behind.getType()).getRealFloat()) / (2.0f * spacing[m]);
                        ahead.bck(n);
                        ahead.bck(n);
                        behind.bck(n);
                        behind.bck(n);
                        float firstDerivativeB = (((RealType)ahead.getType()).getRealFloat() - ((RealType)behind.getType()).getRealFloat()) / (2.0f * spacing[m]);
                        double value = (firstDerivativeA - firstDerivativeB) / (2.0f * spacing[n]);
                        hessian.set(m, n, value);
                    }
                }
                double frobeniusNorm = hessian.normF();
                EigenvalueDecomposition e = hessian.eig();
                double[] eigenvaluesArray = e.getRealEigenvalues();
                ArrayList<Float> eigenvaluesArrayList = new ArrayList<Float>(eigenvaluesArray.length);
                for (double ev : eigenvaluesArray) {
                    eigenvaluesArrayList.add(new Float(ev));
                }
                Collections.sort(eigenvaluesArrayList, comparator);
                double v = 0.0;
                if (numberOfDimensions == 2) {
                    c = 15.0;
                    cd = 2.0 * c * c;
                    l1 = ((Float)eigenvaluesArrayList.get(0)).floatValue();
                    l2 = ((Float)eigenvaluesArrayList.get(1)).floatValue();
                    double rb = l1 / l2;
                    double s = Math.sqrt(l1 * l1 + l2 * l2);
                    double bn = -rb * rb;
                    double cn = -s * s;
                    if (l2 <= 0.0) {
                        v = Math.exp(bn / bd) * (1.0 - Math.exp(cn / cd));
                    }
                } else if (numberOfDimensions == 3) {
                    c = 500.0;
                    cd = 2.0 * c * c;
                    l1 = ((Float)eigenvaluesArrayList.get(0)).floatValue();
                    l2 = ((Float)eigenvaluesArrayList.get(1)).floatValue();
                    double l3 = ((Float)eigenvaluesArrayList.get(2)).floatValue();
                    double rb = Math.abs(l1) / Math.sqrt(Math.abs(l2 * l3));
                    double ra = Math.abs(l2) / Math.abs(l3);
                    double s = Math.sqrt(l1 * l1 + l2 * l2 + l3 * l3);
                    double an = -ra * ra;
                    double bn = -rb * rb;
                    double cn = -s * s;
                    if (l2 <= 0.0 && l3 <= 0.0) {
                        v = (1.0 - Math.exp(an / ad)) * Math.exp(bn / bd) * (1.0 - Math.exp(cn / cd));
                    }
                } else {
                    throw new RuntimeException("Currently only 2 or 3 dimensional images are supported.");
                }
                if (!Double.isNaN(v)) {
                    this.maximumVesselness = Math.max(v, this.maximumVesselness);
                    this.minimumVesselness = Math.min(v, this.minimumVesselness);
                }
                resultCursor.moveTo((Localizable)cursor);
                ((FloatType)resultCursor.getType()).set((float)v);
                ++pointsDone;
            }
            cursor.close();
            ahead.close();
            behind.close();
            resultCursor.close();
            this.result = resultImage;
            return this.result;
        }
    }

    public static class AbsoluteFloatComparator
    implements Comparator {
        public int compare(Object d1, Object d2) {
            return Double.compare(Math.abs(((Float)d1).floatValue()), Math.abs(((Float)d2).floatValue()));
        }
    }
}

