/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.List;
import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rights
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Rights.class);
    private String rightsHolder;
    private String rightsHeld;

    public Rights() {
    }

    public Rights(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Rights(Rights orig) {
        this.rightsHolder = orig.rightsHolder;
        this.rightsHeld = orig.rightsHeld;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> RightsHeld_nodeList;
        super.update(element, model);
        List<Element> RightsHolder_nodeList = Rights.getChildrenByTagName(element, "RightsHolder");
        if (RightsHolder_nodeList.size() > 1) {
            throw new RuntimeException(String.format("RightsHolder node list size %d != 1", RightsHolder_nodeList.size()));
        }
        if (RightsHolder_nodeList.size() != 0) {
            this.setRightsHolder(String.valueOf(RightsHolder_nodeList.get(0).getTextContent()));
        }
        if ((RightsHeld_nodeList = Rights.getChildrenByTagName(element, "RightsHeld")).size() > 1) {
            throw new RuntimeException(String.format("RightsHeld node list size %d != 1", RightsHeld_nodeList.size()));
        }
        if (RightsHeld_nodeList.size() != 0) {
            this.setRightsHeld(String.valueOf(RightsHeld_nodeList.get(0).getTextContent()));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public String getRightsHolder() {
        return this.rightsHolder;
    }

    public void setRightsHolder(String rightsHolder) {
        this.rightsHolder = rightsHolder;
    }

    public String getRightsHeld() {
        return this.rightsHeld;
    }

    public void setRightsHeld(String rightsHeld) {
        this.rightsHeld = rightsHeld;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Rights_element) {
        if (Rights_element == null) {
            Rights_element = document.createElementNS(NAMESPACE, "Rights");
        }
        super.asXMLElement(document, Rights_element);
        if (this.rightsHolder != null) {
            Element rightsHolder_element = document.createElementNS(NAMESPACE, "RightsHolder");
            rightsHolder_element.setTextContent(this.rightsHolder);
            Rights_element.appendChild(rightsHolder_element);
        }
        if (this.rightsHeld != null) {
            Element rightsHeld_element = document.createElementNS(NAMESPACE, "RightsHeld");
            rightsHeld_element.setTextContent(this.rightsHeld);
            Rights_element.appendChild(rightsHeld_element);
        }
        return Rights_element;
    }
}

