/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.bdv;

import bdv.viewer.Source;
import bdv.viewer.ViewerPanel;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Checkbox;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.ClickBehaviour;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.InputTriggerMap;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class CropController<T extends NumericType<T> & NativeType<T>> {
    protected final ViewerPanel viewer;
    private RealPoint lastClick = new RealPoint(3);
    private List<? extends Source<T>> sources;
    private static int width = 1024;
    private static int height = 1024;
    private static int depth = 512;
    private static int scaleLevel = 0;
    private static boolean single4DStack = true;
    private final BehaviourMap behaviourMap = new BehaviourMap();
    private final InputTriggerMap inputTriggerMap = new InputTriggerMap();
    private final InputTriggerAdder inputAdder;
    private final ActionMap ksActionMap = new ActionMap();
    private final InputMap ksInputMap = new InputMap();

    public CropController(ViewerPanel viewer, List<? extends Source<T>> sources, InputTriggerConfig config, InputActionBindings inputActionBindings, KeyStrokeAdder.Factory keyProperties) {
        this.viewer = viewer;
        this.sources = sources;
        this.inputAdder = config.inputTriggerAdder(this.inputTriggerMap, new String[]{"cropLegacy"});
        new Crop("cropLegacy", "ctrl SPACE").register();
        inputActionBindings.addActionMap("select", this.ksActionMap);
        inputActionBindings.addInputMap("select", this.ksInputMap, new String[0]);
    }

    public BehaviourMap getBehaviourMap() {
        return this.behaviourMap;
    }

    public InputTriggerMap getInputTriggerMap() {
        return this.inputTriggerMap;
    }

    private class Crop
    extends SelfRegisteringBehaviour
    implements ClickBehaviour {
        private List<TextField> centerPointTextFields;
        private long[] centerPoint;

        public Crop(String name, String ... defaultTriggers) {
            super(name, defaultTriggers);
        }

        public void click(int x, int y) {
            CropController.this.viewer.displayToGlobalCoordinates((double)x, (double)y, (RealPositionable)CropController.this.lastClick);
            this.centerPoint = new long[CropController.this.lastClick.numDimensions()];
            for (int i = 0; i < this.centerPoint.length; ++i) {
                this.centerPoint[i] = Math.round(CropController.this.lastClick.getDoublePosition(i));
            }
            GenericDialog gd = new GenericDialog("Crop");
            gd.addCheckbox("Custom_center_point", false);
            gd.addNumericField("X : ", (double)this.centerPoint[0], 0);
            gd.addNumericField("Y : ", (double)this.centerPoint[1], 0);
            gd.addNumericField("Z : ", (double)this.centerPoint[2], 0);
            gd.addPanel(new Panel());
            gd.addNumericField("width : ", (double)width, 0, 5, "px");
            gd.addNumericField("height : ", (double)height, 0, 5, "px");
            gd.addNumericField("depth : ", (double)depth, 0, 5, "px");
            gd.addNumericField("scale_level : ", (double)scaleLevel, 0);
            gd.addCheckbox("Single_4D_stack", single4DStack);
            this.centerPointTextFields = new ArrayList<TextField>();
            for (int i = 0; i < 3; ++i) {
                this.centerPointTextFields.add((TextField)gd.getNumericFields().get(i));
            }
            Checkbox centerPointCheckbox = (Checkbox)gd.getCheckboxes().get(0);
            centerPointCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Crop.this.setCenterPointTextFieldsEnabled(e.getStateChange() == 1);
                }
            });
            gd.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent e) {
                    Crop.this.setCenterPointTextFieldsEnabled(false);
                }
            });
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            boolean customCenterPoint = gd.getNextBoolean();
            for (int i = 0; i < 3; ++i) {
                this.centerPoint[i] = (long)gd.getNextNumber();
            }
            width = (int)gd.getNextNumber();
            height = (int)gd.getNextNumber();
            depth = (int)gd.getNextNumber();
            scaleLevel = (int)gd.getNextNumber();
            single4DStack = gd.getNextBoolean();
            int w = width;
            int h = height;
            int d = depth;
            int s = scaleLevel;
            ArrayList<IntervalView> channelsImages = new ArrayList<IntervalView>();
            long[] min = null;
            String centerPosStr = Arrays.toString(this.centerPoint);
            if (customCenterPoint) {
                CropController.this.lastClick.setPosition(this.centerPoint);
            }
            boolean timepoint = true;
            AffineTransform3D firstTransform = null;
            for (int channel = 0; channel < CropController.this.sources.size(); ++channel) {
                Source source = (Source)CropController.this.sources.get(channel);
                if (s < 0 || s >= source.getNumMipmapLevels()) {
                    IJ.log((String)String.format("Specified incorrect scale level %d. Valid range is [%d, %d]", s, 0, source.getNumMipmapLevels() - 1));
                    scaleLevel = source.getNumMipmapLevels() - 1;
                    return;
                }
                RealPoint center = new RealPoint(3);
                AffineTransform3D transform = new AffineTransform3D();
                source.getSourceTransform(1, s, transform);
                transform.applyInverse((RealPositionable)center, (RealLocalizable)CropController.this.lastClick);
                if (firstTransform == null) {
                    firstTransform = transform;
                }
                min = new long[]{Math.round(center.getDoublePosition(0) - 0.5 * (double)w), Math.round(center.getDoublePosition(1) - 0.5 * (double)h), Math.round(center.getDoublePosition(2) - 0.5 * (double)d)};
                long[] size = new long[]{w, h, d};
                IJ.log((String)String.format("Cropping %s pixels at %s using scale level %d", Arrays.toString(size), Arrays.toString(min), s));
                RandomAccessibleInterval img = source.getSource(0, s);
                ExtendedRandomAccessibleInterval imgExtended = Views.extendZero((RandomAccessibleInterval)img);
                IntervalView crop = Views.offsetInterval((RandomAccessible)imgExtended, (long[])min, (long[])size);
                channelsImages.add(crop);
                if (single4DStack) continue;
                ImagePlus imp = this.show((RandomAccessibleInterval)crop, "channel " + channel + " " + centerPosStr);
                this.setMetadata(imp, min, transform);
            }
            if (single4DStack) {
                ImagePlus imp = ImageJFunctions.show((RandomAccessibleInterval)Views.permute((RandomAccessibleInterval)Views.stack(channelsImages), (int)2, (int)3), (String)centerPosStr);
                if (firstTransform != null) {
                    this.setMetadata(imp, min, firstTransform);
                }
            }
            CropController.this.viewer.requestRepaint();
        }

        private void setMetadata(ImagePlus imp, long[] minPixels, AffineTransform3D sourceTransform) {
            double sx = sourceTransform.get(0, 0);
            double sy = sourceTransform.get(1, 1);
            double sz = sourceTransform.get(2, 2);
            imp.getCalibration().pixelWidth = sx;
            imp.getCalibration().pixelHeight = sy;
            imp.getCalibration().pixelDepth = sz;
            imp.getCalibration().xOrigin = sx * (double)minPixels[0];
            imp.getCalibration().yOrigin = sy * (double)minPixels[1];
            imp.getCalibration().zOrigin = sz * (double)minPixels[2];
        }

        private ImagePlus show(RandomAccessibleInterval<T> img, String title) {
            ImagePlus imp = ImageJFunctions.wrap(img, (String)title);
            if (null == imp) {
                return null;
            }
            int[] possible3rdDim = new int[]{imp.getNChannels(), imp.getNSlices(), imp.getNFrames()};
            Arrays.sort(possible3rdDim);
            if (possible3rdDim[0] * possible3rdDim[1] == 1) {
                imp.setDimensions(1, possible3rdDim[2], 1);
            }
            imp.show();
            imp.getProcessor().resetMinAndMax();
            imp.updateAndRepaintWindow();
            return imp;
        }

        private void setCenterPointTextFieldsEnabled(boolean enabled) {
            for (int i = 0; i < this.centerPointTextFields.size(); ++i) {
                TextField tf = this.centerPointTextFields.get(i);
                tf.setEnabled(enabled);
                if (enabled) continue;
                tf.setText(Long.toString(this.centerPoint[i]));
            }
        }
    }

    private abstract class SelfRegisteringBehaviour
    implements Behaviour {
        private final String name;
        private final String[] defaultTriggers;

        public SelfRegisteringBehaviour(String name, String ... defaultTriggers) {
            this.name = name;
            this.defaultTriggers = defaultTriggers;
        }

        public void register() {
            CropController.this.behaviourMap.put(this.name, (Behaviour)this);
            CropController.this.inputAdder.put(this.name, this.defaultTriggers);
        }
    }
}

