/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss;

import net.imglib2.EuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gauss.GaussDouble;
import net.imglib2.algorithm.gauss.GaussFloat;
import net.imglib2.algorithm.gauss.GaussGeneral;
import net.imglib2.algorithm.gauss.GaussNativeType;
import net.imglib2.converter.readwrite.RealDoubleSamplerConverter;
import net.imglib2.converter.readwrite.RealFloatSamplerConverter;
import net.imglib2.converter.readwrite.WriteConvertedIterableRandomAccessibleInterval;
import net.imglib2.converter.readwrite.WriteConvertedRandomAccessible;
import net.imglib2.converter.readwrite.WriteConvertedRandomAccessibleInterval;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

@Deprecated
public class Gauss {
    public static <T extends RealType<T>> Img<FloatType> toFloat(double sigma, Img<T> img) {
        return Gauss.toFloat(Gauss.getSigmaDim(sigma, img), img);
    }

    public static <T extends RealType<T>> Img<FloatType> toFloat(double[] sigma, Img<T> img) {
        return Gauss.toFloat(sigma, img, new OutOfBoundsMirrorFactory<FloatType, RandomAccessibleInterval<FloatType>>(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T extends RealType<T>> Img<FloatType> toFloat(double sigma, Img<T> img, OutOfBoundsFactory<FloatType, RandomAccessibleInterval<FloatType>> outofbounds) {
        return Gauss.toFloat(Gauss.getSigmaDim(sigma, img), img, outofbounds);
    }

    public static <T extends RealType<T>> Img<FloatType> toFloat(double[] sigma, Img<T> img, OutOfBoundsFactory<FloatType, RandomAccessibleInterval<FloatType>> outofbounds) {
        GaussFloat gauss = null;
        try {
            if (FloatType.class.isInstance(img.firstElement())) {
                Img<FloatType> img2 = img;
                gauss = new GaussFloat(sigma, img2);
            } else {
                WriteConvertedIterableRandomAccessibleInterval rIn = new WriteConvertedIterableRandomAccessibleInterval(img, new RealFloatSamplerConverter());
                gauss = new GaussFloat(sigma, Views.extend(rIn, outofbounds), img, img.factory().imgFactory(new FloatType()));
            }
        }
        catch (IncompatibleTypeException e) {
            return null;
        }
        gauss.call();
        return (Img)gauss.getResult();
    }

    public static <T extends RealType<T>> Img<T> inFloat(double sigma, Img<T> img) {
        return Gauss.inFloat(Gauss.getSigmaDim(sigma, img), img);
    }

    public static <T extends RealType<T>> Img<T> inFloat(double[] sigma, Img<T> img) {
        return Gauss.inFloat(sigma, img, new OutOfBoundsMirrorFactory<FloatType, RandomAccessibleInterval<FloatType>>(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T extends RealType<T>> Img<T> inFloat(double sigma, Img<T> img, OutOfBoundsFactory<FloatType, RandomAccessibleInterval<FloatType>> outofbounds) {
        return Gauss.inFloat(Gauss.getSigmaDim(sigma, img), img, outofbounds);
    }

    public static <T extends RealType<T>> Img<T> inFloat(double[] sigma, Img<T> img, OutOfBoundsFactory<FloatType, RandomAccessibleInterval<FloatType>> outofbounds) {
        try {
            if (FloatType.class.isInstance(img.firstElement())) {
                return Gauss.toFloat(sigma, img, outofbounds);
            }
            Img<T> output = img.factory().create(img, img.firstElement());
            ExtendedRandomAccessibleInterval<FloatType, RandomAccessibleInterval<FloatType>> rIn = Views.extend(new WriteConvertedRandomAccessibleInterval(img, new RealFloatSamplerConverter()), outofbounds);
            WriteConvertedRandomAccessible rOut = new WriteConvertedRandomAccessible(output, new RealFloatSamplerConverter());
            Gauss.inFloat(sigma, rIn, img, rOut, (Localizable)new Point(sigma.length), img.factory().imgFactory(new FloatType()));
            return output;
        }
        catch (IncompatibleTypeException e) {
            return null;
        }
    }

    public static <T extends RealType<T>> void inFloatInPlace(double sigma, Img<T> img) {
        Gauss.inFloatInPlace(Gauss.getSigmaDim(sigma, img), img);
    }

    public static <T extends RealType<T>> void inFloatInPlace(double[] sigma, Img<T> img) {
        Gauss.inFloatInPlace(sigma, img, new OutOfBoundsMirrorFactory<FloatType, RandomAccessibleInterval<FloatType>>(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T extends RealType<T>> void inFloatInPlace(double sigma, Img<T> img, OutOfBoundsFactory<FloatType, RandomAccessibleInterval<FloatType>> outofbounds) {
        Gauss.inFloatInPlace(Gauss.getSigmaDim(sigma, img), img, outofbounds);
    }

    public static <T extends RealType<T>> void inFloatInPlace(double[] sigma, Img<T> img, OutOfBoundsFactory<FloatType, RandomAccessibleInterval<FloatType>> outofbounds) {
        GaussFloat gauss = null;
        try {
            if (FloatType.class.isInstance(img.firstElement())) {
                Img<FloatType> img2 = img;
                gauss = new GaussFloat(sigma, Views.extend(img2, outofbounds), img2, img2, new Point(sigma.length), img2.factory().imgFactory(new FloatType()));
            } else {
                WriteConvertedIterableRandomAccessibleInterval rIn = new WriteConvertedIterableRandomAccessibleInterval(img, new RealFloatSamplerConverter());
                gauss = new GaussFloat(sigma, Views.extend(rIn, outofbounds), img, rIn, new Point(sigma.length), img.factory().imgFactory(new FloatType()));
            }
        }
        catch (IncompatibleTypeException e) {
            System.out.println(e);
            return;
        }
        gauss.call();
    }

    public static <T extends RealType<T>> void inFloat(double sigma, RandomAccessible<T> img, Interval interval, RandomAccessible<T> output, Localizable origin, ImgFactory<FloatType> imgFactory) {
        Gauss.inFloat(Gauss.getSigmaDim(sigma, img), img, interval, output, origin, imgFactory);
    }

    public static <T extends RealType<T>> void inFloat(double[] sigma, RandomAccessible<T> img, Interval interval, RandomAccessible<T> output, Localizable origin, ImgFactory<FloatType> imgFactory) {
        long[] tmpCoordinate = new long[img.numDimensions()];
        interval.min(tmpCoordinate);
        RandomAccess<T> tmp = img.randomAccess();
        tmp.setPosition(tmpCoordinate);
        if (FloatType.class.isInstance(tmp.get())) {
            RandomAccessible<FloatType> rIn = img;
            RandomAccessible<FloatType> rOut = output;
            new GaussFloat(sigma, rIn, interval, rOut, origin, imgFactory).call();
        } else {
            WriteConvertedRandomAccessible rIn = new WriteConvertedRandomAccessible(img, new RealFloatSamplerConverter());
            WriteConvertedRandomAccessible rOut = new WriteConvertedRandomAccessible(output, new RealFloatSamplerConverter());
            new GaussFloat(sigma, rIn, interval, rOut, origin, imgFactory).call();
        }
    }

    public static <T extends RealType<T>> Img<DoubleType> toDouble(double sigma, Img<T> img) {
        return Gauss.toDouble(Gauss.getSigmaDim(sigma, img), img);
    }

    public static <T extends RealType<T>> Img<DoubleType> toDouble(double[] sigma, Img<T> img) {
        return Gauss.toDouble(sigma, img, new OutOfBoundsMirrorFactory<DoubleType, RandomAccessibleInterval<DoubleType>>(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T extends RealType<T>> Img<DoubleType> toDouble(double sigma, Img<T> img, OutOfBoundsFactory<DoubleType, RandomAccessibleInterval<DoubleType>> outofbounds) {
        return Gauss.toDouble(Gauss.getSigmaDim(sigma, img), img, outofbounds);
    }

    public static <T extends RealType<T>> Img<DoubleType> toDouble(double[] sigma, Img<T> img, OutOfBoundsFactory<DoubleType, RandomAccessibleInterval<DoubleType>> outofbounds) {
        GaussDouble gauss = null;
        try {
            if (DoubleType.class.isInstance(img.firstElement())) {
                Img<DoubleType> img2 = img;
                gauss = new GaussDouble(sigma, img2);
            } else {
                WriteConvertedIterableRandomAccessibleInterval rIn = new WriteConvertedIterableRandomAccessibleInterval(img, new RealDoubleSamplerConverter());
                gauss = new GaussDouble(sigma, Views.extend(rIn, outofbounds), img, img.factory().imgFactory(new DoubleType()));
            }
        }
        catch (IncompatibleTypeException e) {
            return null;
        }
        gauss.call();
        return (Img)gauss.getResult();
    }

    public static <T extends RealType<T>> Img<T> inDouble(double sigma, Img<T> img) {
        return Gauss.inDouble(Gauss.getSigmaDim(sigma, img), img);
    }

    public static <T extends RealType<T>> Img<T> inDouble(double[] sigma, Img<T> img) {
        return Gauss.inDouble(sigma, img, new OutOfBoundsMirrorFactory<DoubleType, RandomAccessibleInterval<DoubleType>>(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T extends RealType<T>> Img<T> inDouble(double sigma, Img<T> img, OutOfBoundsFactory<DoubleType, RandomAccessibleInterval<DoubleType>> outofbounds) {
        return Gauss.inDouble(Gauss.getSigmaDim(sigma, img), img, outofbounds);
    }

    public static <T extends RealType<T>> Img<T> inDouble(double[] sigma, Img<T> img, OutOfBoundsFactory<DoubleType, RandomAccessibleInterval<DoubleType>> outofbounds) {
        try {
            if (DoubleType.class.isInstance(img.firstElement())) {
                return Gauss.toDouble(sigma, img, outofbounds);
            }
            Img<T> output = img.factory().create(img, img.firstElement());
            ExtendedRandomAccessibleInterval<DoubleType, RandomAccessibleInterval<DoubleType>> rIn = Views.extend(new WriteConvertedRandomAccessibleInterval(img, new RealDoubleSamplerConverter()), outofbounds);
            WriteConvertedRandomAccessible rOut = new WriteConvertedRandomAccessible(output, new RealDoubleSamplerConverter());
            Gauss.inDouble(sigma, rIn, img, rOut, (Localizable)new Point(sigma.length), img.factory().imgFactory(new DoubleType()));
            return output;
        }
        catch (IncompatibleTypeException e) {
            return null;
        }
    }

    public static <T extends RealType<T>> void inDoubleInPlace(double sigma, Img<T> img) {
        Gauss.inDoubleInPlace(Gauss.getSigmaDim(sigma, img), img);
    }

    public static <T extends RealType<T>> void inDoubleInPlace(double[] sigma, Img<T> img) {
        Gauss.inDoubleInPlace(sigma, img, new OutOfBoundsMirrorFactory<DoubleType, RandomAccessibleInterval<DoubleType>>(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T extends RealType<T>> void inDoubleInPlace(double sigma, Img<T> img, OutOfBoundsFactory<DoubleType, RandomAccessibleInterval<DoubleType>> outofbounds) {
        Gauss.inDoubleInPlace(Gauss.getSigmaDim(sigma, img), img, outofbounds);
    }

    public static <T extends RealType<T>> void inDoubleInPlace(double[] sigma, Img<T> img, OutOfBoundsFactory<DoubleType, RandomAccessibleInterval<DoubleType>> outofbounds) {
        GaussDouble gauss = null;
        try {
            if (DoubleType.class.isInstance(img.firstElement())) {
                Img<DoubleType> img2 = img;
                gauss = new GaussDouble(sigma, Views.extend(img2, outofbounds), img2, img2, new Point(sigma.length), img2.factory().imgFactory(new DoubleType()));
            } else {
                WriteConvertedIterableRandomAccessibleInterval rIn = new WriteConvertedIterableRandomAccessibleInterval(img, new RealDoubleSamplerConverter());
                gauss = new GaussDouble(sigma, Views.extend(rIn, outofbounds), img, rIn, new Point(sigma.length), img.factory().imgFactory(new DoubleType()));
            }
        }
        catch (IncompatibleTypeException e) {
            return;
        }
        gauss.call();
    }

    public static <T extends RealType<T>> void inDouble(double sigma, RandomAccessible<T> img, Interval interval, RandomAccessible<T> output, Localizable origin, ImgFactory<DoubleType> imgFactory) {
        Gauss.inDouble(Gauss.getSigmaDim(sigma, img), img, interval, output, origin, imgFactory);
    }

    public static <T extends RealType<T>> void inDouble(double[] sigma, RandomAccessible<T> img, Interval interval, RandomAccessible<T> output, Localizable origin, ImgFactory<DoubleType> imgFactory) {
        long[] tmpCoordinate = new long[img.numDimensions()];
        interval.min(tmpCoordinate);
        RandomAccess<T> tmp = img.randomAccess();
        tmp.setPosition(tmpCoordinate);
        if (DoubleType.class.isInstance(tmp.get())) {
            RandomAccessible<DoubleType> rIn = img;
            RandomAccessible<DoubleType> rOut = output;
            new GaussDouble(sigma, rIn, interval, rOut, origin, imgFactory).call();
        } else {
            WriteConvertedRandomAccessible rIn = new WriteConvertedRandomAccessible(img, new RealDoubleSamplerConverter());
            WriteConvertedRandomAccessible rOut = new WriteConvertedRandomAccessible(output, new RealDoubleSamplerConverter());
            new GaussDouble(sigma, rIn, interval, rOut, origin, imgFactory).call();
        }
    }

    public static <T extends NumericType<T>> Img<T> inNumericType(double sigma, Img<T> img) {
        return Gauss.inNumericType(Gauss.getSigmaDim(sigma, img), img);
    }

    public static <T extends NumericType<T>> Img<T> inNumericType(double[] sigma, Img<T> img) {
        return Gauss.inNumericType(sigma, img, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T extends NumericType<T>> Img<T> inNumericType(double sigma, Img<T> img, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outofbounds) {
        return Gauss.inNumericType(Gauss.getSigmaDim(sigma, img), img, outofbounds);
    }

    public static <T extends NumericType<T>> Img<T> inNumericType(double[] sigma, Img<T> img, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outofbounds) {
        Img<T> output = img.factory().create(img, img.firstElement());
        Gauss.inNumericType(sigma, Views.extend(img, outofbounds), img, output, (Localizable)new Point(sigma.length), img.factory());
        return output;
    }

    public static <T extends NumericType<T>> void inNumericTypeInPlace(double sigma, Img<T> img) {
        Gauss.inNumericTypeInPlace(Gauss.getSigmaDim(sigma, img), img);
    }

    public static <T extends NumericType<T>> void inNumericTypeInPlace(double[] sigma, Img<T> img) {
        Gauss.inNumericTypeInPlace(sigma, img, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T extends NumericType<T>> void inNumericTypeInPlace(double sigma, Img<T> img, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outofbounds) {
        Gauss.inNumericTypeInPlace(Gauss.getSigmaDim(sigma, img), img, outofbounds);
    }

    public static <T extends NumericType<T>> void inNumericTypeInPlace(double[] sigma, Img<T> img, OutOfBoundsFactory<T, RandomAccessibleInterval<T>> outofbounds) {
        Gauss.inNumericType(sigma, Views.extend(img, outofbounds), img, img, (Localizable)new Point(sigma.length), img.factory());
    }

    public static <T extends NumericType<T>> void inNumericType(double sigma, RandomAccessible<T> img, Interval interval, RandomAccessible<T> output, Localizable origin, ImgFactory<T> imgFactory) {
        Gauss.inNumericType(Gauss.getSigmaDim(sigma, img), img, interval, output, origin, imgFactory);
    }

    public static <T extends NumericType<T>> void inNumericType(double[] sigma, RandomAccessible<T> img, Interval interval, RandomAccessible<T> output, Localizable origin, ImgFactory<T> imgFactory) {
        long[] tmpCoordinate = new long[img.numDimensions()];
        interval.min(tmpCoordinate);
        RandomAccess<T> tmp = img.randomAccess();
        tmp.setPosition(tmpCoordinate);
        if (NativeType.class.isInstance(tmp.get())) {
            Gauss.computeInNativeType(sigma, img, interval, output, origin, imgFactory, (Type)tmp.get());
        } else {
            GaussGeneral<NumericType> gauss = new GaussGeneral<NumericType>(sigma, img, interval, output, origin, imgFactory, (NumericType)tmp.get());
            gauss.call();
        }
    }

    private static final <T extends NumericType<T> & NativeType<T>> void computeInNativeType(double[] sigma, RandomAccessible<T> img, Interval interval, RandomAccessible<T> output, Localizable origin, ImgFactory<T> imgFactory, Type type) {
        GaussNativeType<NumericType> gauss = new GaussNativeType<NumericType>(sigma, img, interval, output, origin, imgFactory, (NumericType)type);
        gauss.call();
    }

    private static final double[] getSigmaDim(double sigma, EuclideanSpace img) {
        double[] s = new double[img.numDimensions()];
        for (int d = 0; d < img.numDimensions(); ++d) {
            s[d] = sigma;
        }
        return s;
    }
}

