/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.kdtree;

import gnu.trove.list.array.TIntArrayList;
import java.util.NoSuchElementException;
import net.imglib2.kdtree.KDTreeImpl;

class NodeIndexIterable {
    private final TIntArrayList nodes;
    private final TIntArrayList subtrees;
    private final KDTreeImpl tree;

    NodeIndexIterable(TIntArrayList singleNodes, TIntArrayList subtrees, KDTreeImpl tree) {
        this.nodes = singleNodes;
        this.subtrees = subtrees;
        this.tree = tree;
    }

    NodeIndexIterator iterator() {
        return new NodeIndexIterator();
    }

    private static class IntStack {
        private final int[] elements;
        private int ptr;

        IntStack(int size) {
            this.elements = new int[size];
            this.ptr = 0;
        }

        void push(int element) {
            this.elements[this.ptr++] = element;
        }

        int pop() {
            return this.elements[--this.ptr];
        }

        boolean isEmpty() {
            return this.ptr == 0;
        }
    }

    class NodeIndexIterator {
        private int nextNodeIndex = 0;
        private int nextSubtreeIndex = 0;
        private final IntStack stack;

        NodeIndexIterator() {
            this.stack = new IntStack(NodeIndexIterable.this.tree.depth() + 1);
        }

        int next() {
            if (!this.stack.isEmpty()) {
                return this.pushChildren(this.stack.pop());
            }
            if (this.nextSubtreeIndex < NodeIndexIterable.this.subtrees.size()) {
                return this.pushChildren(NodeIndexIterable.this.subtrees.get(this.nextSubtreeIndex++));
            }
            if (this.nextNodeIndex < NodeIndexIterable.this.nodes.size()) {
                return NodeIndexIterable.this.nodes.get(this.nextNodeIndex++);
            }
            throw new NoSuchElementException();
        }

        boolean hasNext() {
            return !this.stack.isEmpty() || this.nextSubtreeIndex < NodeIndexIterable.this.subtrees.size() || this.nextNodeIndex < NodeIndexIterable.this.nodes.size();
        }

        private int pushChildren(int node) {
            int left = NodeIndexIterable.this.tree.left(node);
            int right = NodeIndexIterable.this.tree.right(node);
            if (left >= 0) {
                this.stack.push(left);
            }
            if (right >= 0) {
                this.stack.push(right);
            }
            return node;
        }
    }
}

