/*
 * Decompiled with CFR 0.152.
 */
package bdv.img.n5;

import java.util.EnumMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.imglib2.Volatile;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.volatiles.VolatileByteType;
import net.imglib2.type.volatiles.VolatileDoubleType;
import net.imglib2.type.volatiles.VolatileFloatType;
import net.imglib2.type.volatiles.VolatileIntType;
import net.imglib2.type.volatiles.VolatileLongType;
import net.imglib2.type.volatiles.VolatileShortType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedIntType;
import net.imglib2.type.volatiles.VolatileUnsignedLongType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;
import org.janelia.saalfeldlab.n5.DataType;

public class DataTypeProperties<T extends NativeType<T>, V extends Volatile<T>, P, A extends DataAccess> {
    private DataType dataType;
    private final T type;
    private final V volatileType;
    private final IntFunction<P> createPrimitiveArray;
    private final Function<P, A> createVolatileArrayAccess;
    private static final EnumMap<DataType, DataTypeProperties<?, ?, ?, ?>> props = new EnumMap(DataType.class);

    private DataTypeProperties(DataType dataType, T type, V volatileType, IntFunction<P> createPrimitiveArray, Function<P, A> createVolatileArrayAccess) {
        this.dataType = dataType;
        this.type = type;
        this.volatileType = volatileType;
        this.createPrimitiveArray = createPrimitiveArray;
        this.createVolatileArrayAccess = createVolatileArrayAccess;
    }

    public IntFunction<P> createPrimitiveArray() {
        return this.createPrimitiveArray;
    }

    public Function<P, A> createVolatileArrayAccess() {
        return this.createVolatileArrayAccess;
    }

    public T type() {
        return this.type;
    }

    public V volatileType() {
        return this.volatileType;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public static DataTypeProperties<?, ?, ?, ?> of(DataType dataType) {
        return props.get(dataType);
    }

    public static <T extends NativeType<T>> DataType n5DataType(T type) {
        if (type instanceof DoubleType) {
            return DataType.FLOAT64;
        }
        if (type instanceof FloatType) {
            return DataType.FLOAT32;
        }
        if (type instanceof LongType) {
            return DataType.INT64;
        }
        if (type instanceof UnsignedLongType) {
            return DataType.UINT64;
        }
        if (type instanceof IntType) {
            return DataType.INT32;
        }
        if (type instanceof UnsignedIntType) {
            return DataType.UINT32;
        }
        if (type instanceof ShortType) {
            return DataType.INT16;
        }
        if (type instanceof UnsignedShortType) {
            return DataType.UINT16;
        }
        if (type instanceof ByteType) {
            return DataType.INT8;
        }
        if (type instanceof UnsignedByteType) {
            return DataType.UINT8;
        }
        return null;
    }

    static {
        props.put(DataType.INT8, new DataTypeProperties<ByteType, VolatileByteType, byte[], VolatileByteArray>(DataType.INT8, new ByteType(), new VolatileByteType(), byte[]::new, data -> new VolatileByteArray((byte[])data, true)));
        props.put(DataType.UINT8, new DataTypeProperties<UnsignedByteType, VolatileUnsignedByteType, byte[], VolatileByteArray>(DataType.UINT8, new UnsignedByteType(), new VolatileUnsignedByteType(), byte[]::new, data -> new VolatileByteArray((byte[])data, true)));
        props.put(DataType.INT16, new DataTypeProperties<ShortType, VolatileShortType, short[], VolatileShortArray>(DataType.INT16, new ShortType(), new VolatileShortType(), short[]::new, data -> new VolatileShortArray((short[])data, true)));
        props.put(DataType.UINT16, new DataTypeProperties<UnsignedShortType, VolatileUnsignedShortType, short[], VolatileShortArray>(DataType.UINT16, new UnsignedShortType(), new VolatileUnsignedShortType(), short[]::new, data -> new VolatileShortArray((short[])data, true)));
        props.put(DataType.INT32, new DataTypeProperties<IntType, VolatileIntType, int[], VolatileIntArray>(DataType.INT32, new IntType(), new VolatileIntType(), int[]::new, data -> new VolatileIntArray((int[])data, true)));
        props.put(DataType.UINT32, new DataTypeProperties<UnsignedIntType, VolatileUnsignedIntType, int[], VolatileIntArray>(DataType.UINT32, new UnsignedIntType(), new VolatileUnsignedIntType(), int[]::new, data -> new VolatileIntArray((int[])data, true)));
        props.put(DataType.INT64, new DataTypeProperties<LongType, VolatileLongType, long[], VolatileLongArray>(DataType.INT64, new LongType(), new VolatileLongType(), long[]::new, data -> new VolatileLongArray((long[])data, true)));
        props.put(DataType.UINT64, new DataTypeProperties<UnsignedLongType, VolatileUnsignedLongType, long[], VolatileLongArray>(DataType.UINT64, new UnsignedLongType(), new VolatileUnsignedLongType(), long[]::new, data -> new VolatileLongArray((long[])data, true)));
        props.put(DataType.FLOAT32, new DataTypeProperties<FloatType, VolatileFloatType, float[], VolatileFloatArray>(DataType.FLOAT32, new FloatType(), new VolatileFloatType(), float[]::new, data -> new VolatileFloatArray((float[])data, true)));
        props.put(DataType.FLOAT64, new DataTypeProperties<DoubleType, VolatileDoubleType, double[], VolatileDoubleArray>(DataType.FLOAT64, new DoubleType(), new VolatileDoubleType(), double[]::new, data -> new VolatileDoubleArray((double[])data, true)));
    }
}

