/*
 * Decompiled with CFR 0.152.
 */
package bdv.tools.bookmarks;

import bdv.tools.bookmarks.BookmarkTextOverlayAnimator;
import bdv.tools.bookmarks.Bookmarks;
import bdv.util.Affine3DHelpers;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.animate.RotationAnimator;
import bdv.viewer.animate.SimilarityTransformAnimator;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import net.imglib2.Point;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class BookmarksEditor {
    private Mode mode = Mode.INACTIVE;
    private volatile boolean initialKey = false;
    private final ArrayList<String> inputMapsToBlock;
    private final AbstractViewerPanel viewer;
    private final InputActionBindings bindings;
    private final ActionMap actionMap;
    private final InputMap inputMap;
    private BookmarkTextOverlayAnimator animator;

    public BookmarksEditor(final AbstractViewerPanel viewer, InputActionBindings inputActionBindings, final Bookmarks bookmarks) {
        this.viewer = viewer;
        this.bindings = inputActionBindings;
        this.inputMapsToBlock = new ArrayList<String>(Arrays.asList("bdv", "navigation"));
        KeyStroke abortKey = KeyStroke.getKeyStroke(27, 0);
        AbstractAction abortAction = new AbstractAction("abort bookmark"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BookmarksEditor.this.abort();
            }
        };
        this.actionMap = new ActionMap();
        this.inputMap = new InputMap();
        this.actionMap.put("abort bookmark", abortAction);
        this.inputMap.put(abortKey, "abort bookmark");
        this.bindings.addActionMap("bookmarks", this.actionMap);
        viewer.getDisplayComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (BookmarksEditor.this.mode != Mode.INACTIVE) {
                    if (BookmarksEditor.this.initialKey) {
                        BookmarksEditor.this.initialKey = false;
                    } else {
                        String key = String.valueOf(e.getKeyChar());
                        switch (BookmarksEditor.this.mode) {
                            case SET: {
                                AffineTransform3D t = new AffineTransform3D();
                                viewer.state().getViewerTransform(t);
                                double cX = (double)viewer.getDisplayComponent().getWidth() / 2.0;
                                double cY = (double)viewer.getDisplayComponent().getHeight() / 2.0;
                                t.set(t.get(0, 3) - cX, 0, 3);
                                t.set(t.get(1, 3) - cY, 1, 3);
                                bookmarks.put(key, t);
                                BookmarksEditor.this.animator.fadeOut("set bookmark: " + key, 500L);
                                viewer.requestRepaint();
                                break;
                            }
                            case RECALL_TRANSFORM: {
                                AffineTransform3D t = bookmarks.get(key);
                                if (t != null) {
                                    AffineTransform3D c = new AffineTransform3D();
                                    viewer.state().getViewerTransform(c);
                                    double cX = (double)viewer.getDisplayComponent().getWidth() / 2.0;
                                    double cY = (double)viewer.getDisplayComponent().getHeight() / 2.0;
                                    c.set(c.get(0, 3) - cX, 0, 3);
                                    c.set(c.get(1, 3) - cY, 1, 3);
                                    viewer.setTransformAnimator(new SimilarityTransformAnimator(c, t, cX, cY, 300L));
                                }
                                BookmarksEditor.this.animator.fadeOut("go to bookmark: " + key, 500L);
                                break;
                            }
                            case RECALL_ORIENTATION: {
                                AffineTransform3D t = bookmarks.get(key);
                                if (t != null) {
                                    AffineTransform3D c = new AffineTransform3D();
                                    viewer.state().getViewerTransform(c);
                                    Point p = new Point(2);
                                    viewer.getMouseCoordinates(p);
                                    double[] qTarget = new double[4];
                                    Affine3DHelpers.extractRotation(t, qTarget);
                                    viewer.setTransformAnimator(new RotationAnimator(c, p.getDoublePosition(0), p.getDoublePosition(1), qTarget, 300L));
                                }
                                BookmarksEditor.this.animator.fadeOut("go to bookmark orientation: " + key, 500L);
                                break;
                            }
                        }
                        BookmarksEditor.this.done();
                    }
                }
            }
        });
    }

    public synchronized void abort() {
        if (this.animator != null) {
            this.animator.clear();
        }
        this.done();
    }

    protected synchronized void init(Mode mode, String message) {
        this.initialKey = true;
        this.mode = mode;
        this.bindings.addInputMap("bookmarks", this.inputMap, this.inputMapsToBlock);
        if (this.animator != null) {
            this.animator.clear();
        }
        this.animator = new BookmarkTextOverlayAnimator(this.viewer);
        this.viewer.addOverlayAnimator(this.animator);
        this.animator.fadeIn(message, 100L);
    }

    public synchronized void initSetBookmark() {
        this.init(Mode.SET, "set bookmark: ");
    }

    public synchronized void initGoToBookmark() {
        this.init(Mode.RECALL_TRANSFORM, "go to bookmark: ");
    }

    public void initGoToBookmarkRotation() {
        this.init(Mode.RECALL_ORIENTATION, "go to bookmark orientation: ");
    }

    public synchronized void done() {
        this.mode = Mode.INACTIVE;
        this.initialKey = false;
        this.bindings.removeInputMap("bookmarks");
    }

    public synchronized void setInputMapsToBlock(Collection<String> idsToBlock) {
        this.inputMapsToBlock.clear();
        this.inputMapsToBlock.addAll(idsToBlock);
    }

    static enum Mode {
        INACTIVE,
        SET,
        RECALL_TRANSFORM,
        RECALL_ORIENTATION;

    }
}

