/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.convertersetupeditor;

import bdv.tools.brightness.ColorIcon;
import bdv.ui.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.imglib2.type.numeric.ARGBType;
import net.miginfocom.swing.MigLayout;
import org.scijava.listeners.Listeners;

class ColorPanel
extends JPanel {
    private final JButton colorButton;
    private final ARGBType color = new ARGBType();
    private final Listeners.List<ChangeListener> listeners = new Listeners.SynchronizedList();
    private boolean isConsistent = true;
    private Color consistentBg = Color.WHITE;
    private Color inConsistentBg = Color.WHITE;

    public ColorPanel() {
        this.setLayout((LayoutManager)new MigLayout("ins 0, fillx, filly, hidemode 3", "[grow]", ""));
        this.updateColors();
        this.colorButton = new JButton();
        this.add((Component)this.colorButton, "center");
        this.colorButton.addActionListener(e -> this.chooseColor());
        this.colorButton.setBorderPainted(false);
        this.colorButton.setFocusPainted(false);
        this.colorButton.setContentAreaFilled(false);
        this.colorButton.setMinimumSize(new Dimension(46, 42));
        this.colorButton.setPreferredSize(new Dimension(46, 42));
        this.setColor(null);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.colorButton != null) {
            this.colorButton.setEnabled(enabled);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateColors();
        if (!this.isConsistent) {
            this.setBackground(this.inConsistentBg);
        }
    }

    private void updateColors() {
        this.consistentBg = UIManager.getColor("Panel.background");
        this.inConsistentBg = UIUtils.mix(this.consistentBg, Color.red, 0.9);
    }

    public void setConsistent(boolean isConsistent) {
        this.isConsistent = isConsistent;
        this.setBackground(isConsistent ? this.consistentBg : this.inConsistentBg);
    }

    private void chooseColor() {
        Color newColor = JColorChooser.showDialog(null, "Set Source Color", new Color(this.color.get()));
        if (newColor == null) {
            return;
        }
        this.setColor(new ARGBType(newColor.getRGB() | 0xFF000000));
        this.listeners.list.forEach(ChangeListener::colorChanged);
    }

    public Listeners<ChangeListener> changeListeners() {
        return this.listeners;
    }

    public synchronized void setColor(ARGBType color) {
        if (color == null) {
            this.color.set(-5592406);
        } else {
            this.color.set(color);
        }
        this.colorButton.setIcon(new ColorIcon(new Color(this.color.get()), 30, 30, 10, 10, true));
    }

    public ARGBType getColor() {
        return this.color.copy();
    }

    public static interface ChangeListener {
        public void colorChanged();
    }
}

