/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.sourcetable;

import bdv.tools.brightness.ColorIcon;
import bdv.ui.UIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import net.imglib2.type.numeric.ARGBType;

class ColorRenderer
extends JLabel
implements TableCellRenderer {
    private final NoColorIcon noColorIcon;

    public ColorRenderer() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.setOpaque(true);
        this.setHorizontalAlignment(0);
        this.noColorIcon = new NoColorIcon(14, 14);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        if (value == null) {
            this.setIcon(this.noColorIcon);
        } else {
            Color c = new Color(((ARGBType)value).get());
            int w = table.getColumnModel().getColumn(3).getWidth() - 6;
            int h = table.getRowHeight() - 6;
            Color outlineColor = UIUtils.mix(c, isSelected ? table.getSelectionForeground() : table.getForeground(), 0.5);
            this.setIcon(new ColorIcon(c, w, h, 5, 5, true, outlineColor));
        }
        return this;
    }

    private static class NoColorIcon
    implements Icon {
        private final int width;
        private final int height;
        private final int size;
        private final int ox;
        private final int oy;
        private final int lox0;
        private final int loy0;
        private final int lox1;
        private final int loy1;
        private final Color color = new Color(0xBBBBBB);
        private final BasicStroke stroke = new BasicStroke(2.0f);

        public NoColorIcon(int width, int height) {
            this.width = width;
            this.height = height;
            this.size = Math.min(width, height);
            this.ox = (width - this.size) / 2;
            this.oy = (height - this.size) / 2;
            this.lox0 = (int)((double)this.ox + (double)this.size * (0.5 * (1.0 - Math.sqrt(0.5))));
            this.loy0 = (int)((double)this.oy + (double)this.size * (0.5 * (1.0 - Math.sqrt(0.5))));
            this.lox1 = (int)((double)this.ox + (double)this.size * (0.5 * (1.0 + Math.sqrt(0.5))));
            this.loy1 = (int)((double)this.oy + (double)this.size * (0.5 * (1.0 + Math.sqrt(0.5))));
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.color);
            g2d.setStroke(this.stroke);
            int lx0 = x + this.lox0;
            int ly0 = y + this.loy0;
            int lx1 = x + this.lox1;
            int ly1 = y + this.loy1;
            g2d.drawLine(lx0, ly0, lx1, ly1);
            int x0 = x + this.ox;
            int y0 = y + this.oy;
            g2d.drawOval(x0, y0, this.size, this.size);
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

