/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.AbstractSource;
import bdv.viewer.Interpolation;
import mpicbg.spim.data.sequence.DefaultVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public class RandomAccessibleIntervalSource<T extends NumericType<T>>
extends AbstractSource<T> {
    private final RandomAccessibleInterval<T> source;
    private final RealRandomAccessible<T>[] interpolatedSources;
    private final AffineTransform3D sourceTransform;

    public RandomAccessibleIntervalSource(RandomAccessibleInterval<T> img, T type, String name) {
        this(img, type, new AffineTransform3D(), name, true);
    }

    public RandomAccessibleIntervalSource(RandomAccessibleInterval<T> img, T type, AffineTransform3D sourceTransform, String name) {
        this(img, type, sourceTransform, name, true);
    }

    public RandomAccessibleIntervalSource(RandomAccessibleInterval<T> img, T type, AffineTransform3D sourceTransform, String name, boolean doBoundingBoxCulling) {
        super(type, name, (VoxelDimensions)new DefaultVoxelDimensions(img.numDimensions()), doBoundingBoxCulling);
        this.source = img;
        this.sourceTransform = sourceTransform;
        this.interpolatedSources = new RealRandomAccessible[Interpolation.values().length];
        NumericType zero = (NumericType)this.getType().createVariable();
        zero.setZero();
        for (Interpolation method : Interpolation.values()) {
            this.interpolatedSources[method.ordinal()] = Views.interpolate(Views.extendValue(this.source, zero), this.interpolators.get(method));
        }
    }

    @Override
    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return this.source;
    }

    @Override
    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return this.interpolatedSources[method.ordinal()];
    }

    @Override
    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.sourceTransform);
    }
}

