/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.smurn.jply.ElementType;
import org.smurn.jply.ListProperty;
import org.smurn.jply.Property;

public final class Element
implements Cloneable {
    private final double[][] data;
    private final ElementType type;
    private final Map<String, Integer> propertyMap;

    Element(double[][] values, ElementType type) {
        if (values == null || type == null) {
            throw new NullPointerException();
        }
        this.data = values;
        this.type = type;
        this.propertyMap = type.getPropertyMap();
    }

    public Element(ElementType type) {
        this.type = type;
        this.propertyMap = type.getPropertyMap();
        List<Property> properties = type.getProperties();
        this.data = new double[properties.size()][];
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = properties.get(i) instanceof ListProperty ? new double[0] : new double[]{0.0};
            ++i;
        }
    }

    public ElementType getType() {
        return this.type;
    }

    public int getInt(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null.");
        }
        Integer index = this.propertyMap.get(propertyName);
        if (index == null) {
            throw new IllegalArgumentException("non existent property: '" + propertyName + "'.");
        }
        if (this.data[index].length == 0) {
            throw new IndexOutOfBoundsException("The property value is a list with zero entries.");
        }
        return (int)this.data[index][0];
    }

    public double getDouble(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null.");
        }
        Integer index = this.propertyMap.get(propertyName);
        if (index == null) {
            throw new IllegalArgumentException("non existent property: '" + propertyName + "'.");
        }
        if (this.data[index].length == 0) {
            throw new IndexOutOfBoundsException("The property value is a list with zero entries.");
        }
        return this.data[index][0];
    }

    public int[] getIntList(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null.");
        }
        Integer index = this.propertyMap.get(propertyName);
        if (index == null) {
            throw new IllegalArgumentException("non existent property: '" + propertyName + "'.");
        }
        int[] v = new int[this.data[index].length];
        int i = 0;
        while (i < v.length) {
            v[i] = (int)this.data[index][i];
            ++i;
        }
        return v;
    }

    public double[] getDoubleList(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null.");
        }
        Integer index = this.propertyMap.get(propertyName);
        if (index == null) {
            throw new IllegalArgumentException("non existent property: '" + propertyName + "'.");
        }
        return (double[])this.data[index].clone();
    }

    public void setDoubleList(String propertyName, double[] values) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null.");
        }
        Integer index = this.propertyMap.get(propertyName);
        if (index == null) {
            throw new IllegalArgumentException("non existent property: '" + propertyName + "'.");
        }
        if (this.type.getProperties().get(index) instanceof ListProperty) {
            this.data[index.intValue()] = (double[])values.clone();
        } else {
            if (values.length != 0) {
                throw new IndexOutOfBoundsException("property is not a list");
            }
            this.data[index.intValue()][0] = values[0];
        }
    }

    public void setDouble(String propertyName, double value) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null.");
        }
        Integer index = this.propertyMap.get(propertyName);
        if (index == null) {
            throw new IllegalArgumentException("non existent property: '" + propertyName + "'.");
        }
        this.data[index.intValue()] = new double[]{value};
    }

    public void setIntList(String propertyName, int[] values) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null.");
        }
        Integer index = this.propertyMap.get(propertyName);
        if (index == null) {
            throw new IllegalArgumentException("non existent property: '" + propertyName + "'.");
        }
        if (this.type.getProperties().get(index) instanceof ListProperty) {
            this.data[index.intValue()] = new double[values.length];
            int i = 0;
            while (i < values.length) {
                this.data[index.intValue()][i] = values[i];
                ++i;
            }
        } else {
            if (values.length != 0) {
                throw new IndexOutOfBoundsException("property is not a list");
            }
            this.data[index.intValue()][0] = values[0];
        }
    }

    public void setInt(String propertyName, int value) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName must not be null.");
        }
        Integer index = this.propertyMap.get(propertyName);
        if (index == null) {
            throw new IllegalArgumentException("non existent property: '" + propertyName + "'.");
        }
        this.data[index.intValue()] = new double[]{value};
    }

    public Element clone() {
        double[][] clone = new double[this.data.length][];
        int i = 0;
        while (i < clone.length) {
            clone[i] = (double[])this.data[i].clone();
            ++i;
        }
        return new Element(clone, this.type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Element rhs = (Element)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.type, (Object)rhs.type);
        builder.append((Object[])this.data, (Object[])rhs.data);
        return builder.isEquals();
    }

    public boolean equals(Element rhs, double epsilon) {
        if (rhs == null) {
            return false;
        }
        if (rhs == this) {
            return true;
        }
        if (!this.type.equals(rhs.type)) {
            return false;
        }
        if (this.data.length != rhs.data.length) {
            return false;
        }
        int i = 0;
        while (i < this.data.length) {
            if (this.data[i].length != rhs.data[i].length) {
                return false;
            }
            int j = 0;
            while (j < this.data[i].length) {
                if (Math.abs(this.data[i][j] - rhs.data[i][j]) > epsilon) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.type);
        builder.append((Object[])this.data);
        return builder.toHashCode();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("Element ");
        str.append(this.type.getName());
        str.append(" {");
        int i = 0;
        while (i < this.type.getProperties().size()) {
            Property property = this.type.getProperties().get(i);
            if (i > 0) {
                str.append(" ");
            }
            str.append(property.getName());
            str.append("=");
            if (property instanceof ListProperty) {
                str.append(Arrays.toString(this.data[i]));
            } else {
                str.append(this.data[i][0]);
            }
            ++i;
        }
        str.append("}");
        return str.toString();
    }
}

