/*
 * Decompiled with CFR 0.152.
 */
package org.smurn.jply.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.smurn.jply.Element;
import org.smurn.jply.ElementReader;
import org.smurn.jply.ElementType;
import org.smurn.jply.util.RandomElementReader;

class BufferedElementReader
implements RandomElementReader {
    private final ElementReader reader;
    private List<Element> buffer = new ArrayList<Element>();
    private int nextElement = 0;
    private boolean closed = false;
    private boolean sourceClosed = false;

    BufferedElementReader(ElementReader reader) {
        if (reader == null) {
            throw new NullPointerException("reader must not be null.");
        }
        this.reader = reader;
    }

    @Override
    public ElementType getElementType() {
        return this.reader.getElementType();
    }

    @Override
    public int getCount() {
        if (this.sourceClosed) {
            return this.buffer.size();
        }
        return this.reader.getCount();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Element readElement(int index) throws IOException {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index is negative.");
        }
        if (!this.closed) ** GOTO lbl10
        throw new IllegalStateException("Reader is closed.");
lbl-1000:
        // 1 sources

        {
            element = this.reader.readElement();
            if (element == null) {
                throw new IndexOutOfBoundsException("Index is larger or equal to the number of elements.");
            }
            this.buffer.add(element);
lbl10:
            // 2 sources

            ** while (index >= this.buffer.size())
        }
lbl11:
        // 1 sources

        return this.buffer.get(index);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Element readElement() throws IOException {
        if (!this.closed) ** GOTO lbl8
        throw new IllegalStateException("Reader is closed.");
lbl-1000:
        // 1 sources

        {
            element = this.sourceClosed != false ? null : this.reader.readElement();
            if (element == null) {
                return null;
            }
            this.buffer.add(element);
lbl8:
            // 2 sources

            ** while (this.nextElement >= this.buffer.size())
        }
lbl9:
        // 1 sources

        return this.buffer.get(this.nextElement++);
    }

    public void reset() {
        this.nextElement = 0;
    }

    @Override
    public RandomElementReader duplicate() {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        return new RandomElementReader(){
            private boolean closed = false;
            private int nextElement = 0;

            @Override
            public Element readElement(int index) throws IOException {
                if (this.closed) {
                    throw new IllegalStateException("Reader closed");
                }
                return BufferedElementReader.this.readElement(index);
            }

            @Override
            public ElementType getElementType() {
                return BufferedElementReader.this.getElementType();
            }

            @Override
            public int getCount() {
                return BufferedElementReader.this.getCount();
            }

            @Override
            public Element readElement() throws IOException {
                if (this.nextElement >= this.getCount()) {
                    return null;
                }
                if (this.closed) {
                    throw new IllegalStateException("Reader closed");
                }
                return BufferedElementReader.this.readElement(this.nextElement++);
            }

            @Override
            public void close() throws IOException {
                this.closed = true;
            }

            @Override
            public RandomElementReader duplicate() {
                return BufferedElementReader.this.duplicate();
            }

            @Override
            public boolean isClosed() {
                return this.closed;
            }
        };
    }

    public void detach() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Reader is closed.");
        }
        Element element = this.reader.readElement();
        while (element != null) {
            this.buffer.add(element);
            element = this.reader.readElement();
        }
        this.reader.close();
        this.sourceClosed = true;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.sourceClosed = true;
        this.buffer = null;
        this.reader.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

