/*
 * Decompiled with CFR 0.152.
 */
package lenscorrection;

import Jama.Matrix;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import mpicbg.trakem2.transform.NonLinearCoordinateTransform;

public class NonLinearTransform
extends NonLinearCoordinateTransform {
    private double[][][] transField = null;
    private boolean precalculated = false;

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
        this.length = (dimension + 1) * (dimension + 2) / 2;
        this.beta = new double[this.length][2];
        this.normMean = new double[this.length];
        this.normVar = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.normMean[i] = 0.0;
            this.normVar[i] = 1.0;
        }
        this.transField = null;
        this.precalculated = false;
    }

    public int getMinNumMatches() {
        return this.length;
    }

    public void fit(double[][] x, double[][] y, double lambda) {
        double[][] expandedX = this.kernelExpandMatrixNormalize(x);
        Matrix phiX = new Matrix(expandedX, expandedX.length, this.length);
        Matrix phiXTransp = phiX.transpose();
        Matrix phiXProduct = phiXTransp.times(phiX);
        int l = phiXProduct.getRowDimension();
        double lambda2 = 2.0 * lambda;
        for (int i = 0; i < l; ++i) {
            phiXProduct.set(i, i, phiXProduct.get(i, i) + lambda2);
        }
        Matrix phiXPseudoInverse = phiXProduct.inverse();
        Matrix phiXProduct2 = phiXPseudoInverse.times(phiXTransp);
        Matrix betaMatrix = phiXProduct2.times(new Matrix(y, y.length, 2));
        this.setBeta(betaMatrix.getArray());
    }

    public void estimateDistortion(double[][] hack1, double[][] hack2, double[][] transformParams, double lambda, int w, int h) {
        this.beta = new double[this.length][2];
        this.normMean = new double[this.length];
        this.normVar = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.normMean[i] = 0.0;
            this.normVar[i] = 1.0;
        }
        this.width = w;
        this.height = h;
        double[][] expandedX = this.kernelExpandMatrixNormalize(hack1);
        double[][] expandedY = this.kernelExpandMatrix(hack2);
        int s = expandedX[0].length;
        Matrix S1 = new Matrix(2 * s, 2 * s);
        Matrix S2 = new Matrix(2 * s, 1);
        for (int i = 0; i < expandedX.length; ++i) {
            Matrix xk_ij = new Matrix(expandedX[i], 1);
            Matrix xk_ji = new Matrix(expandedY[i], 1);
            Matrix yk1a = xk_ij.minus(xk_ji.times(transformParams[i][0]));
            Matrix yk1b = xk_ij.times(0.0).minus(xk_ji.times(-transformParams[i][2]));
            Matrix yk2a = xk_ij.times(0.0).minus(xk_ji.times(-transformParams[i][1]));
            Matrix yk2b = xk_ij.minus(xk_ji.times(transformParams[i][3]));
            Matrix y = new Matrix(2, 2 * s);
            y.setMatrix(0, 0, 0, s - 1, yk1a);
            y.setMatrix(0, 0, s, 2 * s - 1, yk1b);
            y.setMatrix(1, 1, 0, s - 1, yk2a);
            y.setMatrix(1, 1, s, 2 * s - 1, yk2b);
            Matrix xk = new Matrix(2, 2 * expandedX[0].length);
            xk.setMatrix(0, 0, 0, s - 1, xk_ij);
            xk.setMatrix(1, 1, s, 2 * s - 1, xk_ij);
            double[] vals = new double[]{hack1[i][0], hack1[i][1]};
            Matrix c = new Matrix(vals, 2);
            Matrix X = xk.transpose().times(xk).times(lambda);
            Matrix Y = y.transpose().times(y);
            S1 = S1.plus(Y.plus(X));
            double trans1 = transformParams[i][2] * transformParams[i][5] - transformParams[i][0] * transformParams[i][4];
            double trans2 = transformParams[i][1] * transformParams[i][4] - transformParams[i][3] * transformParams[i][5];
            double[] trans = new double[]{trans1, trans2};
            Matrix translation = new Matrix(trans, 2);
            Matrix YT = y.transpose().times(translation);
            Matrix XC = xk.transpose().times(c).times(lambda);
            S2 = S2.plus(YT.plus(XC));
        }
        Matrix regularize = Matrix.identity((int)S1.getRowDimension(), (int)S1.getColumnDimension());
        Matrix newBeta = new Matrix(S1.plus(regularize.times(0.001)).inverse().times(S2).getColumnPackedCopy(), s);
        this.setBeta(newBeta.getArray());
    }

    public NonLinearTransform(double[][] b, double[] nm, double[] nv, int d, int w, int h) {
        this.beta = b;
        this.normMean = nm;
        this.normVar = nv;
        this.dimension = d;
        this.length = (this.dimension + 1) * (this.dimension + 2) / 2;
        this.width = w;
        this.height = h;
    }

    public NonLinearTransform(int d, int w, int h) {
        this.dimension = d;
        this.length = (this.dimension + 1) * (this.dimension + 2) / 2;
        this.beta = new double[this.length][2];
        this.normMean = new double[this.length];
        this.normVar = new double[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.normMean[i] = 0.0;
            this.normVar[i] = 1.0;
        }
        this.width = w;
        this.height = h;
    }

    public NonLinearTransform() {
    }

    public NonLinearTransform(String filename) {
        this.load(filename);
    }

    public NonLinearTransform(double[][] coeffMatrix, int w, int h) {
        this.length = coeffMatrix.length;
        this.beta = new double[this.length][2];
        this.normMean = new double[this.length];
        this.normVar = new double[this.length];
        this.width = w;
        this.height = h;
        this.dimension = (int)(-1.5 + Math.sqrt(0.25 + (double)(2 * this.length)));
        for (int i = 0; i < this.length; ++i) {
            this.beta[i][0] = coeffMatrix[0][i];
            this.beta[i][1] = coeffMatrix[1][i];
            this.normMean[i] = coeffMatrix[2][i];
            this.normVar[i] = coeffMatrix[3][i];
        }
    }

    void precalculateTransfom() {
        this.transField = new double[this.width][this.height][2];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                double[] position = new double[]{x, y};
                double[] featureVector = this.kernelExpand(position);
                double[] newPosition = NonLinearTransform.multiply((double[][])this.beta, (double[])featureVector);
                if (newPosition[0] < 0.0 || newPosition[0] >= (double)this.width || newPosition[1] < 0.0 || newPosition[1] >= (double)this.height) {
                    this.transField[x][y][0] = -1.0;
                    this.transField[x][y][1] = -1.0;
                    continue;
                }
                this.transField[x][y][0] = newPosition[0];
                this.transField[x][y][1] = newPosition[1];
            }
        }
        this.precalculated = true;
    }

    public double[][] getCoefficients() {
        double[][] coeffMatrix = new double[4][this.length];
        for (int i = 0; i < this.length; ++i) {
            coeffMatrix[0][i] = this.beta[i][0];
            coeffMatrix[1][i] = this.beta[i][1];
            coeffMatrix[2][i] = this.normMean[i];
            coeffMatrix[3][i] = this.normVar[i];
        }
        return coeffMatrix;
    }

    public void setBeta(double[][] b) {
        this.beta = b;
    }

    public void print() {
        int i;
        System.out.println("beta:");
        for (i = 0; i < this.beta.length; ++i) {
            for (int j = 0; j < this.beta[i].length; ++j) {
                System.out.print(this.beta[i][j]);
                System.out.print(" ");
            }
            System.out.println();
        }
        System.out.println("normMean:");
        for (i = 0; i < this.normMean.length; ++i) {
            System.out.print(this.normMean[i]);
            System.out.print(" ");
        }
        System.out.println("normVar:");
        for (i = 0; i < this.normVar.length; ++i) {
            System.out.print(this.normVar[i]);
            System.out.print(" ");
        }
        System.out.println("Image size:");
        System.out.println("width: " + this.width + " height: " + this.height);
        System.out.println();
    }

    public void save(String filename) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filename)));
            try {
                int i;
                out.write("Kerneldimension");
                out.newLine();
                out.write(Integer.toString(this.dimension));
                out.newLine();
                out.newLine();
                out.write("number of rows");
                out.newLine();
                out.write(Integer.toString(this.length));
                out.newLine();
                out.newLine();
                out.write("Coefficients of the transform matrix:");
                out.newLine();
                for (i = 0; i < this.length; ++i) {
                    String s = Double.toString(this.beta[i][0]);
                    s = s + "    ";
                    s = s + Double.toString(this.beta[i][1]);
                    out.write(s);
                    out.newLine();
                }
                out.newLine();
                out.write("normMean:");
                out.newLine();
                for (i = 0; i < this.length; ++i) {
                    out.write(Double.toString(this.normMean[i]));
                    out.newLine();
                }
                out.newLine();
                out.write("normVar: ");
                out.newLine();
                for (i = 0; i < this.length; ++i) {
                    out.write(Double.toString(this.normVar[i]));
                    out.newLine();
                }
                out.newLine();
                out.write("image size: ");
                out.newLine();
                out.write(this.width + "    " + this.height);
                out.close();
            }
            catch (IOException e) {
                System.out.println("IOException");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found!");
        }
    }

    public void load(String filename) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            try {
                int i;
                String line = in.readLine();
                this.dimension = Integer.parseInt(in.readLine());
                line = in.readLine();
                line = in.readLine();
                this.length = Integer.parseInt(in.readLine());
                line = in.readLine();
                line = in.readLine();
                this.beta = new double[this.length][2];
                for (i = 0; i < this.length; ++i) {
                    line = in.readLine();
                    int ind = line.indexOf(" ");
                    this.beta[i][0] = Double.parseDouble(line.substring(0, ind));
                    this.beta[i][1] = Double.parseDouble(line.substring(ind + 4));
                }
                line = in.readLine();
                line = in.readLine();
                this.normMean = new double[this.length];
                for (i = 0; i < this.length; ++i) {
                    this.normMean[i] = Double.parseDouble(in.readLine());
                }
                line = in.readLine();
                line = in.readLine();
                this.normVar = new double[this.length];
                for (i = 0; i < this.length; ++i) {
                    this.normVar[i] = Double.parseDouble(in.readLine());
                }
                line = in.readLine();
                line = in.readLine();
                line = in.readLine();
                int ind = line.indexOf(" ");
                this.width = Integer.parseInt(line.substring(0, ind));
                this.height = Integer.parseInt(line.substring(ind + 4));
                in.close();
                this.print();
            }
            catch (IOException e) {
                System.out.println("IOException");
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found!");
        }
    }

    public ImageProcessor[] transform(ImageProcessor ip) {
        if (!this.precalculated) {
            this.precalculateTransfom();
        }
        ImageProcessor newIp = ip.createProcessor(ip.getWidth(), ip.getHeight());
        if (ip instanceof ColorProcessor) {
            ip.max(0.0);
        }
        ByteProcessor maskIp = new ByteProcessor(ip.getWidth(), ip.getHeight());
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (this.transField[x][y][0] == -1.0) continue;
                newIp.set(x, y, (int)ip.getInterpolatedPixel((double)((int)this.transField[x][y][0]), (double)((int)this.transField[x][y][1])));
                maskIp.set(x, y, 255);
            }
        }
        return new ImageProcessor[]{newIp, maskIp};
    }

    public double[][] kernelExpandMatrixNormalize(double[][] positions) {
        int i;
        this.normMean = new double[this.length];
        this.normVar = new double[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            this.normMean[i2] = 0.0;
            this.normVar[i2] = 1.0;
        }
        double[][] expanded = new double[positions.length][this.length];
        for (i = 0; i < positions.length; ++i) {
            expanded[i] = this.kernelExpand(positions[i]);
        }
        for (i = 0; i < this.length; ++i) {
            int j;
            double mean = 0.0;
            double var = 0.0;
            for (j = 0; j < expanded.length; ++j) {
                mean += expanded[j][i];
            }
            mean /= (double)expanded.length;
            for (j = 0; j < expanded.length; ++j) {
                var += (expanded[j][i] - mean) * (expanded[j][i] - mean);
            }
            var /= (double)(expanded.length - 1);
            var = Math.sqrt(var);
            this.normMean[i] = mean;
            this.normVar[i] = var;
        }
        return this.kernelExpandMatrix(positions);
    }

    public double[][] kernelExpandMatrix(double[][] positions) {
        double[][] expanded = new double[positions.length][this.length];
        for (int i = 0; i < positions.length; ++i) {
            expanded[i] = this.kernelExpand(positions[i]);
        }
        return expanded;
    }

    public void inverseTransform(double[][] range) {
        Matrix expanded = new Matrix(this.kernelExpandMatrix(range));
        Matrix b = new Matrix(this.beta);
        Matrix transformed = expanded.times(b);
        expanded = new Matrix(this.kernelExpandMatrixNormalize(transformed.getArray()));
        Matrix r = new Matrix(range);
        Matrix invBeta = expanded.transpose().times(expanded).inverse().times(expanded.transpose()).times(r);
        this.setBeta(invBeta.getArray());
    }

    public void visualize() {
        int density = Math.max(this.width, this.height) / 32;
        int border = Math.max(this.width, this.height) / 8;
        double[][] orig = new double[this.width * this.height][2];
        double[][] trans = new double[this.height * this.width][2];
        double[][] gridOrigVert = new double[this.width * this.height][2];
        double[][] gridTransVert = new double[this.width * this.height][2];
        double[][] gridOrigHor = new double[this.width * this.height][2];
        double[][] gridTransHor = new double[this.width * this.height][2];
        FloatProcessor magnitude = new FloatProcessor(this.width, this.height);
        FloatProcessor angle = new FloatProcessor(this.width, this.height);
        ColorProcessor quiver = new ColorProcessor(this.width, this.height);
        ByteProcessor empty = new ByteProcessor(this.width + 2 * border, this.height + 2 * border);
        quiver.setLineWidth(1);
        quiver.setColor(Color.green);
        GeneralPath quiverField = new GeneralPath();
        float minM = 1000.0f;
        float maxM = 0.0f;
        float minArc = 5.0f;
        float maxArc = -6.0f;
        int countVert = 0;
        int countHor = 0;
        int countHorWhole = 0;
        for (int i = 0; i < this.width; ++i) {
            countHor = 0;
            for (int j = 0; j < this.height; ++j) {
                double[] position = new double[]{i, j};
                double[] posExpanded = this.kernelExpand(position);
                double[] newPosition = NonLinearTransform.multiply((double[][])this.beta, (double[])posExpanded);
                orig[i * j][0] = position[0];
                orig[i * j][1] = position[1];
                trans[i * j][0] = newPosition[0];
                trans[i * j][1] = newPosition[1];
                double m = (position[0] - newPosition[0]) * (position[0] - newPosition[0]);
                m += (position[1] - newPosition[1]) * (position[1] - newPosition[1]);
                m = Math.sqrt(m);
                magnitude.setf(i, j, (float)m);
                minM = Math.min(minM, (float)m);
                maxM = Math.max(maxM, (float)m);
                double a = Math.atan2(position[0] - newPosition[0], position[1] - newPosition[1]);
                minArc = Math.min(minArc, (float)a);
                maxArc = Math.max(maxArc, (float)a);
                angle.setf(i, j, (float)a);
                if (i % density == 0 && j % density == 0) {
                    NonLinearTransform.drawQuiverField(quiverField, position[0], position[1], newPosition[0], newPosition[1]);
                }
                if (i % density == 0) {
                    gridOrigVert[countVert][0] = position[0] + (double)border;
                    gridOrigVert[countVert][1] = position[1] + (double)border;
                    gridTransVert[countVert][0] = newPosition[0] + (double)border;
                    gridTransVert[countVert][1] = newPosition[1] + (double)border;
                    ++countVert;
                }
                if (j % density != 0) continue;
                gridOrigHor[countHor * this.width + i][0] = position[0] + (double)border;
                gridOrigHor[countHor * this.width + i][1] = position[1] + (double)border;
                gridTransHor[countHor * this.width + i][0] = newPosition[0] + (double)border;
                gridTransHor[countHor * this.width + i][1] = newPosition[1] + (double)border;
                ++countHor;
                ++countHorWhole;
            }
        }
        magnitude.setMinAndMax((double)minM, (double)maxM);
        angle.setMinAndMax((double)minArc, (double)maxArc);
        ImagePlus magImg = new ImagePlus("Magnitude of Distortion Field", (ImageProcessor)magnitude);
        magImg.show();
        ImagePlus quiverImg = new ImagePlus("Quiver Plot of Distortion Field", (ImageProcessor)magnitude);
        quiverImg.show();
        quiverImg.getCanvas().setDisplayList((Shape)quiverField, Color.green, null);
        quiverImg.updateAndDraw();
        GeneralPath gridTrans = new GeneralPath();
        NonLinearTransform.drawGrid(gridTrans, gridTransVert, countVert, this.height);
        NonLinearTransform.drawGrid(gridTrans, gridTransHor, countHorWhole, this.width);
        ImagePlus gridImgTrans = new ImagePlus("Distortion Grid", (ImageProcessor)empty);
        gridImgTrans.show();
        gridImgTrans.getCanvas().setDisplayList((Shape)gridTrans, Color.green, null);
        gridImgTrans.updateAndDraw();
        new FileSaver(quiverImg).saveAsTiff("QuiverImPs.tif");
        System.out.println("FINISHED");
    }

    public void visualizeSmall(double lambda) {
        int density = Math.max(this.width, this.height) / 32;
        double[][] orig = new double[2][this.width * this.height];
        double[][] trans = new double[2][this.height * this.width];
        FloatProcessor magnitude = new FloatProcessor(this.width, this.height);
        GeneralPath quiverField = new GeneralPath();
        float minM = 1000.0f;
        float maxM = 0.0f;
        float minArc = 5.0f;
        float maxArc = -6.0f;
        boolean countVert = false;
        boolean countHor = false;
        boolean countHorWhole = false;
        for (int i = 0; i < this.width; ++i) {
            countHor = false;
            for (int j = 0; j < this.height; ++j) {
                double[] position = new double[]{i, j};
                double[] posExpanded = this.kernelExpand(position);
                double[] newPosition = NonLinearTransform.multiply((double[][])this.beta, (double[])posExpanded);
                orig[0][i * j] = position[0];
                orig[1][i * j] = position[1];
                trans[0][i * j] = newPosition[0];
                trans[1][i * j] = newPosition[1];
                double m = (position[0] - newPosition[0]) * (position[0] - newPosition[0]);
                m += (position[1] - newPosition[1]) * (position[1] - newPosition[1]);
                m = Math.sqrt(m);
                magnitude.setf(i, j, (float)m);
                minM = Math.min(minM, (float)m);
                maxM = Math.max(maxM, (float)m);
                if (i % density != 0 || j % density != 0) continue;
                NonLinearTransform.drawQuiverField(quiverField, position[0], position[1], newPosition[0], newPosition[1]);
            }
        }
        magnitude.setMinAndMax((double)minM, (double)maxM);
        ImagePlus quiverImg = new ImagePlus("Quiver Plot for lambda = " + lambda, (ImageProcessor)magnitude);
        quiverImg.show();
        quiverImg.getCanvas().setDisplayList((Shape)quiverField, Color.green, null);
        quiverImg.updateAndDraw();
        System.out.println("FINISHED");
    }

    public static void drawGrid(GeneralPath g, double[][] points, int count, int s) {
        for (int i = 0; i < count - 1; ++i) {
            if ((i + 1) % s == 0) continue;
            g.moveTo((float)points[i][0], (float)points[i][1]);
            g.lineTo((float)points[i + 1][0], (float)points[i + 1][1]);
        }
    }

    public static void drawQuiverField(GeneralPath qf, double x1, double y1, double x2, double y2) {
        qf.moveTo((float)x1, (float)y1);
        qf.lineTo((float)x2, (float)y2);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public final NonLinearTransform copy() {
        NonLinearTransform t = new NonLinearTransform();
        t.init(this.toDataString());
        return t;
    }

    public void set(NonLinearTransform nlt) {
        this.dimension = nlt.dimension;
        this.height = nlt.height;
        this.length = nlt.length;
        this.precalculated = nlt.precalculated;
        this.width = nlt.width;
        this.beta = new double[nlt.beta.length][];
        for (int i = 0; i < nlt.beta.length; ++i) {
            this.beta[i] = (double[])nlt.beta[i].clone();
        }
        this.normMean = (double[])nlt.normMean.clone();
        this.normVar = (double[])nlt.normVar.clone();
        this.transField = new double[nlt.transField.length][][];
        for (int a = 0; a < nlt.transField.length; ++a) {
            this.transField[a] = new double[nlt.transField[a].length][];
            for (int b = 0; b < nlt.transField[a].length; ++b) {
                this.transField[a][b] = (double[])nlt.transField[a][b].clone();
            }
        }
    }
}

