/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import ij.plugin.filter.GaussianBlur;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ini.trakem2.display.Patch;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;
import java.util.List;
import mpicbg.trakem2.transform.ExportARGB;
import mpicbg.trakem2.transform.ExportUnsignedByte;
import mpicbg.trakem2.util.Pair;

public class ExportBestFlatImage {
    public final List<Patch> patches;
    public final Rectangle finalBox;
    public final int backgroundValue;
    public final double scale;
    public final double largest_possibly_needed_area;
    public final double max_possible_area;
    public final double scaleUP;
    protected final Loader loader;

    public ExportBestFlatImage(List<Patch> patches, Rectangle finalBox, int backgroundValue, double scale) {
        this.patches = patches;
        this.finalBox = finalBox;
        this.backgroundValue = backgroundValue;
        this.scale = scale;
        this.loader = patches.get(0).getProject().getLoader();
        this.largest_possibly_needed_area = (double)finalBox.width * (double)finalBox.height * scale * scale * 4.0;
        this.max_possible_area = Math.min(this.largest_possibly_needed_area, Math.pow(2.0, 31.0));
        this.scaleUP = Math.min(1.0, Math.sqrt(this.max_possible_area / this.largest_possibly_needed_area)) - Math.max(1.0 / (double)finalBox.width, 1.0 / (double)finalBox.height);
    }

    public boolean canUseAWTImage() {
        return (double)((long)this.finalBox.width * (long)this.finalBox.height) * this.scale * this.scale * 4.0 < Math.pow(2.0, 29.0) && this.loader.isMipMapsRegenerationEnabled();
    }

    public boolean isSmallerThan2GB() {
        return (double)this.finalBox.width * this.scale * (double)this.finalBox.height * this.scale <= Math.pow(2.0, 31.0);
    }

    public void printInfo() {
        System.out.println("###\nExportBestFlatImage dimensions and quality scale ");
        System.out.println("srcRect w,h: " + this.finalBox.width + ", " + this.finalBox.height);
        System.out.println("area: " + this.largest_possibly_needed_area);
        System.out.println("max_area: " + this.max_possible_area);
        System.out.println("scale: " + this.scale);
        System.out.println("scaleUP: " + this.scaleUP);
    }

    protected FloatProcessor convertToFloat(ShortProcessor sp) {
        short[] pixS = (short[])sp.getPixels();
        this.loader.releaseToFit(pixS.length * 4);
        float[] pixF = new float[pixS.length];
        for (int i = 0; i < pixS.length; ++i) {
            pixF[i] = pixS[i] & 0xFFFF;
        }
        return new FloatProcessor(sp.getWidth(), sp.getHeight(), pixF);
    }

    public double computeSigma(int width, int height) {
        double max_dimension_source = Math.max(width, height);
        double max_dimension_target = Math.max((int)((double)this.finalBox.width * this.scale), (int)((double)this.finalBox.height * this.scale));
        double s = 0.5;
        double sigma = 0.5 * max_dimension_source / max_dimension_target - 0.25;
        return sigma;
    }

    protected FloatProcessor gaussianDownsampled(FloatProcessor ip) {
        this.loader.releaseToFit(((float[])ip.getPixels()).length * 2);
        double sigma = this.computeSigma(ip.getWidth(), ip.getHeight());
        Utils.log("Gaussian downsampling. If this is slow, check the number of threads in the plugin preferences.");
        new GaussianBlur().blurFloat(ip, sigma, sigma, 2.0E-4);
        ip.setInterpolationMethod(0);
        return (FloatProcessor)ip.resize((int)Math.ceil((double)this.finalBox.width * this.scale));
    }

    protected Image createAWTImage(int type, Color background) {
        return this.loader.getFlatAWTImage(this.patches.get(0).getLayer(), this.finalBox, this.scale, -1, type, Patch.class, this.patches, true, background, null);
    }

    protected Image createAWTImage(int type) {
        return this.loader.getFlatAWTImage(this.patches.get(0).getLayer(), this.finalBox, this.scale, -1, type, Patch.class, this.patches, true, Color.black, null);
    }

    public Pair<ColorProcessor, ByteProcessor> makeFlatColorImage() {
        if (this.canUseAWTImage()) {
            ColorProcessor cp = new ColorProcessor(this.createAWTImage(4));
            ByteProcessor alpha = new ByteProcessor(cp.getWidth(), cp.getHeight(), cp.getChannel(4));
            return new Pair((Object)cp, (Object)alpha);
        }
        if (!this.isSmallerThan2GB()) {
            Utils.log("Cannot create an image larger than 2 GB.");
            return null;
        }
        if (this.loader.isMipMapsRegenerationEnabled()) {
            return ExportARGB.makeFlatImageARGBFromMipMaps(this.patches, this.finalBox, 0.0, this.scale);
        }
        Pair<ColorProcessor, ByteProcessor> pair = ExportARGB.makeFlatImageARGBFromOriginals(this.patches, this.finalBox, 0.0, this.scaleUP);
        double sigma = this.computeSigma(((ColorProcessor)pair.a).getWidth(), ((ColorProcessor)pair.a).getHeight());
        new GaussianBlur().blurGaussian((ImageProcessor)pair.a, sigma, sigma, 2.0E-4);
        new GaussianBlur().blurGaussian((ImageProcessor)pair.b, sigma, sigma, 2.0E-4);
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteProcessor makeFlatGrayImage() {
        if (this.canUseAWTImage()) {
            Image img = this.createAWTImage(0);
            try {
                if (img instanceof BufferedImage && 10 == ((BufferedImage)img).getType()) {
                    ByteProcessor byteProcessor = new ByteProcessor((BufferedImage)img);
                    return byteProcessor;
                }
                PixelGrabber pg = new PixelGrabber(img, 0, 0, img.getWidth(null), img.getHeight(null), false);
                try {
                    pg.grabPixels();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
                if (pg.getColorModel() instanceof IndexColorModel) {
                    ByteProcessor byteProcessor = new ByteProcessor(img.getWidth(null), img.getHeight(null), (byte[])pg.getPixels(), null);
                    return byteProcessor;
                }
                ByteProcessor byteProcessor = new ColorProcessor(img).convertToByteProcessor();
                return byteProcessor;
            }
            finally {
                img.flush();
            }
        }
        if (!this.isSmallerThan2GB()) {
            Utils.log("Cannot create an image larger than 2 GB.");
            return null;
        }
        if (this.loader.isMipMapsRegenerationEnabled()) {
            return (ByteProcessor)ExportUnsignedByte.makeFlatImageFromMipMaps(this.patches, (Rectangle)this.finalBox, (double)0.0, (double)this.scale).a;
        }
        return (ByteProcessor)ExportUnsignedByte.makeFlatImageFromOriginals(this.patches, (Rectangle)this.finalBox, (double)0.0, (double)this.scale).a;
    }

    public Pair<ByteProcessor, ByteProcessor> makeFlatGrayImageAndAlpha() {
        if (this.canUseAWTImage()) {
            Image img = this.createAWTImage(4);
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            int[] pixels = new int[width * height];
            PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            byte[] grey = new byte[pixels.length];
            byte[] alpha = new byte[pixels.length];
            for (int i = 0; i < pixels.length; ++i) {
                int p = pixels[i];
                alpha[i] = (byte)((p & 0xFF000000) >> 24);
                grey[i] = (byte)((float)(((p & 0xFF0000) >> 16) + ((p & 0xFF00) >> 8) + (p & 0xFF)) / 3.0f);
            }
            return new Pair((Object)new ByteProcessor(width, height, grey, null), (Object)new ByteProcessor(width, height, alpha, null));
        }
        if (!this.isSmallerThan2GB()) {
            Utils.log("Cannot create an image larger than 2 GB.");
            return null;
        }
        if (this.loader.isMipMapsRegenerationEnabled()) {
            return ExportUnsignedByte.makeFlatImageFromMipMaps(this.patches, this.finalBox, 0.0, this.scale);
        }
        return ExportUnsignedByte.makeFlatImageFromOriginals(this.patches, this.finalBox, 0.0, this.scale);
    }

    public Pair<FloatProcessor, FloatProcessor> makeFlatFloatGrayImageAndAlpha() {
        if (this.canUseAWTImage()) {
            Image img = this.createAWTImage(4, new Color(0, true));
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            int[] pixels = new int[width * height];
            PixelGrabber pg = new PixelGrabber(img, 0, 0, width, height, pixels, 0, width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            float[] grey = new float[pixels.length];
            float[] alpha = new float[pixels.length];
            for (int i = 0; i < pixels.length; ++i) {
                int p = pixels[i];
                alpha[i] = (p & 0xFF000000) >>> 24;
                grey[i] = (float)(((p & 0xFF0000) >>> 16) + ((p & 0xFF00) >>> 8) + (p & 0xFF)) / 3.0f;
            }
            return new Pair((Object)new FloatProcessor(width, height, grey, null), (Object)new FloatProcessor(width, height, alpha, null));
        }
        if (!this.isSmallerThan2GB()) {
            Utils.log("Cannot create an image larger than 2 GB.");
            return null;
        }
        if (this.loader.isMipMapsRegenerationEnabled()) {
            Pair<ByteProcessor, ByteProcessor> pair = ExportUnsignedByte.makeFlatImageFromMipMaps(this.patches, this.finalBox, 0.0, this.scale);
            return new Pair((Object)((ByteProcessor)pair.a).convertToFloatProcessor(), (Object)((ByteProcessor)pair.b).convertToFloatProcessor());
        }
        this.loader.releaseAll();
        Pair<ByteProcessor, ByteProcessor> pair = ExportUnsignedByte.makeFlatImageFromOriginals(this.patches, this.finalBox, 0.0, this.scale);
        return new Pair((Object)((ByteProcessor)pair.a).convertToFloatProcessor(), (Object)((ByteProcessor)pair.b).convertToFloatProcessor());
    }
}

