/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.DefaultBlockReader;
import org.janelia.saalfeldlab.n5.GsonN5Reader;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;

public interface GsonKeyValueN5Reader
extends GsonN5Reader {
    public KeyValueAccess getKeyValueAccess();

    default public boolean groupExists(String normalPath) {
        return this.getKeyValueAccess().isDirectory(this.absoluteGroupPath(normalPath));
    }

    @Override
    default public boolean exists(String pathName) {
        String normalPath = N5URI.normalizeGroupPath(pathName);
        return this.groupExists(normalPath) || this.datasetExists(normalPath);
    }

    @Override
    default public boolean datasetExists(String pathName) throws N5Exception {
        return this.getDatasetAttributes(pathName) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public JsonElement getAttributes(String pathName) throws N5Exception {
        String groupPath = N5URI.normalizeGroupPath(pathName);
        String attributesPath = this.absoluteAttributesPath(groupPath);
        try (LockedChannel lockedChannel = this.getKeyValueAccess().lockForReading(attributesPath);){
            JsonElement jsonElement = GsonUtils.readAttributes(lockedChannel.newReader(), this.getGson());
            return jsonElement;
        }
        catch (N5Exception.N5NoSuchKeyException e) {
            return null;
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to read attributes from dataset " + pathName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    default public DataBlock<?> readBlock(String pathName, DatasetAttributes datasetAttributes, long ... gridPosition) throws N5Exception {
        String path = this.absoluteDataBlockPath(N5URI.normalizeGroupPath(pathName), gridPosition);
        try (LockedChannel lockedChannel = this.getKeyValueAccess().lockForReading(path);){
            DataBlock<?> dataBlock = DefaultBlockReader.readBlock(lockedChannel.newInputStream(), datasetAttributes, gridPosition);
            return dataBlock;
        }
        catch (N5Exception.N5NoSuchKeyException e) {
            return null;
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to read block " + Arrays.toString(gridPosition) + " from dataset " + path, e);
        }
    }

    @Override
    default public String[] list(String pathName) throws N5Exception {
        try {
            return this.getKeyValueAccess().listDirectories(this.absoluteGroupPath(pathName));
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Cannot list directories for group " + pathName, e);
        }
    }

    default public String absoluteDataBlockPath(String normalPath, long ... gridPosition) {
        String[] components = new String[gridPosition.length + 1];
        components[0] = normalPath;
        int i = 0;
        for (long p : gridPosition) {
            components[++i] = Long.toString(p);
        }
        return this.getKeyValueAccess().compose(this.getURI(), components);
    }

    default public String absoluteGroupPath(String normalGroupPath) {
        return this.getKeyValueAccess().compose(this.getURI(), normalGroupPath);
    }

    default public String absoluteAttributesPath(String normalPath) {
        return this.getKeyValueAccess().compose(this.getURI(), normalPath, "attributes.json");
    }
}

