/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser.function;

import fiji.expressionparser.function.SingleOperandPixelBasedAbstractFunction;
import net.imglib2.type.numeric.RealType;

public final class ImgLibAbs<T extends RealType<T>>
extends SingleOperandPixelBasedAbstractFunction<T> {
    public static final String DOCUMENTATION_STRING = "<h3>Element-wise absolute value</h3> This function computes the absolute value of an ImgLib image, taking each pixel as its operand. Calculations are done using <i>Math.abs</i>.";

    public ImgLibAbs() {
        this.numberOfParameters = 1;
    }

    @Override
    public final <R extends RealType<R>> float evaluate(R alpha) {
        return (float)Math.abs(alpha.getRealDouble());
    }

    @Override
    public String getDocumentationString() {
        return DOCUMENTATION_STRING;
    }

    @Override
    public String getFunctionString() {
        return "abs";
    }

    @Override
    public String toString() {
        return "Pixel-wise absolute value";
    }
}

