/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJGradient;
import VolumeJ.VJMatrix;

public class VJPlane {
    private float A;
    private float B;
    private float C;
    private float D;

    public VJPlane(float[] p, float[] q, float[] r) {
        this.solve(p, q, r);
    }

    public VJPlane(VJPlane p) {
        this.A = p.A;
        this.B = p.B;
        this.C = p.C;
        this.D = p.D;
    }

    public VJPlane(VJPlane p, float[] q) {
        this.A = p.A;
        this.B = p.B;
        this.C = p.C;
        this.D = -(this.A * q[0] + this.B * q[1] + this.C * q[2]);
    }

    public VJPlane(float[] p, float[] q, float[] r, VJMatrix m) {
        float[] tsp = m.mul(p);
        float[] tsq = m.mul(q);
        float[] tsr = m.mul(r);
        this.solve(tsp, tsq, tsr);
    }

    private void solve(float[] p, float[] q, float[] r) {
        float[] v1 = new float[]{q[0] - p[0], q[1] - p[1], q[2] - p[2]};
        float[] v2 = new float[]{r[0] - p[0], r[1] - p[1], r[2] - p[2]};
        this.A = v1[1] * v2[2] - v1[2] * v2[1];
        this.B = v1[2] * v2[0] - v1[0] * v2[2];
        this.C = v1[0] * v2[1] - v1[1] * v2[0];
        this.D = -(this.A * p[0] + this.B * p[1] + this.C * p[2]);
    }

    private float[] intersect(float x0, float y0, float z0, float dx, float dy, float dz) {
        if (this.A * dx + this.B * dy + this.C * dz == 0.0f) {
            return null;
        }
        float t = -(this.A * x0 + this.B * y0 + this.C * z0 + this.D) / (this.A * dx + this.B * dy + this.C * dz);
        return VJMatrix.newVector(x0 + t * dx, y0 + t * dy, z0 + t * dz);
    }

    public float intersectRay(float x0, float y0) {
        if (this.C == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        float t = -(this.A * x0 + this.B * y0 + this.D) / this.C;
        return t;
    }

    public static float check(float x, float y, float z, float a, float b, float c, float d) {
        return a * x + b * y + c * z + d;
    }

    public VJGradient getGradient() {
        VJGradient g = new VJGradient(this.A, this.B, this.C);
        g.normalize();
        return g;
    }

    public float getA() {
        return this.A;
    }

    public float getB() {
        return this.B;
    }

    public float getC() {
        return this.C;
    }

    public float getD() {
        return this.D;
    }

    public void setD(float d) {
        this.D = d;
    }

    public String toString() {
        return "plane eq: " + this.A + "x + " + this.B + "y + " + this.C + "z + " + this.D + " = 0";
    }
}

