/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import java.util.List;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.unidata.geoloc.vertical.OceanS;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.util.Parameter;

public class CFOceanS
extends AbstractTransformBuilder
implements VertTransformBuilderIF {
    private String s = "";
    private String eta = "";
    private String depth = "";
    private String a = "";
    private String b = "";
    private String depth_c = "";

    @Override
    public String getTransformName() {
        return VerticalCT.Type.OceanS.name();
    }

    @Override
    public VerticalCT makeCoordinateTransform(NetcdfDataset ds, AttributeContainer ctv) {
        String formula_terms = this.getFormula(ctv);
        if (null == formula_terms) {
            return null;
        }
        String[] values = this.parseFormula(formula_terms, "s eta depth a b depth_c");
        if (values == null) {
            return null;
        }
        this.s = values[0];
        this.eta = values[1];
        this.depth = values[2];
        this.a = values[3];
        this.b = values[4];
        this.depth_c = values[5];
        VerticalCT rs = new VerticalCT("OceanS_Transform_" + ctv.getName(), this.getTransformName(), VerticalCT.Type.OceanS, this);
        rs.addParameter(new Parameter("standard_name", this.getTransformName()));
        rs.addParameter(new Parameter("formula_terms", formula_terms));
        rs.addParameter(new Parameter("height_formula", "height(x,y,z) = depth_c*s(z) + (depth(x,y)-depth_c)*C(z) + eta(x,y) * (1 + (depth_c*s(z) + (depth(x,y)-depth_c)*C(z))/depth(x,y) "));
        rs.addParameter(new Parameter("C_formula", "C(z) = (1-b)*sinh(a*s(z))/sinh(a) + b*(tanh(a*(s(z)+0.5))/(2*tanh(0.5*a))-0.5)"));
        if (!this.addParameter(rs, "Eta_variableName", ds, this.eta)) {
            return null;
        }
        if (!this.addParameter(rs, "S_variableName", ds, this.s)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_variableName", ds, this.depth)) {
            return null;
        }
        if (!this.addParameter(rs, "Depth_c_variableName", ds, this.depth_c)) {
            return null;
        }
        if (!this.addParameter(rs, "A_variableName", ds, this.a)) {
            return null;
        }
        if (!this.addParameter(rs, "B_variableName", ds, this.b)) {
            return null;
        }
        return rs;
    }

    public String toString() {
        return "OceanS: s:" + this.s + " eta:" + this.eta + " depth:" + this.depth + " a:" + this.a + " b:" + this.b + " depth_c:" + this.depth_c;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new OceanS(ds, timeDim, (List<Parameter>)vCT.getParameters());
    }
}

