/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.resourcemanager.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.resourcemanager.v3.CreateTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.CreateTagKeyRequest;
import com.google.cloud.resourcemanager.v3.DeleteTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.DeleteTagKeyRequest;
import com.google.cloud.resourcemanager.v3.GetNamespacedTagKeyRequest;
import com.google.cloud.resourcemanager.v3.GetTagKeyRequest;
import com.google.cloud.resourcemanager.v3.ListTagKeysRequest;
import com.google.cloud.resourcemanager.v3.ListTagKeysResponse;
import com.google.cloud.resourcemanager.v3.TagKey;
import com.google.cloud.resourcemanager.v3.TagKeyName;
import com.google.cloud.resourcemanager.v3.TagKeysSettings;
import com.google.cloud.resourcemanager.v3.UpdateTagKeyMetadata;
import com.google.cloud.resourcemanager.v3.UpdateTagKeyRequest;
import com.google.cloud.resourcemanager.v3.stub.TagKeysStub;
import com.google.cloud.resourcemanager.v3.stub.TagKeysStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class TagKeysClient
implements BackgroundResource {
    private final TagKeysSettings settings;
    private final TagKeysStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final TagKeysClient create() throws IOException {
        return TagKeysClient.create(TagKeysSettings.newBuilder().build());
    }

    public static final TagKeysClient create(TagKeysSettings settings) throws IOException {
        return new TagKeysClient(settings);
    }

    public static final TagKeysClient create(TagKeysStub stub) {
        return new TagKeysClient(stub);
    }

    protected TagKeysClient(TagKeysSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TagKeysStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected TagKeysClient(TagKeysStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final TagKeysSettings getSettings() {
        return this.settings;
    }

    public TagKeysStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListTagKeysPagedResponse listTagKeys(ResourceName parent) {
        ListTagKeysRequest request = ListTagKeysRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTagKeys(request);
    }

    public final ListTagKeysPagedResponse listTagKeys(String parent) {
        ListTagKeysRequest request = ListTagKeysRequest.newBuilder().setParent(parent).build();
        return this.listTagKeys(request);
    }

    public final ListTagKeysPagedResponse listTagKeys(ListTagKeysRequest request) {
        return (ListTagKeysPagedResponse)((Object)this.listTagKeysPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTagKeysRequest, ListTagKeysPagedResponse> listTagKeysPagedCallable() {
        return this.stub.listTagKeysPagedCallable();
    }

    public final UnaryCallable<ListTagKeysRequest, ListTagKeysResponse> listTagKeysCallable() {
        return this.stub.listTagKeysCallable();
    }

    public final TagKey getTagKey(TagKeyName name) {
        GetTagKeyRequest request = GetTagKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTagKey(request);
    }

    public final TagKey getTagKey(String name) {
        GetTagKeyRequest request = GetTagKeyRequest.newBuilder().setName(name).build();
        return this.getTagKey(request);
    }

    public final TagKey getTagKey(GetTagKeyRequest request) {
        return (TagKey)this.getTagKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetTagKeyRequest, TagKey> getTagKeyCallable() {
        return this.stub.getTagKeyCallable();
    }

    public final TagKey getNamespacedTagKey(TagKeyName name) {
        GetNamespacedTagKeyRequest request = GetNamespacedTagKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getNamespacedTagKey(request);
    }

    public final TagKey getNamespacedTagKey(String name) {
        GetNamespacedTagKeyRequest request = GetNamespacedTagKeyRequest.newBuilder().setName(name).build();
        return this.getNamespacedTagKey(request);
    }

    public final TagKey getNamespacedTagKey(GetNamespacedTagKeyRequest request) {
        return (TagKey)this.getNamespacedTagKeyCallable().call((Object)request);
    }

    public final UnaryCallable<GetNamespacedTagKeyRequest, TagKey> getNamespacedTagKeyCallable() {
        return this.stub.getNamespacedTagKeyCallable();
    }

    public final OperationFuture<TagKey, CreateTagKeyMetadata> createTagKeyAsync(TagKey tagKey) {
        CreateTagKeyRequest request = CreateTagKeyRequest.newBuilder().setTagKey(tagKey).build();
        return this.createTagKeyAsync(request);
    }

    public final OperationFuture<TagKey, CreateTagKeyMetadata> createTagKeyAsync(CreateTagKeyRequest request) {
        return this.createTagKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTagKeyRequest, TagKey, CreateTagKeyMetadata> createTagKeyOperationCallable() {
        return this.stub.createTagKeyOperationCallable();
    }

    public final UnaryCallable<CreateTagKeyRequest, Operation> createTagKeyCallable() {
        return this.stub.createTagKeyCallable();
    }

    public final OperationFuture<TagKey, UpdateTagKeyMetadata> updateTagKeyAsync(TagKey tagKey, FieldMask updateMask) {
        UpdateTagKeyRequest request = UpdateTagKeyRequest.newBuilder().setTagKey(tagKey).setUpdateMask(updateMask).build();
        return this.updateTagKeyAsync(request);
    }

    public final OperationFuture<TagKey, UpdateTagKeyMetadata> updateTagKeyAsync(UpdateTagKeyRequest request) {
        return this.updateTagKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTagKeyRequest, TagKey, UpdateTagKeyMetadata> updateTagKeyOperationCallable() {
        return this.stub.updateTagKeyOperationCallable();
    }

    public final UnaryCallable<UpdateTagKeyRequest, Operation> updateTagKeyCallable() {
        return this.stub.updateTagKeyCallable();
    }

    public final OperationFuture<TagKey, DeleteTagKeyMetadata> deleteTagKeyAsync(TagKeyName name) {
        DeleteTagKeyRequest request = DeleteTagKeyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTagKeyAsync(request);
    }

    public final OperationFuture<TagKey, DeleteTagKeyMetadata> deleteTagKeyAsync(String name) {
        DeleteTagKeyRequest request = DeleteTagKeyRequest.newBuilder().setName(name).build();
        return this.deleteTagKeyAsync(request);
    }

    public final OperationFuture<TagKey, DeleteTagKeyMetadata> deleteTagKeyAsync(DeleteTagKeyRequest request) {
        return this.deleteTagKeyOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTagKeyRequest, TagKey, DeleteTagKeyMetadata> deleteTagKeyOperationCallable() {
        return this.stub.deleteTagKeyOperationCallable();
    }

    public final UnaryCallable<DeleteTagKeyRequest, Operation> deleteTagKeyCallable() {
        return this.stub.deleteTagKeyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTagKeysFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTagKeysRequest, ListTagKeysResponse, TagKey, ListTagKeysPage, ListTagKeysFixedSizeCollection> {
        private ListTagKeysFixedSizeCollection(List<ListTagKeysPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTagKeysFixedSizeCollection createEmptyCollection() {
            return new ListTagKeysFixedSizeCollection(null, 0);
        }

        protected ListTagKeysFixedSizeCollection createCollection(List<ListTagKeysPage> pages, int collectionSize) {
            return new ListTagKeysFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTagKeysPage
    extends AbstractPage<ListTagKeysRequest, ListTagKeysResponse, TagKey, ListTagKeysPage> {
        private ListTagKeysPage(PageContext<ListTagKeysRequest, ListTagKeysResponse, TagKey> context, ListTagKeysResponse response) {
            super(context, (Object)response);
        }

        private static ListTagKeysPage createEmptyPage() {
            return new ListTagKeysPage(null, null);
        }

        protected ListTagKeysPage createPage(PageContext<ListTagKeysRequest, ListTagKeysResponse, TagKey> context, ListTagKeysResponse response) {
            return new ListTagKeysPage(context, response);
        }

        public ApiFuture<ListTagKeysPage> createPageAsync(PageContext<ListTagKeysRequest, ListTagKeysResponse, TagKey> context, ApiFuture<ListTagKeysResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTagKeysPagedResponse
    extends AbstractPagedListResponse<ListTagKeysRequest, ListTagKeysResponse, TagKey, ListTagKeysPage, ListTagKeysFixedSizeCollection> {
        public static ApiFuture<ListTagKeysPagedResponse> createAsync(PageContext<ListTagKeysRequest, ListTagKeysResponse, TagKey> context, ApiFuture<ListTagKeysResponse> futureResponse) {
            ApiFuture<ListTagKeysPage> futurePage = ListTagKeysPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTagKeysPagedResponse((ListTagKeysPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTagKeysPagedResponse(ListTagKeysPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTagKeysFixedSizeCollection.createEmptyCollection());
        }
    }
}

