/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.detection;

import java.util.ArrayList;
import java.util.List;
import net.imagej.ImageJService;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import sc.fiji.filamentdetector.detection.AbstractFilamentDetector;
import sc.fiji.filamentdetector.detection.FilamentDetector;
import sc.fiji.filamentdetector.detection.IJ2RidgeDetectionFilamentDetector;
import sc.fiji.filamentdetector.detection.RidgeDetectionFilamentDetector;

@Plugin(type=Service.class)
public class FilamentDetectorService
extends AbstractService
implements ImageJService {
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private PluginService pluginService;

    public List<FilamentDetector> getDetectors() {
        ArrayList<FilamentDetector> detectors = new ArrayList<FilamentDetector>();
        AbstractFilamentDetector detector = new RidgeDetectionFilamentDetector();
        detector.setContext(this.context);
        detectors.add(detector);
        detector = new IJ2RidgeDetectionFilamentDetector();
        detector.setContext(this.context);
        detectors.add(detector);
        return detectors;
    }

    public RidgeDetectionFilamentDetector getRidgeFilamentDetector() {
        PluginInfo pluginInfo = this.pluginService.getPlugin(RidgeDetectionFilamentDetector.class);
        try {
            RidgeDetectionFilamentDetector plugin = (RidgeDetectionFilamentDetector)pluginInfo.createInstance();
            plugin.setContext(this.context);
            return plugin;
        }
        catch (InstantiableException e) {
            this.log.error((Object)("Can't load the following Filament Detector : " + pluginInfo.getName()));
            this.log.error((Object)e.getMessage());
            return null;
        }
    }

    public IJ2RidgeDetectionFilamentDetector getIJ2RidgeFilamentDetector() {
        PluginInfo pluginInfo = this.pluginService.getPlugin(IJ2RidgeDetectionFilamentDetector.class);
        try {
            IJ2RidgeDetectionFilamentDetector plugin = (IJ2RidgeDetectionFilamentDetector)pluginInfo.createInstance();
            plugin.setContext(this.context);
            return plugin;
        }
        catch (InstantiableException e) {
            this.log.error((Object)("Can't load the following Filament Detector : " + pluginInfo.getName()));
            this.log.error((Object)e.getMessage());
            return null;
        }
    }
}

