/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.overlay;

import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.frame.RoiManager;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.imagej.Dataset;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayService;
import net.imagej.ops.OpService;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.convert.ConvertService;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import sc.fiji.filamentdetector.event.FilamentSelectedEvent;
import sc.fiji.filamentdetector.event.ImageNotFoundEvent;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.Filaments;
import sc.fiji.filamentdetector.model.Tip;
import sc.fiji.filamentdetector.model.TrackedFilament;
import sc.fiji.filamentdetector.model.TrackedFilaments;
import sc.fiji.filamentdetector.overlay.ColorService;
import sc.fiji.filamentdetector.overlay.FilamentOverlayService;
import sc.fiji.filamentdetector.overlay.ImageDisplayMode;

@Plugin(type=Service.class)
public class DefaultFilamentOverlayService
extends AbstractService
implements FilamentOverlayService,
MouseListener {
    private static int DEFAULT_COLOR_ALPHA = 190;
    private static int DEFAULT_FILAMENT_WIDTH = 1;
    @Parameter
    private ConvertService convert;
    @Parameter
    private OpService op;
    @Parameter
    private LogService log;
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private ColorService colorService;
    @Parameter
    private EventService eventService;
    private int filamentWidth = DEFAULT_FILAMENT_WIDTH;
    private int colorAlpha = DEFAULT_COLOR_ALPHA;
    private HashMap<Filament, Roi> filamentROIMap = new HashMap();
    private List<Filament> filamentDisplayed = new ArrayList<Filament>();
    private List<TrackedFilament> trackedFilamentDisplayed = new ArrayList<TrackedFilament>();
    private ImageDisplay imageDisplay;
    private ImagePlus imagePlus;
    private List<Filament> selectedFilaments = new ArrayList<Filament>();
    private List<TrackedFilament> selectedTrackedFilament = new ArrayList<TrackedFilament>();
    private boolean drawBoundingBoxes = false;
    private HashMap<Filament, Roi> filamentBoundingBoxesMap = new HashMap();
    private HashMap<TrackedFilament, List<Roi>> filamentPlusTipsMap = new HashMap();
    private HashMap<TrackedFilament, List<Roi>> filamentMinusTipsMap = new HashMap();
    private boolean drawPlusTips = false;
    private boolean drawMinusTips = false;
    private int tipDiameter = 10;

    @Override
    public void add(Filament filament) {
        Dataset data = (Dataset)this.imageDisplay.getActiveView().getData();
        ImagePlus imp = this.getImagePlus();
        Roi roi = filament.getRoi();
        if (data.numDimensions() > 3) {
            roi.setPosition(-1, -1, filament.getFrame() + 1);
        } else {
            roi.setPosition(filament.getFrame() + 1);
        }
        roi.setName(Integer.toString(filament.getId()));
        roi.setStrokeWidth((float)this.filamentWidth);
        Color color = filament.getColor();
        Color realColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.colorAlpha);
        roi.setStrokeColor(realColor);
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
            imp.setOverlay(overlay);
        }
        if (this.drawBoundingBoxes) {
            Roi boundsRoi = new Roi(roi.getBounds().x, roi.getBounds().y, roi.getBounds().width, roi.getBounds().height);
            boundsRoi.setStrokeColor(realColor);
            boundsRoi.setStrokeWidth(1.0f);
            if (data.numDimensions() > 3) {
                boundsRoi.setPosition(-1, -1, filament.getFrame() + 1);
            } else {
                boundsRoi.setPosition(filament.getFrame() + 1);
            }
            this.filamentBoundingBoxesMap.put(filament, boundsRoi);
            overlay.add(boundsRoi);
        }
        overlay.add(roi);
        imp.repaintWindow();
        this.filamentROIMap.put(filament, roi);
        if (!this.filamentDisplayed.contains(filament)) {
            this.filamentDisplayed.add(filament);
        }
    }

    @Override
    public void add(Filaments filaments) {
        for (Filament filament : filaments) {
            this.add(filament);
        }
    }

    @Override
    public void add(TrackedFilament trackedFilament) {
        List<Roi> rois;
        this.trackedFilamentDisplayed.add(trackedFilament);
        for (Filament filament : trackedFilament) {
            this.add(filament);
        }
        if (this.drawPlusTips) {
            rois = this.addTip(trackedFilament, trackedFilament.getPlusTip());
            this.filamentPlusTipsMap.put(trackedFilament, rois);
        }
        if (this.drawMinusTips) {
            rois = this.addTip(trackedFilament, trackedFilament.getMinusTip());
            this.filamentMinusTipsMap.put(trackedFilament, rois);
        }
    }

    private List<Roi> addTip(TrackedFilament trackedFilament, Tip tip) {
        Dataset data = (Dataset)this.imageDisplay.getActiveView().getData();
        ImagePlus imp = this.getImagePlus();
        Color color = trackedFilament.getColor();
        Color realColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.colorAlpha);
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            overlay = new Overlay();
            imp.setOverlay(overlay);
        }
        ArrayList<Roi> rois = new ArrayList<Roi>();
        for (int i = 0; i < tip.getX().length; ++i) {
            double x = tip.getX()[i];
            double y = tip.getY()[i];
            int frame = tip.getFrames()[i];
            OvalRoi tipRoi = new OvalRoi(x - (double)(this.tipDiameter / 2), y - (double)(this.tipDiameter / 2), (double)this.tipDiameter, (double)this.tipDiameter);
            tipRoi.setStrokeColor(realColor);
            tipRoi.setStrokeWidth((float)this.filamentWidth);
            if (data.numDimensions() > 3) {
                tipRoi.setPosition(-1, -1, frame + 1);
            } else {
                tipRoi.setPosition(frame + 1);
            }
            overlay.add((Roi)tipRoi);
            rois.add((Roi)tipRoi);
        }
        return rois;
    }

    @Override
    public void add(TrackedFilaments trackedFilaments) {
        for (TrackedFilament trackedFilament : trackedFilaments) {
            this.add(trackedFilament);
        }
    }

    @Override
    public void clearSelection() {
        for (Filament filament : this.selectedFilaments) {
            Roi oldRoi = this.filamentROIMap.get(filament);
            if (oldRoi == null) continue;
            oldRoi.setStrokeWidth(oldRoi.getStrokeWidth() / 2.0f);
        }
        this.selectedFilaments.clear();
        this.selectedTrackedFilament.clear();
    }

    @Override
    public void disableOverlay(boolean disable) {
        ImagePlus imp = this.getImagePlus();
        imp.setHideOverlay(!disable);
    }

    @Override
    public void exportToROIManager() {
        ImagePlus imp = this.getImagePlus();
        Overlay overlay = imp.getOverlay();
        if (overlay != null) {
            RoiManager rm = RoiManager.getInstance();
            if (rm == null) {
                rm = RoiManager.getRoiManager();
            }
            for (int i = 0; i < overlay.size(); ++i) {
                rm.addRoi(overlay.get(i));
            }
        }
    }

    @Override
    public int getColorAlpha() {
        return this.colorAlpha;
    }

    @Override
    public int getFilamentWidth() {
        return this.filamentWidth;
    }

    @Override
    public ImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        ImagePlus imp = this.getImagePlus();
        if (imp.getWindow() == null || imp.getWindow().getCanvas() == null) {
            return;
        }
        double x = imp.getWindow().getCanvas().offScreenXD(event.getX());
        double y = imp.getWindow().getCanvas().offScreenYD(event.getY());
        int frame = imp.getFrame();
        for (Map.Entry<Filament, Roi> entry : this.filamentROIMap.entrySet()) {
            Filament filament = entry.getKey();
            Roi roi = entry.getValue();
            if (roi.getTPosition() != frame || !roi.getBounds().contains((int)Math.floor(x), (int)Math.floor(y))) continue;
            this.eventService.publish((SciJavaEvent)new FilamentSelectedEvent(filament));
            break;
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void remove(Filament filament) {
        ImagePlus imp = this.getImagePlus();
        if (imp != null) {
            Roi roiToRemove = this.filamentROIMap.get(filament);
            Roi boundingBoxToRemove = this.filamentBoundingBoxesMap.get(filament);
            Overlay overlay = imp.getOverlay();
            try {
                if (overlay != null) {
                    if (roiToRemove != null) {
                        overlay.remove(roiToRemove);
                    }
                    if (boundingBoxToRemove != null) {
                        overlay.remove(boundingBoxToRemove);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.filamentROIMap.remove(filament);
            this.filamentDisplayed.remove(filament);
            this.filamentBoundingBoxesMap.remove(filament);
            imp.updateAndDraw();
        }
    }

    @Override
    public void remove(Filaments filaments) {
        for (Filament filament : filaments) {
            this.remove(filament);
        }
        this.getImagePlus().updateAndDraw();
    }

    @Override
    public void remove(TrackedFilament trackedFilament) {
        this.trackedFilamentDisplayed.remove(trackedFilament);
        for (Filament filament : trackedFilament) {
            this.remove(filament);
        }
        ImagePlus imp = this.getImagePlus();
        List<Roi> plusTipToRemove = this.filamentPlusTipsMap.get(trackedFilament);
        List<Roi> minusTipToRemove = this.filamentMinusTipsMap.get(trackedFilament);
        Overlay overlay = imp.getOverlay();
        if (plusTipToRemove != null) {
            for (Roi roi : plusTipToRemove) {
                if (overlay == null || roi == null) continue;
                overlay.remove(roi);
            }
        }
        if (minusTipToRemove != null) {
            for (Roi roi : minusTipToRemove) {
                if (overlay == null || roi == null) continue;
                overlay.remove(roi);
            }
        }
        this.filamentPlusTipsMap.remove(trackedFilament);
        this.filamentMinusTipsMap.remove(trackedFilament);
        this.getImagePlus().updateAndDraw();
    }

    @Override
    public void remove(TrackedFilaments trackedFilaments) {
        for (TrackedFilament trackedFilament : trackedFilaments) {
            this.trackedFilamentDisplayed.remove(trackedFilament);
            this.remove(trackedFilament);
        }
        this.getImagePlus().updateAndDraw();
    }

    @Override
    public void reset() {
        for (TrackedFilament trackedFilament : new ArrayList<TrackedFilament>(this.trackedFilamentDisplayed)) {
            this.remove(trackedFilament);
        }
        for (Filament filament : new ArrayList<Filament>(this.filamentDisplayed)) {
            this.remove(filament);
        }
        ImagePlus imp = this.getImagePlus();
        if (imp != null) {
            imp.updateAndDraw();
        }
    }

    @Override
    public void refresh() {
        for (TrackedFilament trackedFilament : new ArrayList<TrackedFilament>(this.trackedFilamentDisplayed)) {
            this.remove(trackedFilament);
            this.add(trackedFilament);
        }
        for (Filament filament : new ArrayList<Filament>(this.filamentDisplayed)) {
            this.remove(filament);
            this.add(filament);
        }
        ImagePlus imp = this.getImagePlus();
        if (imp != null) {
            imp.updateAndDraw();
        }
    }

    @Override
    public void setColorAlpha(int colorAlpha) {
        this.colorAlpha = colorAlpha;
    }

    @Override
    public void setFilamentWidth(int filamentWidth) {
        this.filamentWidth = filamentWidth;
    }

    @Override
    public void setImageDisplay(ImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
        this.imagePlus = null;
        ImagePlus imp = this.getImagePlus();
        if (imp != null) {
            imp.getWindow().getCanvas().addMouseListener((MouseListener)this);
        }
        this.refresh();
    }

    @Override
    public void setSelected(Filament filament, boolean moveToFrame, boolean clearSelection) {
        if (clearSelection) {
            this.clearSelection();
        }
        if (!this.selectedFilaments.contains(filament)) {
            this.selectedFilaments.add(filament);
            Roi roi = this.filamentROIMap.get(filament);
            if (roi != null) {
                roi.setStrokeWidth(roi.getStrokeWidth() * 2.0f);
                ImagePlus imp = this.getImagePlus();
                if (moveToFrame) {
                    imp.setT(filament.getFrame() + 1);
                }
                imp.repaintWindow();
            }
        }
    }

    @Override
    public void setSelected(TrackedFilament trackedFilament, boolean moveToFrame, boolean clearSelection) {
        if (clearSelection) {
            this.clearSelection();
        }
        this.selectedTrackedFilament.add(trackedFilament);
        for (Filament filament : trackedFilament) {
            this.setSelected(filament, false, false);
        }
        if (moveToFrame) {
            ImagePlus imp = this.getImagePlus();
            imp.setT(((Filament)trackedFilament.get(0)).getFrame() + 1);
        }
    }

    @Override
    public boolean isDrawBoundingBoxes() {
        return this.drawBoundingBoxes;
    }

    @Override
    public void setDrawBoundingBoxes(boolean drawBoundingBoxes) {
        this.drawBoundingBoxes = drawBoundingBoxes;
    }

    private ImagePlus getImagePlus() {
        Calibration cal;
        if (this.imageDisplay == null) {
            this.log.debug((Object)"ImageDisplay is null. Can't retrieve ImagePlus.");
            return null;
        }
        if (this.imagePlus != null) {
            return this.imagePlus;
        }
        try {
            this.imagePlus = (ImagePlus)this.convert.convert((Object)this.imageDisplay, ImagePlus.class);
        }
        catch (NullPointerException e) {
            this.eventService.publish((SciJavaEvent)new ImageNotFoundEvent());
            return null;
        }
        if (this.imageDisplay != null && this.imagePlus == null) {
            this.log.error((Object)"Critical error: ImagePlus not found.");
        }
        if (this.imagePlus != null && (cal = this.imagePlus.getCalibration()) == null) {
            this.imagePlus.setCalibration(new Calibration());
        }
        return this.imagePlus;
    }

    @Override
    public boolean isDrawPlusTips() {
        return this.drawPlusTips;
    }

    @Override
    public void setDrawPlusTips(boolean drawPlusTips) {
        this.drawPlusTips = drawPlusTips;
    }

    @Override
    public boolean isDrawMinusTips() {
        return this.drawMinusTips;
    }

    @Override
    public void setDrawMinusTips(boolean drawMinusTips) {
        this.drawMinusTips = drawMinusTips;
    }

    @Override
    public int getTipDiameter() {
        return this.tipDiameter;
    }

    @Override
    public void setTipDiameter(int tipDiameter) {
        this.tipDiameter = tipDiameter;
    }

    @Override
    public void updateTransparency() {
        Color newColor;
        Color color;
        for (Map.Entry<Filament, Roi> entry : this.filamentROIMap.entrySet()) {
            color = entry.getValue().getStrokeColor();
            newColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.colorAlpha);
            entry.getValue().setStrokeColor(newColor);
        }
        for (Map.Entry<Filament, Roi> entry : this.filamentBoundingBoxesMap.entrySet()) {
            color = entry.getValue().getStrokeColor();
            newColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.colorAlpha);
            entry.getValue().setStrokeColor(newColor);
        }
        for (Map.Entry<Object, Object> entry : this.filamentPlusTipsMap.entrySet()) {
            for (Roi roi : (List)entry.getValue()) {
                color = roi.getStrokeColor();
                newColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.colorAlpha);
                roi.setStrokeColor(newColor);
            }
        }
        for (Map.Entry<Object, Object> entry : this.filamentMinusTipsMap.entrySet()) {
            for (Roi roi : (List)entry.getValue()) {
                color = roi.getStrokeColor();
                newColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.colorAlpha);
                roi.setStrokeColor(newColor);
            }
        }
        this.getImagePlus().repaintWindow();
    }

    @Override
    public void updateLineWidth() {
        for (Map.Entry<Filament, Roi> entry : this.filamentROIMap.entrySet()) {
            entry.getValue().setStrokeWidth((float)this.filamentWidth);
        }
        for (Map.Entry<Filament, Roi> entry : this.filamentBoundingBoxesMap.entrySet()) {
            entry.getValue().setStrokeWidth((float)this.filamentWidth);
        }
        for (Map.Entry<Object, Object> entry : this.filamentPlusTipsMap.entrySet()) {
            for (Roi roi : (List)entry.getValue()) {
                roi.setStrokeWidth((float)this.filamentWidth);
            }
        }
        for (Map.Entry<Object, Object> entry : this.filamentMinusTipsMap.entrySet()) {
            for (Roi roi : (List)entry.getValue()) {
                roi.setStrokeWidth((float)this.filamentWidth);
            }
        }
        this.getImagePlus().repaintWindow();
    }

    @Override
    public void setViewMode(ImageDisplayMode viewMode) {
        ImagePlus imp = this.getImagePlus();
        if (imp != null) {
            if (viewMode == ImageDisplayMode.COLOR) {
                imp.setDisplayMode(2);
            } else if (viewMode == ImageDisplayMode.COMPOSITE) {
                imp.setDisplayMode(1);
            } else if (viewMode == ImageDisplayMode.GRAYSCALE) {
                imp.setDisplayMode(3);
            }
            this.autoScaleImage();
        }
    }

    @Override
    public void autoScaleImage() {
        ImagePlus imp = this.getImagePlus();
        ImageDisplay imd = this.getImageDisplay();
        Dataset data = (Dataset)imd.getActiveView().getData();
        if (imp != null) {
            int currentChannel = imp.getC();
            DoubleType min = (DoubleType)this.op.run("stats.min", new Object[]{data});
            DoubleType max = (DoubleType)this.op.run("stats.max", new Object[]{data});
            for (int c = 0; c <= imp.getChannel(); ++c) {
                imp.setC(c);
                imp.setDisplayRange(min.get(), max.get());
                imp.updateChannelAndDraw();
            }
            imp.setC(currentChannel);
        }
    }
}

