/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.NewImage;
import ij.gui.Roi;
import ij.io.FileSaver;
import ij.measure.ResultsTable;
import ij.plugin.BrowserLauncher;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Color_Inspector_3D
implements PlugIn {
    private static final String version = "v2.5";
    public static final char degreeSymbol = '\u00b0';
    static final int RGB = 0;
    static final int YUV = 1;
    static final int YCBCR = 2;
    static final int YIQ = 3;
    static final int YCGCO = 4;
    static final int HSB = 5;
    static final int HSV = 6;
    static final int HSL = 7;
    static final int HMMD = 8;
    static final int LAB = 9;
    static final int LUV = 10;
    static final int XYY = 11;
    static final int XYZ = 12;
    static final int KLT = 13;
    static final int HCL = 14;
    private static final String[] stringColorSpaceNames = new String[]{"RGB", "YUV", "YCbCr", "YIQ", "YCgCo", "HSB", "HSV", "HSL", "HMMD", "Lab", "Luv", "xyY", "XYZ", "KLT/PCA"};
    private static final String[][] stringColorSpaceLetters = new String[][]{{"R", "G", "B"}, {"Y", "U", "V"}, {"Y", "Cb", "Cr"}, {"Y", "I", "Q"}, {"Y", "Cg", "Co"}, {"H", "S", "B"}, {"H", "S", "V"}, {"H", "S", "L"}, {"Hue", "Diff", "Sum"}, {"L", "a", "b"}, {"L", "u", "v"}, {"x", "y", "Y"}, {"X", "Y", "Z"}, {"C0", "C1", "C2"}};
    private boolean english = true;
    private String stringAllColors;
    private String stringWeighted;
    private String stringHistogram;
    private String stringMedianCut;
    private String stringWu;
    private final String[] stringDisplayMode = new String[5];
    private JSlider slider0;
    private JSlider sliderPerspective;
    private JSlider sliderScale;
    private JSlider sliderSaturation;
    private JSlider sliderBrightness;
    private JSlider sliderContrast;
    private JSlider sliderFactor0;
    private JSlider sliderFactor1;
    private JSlider sliderFactor2;
    private JSlider sliderHueChange;
    private JSlider sliderDepth;
    JLabel label;
    JLabel label0;
    JLabel labelInfo;
    JTextField jTextField;
    int sliderValue0 = 100;
    int renderDepth = -222;
    private static final int OPAQUE = -16777216;
    private boolean showAxes = true;
    private boolean showText = true;
    private boolean colorMode = true;
    private int mode = 0;
    private boolean shift = false;
    private boolean hist = false;
    private boolean pause = false;
    private boolean move = false;
    private boolean rotation = false;
    private boolean fitImage = true;
    private boolean displayOrig = true;
    private float delta = 1.0f;
    private int qMode = 0;
    private int numberOfColors;
    private int numberOfColorsOrig = 0;
    private int maskSize;
    private ColHash[] colHash;
    private float freqFactor;
    private float saturation = 1.0f;
    private int brightness = 0;
    private float contrast = 1.0f;
    private float hueChange = 0.0f;
    private double[] channelFactor = new double[]{1.0, 1.0, 1.0};
    private Picture pic1;
    private Picture pic2;
    private ImageRegion imageRegion1;
    private ImageRegion imageRegion2;
    private CustomWindow cw;
    private JFrame frame;
    private int depthColorNear = 0;
    private int depthColorFar = 0;
    private int xPos = 10;
    private int yPos = 10;
    private int colorSpace = 0;
    private int hashSize;
    private ColorKLT kltColor = null;
    private double[][] kltMatrix = null;
    private double[] kltMean = null;

    public void init() {
        Color_Inspector_3D ci3D = new Color_Inspector_3D();
        ci3D.process("images/titel.jpg");
    }

    public static void main(String[] args) {
        new ImageJ();
        Color_Inspector_3D ci3D = new Color_Inspector_3D();
        if (args.length < 1) {
            ci3D.process("/images/titel.jpg");
        } else {
            ci3D.process(args[0]);
        }
    }

    void process(String path) {
        if (IJ.versionLessThan((String)"1.33b")) {
            return;
        }
        this.run("");
    }

    public void run(String arg) {
        this.stringAllColors = this.english ? "All Colors" : "alle Farben ungewichtet";
        this.stringWeighted = this.english ? "Frequency Weighted" : "gewichtet nach H\u00e4ufigkeit";
        this.stringHistogram = this.english ? "Histogram" : "Histogramm";
        this.stringMedianCut = this.english ? "Median Cut" : "Farbreduktion: Median Cut";
        this.stringWu = this.english ? "Wu Quant" : "Farbreduktion: Wu Quant";
        this.stringDisplayMode[0] = this.stringAllColors;
        this.stringDisplayMode[1] = this.stringWeighted;
        this.stringDisplayMode[2] = this.stringHistogram;
        this.stringDisplayMode[3] = this.stringMedianCut;
        this.stringDisplayMode[4] = this.stringWu;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            String str = "/images/titel.jpg";
            URL url = null;
            try {
                url = this.getClass().getResource(str);
                Image image = Toolkit.getDefaultToolkit().getImage(url);
                imp = new ImagePlus(str, image);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null || msg.equals("")) {
                    msg = "" + e;
                }
                IJ.showMessage((String)"Color Inspector 3D", (String)(msg + "\n \n" + url));
            }
        } else {
            ImageProcessor ip = imp.getProcessor();
            int height = ip.getHeight();
            int width = ip.getWidth();
            int maxSize = Math.max(width, height);
            if (maxSize > 1024) {
                int targetWidth = width * 1024 / maxSize;
                int targetHeight = height * 1024 / maxSize;
                ip = ip.resize(targetWidth, targetHeight);
                String name = "scaled version of " + imp.getTitle();
                imp = new ImagePlus(name, ip);
            }
        }
        this.cw = new CustomWindow();
        this.cw.init(imp);
        this.frame = new JFrame("Color Inspector 3D (v2.5)   " + imp.getTitle());
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Color_Inspector_3D.this.cw.cleanup();
                Color_Inspector_3D.this.frame.dispose();
            }
        });
        this.frame.setLocation(this.xPos, this.yPos);
        this.frame.setJMenuBar(new Menu());
        this.frame.getContentPane().add(this.cw);
        this.frame.setResizable(false);
        this.frame.validate();
        this.frame.pack();
        this.frame.setVisible(true);
    }

    static /* synthetic */ ColHash[] access$6802(Color_Inspector_3D x0, ColHash[] x1) {
        x0.colHash = x1;
        return x1;
    }

    static /* synthetic */ double[][] access$8802(Color_Inspector_3D x0, double[][] x1) {
        x0.kltMatrix = x1;
        return x1;
    }

    static /* synthetic */ double[] access$8902(Color_Inspector_3D x0, double[] x1) {
        x0.kltMean = x1;
        return x1;
    }

    public class WuCq {
        private static final int MAXCOLOR = 512;
        private static final int RED = 2;
        private static final int GREEN = 1;
        private static final int BLUE = 0;
        float[][][] m2 = new float[33][33][33];
        long[][][] wt = new long[33][33][33];
        long[][][] mr = new long[33][33][33];
        long[][][] mg = new long[33][33][33];
        long[][][] mb = new long[33][33][33];
        int[] pixels;
        int size;
        int K;
        int[] Qadd;
        int[] lut_r = new int[512];
        int[] lut_g = new int[512];
        int[] lut_b = new int[512];
        int[] tag;

        WuCq(int[] pixels, int size, int numCols) {
            this.pixels = pixels;
            this.size = size;
            this.K = numCols;
        }

        void Hist3d(long[][][] vwt, long[][][] vmr, long[][][] vmg, long[][][] vmb, float[][][] m2) {
            int i;
            int[] table = new int[256];
            for (i = 0; i < 256; ++i) {
                table[i] = i * i;
            }
            this.Qadd = new int[this.size];
            for (i = 0; i < this.size; ++i) {
                int c = this.pixels[i];
                if ((c & 0xFF000000) != -16777216) continue;
                int r = c >> 16 & 0xFF;
                int g = c >> 8 & 0xFF;
                int b = c & 0xFF;
                int inr = (r >> 3) + 1;
                int ing = (g >> 3) + 1;
                int inb = (b >> 3) + 1;
                this.Qadd[i] = (inr << 10) + (inr << 6) + inr + (ing << 5) + ing + inb;
                long[] lArray = vwt[inr][ing];
                int n = inb;
                lArray[n] = lArray[n] + 1L;
                long[] lArray2 = vmr[inr][ing];
                int n2 = inb;
                lArray2[n2] = lArray2[n2] + (long)r;
                long[] lArray3 = vmg[inr][ing];
                int n3 = inb;
                lArray3[n3] = lArray3[n3] + (long)g;
                long[] lArray4 = vmb[inr][ing];
                int n4 = inb;
                lArray4[n4] = lArray4[n4] + (long)b;
                float[] fArray = m2[inr][ing];
                int n5 = inb;
                fArray[n5] = fArray[n5] + (float)(table[r] + table[g] + table[b]);
            }
        }

        void M3d(long[][][] vwt, long[][][] vmr, long[][][] vmg, long[][][] vmb, float[][][] m2) {
            long[] area = new long[33];
            long[] area_r = new long[33];
            long[] area_g = new long[33];
            long[] area_b = new long[33];
            float[] area2 = new float[33];
            for (int r = 1; r <= 32; ++r) {
                for (int i = 0; i <= 32; ++i) {
                    area_b[i] = 0L;
                    area_g[i] = 0L;
                    area_r[i] = 0L;
                    area[i] = 0L;
                    area2[i] = 0L;
                }
                for (int g = 1; g <= 32; ++g) {
                    long line_b = 0L;
                    long line_g = 0L;
                    long line_r = 0L;
                    long line = 0L;
                    float line2 = 0L;
                    for (int b = 1; b <= 32; ++b) {
                        line += vwt[r][g][b];
                        line_r += vmr[r][g][b];
                        line_g += vmg[r][g][b];
                        line_b += vmb[r][g][b];
                        line2 += m2[r][g][b];
                        int n = b;
                        area[n] = area[n] + line;
                        int n2 = b;
                        area_r[n2] = area_r[n2] + line_r;
                        int n3 = b;
                        area_g[n3] = area_g[n3] + line_g;
                        int n4 = b;
                        area_b[n4] = area_b[n4] + line_b;
                        int n5 = b;
                        area2[n5] = area2[n5] + line2;
                        vwt[r][g][b] = vwt[r - 1][g][b] + area[b];
                        vmr[r][g][b] = vmr[r - 1][g][b] + area_r[b];
                        vmg[r][g][b] = vmg[r - 1][g][b] + area_g[b];
                        vmb[r][g][b] = vmb[r - 1][g][b] + area_b[b];
                        m2[r][g][b] = m2[r - 1][g][b] + area2[b];
                    }
                }
            }
        }

        long Vol(Box cube, long[][][] mmt) {
            return mmt[cube.r1][cube.g1][cube.b1] - mmt[cube.r1][cube.g1][cube.b0] - mmt[cube.r1][cube.g0][cube.b1] + mmt[cube.r1][cube.g0][cube.b0] - mmt[cube.r0][cube.g1][cube.b1] + mmt[cube.r0][cube.g1][cube.b0] + mmt[cube.r0][cube.g0][cube.b1] - mmt[cube.r0][cube.g0][cube.b0];
        }

        long Bottom(Box cube, int dir, long[][][] mmt) {
            switch (dir) {
                case 2: {
                    return -mmt[cube.r0][cube.g1][cube.b1] + mmt[cube.r0][cube.g1][cube.b0] + mmt[cube.r0][cube.g0][cube.b1] - mmt[cube.r0][cube.g0][cube.b0];
                }
                case 1: {
                    return -mmt[cube.r1][cube.g0][cube.b1] + mmt[cube.r1][cube.g0][cube.b0] + mmt[cube.r0][cube.g0][cube.b1] - mmt[cube.r0][cube.g0][cube.b0];
                }
                case 0: {
                    return -mmt[cube.r1][cube.g1][cube.b0] + mmt[cube.r1][cube.g0][cube.b0] + mmt[cube.r0][cube.g1][cube.b0] - mmt[cube.r0][cube.g0][cube.b0];
                }
            }
            return 0L;
        }

        long Top(Box cube, int dir, int pos, long[][][] mmt) {
            switch (dir) {
                case 2: {
                    return mmt[pos][cube.g1][cube.b1] - mmt[pos][cube.g1][cube.b0] - mmt[pos][cube.g0][cube.b1] + mmt[pos][cube.g0][cube.b0];
                }
                case 1: {
                    return mmt[cube.r1][pos][cube.b1] - mmt[cube.r1][pos][cube.b0] - mmt[cube.r0][pos][cube.b1] + mmt[cube.r0][pos][cube.b0];
                }
                case 0: {
                    return mmt[cube.r1][cube.g1][pos] - mmt[cube.r1][cube.g0][pos] - mmt[cube.r0][cube.g1][pos] + mmt[cube.r0][cube.g0][pos];
                }
            }
            return 0L;
        }

        float Var(Box cube) {
            float dr = this.Vol(cube, this.mr);
            float dg = this.Vol(cube, this.mg);
            float db = this.Vol(cube, this.mb);
            float xx = this.m2[cube.r1][cube.g1][cube.b1] - this.m2[cube.r1][cube.g1][cube.b0] - this.m2[cube.r1][cube.g0][cube.b1] + this.m2[cube.r1][cube.g0][cube.b0] - this.m2[cube.r0][cube.g1][cube.b1] + this.m2[cube.r0][cube.g1][cube.b0] + this.m2[cube.r0][cube.g0][cube.b1] - this.m2[cube.r0][cube.g0][cube.b0];
            return xx - (dr * dr + dg * dg + db * db) / (float)this.Vol(cube, this.wt);
        }

        float Maximize(Box cube, int dir, int first, int last, int[] cut, long whole_r, long whole_g, long whole_b, long whole_w) {
            long base_r = this.Bottom(cube, dir, this.mr);
            long base_g = this.Bottom(cube, dir, this.mg);
            long base_b = this.Bottom(cube, dir, this.mb);
            long base_w = this.Bottom(cube, dir, this.wt);
            float max = 0.0f;
            cut[0] = -1;
            for (int i = first; i < last; ++i) {
                long half_r = base_r + this.Top(cube, dir, i, this.mr);
                long half_g = base_g + this.Top(cube, dir, i, this.mg);
                long half_b = base_b + this.Top(cube, dir, i, this.mb);
                long half_w = base_w + this.Top(cube, dir, i, this.wt);
                if (half_w == 0L) continue;
                float temp = ((float)half_r * (float)half_r + (float)half_g * (float)half_g + (float)half_b * (float)half_b) / (float)half_w;
                half_r = whole_r - half_r;
                half_g = whole_g - half_g;
                half_b = whole_b - half_b;
                if ((half_w = whole_w - half_w) == 0L || !((temp += ((float)half_r * (float)half_r + (float)half_g * (float)half_g + (float)half_b * (float)half_b) / (float)half_w) > max)) continue;
                max = temp;
                cut[0] = i;
            }
            return max;
        }

        int Cut(Box set1, Box set2) {
            int dir;
            int[] cutr = new int[]{0};
            int[] cutg = new int[]{0};
            int[] cutb = new int[]{0};
            long whole_r = this.Vol(set1, this.mr);
            long whole_g = this.Vol(set1, this.mg);
            long whole_b = this.Vol(set1, this.mb);
            long whole_w = this.Vol(set1, this.wt);
            float maxr = this.Maximize(set1, 2, set1.r0 + 1, set1.r1, cutr, whole_r, whole_g, whole_b, whole_w);
            float maxg = this.Maximize(set1, 1, set1.g0 + 1, set1.g1, cutg, whole_r, whole_g, whole_b, whole_w);
            float maxb = this.Maximize(set1, 0, set1.b0 + 1, set1.b1, cutb, whole_r, whole_g, whole_b, whole_w);
            if (maxr >= maxg && maxr >= maxb) {
                dir = 2;
                if (cutr[0] < 0) {
                    return 0;
                }
            } else {
                dir = maxg >= maxr && maxg >= maxb ? 1 : 0;
            }
            set2.r1 = set1.r1;
            set2.g1 = set1.g1;
            set2.b1 = set1.b1;
            switch (dir) {
                case 2: {
                    set2.r0 = set1.r1 = cutr[0];
                    set2.g0 = set1.g0;
                    set2.b0 = set1.b0;
                    break;
                }
                case 1: {
                    set2.g0 = set1.g1 = cutg[0];
                    set2.r0 = set1.r0;
                    set2.b0 = set1.b0;
                    break;
                }
                case 0: {
                    set2.b0 = set1.b1 = cutb[0];
                    set2.r0 = set1.r0;
                    set2.g0 = set1.g0;
                }
            }
            set1.vol = (set1.r1 - set1.r0) * (set1.g1 - set1.g0) * (set1.b1 - set1.b0);
            set2.vol = (set2.r1 - set2.r0) * (set2.g1 - set2.g0) * (set2.b1 - set2.b0);
            return 1;
        }

        void Mark(Box cube, int label, int[] tag) {
            for (int r = cube.r0 + 1; r <= cube.r1; ++r) {
                for (int g = cube.g0 + 1; g <= cube.g1; ++g) {
                    for (int b = cube.b0 + 1; b <= cube.b1; ++b) {
                        tag[(r << 10) + (r << 6) + r + (g << 5) + g + b] = label;
                    }
                }
            }
        }

        void main_() {
            int b;
            int g;
            int r;
            int k;
            int c;
            int i;
            int i2;
            Box[] cube = new Box[512];
            for (int i3 = 0; i3 < 512; ++i3) {
                cube[i3] = new Box();
            }
            float[] vv = new float[512];
            this.Hist3d(this.wt, this.mr, this.mg, this.mb, this.m2);
            this.M3d(this.wt, this.mr, this.mg, this.mb, this.m2);
            cube[0].b0 = 0;
            cube[0].g0 = 0;
            cube[0].r0 = 0;
            cube[0].b1 = 32;
            cube[0].g1 = 32;
            cube[0].r1 = 32;
            int next = 0;
            for (i2 = 1; i2 < this.K; ++i2) {
                if (this.Cut(cube[next], cube[i2]) == 1) {
                    vv[next] = (float)(cube[next].vol > 1 ? (double)this.Var(cube[next]) : 0.0);
                    vv[i2] = (float)(cube[i2].vol > 1 ? (double)this.Var(cube[i2]) : 0.0);
                } else {
                    vv[next] = 0.0f;
                    --i2;
                }
                next = 0;
                float temp = vv[0];
                for (int k2 = 1; k2 <= i2; ++k2) {
                    if (!(vv[k2] > temp)) continue;
                    temp = vv[k2];
                    next = k2;
                }
                if (!((double)temp <= 0.0)) continue;
                this.K = i2 + 1;
                break;
            }
            this.tag = new int[35937];
            for (int k3 = 0; k3 < this.K; ++k3) {
                this.Mark(cube[k3], k3, this.tag);
                long weight = this.Vol(cube[k3], this.wt);
                if (weight > 0L) {
                    this.lut_r[k3] = (int)(this.Vol(cube[k3], this.mr) / weight);
                    this.lut_g[k3] = (int)(this.Vol(cube[k3], this.mg) / weight);
                    this.lut_b[k3] = (int)(this.Vol(cube[k3], this.mb) / weight);
                    continue;
                }
                this.lut_b[k3] = 0;
                this.lut_g[k3] = 0;
                this.lut_r[k3] = 0;
            }
            for (i2 = 0; i2 < this.size; ++i2) {
                this.Qadd[i2] = this.tag[this.Qadd[i2]];
            }
            int[] red = new int[this.K + 1];
            int[] green = new int[this.K + 1];
            int[] blue = new int[this.K + 1];
            int[] sum = new int[this.K + 1];
            int[] ind = new int[this.size];
            for (i = 0; i < this.size; ++i) {
                c = this.pixels[i];
                if ((c & 0xFF000000) != -16777216) continue;
                k = this.Qadd[i];
                r = c >> 16 & 0xFF;
                g = c >> 8 & 0xFF;
                b = c & 0xFF;
                int kb = k;
                int eb = 100000000;
                for (int l = 0; l < this.K; ++l) {
                    int lr = this.lut_r[l];
                    int dr = r - lr;
                    int lg = this.lut_g[l];
                    int dg = g - lg;
                    int lb = this.lut_b[l];
                    int db = b - lb;
                    int e = dr * dr + dg * dg + db * db;
                    if (e >= eb) continue;
                    eb = e;
                    kb = l;
                }
                int n = kb;
                red[n] = red[n] + r;
                int n2 = kb;
                green[n2] = green[n2] + g;
                int n3 = kb;
                blue[n3] = blue[n3] + b;
                int n4 = kb;
                sum[n4] = sum[n4] + 1;
                ind[i] = kb;
            }
            for (int k4 = 0; k4 < this.K; ++k4) {
                if (sum[k4] <= 0) continue;
                int n = k4;
                red[n] = red[n] / sum[k4];
                int n5 = k4;
                green[n5] = green[n5] / sum[k4];
                int n6 = k4;
                blue[n6] = blue[n6] / sum[k4];
            }
            for (i = 0; i < this.size; ++i) {
                c = this.pixels[i];
                if ((c & 0xFF000000) != -16777216) continue;
                k = ind[i];
                r = red[k];
                g = green[k];
                b = blue[k];
                this.pixels[i] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }

        class Box {
            int r0;
            int r1;
            int g0;
            int g1;
            int b0;
            int b1;
            int vol;

            Box() {
            }
        }
    }

    class Cube {
        int lower;
        int upper;
        int count = 0;
        int level;
        int rmin;
        int rmax;
        int gmin;
        int gmax;
        int bmin;
        int bmax;

        Cube() {
        }

        public String toString() {
            String s = "lower=" + this.lower + " upper=" + this.upper;
            s = s + " count=" + this.count + " level=" + this.level;
            s = s + " rmin=" + this.rmin + " rmax=" + this.rmax;
            s = s + " gmin=" + this.gmin + " gmax=" + this.gmax;
            s = s + " bmin=" + this.bmin + " bmax=" + this.bmax;
            return s;
        }
    }

    public class Median_Cut {
        static final int MAXCOLORS = 256;
        static final int HSIZE = 32768;
        private int[] hist;
        private int[] histPtr;
        private Cube[] list;
        private int[] pixels32;
        private int width;
        private int height;
        private IndexColorModel cm;

        public Median_Cut(int[] pixels, int width, int height) {
            this.pixels32 = pixels;
            this.width = width;
            this.height = height;
            this.hist = new int[32768];
            for (int i = 0; i < width * height; ++i) {
                int color16;
                if ((this.pixels32[i] & 0xFF000000) != -16777216) continue;
                int n = color16 = this.rgb(this.pixels32[i]);
                this.hist[n] = this.hist[n] + 1;
            }
        }

        int getColorCount() {
            int count = 0;
            for (int i = 0; i < 32768; ++i) {
                if (this.hist[i] <= 0) continue;
                ++count;
            }
            return count;
        }

        Color getModalColor() {
            int max = 0;
            int c = 0;
            for (int i = 0; i < 32768; ++i) {
                if (this.hist[i] <= max) continue;
                max = this.hist[i];
                c = i;
            }
            return new Color(this.red(c), this.green(c), this.blue(c));
        }

        private final int rgb(int c) {
            int r = (c & 0xF80000) >> 19;
            int g = (c & 0xF800) >> 6;
            int b = (c & 0xF8) << 7;
            return b | g | r;
        }

        private final int red(int x) {
            return (x & 0x1F) << 3;
        }

        private final int green(int x) {
            return x >> 2 & 0xF8;
        }

        private final int blue(int x) {
            return x >> 7 & 0xF8;
        }

        public Image convert(int maxcubes) {
            return this.convertToByte(maxcubes);
        }

        public Image convertToByte(int maxcubes) {
            int i;
            int longdim = 0;
            this.list = new Cube[256];
            this.histPtr = new int[32768];
            int ncubes = 0;
            Cube cube = new Cube();
            int color = 0;
            for (i = 0; i <= Short.MAX_VALUE; ++i) {
                if (this.hist[i] == 0) continue;
                this.histPtr[color++] = i;
                cube.count += this.hist[i];
            }
            cube.lower = 0;
            cube.upper = color - 1;
            cube.level = 0;
            this.Shrink(cube);
            this.list[ncubes++] = cube;
            while (ncubes < maxcubes) {
                int level = 255;
                int splitpos = -1;
                for (int k = 0; k <= ncubes - 1; ++k) {
                    if (this.list[k].lower == this.list[k].upper || this.list[k].level >= level) continue;
                    level = this.list[k].level;
                    splitpos = k;
                }
                if (splitpos == -1) break;
                cube = this.list[splitpos];
                int lr = cube.rmax - cube.rmin;
                int lg = cube.gmax - cube.gmin;
                int lb = cube.bmax - cube.bmin;
                if (lr >= lg && lr >= lb) {
                    longdim = 0;
                }
                if (lg >= lr && lg >= lb) {
                    longdim = 1;
                }
                if (lb >= lr && lb >= lg) {
                    longdim = 2;
                }
                this.reorderColors(this.histPtr, cube.lower, cube.upper, longdim);
                this.quickSort(this.histPtr, cube.lower, cube.upper);
                this.restoreColorOrder(this.histPtr, cube.lower, cube.upper, longdim);
                int count = 0;
                for (i = cube.lower; i <= cube.upper - 1 && count < cube.count / 2; count += this.hist[color], ++i) {
                    color = this.histPtr[i];
                }
                int median = i;
                Cube cubeA = new Cube();
                cubeA.lower = cube.lower;
                cubeA.upper = median - 1;
                cubeA.count = count;
                cubeA.level = cube.level + 1;
                this.Shrink(cubeA);
                this.list[splitpos] = cubeA;
                Cube cubeB = new Cube();
                cubeB.lower = median;
                cubeB.upper = cube.upper;
                cubeB.count = cube.count - count;
                cubeB.level = cube.level + 1;
                this.Shrink(cubeB);
                this.list[ncubes++] = cubeB;
            }
            this.makeInverseMap(this.hist, ncubes);
            return this.makeImage();
        }

        void Shrink(Cube cube) {
            int rmin = 255;
            int rmax = 0;
            int gmin = 255;
            int gmax = 0;
            int bmin = 255;
            int bmax = 0;
            for (int i = cube.lower; i <= cube.upper; ++i) {
                int color = this.histPtr[i];
                int r = this.red(color);
                int g = this.green(color);
                int b = this.blue(color);
                if (r > rmax) {
                    rmax = r;
                }
                if (r < rmin) {
                    rmin = r;
                }
                if (g > gmax) {
                    gmax = g;
                }
                if (g < gmin) {
                    gmin = g;
                }
                if (b > bmax) {
                    bmax = b;
                }
                if (b >= bmin) continue;
                bmin = b;
            }
            cube.rmin = rmin;
            cube.rmax = rmax;
            cube.gmin = gmin;
            cube.gmax = gmax;
            cube.bmin = bmin;
            cube.bmax = bmax;
        }

        void makeInverseMap(int[] hist, int ncubes) {
            int color;
            int i;
            Cube cube;
            int k;
            byte[] rLUT = new byte[256];
            byte[] gLUT = new byte[256];
            byte[] bLUT = new byte[256];
            for (k = 0; k <= ncubes - 1; ++k) {
                int b;
                int g;
                int r;
                cube = this.list[k];
                float bsum = 0.0f;
                float gsum = 0.0f;
                float rsum = 0.0f;
                for (i = cube.lower; i <= cube.upper; ++i) {
                    color = this.histPtr[i];
                    r = this.red(color);
                    rsum += (float)r * (float)hist[color];
                    g = this.green(color);
                    gsum += (float)g * (float)hist[color];
                    b = this.blue(color);
                    bsum += (float)b * (float)hist[color];
                }
                r = (int)(rsum / (float)cube.count);
                g = (int)(gsum / (float)cube.count);
                b = (int)(bsum / (float)cube.count);
                if (r == 248 && g == 248 && b == 248) {
                    b = 255;
                    g = 255;
                    r = 255;
                }
                rLUT[k] = (byte)r;
                gLUT[k] = (byte)g;
                bLUT[k] = (byte)b;
            }
            this.cm = new IndexColorModel(8, ncubes, rLUT, gLUT, bLUT);
            for (k = 0; k <= ncubes - 1; ++k) {
                cube = this.list[k];
                for (i = cube.lower; i <= cube.upper; ++i) {
                    color = this.histPtr[i];
                    hist[color] = k;
                }
            }
        }

        void reorderColors(int[] a, int lo, int hi, int longDim) {
            switch (longDim) {
                case 0: {
                    for (int i = lo; i <= hi; ++i) {
                        int c = a[i];
                        int r = c & 0x1F;
                        a[i] = r << 10 | c >> 5;
                    }
                    break;
                }
                case 1: {
                    for (int i = lo; i <= hi; ++i) {
                        int c = a[i];
                        int r = c & 0x1F;
                        int g = c >> 5 & 0x1F;
                        int b = c >> 10;
                        a[i] = g << 10 | b << 5 | r;
                    }
                    break;
                }
            }
        }

        void restoreColorOrder(int[] a, int lo, int hi, int longDim) {
            switch (longDim) {
                case 0: {
                    for (int i = lo; i <= hi; ++i) {
                        int c = a[i];
                        int r = c >> 10;
                        a[i] = (c & 0x3FF) << 5 | r;
                    }
                    break;
                }
                case 1: {
                    for (int i = lo; i <= hi; ++i) {
                        int c = a[i];
                        int r = c & 0x1F;
                        int g = c >> 10;
                        int b = c >> 5 & 0x1F;
                        a[i] = b << 10 | g << 5 | r;
                    }
                    break;
                }
            }
        }

        void quickSort(int[] a, int lo0, int hi0) {
            int lo = lo0;
            int hi = hi0;
            if (hi0 > lo0) {
                int mid = a[(lo0 + hi0) / 2];
                while (lo <= hi) {
                    while (lo < hi0 && a[lo] < mid) {
                        ++lo;
                    }
                    while (hi > lo0 && a[hi] > mid) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    int t = a[lo];
                    a[lo] = a[hi];
                    a[hi] = t;
                    ++lo;
                    --hi;
                }
                if (lo0 < hi) {
                    this.quickSort(a, lo0, hi);
                }
                if (lo < hi0) {
                    this.quickSort(a, lo, hi0);
                }
            }
        }

        Image makeImage() {
            byte[] pixels8 = new byte[this.width * this.height];
            for (int i = 0; i < this.width * this.height; ++i) {
                int color16 = this.rgb(this.pixels32[i]);
                pixels8[i] = (byte)this.hist[color16];
            }
            Image img8 = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.width, this.height, (ColorModel)this.cm, pixels8, 0, this.width));
            return img8;
        }
    }

    static class Misc {
        Misc() {
        }

        static String fm(int len, int val) {
            String s = "" + val;
            while (s.length() < len) {
                s = "  " + s;
            }
            return s;
        }

        static String fm(int len, double val) {
            String s = "" + val;
            while (s.length() < len) {
                s = s + " ";
            }
            return s;
        }
    }

    class TextField {
        private String text = "";
        private Color color;
        private int xpos;
        private int ypos;
        private int z;

        TextField() {
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setXpos(int xpos) {
            this.xpos = xpos;
        }

        public void setYpos(int ypos) {
            this.ypos = ypos;
        }

        public String getText() {
            return this.text;
        }

        public int getXpos() {
            return this.xpos;
        }

        public int getYpos() {
            return this.ypos;
        }

        public void setZ(int z) {
            this.z = z;
        }

        public int getZ() {
            return this.z;
        }
    }

    class Lines {
        int x1;
        int y1;
        int x2;
        int y2;
        int z1;
        int z2;
        Color color;

        Lines() {
        }

        public void setPos(int x1, int y1, int x2, int y2, int z1, int z2, Color color) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.z1 = z1;
            this.z2 = z2;
            this.color = color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    private final class ColHash {
        int R;
        int G;
        int B;
        int color;
        int frequency;

        private ColHash() {
        }
    }

    private class Picture {
        private int R;
        private int G;
        private int B;
        private int X;
        private int Y;
        private int Z;
        private int dotR;
        private int dotG;
        private int dotB;
        private String stringColor;
        private String stringNumber;
        private Image image;
        private static final int dm = 18;
        private static final int dp = 10;
        private final int[][] cubeCornersRGB;
        private final int[][] lineEndsYUV;
        private final int[][] lineEndsKLT;
        private final int[][] lineEndsHSB;
        private final int[][] lineEndsHSV;
        private final int[][] lineEndsHMMD;
        private final int[][] lineEndsLAB;
        private final int[][] textPosRGB;
        private final int[][] textPosXYY;
        private final int[][] textPosXYZ;
        private final int[][] textPosYUV;
        private final int[][] textPosKLT;
        private final int[][] textPosYIQ;
        private final int[][] textPosYCbCr;
        private final int[][] textPosYCgCo;
        private final int[][] textPosHSB;
        private final int[][] textPosHSL;
        private final int[][] textPosHSV;
        private final int[][] textPosHCL;
        private final int[][] textPosHMMD;
        private final int[][] textPosLAB;
        private final int[][] textPosLUV;
        private final int[][][] textPositions;
        private final String[][] letters;
        private final Color[][] letterCol;
        private final Color[][] letterGray;
        private ImageRegion imageRegion;
        private int width;
        private int height;
        private int[] pixels;
        private int[] pixelsAlpha;
        private int[] pixelsOverlay;
        private short[] pixelsZ;
        private float xs;
        private float ys;
        private int xoff;
        private int yoff;
        private float xs_xoff;
        private float ys_yoff;
        private double angleB;
        private double angleR;
        private float d;
        private float cosB;
        private float sinB;
        private float cosR;
        private float sinR;
        private float cosRsinB;
        private float cosRcosB;
        private float sinRsinB;
        private float sinRcosB;
        private int[] vec;
        private float scale;
        private Color cubeBackColor;
        private Color cubeFrontColor;
        private MemoryImageSource memoryImageSource;
        private MemoryImageSource memoryOverlayImageSource;
        boolean dot;
        private int[] pixelsOrig;
        private static final int HASH_F = 13;
        private static final int HASH_P = 101;

        public Picture(ImagePlus imp) {
            this.stringColor = Color_Inspector_3D.this.english ? "Color" : "Farbwert";
            this.stringNumber = Color_Inspector_3D.this.english ? "Frequency" : "Haeufigkeit";
            this.cubeCornersRGB = new int[][]{{-128, -128, -128}, {-128, 127, 127}, {127, -128, 127}, {127, 127, -128}, {-128, -128, 127}, {-128, 127, -128}, {127, -128, -128}, {127, 127, 127}};
            this.lineEndsYUV = new int[][]{{0, 0, -128}, {-128, 0, -128}, {0, -128, -128}, {0, 0, 127}, {127, 0, -128}, {0, 127, -128}};
            this.lineEndsKLT = new int[][]{{0, 0, -128}, {-128, 0, 0}, {0, -128, 0}, {0, 0, 127}, {127, 0, 0}, {0, 127, 0}};
            this.lineEndsHSB = new int[][]{{0, 0, -128}, {0, 0, -128}, {0, 0, 127}, {127, 0, -128}};
            this.lineEndsHSV = new int[][]{{0, 0, -128}, {0, 0, 127}, {0, 0, 127}, {127, 0, 127}};
            this.lineEndsHMMD = new int[][]{{0, 0, -128}, {0, 0, 0}, {0, 0, 127}, {128, 0, 0}};
            this.lineEndsLAB = this.lineEndsYUV;
            this.textPosRGB = new int[][]{{-146, -146, -146}, {137, -146, -146}, {-146, 137, -146}, {-146, -146, 137}};
            this.textPosXYY = this.textPosRGB;
            this.textPosXYZ = this.textPosRGB;
            this.textPosYUV = new int[][]{{0, 0, -146}, {137, 0, -146}, {0, 137, -146}, {0, 0, 137}};
            this.textPosKLT = new int[][]{{0, 0, -18}, {137, 0, -18}, {0, 137, -18}, {0, 0, 137}};
            this.textPosYIQ = this.textPosYUV;
            this.textPosYCbCr = this.textPosYUV;
            this.textPosYCgCo = this.textPosYUV;
            this.textPosHSB = new int[][]{{0, 0, -146}, {0, 147, 137}, {137, 0, -146}, {0, 0, 137}};
            this.textPosHSL = this.textPosHSB;
            this.textPosHSV = new int[][]{{0, 0, -146}, {0, 147, 137}, {137, 0, 137}, {0, 0, 137}};
            this.textPosHCL = this.textPosHSV;
            this.textPosHMMD = new int[][]{{0, 0, -146}, {0, 148, 0}, {148, 0, 0}, {0, 0, 137}};
            this.textPosLAB = new int[][]{{0, 0, -146}, {137, 0, -146}, {0, 137, -146}, {0, 0, 137}};
            this.textPosLUV = this.textPosLAB;
            this.textPositions = new int[][][]{this.textPosRGB, this.textPosYUV, this.textPosYCbCr, this.textPosYIQ, this.textPosYCgCo, this.textPosHSB, this.textPosHSV, this.textPosHSL, this.textPosHMMD, this.textPosLAB, this.textPosLUV, this.textPosXYY, this.textPosXYZ, this.textPosKLT, this.textPosHCL};
            this.letters = new String[][]{{"0", "R", "G", "B"}, {"0", "U", "V", "Y"}, {"0", "Cb", "Cr", "Y"}, {"0", "I", "Q", "Y"}, {"0", "Cg", "Co", "Y"}, {"0", "H", "S", "B"}, {"0", "H", "S", "V"}, {"0", "H", "S", "L"}, {"0", "Hue", "Diff", "Sum"}, {"0", "a", "b", "L"}, {"0", "u", "v", "L"}, {"0", "x", "y", "Y"}, {"0", "X", "Y", "Z"}, {"0", "C1", "C2", "C0"}, {"0", "H", "C", "L"}};
            this.letterCol = new Color[][]{{Color.black, Color.red, Color.green, Color.blue}, {Color.black, Color.orange, Color.orange, Color.orange}};
            this.letterGray = new Color[][]{{Color.black, Color.red, Color.green, Color.blue}, {Color.black, Color.blue, Color.blue, Color.blue}};
            this.imageRegion = null;
            this.pixels = null;
            this.pixelsAlpha = null;
            this.pixelsOverlay = null;
            this.pixelsZ = null;
            this.angleB = -0.6125;
            this.angleR = 2.0;
            this.d = 1089.0f;
            this.cosB = (float)Math.cos(this.angleB);
            this.sinB = (float)Math.sin(this.angleB);
            this.cosR = (float)Math.cos(this.angleR);
            this.sinR = (float)Math.sin(this.angleR);
            this.cosRsinB = this.cosR * this.sinB;
            this.cosRcosB = this.cosR * this.cosB;
            this.sinRsinB = this.sinR * this.sinB;
            this.sinRcosB = this.sinR * this.cosB;
            this.vec = new int[]{0, 0, 0};
            this.scale = 1.0f;
            this.dot = false;
            this.image = imp.getImage();
            this.width = imp.getWidth();
            this.height = imp.getHeight();
            Color_Inspector_3D.this.maskSize = this.width * this.height;
            this.xs_xoff = this.xs = (float)((double)this.width / 2.0 + 0.5);
            this.ys_yoff = this.ys = (float)((double)this.height / 2.0 + 0.5);
            PixelGrabber pg = null;
            this.pixels = new int[this.width * this.height];
            this.pixelsOrig = new int[this.width * this.height];
            pg = new PixelGrabber(this.image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException ex) {
                IJ.error((String)"error grabbing pixels");
            }
            Roi roi = imp.getRoi();
            if (roi != null) {
                ImageProcessor mask = roi.getMask();
                byte[] mpixels = null;
                int mWidth = 0;
                if (mask != null) {
                    ImageProcessor ipMask = mask.duplicate();
                    mpixels = (byte[])ipMask.getPixels();
                    mWidth = ipMask.getWidth();
                }
                Rectangle r = roi.getBoundingRect();
                for (int y = 0; y < this.height; ++y) {
                    int offset = y * this.width;
                    for (int x = 0; x < this.width; ++x) {
                        int mx;
                        int my;
                        int i = offset + x;
                        if (x < r.x || x >= r.x + r.width || y < r.y || y >= r.y + r.height) {
                            this.pixels[i] = 0x3F000000 | this.pixels[i] & 0xFFFFFF;
                            Color_Inspector_3D.this.maskSize--;
                            continue;
                        }
                        if (mask == null || mpixels[(my = y - r.y) * mWidth + (mx = x - r.x)] != 0) continue;
                        this.pixels[i] = 0x3F000000 | this.pixels[i] & 0xFFFFFF;
                        Color_Inspector_3D.this.maskSize--;
                    }
                }
            }
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixelsOrig[i] = this.pixels[i];
            }
            this.memoryImageSource = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
            this.image = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
        }

        public void setupOverlayImage() {
            this.pixelsOverlay = new int[this.width * this.height];
            this.memoryOverlayImageSource = new MemoryImageSource(this.width, this.height, this.pixelsOverlay, 0, this.width);
        }

        public void resetToOriginalImage() {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = this.pixelsOrig[i];
            }
        }

        public Picture(Image image, int width, int height) {
            this.stringColor = Color_Inspector_3D.this.english ? "Color" : "Farbwert";
            this.stringNumber = Color_Inspector_3D.this.english ? "Frequency" : "Haeufigkeit";
            this.cubeCornersRGB = new int[][]{{-128, -128, -128}, {-128, 127, 127}, {127, -128, 127}, {127, 127, -128}, {-128, -128, 127}, {-128, 127, -128}, {127, -128, -128}, {127, 127, 127}};
            this.lineEndsYUV = new int[][]{{0, 0, -128}, {-128, 0, -128}, {0, -128, -128}, {0, 0, 127}, {127, 0, -128}, {0, 127, -128}};
            this.lineEndsKLT = new int[][]{{0, 0, -128}, {-128, 0, 0}, {0, -128, 0}, {0, 0, 127}, {127, 0, 0}, {0, 127, 0}};
            this.lineEndsHSB = new int[][]{{0, 0, -128}, {0, 0, -128}, {0, 0, 127}, {127, 0, -128}};
            this.lineEndsHSV = new int[][]{{0, 0, -128}, {0, 0, 127}, {0, 0, 127}, {127, 0, 127}};
            this.lineEndsHMMD = new int[][]{{0, 0, -128}, {0, 0, 0}, {0, 0, 127}, {128, 0, 0}};
            this.lineEndsLAB = this.lineEndsYUV;
            this.textPosRGB = new int[][]{{-146, -146, -146}, {137, -146, -146}, {-146, 137, -146}, {-146, -146, 137}};
            this.textPosXYY = this.textPosRGB;
            this.textPosXYZ = this.textPosRGB;
            this.textPosYUV = new int[][]{{0, 0, -146}, {137, 0, -146}, {0, 137, -146}, {0, 0, 137}};
            this.textPosKLT = new int[][]{{0, 0, -18}, {137, 0, -18}, {0, 137, -18}, {0, 0, 137}};
            this.textPosYIQ = this.textPosYUV;
            this.textPosYCbCr = this.textPosYUV;
            this.textPosYCgCo = this.textPosYUV;
            this.textPosHSB = new int[][]{{0, 0, -146}, {0, 147, 137}, {137, 0, -146}, {0, 0, 137}};
            this.textPosHSL = this.textPosHSB;
            this.textPosHSV = new int[][]{{0, 0, -146}, {0, 147, 137}, {137, 0, 137}, {0, 0, 137}};
            this.textPosHCL = this.textPosHSV;
            this.textPosHMMD = new int[][]{{0, 0, -146}, {0, 148, 0}, {148, 0, 0}, {0, 0, 137}};
            this.textPosLAB = new int[][]{{0, 0, -146}, {137, 0, -146}, {0, 137, -146}, {0, 0, 137}};
            this.textPosLUV = this.textPosLAB;
            this.textPositions = new int[][][]{this.textPosRGB, this.textPosYUV, this.textPosYCbCr, this.textPosYIQ, this.textPosYCgCo, this.textPosHSB, this.textPosHSV, this.textPosHSL, this.textPosHMMD, this.textPosLAB, this.textPosLUV, this.textPosXYY, this.textPosXYZ, this.textPosKLT, this.textPosHCL};
            this.letters = new String[][]{{"0", "R", "G", "B"}, {"0", "U", "V", "Y"}, {"0", "Cb", "Cr", "Y"}, {"0", "I", "Q", "Y"}, {"0", "Cg", "Co", "Y"}, {"0", "H", "S", "B"}, {"0", "H", "S", "V"}, {"0", "H", "S", "L"}, {"0", "Hue", "Diff", "Sum"}, {"0", "a", "b", "L"}, {"0", "u", "v", "L"}, {"0", "x", "y", "Y"}, {"0", "X", "Y", "Z"}, {"0", "C1", "C2", "C0"}, {"0", "H", "C", "L"}};
            this.letterCol = new Color[][]{{Color.black, Color.red, Color.green, Color.blue}, {Color.black, Color.orange, Color.orange, Color.orange}};
            this.letterGray = new Color[][]{{Color.black, Color.red, Color.green, Color.blue}, {Color.black, Color.blue, Color.blue, Color.blue}};
            this.imageRegion = null;
            this.pixels = null;
            this.pixelsAlpha = null;
            this.pixelsOverlay = null;
            this.pixelsZ = null;
            this.angleB = -0.6125;
            this.angleR = 2.0;
            this.d = 1089.0f;
            this.cosB = (float)Math.cos(this.angleB);
            this.sinB = (float)Math.sin(this.angleB);
            this.cosR = (float)Math.cos(this.angleR);
            this.sinR = (float)Math.sin(this.angleR);
            this.cosRsinB = this.cosR * this.sinB;
            this.cosRcosB = this.cosR * this.cosB;
            this.sinRsinB = this.sinR * this.sinB;
            this.sinRcosB = this.sinR * this.cosB;
            this.vec = new int[]{0, 0, 0};
            this.scale = 1.0f;
            this.dot = false;
            this.image = image;
            this.width = width;
            this.height = height;
            this.pixels = new int[width * height];
            PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, this.pixels, 0, width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.xs_xoff = this.xs = (float)((double)width / 2.0 + 0.5);
            this.ys_yoff = this.ys = (float)((double)height / 2.0 + 0.5);
        }

        public Picture(int width, int height) {
            this.stringColor = Color_Inspector_3D.this.english ? "Color" : "Farbwert";
            this.stringNumber = Color_Inspector_3D.this.english ? "Frequency" : "Haeufigkeit";
            this.cubeCornersRGB = new int[][]{{-128, -128, -128}, {-128, 127, 127}, {127, -128, 127}, {127, 127, -128}, {-128, -128, 127}, {-128, 127, -128}, {127, -128, -128}, {127, 127, 127}};
            this.lineEndsYUV = new int[][]{{0, 0, -128}, {-128, 0, -128}, {0, -128, -128}, {0, 0, 127}, {127, 0, -128}, {0, 127, -128}};
            this.lineEndsKLT = new int[][]{{0, 0, -128}, {-128, 0, 0}, {0, -128, 0}, {0, 0, 127}, {127, 0, 0}, {0, 127, 0}};
            this.lineEndsHSB = new int[][]{{0, 0, -128}, {0, 0, -128}, {0, 0, 127}, {127, 0, -128}};
            this.lineEndsHSV = new int[][]{{0, 0, -128}, {0, 0, 127}, {0, 0, 127}, {127, 0, 127}};
            this.lineEndsHMMD = new int[][]{{0, 0, -128}, {0, 0, 0}, {0, 0, 127}, {128, 0, 0}};
            this.lineEndsLAB = this.lineEndsYUV;
            this.textPosRGB = new int[][]{{-146, -146, -146}, {137, -146, -146}, {-146, 137, -146}, {-146, -146, 137}};
            this.textPosXYY = this.textPosRGB;
            this.textPosXYZ = this.textPosRGB;
            this.textPosYUV = new int[][]{{0, 0, -146}, {137, 0, -146}, {0, 137, -146}, {0, 0, 137}};
            this.textPosKLT = new int[][]{{0, 0, -18}, {137, 0, -18}, {0, 137, -18}, {0, 0, 137}};
            this.textPosYIQ = this.textPosYUV;
            this.textPosYCbCr = this.textPosYUV;
            this.textPosYCgCo = this.textPosYUV;
            this.textPosHSB = new int[][]{{0, 0, -146}, {0, 147, 137}, {137, 0, -146}, {0, 0, 137}};
            this.textPosHSL = this.textPosHSB;
            this.textPosHSV = new int[][]{{0, 0, -146}, {0, 147, 137}, {137, 0, 137}, {0, 0, 137}};
            this.textPosHCL = this.textPosHSV;
            this.textPosHMMD = new int[][]{{0, 0, -146}, {0, 148, 0}, {148, 0, 0}, {0, 0, 137}};
            this.textPosLAB = new int[][]{{0, 0, -146}, {137, 0, -146}, {0, 137, -146}, {0, 0, 137}};
            this.textPosLUV = this.textPosLAB;
            this.textPositions = new int[][][]{this.textPosRGB, this.textPosYUV, this.textPosYCbCr, this.textPosYIQ, this.textPosYCgCo, this.textPosHSB, this.textPosHSV, this.textPosHSL, this.textPosHMMD, this.textPosLAB, this.textPosLUV, this.textPosXYY, this.textPosXYZ, this.textPosKLT, this.textPosHCL};
            this.letters = new String[][]{{"0", "R", "G", "B"}, {"0", "U", "V", "Y"}, {"0", "Cb", "Cr", "Y"}, {"0", "I", "Q", "Y"}, {"0", "Cg", "Co", "Y"}, {"0", "H", "S", "B"}, {"0", "H", "S", "V"}, {"0", "H", "S", "L"}, {"0", "Hue", "Diff", "Sum"}, {"0", "a", "b", "L"}, {"0", "u", "v", "L"}, {"0", "x", "y", "Y"}, {"0", "X", "Y", "Z"}, {"0", "C1", "C2", "C0"}, {"0", "H", "C", "L"}};
            this.letterCol = new Color[][]{{Color.black, Color.red, Color.green, Color.blue}, {Color.black, Color.orange, Color.orange, Color.orange}};
            this.letterGray = new Color[][]{{Color.black, Color.red, Color.green, Color.blue}, {Color.black, Color.blue, Color.blue, Color.blue}};
            this.imageRegion = null;
            this.pixels = null;
            this.pixelsAlpha = null;
            this.pixelsOverlay = null;
            this.pixelsZ = null;
            this.angleB = -0.6125;
            this.angleR = 2.0;
            this.d = 1089.0f;
            this.cosB = (float)Math.cos(this.angleB);
            this.sinB = (float)Math.sin(this.angleB);
            this.cosR = (float)Math.cos(this.angleR);
            this.sinR = (float)Math.sin(this.angleR);
            this.cosRsinB = this.cosR * this.sinB;
            this.cosRcosB = this.cosR * this.cosB;
            this.sinRsinB = this.sinR * this.sinB;
            this.sinRcosB = this.sinR * this.cosB;
            this.vec = new int[]{0, 0, 0};
            this.scale = 1.0f;
            this.dot = false;
            this.width = width;
            this.height = height;
            this.pixels = new int[width * height];
            this.pixelsAlpha = new int[width * height];
            this.pixelsZ = new short[width * height];
            this.memoryImageSource = new MemoryImageSource(width, height, this.pixels, 0, width);
            this.image = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
            this.xs_xoff = this.xs = (float)((double)width / 2.0 + 0.5);
            this.ys_yoff = this.ys = (float)((double)height / 2.0 + 0.5);
        }

        public void initTextsAndDrawColors() {
            String string;
            this.imageRegion.newText(7);
            this.imageRegion.newLines(62);
            boolean col = (Color_Inspector_3D.this.mode & 1) == 0;
            this.imageRegion.setPlaneColor(col ? new Color(-8947849) : Color.white);
            this.cubeBackColor = new Color(0, 0, 0, 100);
            this.cubeFrontColor = col ? Color.white : Color.blue;
            for (int i = 0; i < this.letters[0].length; ++i) {
                Color color = col ? (Color_Inspector_3D.this.colorSpace == 0 ? this.letterCol[0][i] : this.letterCol[1][i]) : (Color_Inspector_3D.this.colorSpace == 0 ? this.letterGray[0][i] : this.letterGray[1][i]);
                this.imageRegion.setText(this.letters[Color_Inspector_3D.this.colorSpace][i], i, color);
            }
            this.imageRegion.setText("", 5, this.width - 60, this.height - 10, 1, col ? Color.white : Color.black);
            String string2 = string = Color_Inspector_3D.this.english ? Color_Inspector_3D.this.maskSize + " Pixels,  " + Color_Inspector_3D.this.numberOfColors + " Colors    " : Color_Inspector_3D.this.maskSize + " Pixel,  " + Color_Inspector_3D.this.numberOfColors + " Farben    ";
            if (Color_Inspector_3D.this.numberOfColors == 1) {
                string = Color_Inspector_3D.this.english ? Color_Inspector_3D.this.maskSize + " Pixels  1 Color     " : Color_Inspector_3D.this.maskSize + " Pixel  1 Farbe     ";
            }
            Color_Inspector_3D.this.label.setText(string);
        }

        public void setDot() {
            this.R = this.dotR;
            this.G = this.dotG;
            this.B = this.dotB;
            this.xyzPos();
        }

        int quant(int x) {
            if ((x -= 128) >= 0) {
                x = (int)((float)x + Color_Inspector_3D.this.delta / 2.0f);
                x = (int)((float)x / Color_Inspector_3D.this.delta);
                x = (int)((float)x * Color_Inspector_3D.this.delta);
            } else {
                x = -x;
                x = (int)((float)x + Color_Inspector_3D.this.delta / 2.0f);
                x = (int)((float)x / Color_Inspector_3D.this.delta);
                x = (int)((float)x * Color_Inspector_3D.this.delta);
                x = -x;
            }
            if ((x += 128) < 0) {
                x = 0;
            }
            if (x > 255) {
                x = 255;
            }
            return x;
        }

        public void setScale(float s) {
            this.scale = s;
            this.imageRegion.setScale(this.scale);
        }

        public void setMouseMovement(int dx, int dy) {
            this.angleB += (double)dx / 100.0;
            this.angleR += (double)dy / 100.0;
            this.cosB = (float)Math.cos(this.angleB);
            this.sinB = (float)Math.sin(this.angleB);
            this.cosR = (float)Math.cos(this.angleR);
            this.sinR = (float)Math.sin(this.angleR);
            this.cosRsinB = this.cosR * this.sinB;
            this.cosRcosB = this.cosR * this.cosB;
            this.sinRsinB = this.sinR * this.sinB;
            this.sinRcosB = this.sinR * this.cosB;
        }

        public void setMouseAngle(float a, float b) {
            this.angleB = Math.toRadians(a);
            this.angleR = Math.toRadians(b);
            this.cosB = (float)Math.cos(this.angleB);
            this.sinB = (float)Math.sin(this.angleB);
            this.cosR = (float)Math.cos(this.angleR);
            this.sinR = (float)Math.sin(this.angleR);
            this.cosRsinB = this.cosR * this.sinB;
            this.cosRcosB = this.cosR * this.cosB;
            this.sinRsinB = this.sinR * this.sinB;
            this.sinRcosB = this.sinR * this.cosB;
        }

        public void setMouseMovementOffset(int dx, int dy) {
            this.xoff += dx;
            this.yoff += dy;
            this.xs_xoff = this.xs + (float)this.xoff;
            this.ys_yoff = this.ys + (float)this.yoff;
        }

        public void setImageRegion(ImageRegion imageRegion) {
            this.imageRegion = imageRegion;
        }

        int getWidth() {
            return this.width;
        }

        int getHeight() {
            return this.height;
        }

        Image getImage() {
            return this.image;
        }

        int[] getPixels() {
            return this.pixels;
        }

        private final void xyzPosC() {
            float Y2 = this.cosRsinB * (float)this.R + this.cosRcosB * (float)this.G - this.sinR * (float)this.B;
            float z = this.sinRsinB * (float)this.R + this.sinRcosB * (float)this.G + this.cosR * (float)this.B;
            this.Z = (int)z;
            z += this.d;
            z = this.d / z;
            this.X = (int)((this.cosB * (float)this.R - this.sinB * (float)this.G) * z + this.xs_xoff);
            this.Y = (int)(Y2 * z + this.ys_yoff);
        }

        private final void xyzPos() {
            float Y1 = this.sinB * (float)this.R + this.cosB * (float)this.G;
            float Y2 = this.cosR * Y1 - this.sinR * (float)this.B;
            float z = this.sinR * Y1 + this.cosR * (float)this.B;
            float sz = this.scale * this.d / (z + this.d);
            this.Z = (int)z;
            this.X = (int)((this.cosB * (float)this.R - this.sinB * (float)this.G) * sz + this.xs + this.scale * (float)this.xoff);
            this.Y = (int)(Y2 * sz + this.ys + this.scale * (float)this.yoff);
        }

        private final void xyzPos(int r, int g, int b) {
            this.R = r;
            this.G = g;
            this.B = b;
            this.xyzPos();
        }

        private final void xyzPos(int[] rgb) {
            this.R = rgb[0];
            this.G = rgb[1];
            this.B = rgb[2];
            this.xyzPos();
        }

        private void rgb2ycgco(int r, int g, int b, int[] ycgco) {
            int[] rgb = new int[]{r, g, b};
            this.rgb2ycgco(rgb, ycgco);
        }

        private void rgb2ycgco(int[] rgb, ColHash cv) {
            this.rgb2ycgco(rgb, this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2ycgco(int[] rgb, int[] ycgco) {
            int r = rgb[0];
            int g = rgb[1];
            int b = rgb[2];
            ycgco[2] = (r + 2 * g + b) / 4;
            ycgco[0] = (-r + 2 * g - b) / 4;
            ycgco[1] = (r - b) / 2;
        }

        private void ycgco2rgb(int[] ycgco, int[] rgb) {
            int c0 = ycgco[2];
            int c1 = ycgco[0];
            int c2 = ycgco[1];
            int tmp = c0 - c1;
            rgb[0] = tmp + c2;
            rgb[1] = c0 + c1;
            rgb[2] = tmp - c2;
        }

        private void rgb2ycbcr(int r, int g, int b, int[] yuv) {
            int[] rgb = new int[]{r, g, b};
            this.rgb2ycbcr(rgb, yuv);
        }

        private void rgb2ycbcr(int[] rgb, ColHash cv) {
            this.rgb2ycbcr(rgb, this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2ycbcr(int[] rgb, int[] yuv) {
            yuv[2] = (int)(0.299f * (float)rgb[0] + 0.587f * (float)rgb[1] + 0.114f * (float)rgb[2]);
            yuv[0] = (int)(-0.16874f * (float)rgb[0] - 0.33126f * (float)rgb[1] + 0.5f * (float)rgb[2]);
            yuv[1] = (int)(0.5f * (float)rgb[0] - 0.41869f * (float)rgb[1] - 0.08131f * (float)rgb[2]);
        }

        private void ycbcr2rgb(int[] yuv, int[] rgb) {
            float y = yuv[2];
            float u = yuv[0];
            float v = yuv[1];
            rgb[0] = (int)(y + 1.402f * v);
            rgb[1] = (int)(y - 0.3441f * u - 0.7141f * v);
            rgb[2] = (int)(y + 1.772f * u);
        }

        private void yiq2rgb(int[] yiq, int[] rgb) {
            float y = yiq[2];
            float i = yiq[0];
            float q = yiq[1];
            rgb[0] = (int)(y + 0.9563f * i + 0.621f * q);
            rgb[1] = (int)(y - 0.2721f * i - 0.6473f * q);
            rgb[2] = (int)(y - 1.107f * i + 1.7046f * q);
        }

        private void rgb2klt(int r, int g, int b, int[] yuv) {
            int[] rgb = new int[]{r, g, b};
            this.rgb2klt(rgb, yuv);
        }

        private void rgb2klt(int[] rgb, ColHash cv) {
            this.rgb2klt(rgb, this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2klt(int[] rgb, int[] yuv) {
            double m00 = Color_Inspector_3D.this.kltMatrix[0][0];
            double m01 = Color_Inspector_3D.this.kltMatrix[1][0];
            double m02 = Color_Inspector_3D.this.kltMatrix[2][0];
            double m10 = Color_Inspector_3D.this.kltMatrix[0][1];
            double m11 = Color_Inspector_3D.this.kltMatrix[1][1];
            double m12 = Color_Inspector_3D.this.kltMatrix[2][1];
            double m20 = Color_Inspector_3D.this.kltMatrix[0][2];
            double m21 = Color_Inspector_3D.this.kltMatrix[1][2];
            double m22 = Color_Inspector_3D.this.kltMatrix[2][2];
            double r = ((double)rgb[0] - Color_Inspector_3D.this.kltMean[0]) * 0.7071;
            double g = ((double)rgb[1] - Color_Inspector_3D.this.kltMean[1]) * 0.7071;
            double b = ((double)rgb[2] - Color_Inspector_3D.this.kltMean[2]) * 0.7071;
            yuv[2] = (int)(m00 * r + m01 * g + m02 * b);
            yuv[0] = (int)(m10 * r + m11 * g + m12 * b);
            yuv[1] = (int)(m20 * r + m21 * g + m22 * b);
        }

        private void klt2rgb(int[] vec, int[] rgb) {
            double m00 = Color_Inspector_3D.this.kltMatrix[0][0];
            double m01 = Color_Inspector_3D.this.kltMatrix[0][1];
            double m02 = Color_Inspector_3D.this.kltMatrix[0][2];
            double m10 = Color_Inspector_3D.this.kltMatrix[1][0];
            double m11 = Color_Inspector_3D.this.kltMatrix[1][1];
            double m12 = Color_Inspector_3D.this.kltMatrix[1][2];
            double m20 = Color_Inspector_3D.this.kltMatrix[2][0];
            double m21 = Color_Inspector_3D.this.kltMatrix[2][1];
            double m22 = Color_Inspector_3D.this.kltMatrix[2][2];
            double v0 = (float)vec[2] * 1.4142f;
            double v1 = (float)vec[0] * 1.4142f;
            double v2 = (float)vec[1] * 1.4142f;
            rgb[0] = (int)(m00 * v0 + m01 * v1 + m02 * v2 + Color_Inspector_3D.this.kltMean[0]);
            rgb[1] = (int)(m10 * v0 + m11 * v1 + m12 * v2 + Color_Inspector_3D.this.kltMean[1]);
            rgb[2] = (int)(m20 * v0 + m21 * v1 + m22 * v2 + Color_Inspector_3D.this.kltMean[2]);
        }

        private void rgb2yuv(int r, int g, int b, int[] yuv) {
            int[] rgb = new int[]{r, g, b};
            this.rgb2yuv(rgb, yuv);
        }

        private void rgb2yuv(int[] rgb, ColHash cv) {
            this.rgb2yuv(rgb, this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2yuv(int[] rgb, int[] yuv) {
            yuv[2] = (int)(0.299f * (float)rgb[0] + 0.587f * (float)rgb[1] + 0.114f * (float)rgb[2]);
            yuv[0] = (int)((float)(rgb[2] - yuv[2]) * 0.492f * 0.8f);
            yuv[1] = (int)((float)(rgb[0] - yuv[2]) * 0.877f * 0.8f);
        }

        private void yuv2rgb(int[] yuv, int[] rgb) {
            float b = (float)yuv[0] / 0.492f / 0.8f + (float)yuv[2];
            float r = (float)yuv[1] / 0.877f / 0.8f + (float)yuv[2];
            float g = ((float)yuv[2] - 0.299f * r - 0.114f * b) / 0.587f;
            rgb[0] = (int)r;
            rgb[1] = (int)g;
            rgb[2] = (int)b;
        }

        private void rgb2hsb_(int[] rgb, ColHash cv) {
            float[] hsbvals = new float[3];
            Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], hsbvals);
            float phi = 360.0f * hsbvals[0];
            float s = hsbvals[1] * 128.0f;
            float br = hsbvals[2] * 255.0f;
            cv.R = (int)phi;
            cv.G = (int)s;
            cv.B = (int)br;
        }

        private void hsb2rgb_(int[] hsb, int[] vec) {
            float hue = (float)(Color_Inspector_3D.this.channelFactor[0] * (double)hsb[0] / 360.0);
            float sat = (float)(Color_Inspector_3D.this.channelFactor[1] * (double)hsb[1] / 128.0);
            float br = (float)(Color_Inspector_3D.this.channelFactor[2] * ((double)hsb[2] - 127.5) / 255.0 + 0.5);
            sat = Math.min(1.0f, Math.max(0.0f, sat));
            br = Math.min(1.0f, Math.max(0.0f, br));
            int c = Color.HSBtoRGB(hue, sat, br);
            vec[0] = c >> 16 & 0xFF;
            vec[1] = c >> 8 & 0xFF;
            vec[2] = c & 0xFF;
        }

        private void rgb2hsb(int[] rgb, ColHash cv) {
            this.rgb2hsb(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2hsb(int[] yuv, int[] rgb) {
            this.rgb2hsb(rgb[0], rgb[1], rgb[2], yuv);
        }

        private void rgb2hsb(int r, int g, int b, int[] hsb) {
            float[] hsbvals = new float[3];
            Color.RGBtoHSB(r, g, b, hsbvals);
            float phi = (float)Math.toRadians(360.0f * hsbvals[0]);
            float s = hsbvals[1] * 128.0f;
            float br = hsbvals[2] * 255.0f;
            hsb[0] = (int)((double)s * Math.cos(phi));
            hsb[1] = (int)((double)s * Math.sin(phi));
            hsb[2] = (int)br;
            hsbvals = null;
        }

        private void rgb2hsb_(int r, int g, int b, int[] hsb) {
            float[] hsbvals = new float[3];
            Color.RGBtoHSB(r, g, b, hsbvals);
            hsb[0] = (int)(360.0f * hsbvals[0] + 0.5f);
            hsb[1] = (int)(hsbvals[1] * 100.0f + 0.5f);
            hsb[2] = (int)(hsbvals[2] * 100.0f + 0.5f);
            hsbvals = null;
        }

        private void rgb2hmmd(int[] rgb, ColHash cv) {
            this.rgb2hmmd(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2yiq(int[] rgb, ColHash cv) {
            this.rgb2yiq(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2yiq(int r, int g, int b, int[] yiq) {
            int[] rgb = new int[]{r, g, b};
            this.rgb2yiq(rgb, yiq);
        }

        private void rgb2yiq(int[] rgb, int[] yiq) {
            yiq[2] = (int)(0.299f * (float)rgb[0] + 0.587f * (float)rgb[1] + 0.114f * (float)rgb[2]);
            yiq[0] = (int)(0.5957f * (float)rgb[0] - 0.2744f * (float)rgb[1] - 0.3212f * (float)rgb[2]);
            yiq[1] = (int)(0.2114f * (float)rgb[0] - 0.5226f * (float)rgb[1] + 0.3111f * (float)rgb[2]);
        }

        private void rgb2hcl(int[] rgb, ColHash cv) {
            this.rgb2hcl(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2hcl(int r, int g, int b, int[] hcl) {
            float L;
            float C;
            float H;
            int max;
            int min;
            float Y0 = 100.0f;
            float gamma = 3.0f;
            if (r > g) {
                min = g;
                max = r;
            } else {
                min = r;
                max = g;
            }
            if (b > max) {
                max = b;
            }
            if (b < min) {
                min = b;
            }
            if (min == 0 && max == 0) {
                H = 0.0f;
                C = 0.0f;
                L = 0.0f;
            } else {
                float alpha = (float)(min / max) / Y0;
                float Q = (float)Math.exp(alpha * gamma);
                int rg = r - g;
                int gb = g - b;
                int br = b - r;
                L = (float)((double)(Q * (float)max + (1.0f - Q) * (float)min) / 2.0);
                C = (float)((double)(Q * (float)(Math.abs(rg) + Math.abs(gb) + Math.abs(br))) / 3.0);
                H = (float)Math.toDegrees(Math.atan((double)gb / (double)rg));
                if (rg < 0 && gb >= 0) {
                    H = 180.0f + H;
                }
                if (rg < 0 && gb < 0) {
                    H -= 180.0f;
                }
            }
            float phi = (float)Math.toRadians(H);
            hcl[0] = (int)((double)C * Math.cos(phi));
            hcl[1] = (int)((double)C * Math.sin(phi));
            hcl[2] = (int)L;
        }

        private void rgb2hsl(int[] rgb, ColHash cv) {
            this.rgb2hsl(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2hsl(int[] rgb, int[] vec) {
            this.rgb2hsl(rgb[0], rgb[1], rgb[2], vec);
        }

        private void rgb2hsl(int r, int g, int b, int[] hsl) {
            float S;
            float var_Max;
            float var_Min;
            float var_R = (float)r / 255.0f;
            float var_G = (float)g / 255.0f;
            float var_B = (float)b / 255.0f;
            if (var_R > var_G) {
                var_Min = var_G;
                var_Max = var_R;
            } else {
                var_Min = var_R;
                var_Max = var_G;
            }
            if (var_B > var_Max) {
                var_Max = var_B;
            }
            if (var_B < var_Min) {
                var_Min = var_B;
            }
            float del_Max = var_Max - var_Min;
            float H = 0.0f;
            float L = (var_Max + var_Min) / 2.0f;
            if (del_Max == 0.0f) {
                H = 0.0f;
                S = 0.0f;
            } else {
                S = (double)L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
                float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
                float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
                float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
                if (var_R == var_Max) {
                    H = del_B - del_G;
                } else if (var_G == var_Max) {
                    H = 0.33333334f + del_R - del_B;
                } else if (var_B == var_Max) {
                    H = 0.6666667f + del_G - del_R;
                }
                if (H < 0.0f) {
                    H += 1.0f;
                }
                if (H > 1.0f) {
                    H -= 1.0f;
                }
            }
            float phi = (float)Math.toRadians(360.0f * H);
            hsl[0] = (int)((double)S * Math.cos(phi) * 128.0);
            hsl[1] = (int)((double)S * Math.sin(phi) * 128.0);
            hsl[2] = (int)(L * 255.0f);
        }

        private void rgb2hsl_(int r, int g, int b, int[] hsl) {
            float S;
            float var_Max;
            float var_Min;
            float var_R = (float)r / 255.0f;
            float var_G = (float)g / 255.0f;
            float var_B = (float)b / 255.0f;
            if (var_R > var_G) {
                var_Min = var_G;
                var_Max = var_R;
            } else {
                var_Min = var_R;
                var_Max = var_G;
            }
            if (var_B > var_Max) {
                var_Max = var_B;
            }
            if (var_B < var_Min) {
                var_Min = var_B;
            }
            float del_Max = var_Max - var_Min;
            float H = 0.0f;
            float L = (var_Max + var_Min) / 2.0f;
            if (del_Max == 0.0f) {
                H = 0.0f;
                S = 0.0f;
            } else {
                S = (double)L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
                float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
                float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
                float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
                if (var_R == var_Max) {
                    H = del_B - del_G;
                } else if (var_G == var_Max) {
                    H = 0.33333334f + del_R - del_B;
                } else if (var_B == var_Max) {
                    H = 0.6666667f + del_G - del_R;
                }
                if (H < 0.0f) {
                    H += 1.0f;
                }
                if (H > 1.0f) {
                    H -= 1.0f;
                }
            }
            hsl[0] = (int)(360.0f * H);
            hsl[1] = (int)(S * 100.0f);
            hsl[2] = (int)(L * 100.0f);
        }

        private void rgb2hsv(int[] rgb, int[] vec) {
            this.rgb2hsv(rgb[0], rgb[1], rgb[2], vec);
        }

        private void rgb2hsv(int[] rgb, ColHash cv) {
            this.rgb2hsv(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        private void rgb2hsv(int r, int g, int b, int[] hsv) {
            float S;
            int max;
            int min;
            if (r > g) {
                min = g;
                max = r;
            } else {
                min = r;
                max = g;
            }
            if (b > max) {
                max = b;
            }
            if (b < min) {
                min = b;
            }
            int delMax = max - min;
            float H = 0.0f;
            float V = max;
            if (delMax == 0) {
                H = 0.0f;
                S = 0.0f;
            } else {
                S = (float)delMax / 255.0f;
                if (r == max) {
                    H = (float)(g - b) / (float)delMax * 60.0f;
                } else if (g == max) {
                    H = (2.0f + (float)(b - r) / (float)delMax) * 60.0f;
                } else if (b == max) {
                    H = (4.0f + (float)(r - g) / (float)delMax) * 60.0f;
                }
            }
            float phi = (float)Math.toRadians(H);
            hsv[0] = (int)((double)S * Math.cos(phi) * 128.0);
            hsv[1] = (int)((double)S * Math.sin(phi) * 128.0);
            hsv[2] = (int)V;
        }

        private void rgb2hsv_(int r, int g, int b, int[] hsv) {
            float S;
            int max;
            int min;
            if (r > g) {
                min = g;
                max = r;
            } else {
                min = r;
                max = g;
            }
            if (b > max) {
                max = b;
            }
            if (b < min) {
                min = b;
            }
            int delMax = max - min;
            float H = 0.0f;
            float V = max;
            if (delMax == 0) {
                H = 0.0f;
                S = 0.0f;
            } else {
                S = (float)delMax / 255.0f;
                if (r == max) {
                    H = (float)(g - b) / (float)delMax * 60.0f;
                } else if (g == max) {
                    H = (2.0f + (float)(b - r) / (float)delMax) * 60.0f;
                } else if (b == max) {
                    H = (4.0f + (float)(r - g) / (float)delMax) * 60.0f;
                }
            }
            if (H < 0.0f) {
                H += 360.0f;
            }
            hsv[0] = (int)H;
            hsv[1] = (int)(S * 100.0f);
            hsv[2] = (int)(V / 255.0f * 100.0f);
        }

        private void rgb2hmmd_orig(int r, int g, int b, int[] hmmd) {
            float max = Math.max(Math.max(r, g), Math.max(g, b));
            float min = Math.min(Math.min(r, g), Math.min(g, b));
            float diff = max - min;
            float sum = (float)((double)(max + min) / 2.0);
            float hue = 0.0f;
            if (diff == 0.0f) {
                hue = 0.0f;
            } else if ((float)r == max && g - b > 0) {
                hue = (float)(60 * (g - b)) / (max - min);
            } else if ((float)r == max && g - b <= 0) {
                hue = (float)(60 * (g - b)) / (max - min) + 360.0f;
            } else if ((float)g == max) {
                hue = (float)(60.0 * (2.0 + (double)((float)(b - r) / (max - min))));
            } else if ((float)b == max) {
                hue = (float)(60.0 * (4.0 + (double)((float)(r - g) / (max - min))));
            }
            float phi = (float)Math.toRadians(hue);
            hmmd[0] = (int)((double)(diff /= 2.0f) * Math.cos(phi));
            hmmd[1] = (int)((double)diff * Math.sin(phi));
            hmmd[2] = (int)sum;
        }

        private void rgb2hmmd(int r, int g, int b, int[] hmmd) {
            float temp;
            float max = Math.max(Math.max(r, g), Math.max(g, b));
            float min = Math.min(Math.min(r, g), Math.min(g, b));
            float diff = max - min;
            float sum = (float)((double)(max + min) / 2.0);
            float hue = 0.0f;
            if (max != min) {
                temp = (float)(60.0 / (double)diff);
                hue = (float)r == max ? (g >= b ? (float)(g - b) * temp : (float)((double)((float)(-(b - g)) * temp) + 360.0)) : ((float)g == max ? (float)(120.0 + (double)((float)(b - r) * temp)) : (float)(240.0 + (double)((float)(r - g) * temp)));
            }
            temp = (float)((double)((int)hue % 120) + ((double)hue - Math.floor(hue)));
            temp = (float)Math.toRadians(temp);
            hue = (float)(60.0 * (1.0 - Math.cos(1.5 * (double)temp)) + 120.0 * Math.floor((double)hue / 120.0));
            float phi = (float)Math.toRadians(hue);
            hmmd[0] = (int)((double)(diff /= 2.0f) * Math.cos(phi));
            hmmd[1] = (int)((double)diff * Math.sin(phi));
            hmmd[2] = (int)sum;
        }

        private void rgb2hmmd_(int r, int g, int b, int[] hmmd) {
            float max = Math.max(Math.max(r, g), Math.max(g, b));
            float min = Math.min(Math.min(r, g), Math.min(g, b));
            float diff = max - min;
            float hue = 0.0f;
            if (diff == 0.0f) {
                hue = 0.0f;
            } else if ((float)r == max && g - b > 0) {
                hue = (float)(60 * (g - b)) / (max - min);
            } else if ((float)r == max && g - b <= 0) {
                hue = (float)(60 * (g - b)) / (max - min) + 360.0f;
            } else if ((float)g == max) {
                hue = (float)(60.0 * (2.0 + (double)((float)(b - r) / (max - min))));
            } else if ((float)b == max) {
                hue = (float)(60.0 * (4.0 + (double)((float)(r - g) / (max - min))));
            }
            hmmd[0] = (int)hue;
            hmmd[1] = (int)max;
            hmmd[2] = (int)min;
            hmmd[3] = (int)(diff /= 2.0f);
        }

        private void rgb2xyy(int[] rgb, ColHash cv) {
            this.rgb2xyy(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        public void rgb2xyy(int R, int G, int B, int[] xyy) {
            float y;
            float x;
            float r = (float)R / 255.0f;
            float g = (float)G / 255.0f;
            float b = (float)B / 255.0f;
            r = (double)r <= 0.04045 ? (r /= 12.0f) : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
            g = (double)g <= 0.04045 ? (g /= 12.0f) : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
            b = (double)b <= 0.04045 ? (b /= 12.0f) : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
            float X = 0.43605202f * r + 0.3850816f * g + 0.14308742f * b;
            float Y = 0.22249159f * r + 0.71688604f * g + 0.060621485f * b;
            float Z = 0.013929122f * r + 0.097097f * g + 0.7141855f * b;
            float sum = X + Y + Z;
            if (sum != 0.0f) {
                x = X / sum;
                y = Y / sum;
            } else {
                float Xr = 0.964221f;
                float Yr = 1.0f;
                float Zr = 0.825211f;
                x = Xr / (Xr + Yr + Zr);
                y = Yr / (Xr + Yr + Zr);
            }
            xyy[2] = (int)((double)(255.0f * Y) + 0.5);
            xyy[0] = (int)((double)(255.0f * x) + 0.5);
            xyy[1] = (int)((double)(255.0f * y) + 0.5);
        }

        private void rgb2xyz(int[] rgb, ColHash cv) {
            this.rgb2xyz(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        public void rgb2xyz(int R, int G, int B, int[] xyz) {
            float r = (float)R / 255.0f;
            float g = (float)G / 255.0f;
            float b = (float)B / 255.0f;
            r = (double)r <= 0.04045 ? (r /= 12.0f) : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
            g = (double)g <= 0.04045 ? (g /= 12.0f) : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
            b = (double)b <= 0.04045 ? (b /= 12.0f) : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
            float X = 0.43605202f * r + 0.3850816f * g + 0.14308742f * b;
            float Y = 0.22249159f * r + 0.71688604f * g + 0.060621485f * b;
            float Z = 0.013929122f * r + 0.097097f * g + 0.7141855f * b;
            xyz[2] = (int)((double)(255.0f * Y) + 0.5);
            xyz[0] = (int)((double)(255.0f * X) + 0.5);
            xyz[1] = (int)((double)(255.0f * Z) + 0.5);
        }

        private void rgb2lab(int[] rgb, int[] vec) {
            this.rgb2lab(rgb[0], rgb[1], rgb[2], vec);
        }

        private void rgb2luv(int[] rgb, int[] vec) {
            this.rgb2luv(rgb[0], rgb[1], rgb[2], vec);
        }

        private void rgb2lab(int[] rgb, ColHash cv) {
            this.rgb2lab(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        public void rgb2lab_alt(int R, int G, int B, int[] lab) {
            float eps = 0.008856452f;
            float k = 903.2963f;
            float Xr = 0.964221f;
            float Yr = 1.0f;
            float Zr = 0.825211f;
            float r = (float)R / 255.0f;
            float g = (float)G / 255.0f;
            float b = (float)B / 255.0f;
            r = (double)r <= 0.04045 ? (r /= 12.0f) : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
            g = (double)g <= 0.04045 ? (g /= 12.0f) : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
            b = (double)b <= 0.04045 ? (b /= 12.0f) : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
            float X = 0.43605202f * r + 0.3850816f * g + 0.14308742f * b;
            float Y = 0.22249159f * r + 0.71688604f * g + 0.060621485f * b;
            float Z = 0.013929122f * r + 0.097097f * g + 0.7141855f * b;
            float xr = X / Xr;
            float yr = Y / Yr;
            float zr = Z / Zr;
            float fx = xr > eps ? (float)Math.pow(xr, 0.3333333333333333) : (float)(((double)(k * xr) + 16.0) / 116.0);
            float fy = yr > eps ? (float)Math.pow(yr, 0.3333333333333333) : (float)(((double)(k * yr) + 16.0) / 116.0);
            float fz = zr > eps ? (float)Math.pow(zr, 0.3333333333333333) : (float)(((double)(k * zr) + 16.0) / 116.0);
            float Ls = 116.0f * fy - 16.0f;
            float as = 500.0f * (fx - fy);
            float bs = 200.0f * (fy - fz);
            lab[2] = (int)(2.55 * (double)Ls + 0.5);
            lab[0] = (int)((double)as + 0.5);
            lab[1] = (int)((double)bs + 0.5);
        }

        public void rgb2lab(int R, int G, int B, int[] lab) {
            double eps = 0.008856451679035631;
            double k = 903.2962962962963;
            double divXr = 1.0371066384158818;
            double divZr = 1.2118112822053995;
            double divmax = 0.00392156862745098;
            double div116 = 0.008620689655172414;
            double r = (double)R * divmax;
            double g = (double)G * divmax;
            double b = (double)B * divmax;
            r = r <= 0.04045 ? (r /= 12.92) : (double)((float)Math.pow((r + 0.055) / 1.055, 2.4));
            g = g <= 0.04045 ? (g /= 12.92) : (double)((float)Math.pow((g + 0.055) / 1.055, 2.4));
            b = b <= 0.04045 ? (b /= 12.92) : (double)((float)Math.pow((b + 0.055) / 1.055, 2.4));
            double X = 0.43605202436447144 * r + (double)0.3850816f * g + 0.14308741688728333 * b;
            double Y = 0.22249159216880798 * r + 0.716886043548584 * g + 0.060621485114097595 * b;
            double Z = 0.013929122127592564 * r + (double)0.097097f * g + 0.7141854763031006 * b;
            double xr = X * divXr;
            double yr = Y;
            double zr = Z * divZr;
            double fx = xr > eps ? Math.pow(xr, 0.3333333333333333) : (k * xr + 16.0) * div116;
            double fy = yr > eps ? Math.pow(yr, 0.3333333333333333) : (k * yr + 16.0) * div116;
            double fz = zr > eps ? Math.pow(zr, 0.3333333333333333) : (k * zr + 16.0) * div116;
            double Ls = 116.0 * fy - 16.0;
            double as = 500.0 * (fx - fy);
            double bs = 200.0 * (fy - fz);
            lab[2] = (int)(2.55 * Ls + 0.5);
            lab[0] = (int)(as + 0.5);
            lab[1] = (int)(bs + 0.5);
        }

        private void lab2rgb(int[] vec, int[] rgb) {
            double d;
            double d2;
            double eps = 0.008856451679035631;
            double k = 903.2962962962963;
            double keps = 8.0;
            double f1 = 0.39215686274509803;
            double Xr = 0.964221;
            double Zr = 0.825211;
            double div2p4 = 0.4166666666666667;
            double div116 = 0.008620689655172414;
            double div200 = 0.005;
            double div500 = 0.002;
            double divk = 0.0011070564598794539;
            double dmax = 255.0;
            double L = (double)vec[2] * 0.39215686274509803;
            double a_ = vec[0];
            double b_ = vec[1];
            double yr = L > 8.0 ? Math.pow((L + 16.0) * 0.008620689655172414, 3.0) : L * 0.0011070564598794539;
            double fy = yr > 0.008856451679035631 ? (L + 16.0) * 0.008620689655172414 : (903.2962962962963 * yr + 16.0) * 0.008620689655172414;
            double fx = a_ * 0.002 + fy;
            double fz = fy - b_ * 0.005;
            double temp = Math.pow(fx, 3.0);
            double xr = d2 > 0.008856451679035631 ? temp : (116.0 * fx - 16.0) * 0.0011070564598794539;
            temp = Math.pow(fz, 3.0);
            double zr = d > 0.008856451679035631 ? temp : (116.0 * fz - 16.0) * 0.0011070564598794539;
            double X = xr * 0.964221;
            double Y = yr;
            double Z = zr * 0.825211;
            double r = 3.134051341 * X + -1.617027711 * Y + -0.49065221 * Z;
            double g = -0.97876273 * X + 1.916142228 * Y + 0.033449629 * Z;
            double b = 0.071942577 * X + -0.22897118 * Y + 1.405218305 * Z;
            r = r <= 0.0031308 ? (r *= 12.92) : Math.pow(1.055 * r, 0.4166666666666667) - 0.055;
            g = g <= 0.0031308 ? (g *= 12.92) : Math.pow(1.055 * g, 0.4166666666666667) - 0.055;
            b = b <= 0.0031308 ? (b *= 12.92) : Math.pow(1.055 * b, 0.4166666666666667) - 0.055;
            rgb[0] = (int)(255.0 * r + 0.5);
            rgb[1] = (int)(255.0 * g + 0.5);
            rgb[2] = (int)(255.0 * b + 0.5);
        }

        private void luv2rgb(int[] vec, int[] rgb) {
            double tL;
            double keps = 8.0;
            double Xr = 0.964221;
            double Zr = 0.825211;
            double f1 = 0.39215686274509803;
            double u0t13 = 13.0 * (4.0 * Xr / (Xr + 15.0 + 3.0 * Zr));
            double v0t13 = 13.0 * (9.0 / (Xr + 15.0 + 3.0 * Zr));
            double div3 = 0.3333333333333333;
            double div116 = 0.008620689655172414;
            double divk = 0.0011070564598794539;
            double div2p4 = 0.4166666666666667;
            double dmax = 255.0;
            double L = tL = (double)vec[2] * f1;
            double u = vec[0];
            double v = vec[1];
            double Y = tL > keps ? Math.pow((L + 16.0) * div116, 3.0) : L * divk;
            double a_ = div3 * (52.0 * L / (u + L * u0t13) - 1.0);
            double b_ = -5.0 * Y;
            double d_ = Y * (39.0 * L / (v + L * v0t13) - 5.0);
            double X = (d_ - b_) / (a_ + div3);
            double Z = X * a_ + b_;
            double r = 3.134051341 * X + -1.617027711 * Y + -0.49065221 * Z;
            double g = -0.97876273 * X + 1.916142228 * Y + 0.033449629 * Z;
            double b = 0.071942577 * X + -0.22897118 * Y + 1.405218305 * Z;
            r = r <= 0.0031308 ? (r *= 12.92) : Math.pow(1.055 * r, div2p4) - 0.055;
            g = g <= 0.0031308 ? (g *= 12.92) : Math.pow(1.055 * g, div2p4) - 0.055;
            b = b <= 0.0031308 ? (b *= 12.92) : Math.pow(1.055 * b, div2p4) - 0.055;
            rgb[0] = (int)(Math.max(0.0, Math.min(255.0, dmax * r)) + 0.5);
            rgb[1] = (int)(Math.max(0.0, Math.min(255.0, dmax * g)) + 0.5);
            rgb[2] = (int)(Math.max(0.0, Math.min(255.0, dmax * b)) + 0.5);
        }

        private void rgb2luv(int[] rgb, ColHash cv) {
            this.rgb2luv(rgb[0], rgb[1], rgb[2], this.vec);
            cv.R = this.vec[0];
            cv.G = this.vec[1];
            cv.B = this.vec[2];
        }

        public void rgb2luv(int R, int G, int B, int[] luv) {
            double eps = 0.008856451679035631;
            double k = 903.2962962962963;
            double Xr = 0.964221;
            double Yr = 1.0;
            double Zr = 0.825211;
            double div12p92 = 0.07739938080495357;
            double div1p055 = 0.9478672985781991;
            double divmax = 0.00392156862745098;
            double r = (double)R * divmax;
            double g = (double)G * divmax;
            double b = (double)B * divmax;
            r = r <= 0.04045 ? (r *= div12p92) : (double)((float)Math.pow((r + 0.055) * div1p055, 2.4));
            g = g <= 0.04045 ? (g *= div12p92) : (double)((float)Math.pow((g + 0.055) * div1p055, 2.4));
            b = b <= 0.04045 ? (b *= div12p92) : (double)((float)Math.pow((b + 0.055) * div1p055, 2.4));
            double X = 0.43605202436447144 * r + (double)0.3850816f * g + 0.14308741688728333 * b;
            double Y = 0.22249159216880798 * r + 0.716886043548584 * g + 0.060621485114097595 * b;
            double Z = 0.013929122127592564 * r + (double)0.097097f * g + 0.7141854763031006 * b;
            double u_ = 4.0 * X / (X + 15.0 * Y + 3.0 * Z);
            double v_ = 9.0 * Y / (X + 15.0 * Y + 3.0 * Z);
            double ur_ = 4.0 * Xr / (Xr + 15.0 * Yr + 3.0 * Zr);
            double vr_ = 9.0 * Yr / (Xr + 15.0 * Yr + 3.0 * Zr);
            double yr = Y / Yr;
            double L = yr > eps ? (double)((float)(116.0 * Math.pow(yr, 0.3333333333333333) - 16.0)) : k * yr;
            double u = 13.0 * L * (u_ - ur_);
            double v = 13.0 * L * (v_ - vr_);
            luv[2] = (int)(2.55 * L + 0.5);
            luv[0] = (int)(u + 0.5);
            luv[1] = (int)(v + 0.5);
        }

        public synchronized void computeColorSpaceCoordinates() {
            int[] rgb = new int[]{0, 0, 0};
            if (Color_Inspector_3D.this.colorSpace == 13 && Color_Inspector_3D.this.kltColor == null) {
                Color_Inspector_3D.this.kltColor = new ColorKLT(((Color_Inspector_3D)Color_Inspector_3D.this).pic1.pixels);
                Color_Inspector_3D.access$8802(Color_Inspector_3D.this, ((Color_Inspector_3D)Color_Inspector_3D.this).kltColor.klt.m);
                Color_Inspector_3D.access$8902(Color_Inspector_3D.this, ((Color_Inspector_3D)Color_Inspector_3D.this).kltColor.mean);
            }
            block16: for (int i = 0; i < Color_Inspector_3D.this.colHash.length; ++i) {
                ColHash cv = Color_Inspector_3D.this.colHash[i];
                if (cv == null) continue;
                int c = cv.color;
                rgb[0] = c >> 16 & 0xFF;
                rgb[1] = c >> 8 & 0xFF;
                rgb[2] = c & 0xFF;
                switch (Color_Inspector_3D.this.colorSpace) {
                    case 0: {
                        cv.R = rgb[0] - 128;
                        cv.G = rgb[1] - 128;
                        cv.B = rgb[2] - 128;
                        continue block16;
                    }
                    case 13: {
                        this.rgb2klt(rgb, cv);
                        continue block16;
                    }
                    case 1: {
                        this.rgb2yuv(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 2: {
                        this.rgb2ycbcr(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 4: {
                        this.rgb2ycgco(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 3: {
                        this.rgb2yiq(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 5: {
                        this.rgb2hsb(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 6: {
                        this.rgb2hsv(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 7: {
                        this.rgb2hsl(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 8: {
                        this.rgb2hmmd(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 9: {
                        this.rgb2lab(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 10: {
                        this.rgb2luv(rgb, cv);
                        cv.B -= 128;
                        continue block16;
                    }
                    case 11: {
                        this.rgb2xyy(rgb, cv);
                        cv.R -= 128;
                        cv.G -= 128;
                        cv.B -= 128;
                        continue block16;
                    }
                    case 12: {
                        this.rgb2xyz(rgb, cv);
                        cv.R -= 128;
                        cv.G -= 128;
                        cv.B -= 128;
                    }
                }
            }
        }

        public synchronized void convertPixelColors(int[] pixelsSrc, int[] pixelsDst) {
            int[] rgb = new int[]{0, 0, 0};
            int[] vec = new int[]{0, 0, 0};
            if (Color_Inspector_3D.this.colorSpace == 13 && Color_Inspector_3D.this.kltColor == null) {
                Color_Inspector_3D.this.kltColor = new ColorKLT(((Color_Inspector_3D)Color_Inspector_3D.this).pic1.pixels);
                Color_Inspector_3D.access$8802(Color_Inspector_3D.this, ((Color_Inspector_3D)Color_Inspector_3D.this).kltColor.klt.m);
                Color_Inspector_3D.access$8902(Color_Inspector_3D.this, ((Color_Inspector_3D)Color_Inspector_3D.this).kltColor.mean);
            }
            for (int i = 0; i < this.pixels.length; ++i) {
                int c = pixelsSrc[i];
                if ((c & 0xFF000000) == -16777216) {
                    rgb[0] = c >> 16 & 0xFF;
                    rgb[1] = c >> 8 & 0xFF;
                    rgb[2] = c & 0xFF;
                    switch (Color_Inspector_3D.this.colorSpace) {
                        case 0: {
                            vec[0] = rgb[0];
                            vec[1] = rgb[1];
                            vec[2] = rgb[2];
                            break;
                        }
                        case 1: {
                            this.rgb2yuv(rgb, vec);
                            vec[0] = vec[0] + 128;
                            vec[1] = vec[1] + 128;
                            break;
                        }
                        case 13: {
                            this.rgb2klt(rgb, vec);
                            vec[0] = vec[0] + 128;
                            vec[1] = vec[1] + 128;
                            vec[2] = vec[2] + 128;
                            break;
                        }
                        case 2: {
                            this.rgb2ycbcr(rgb, vec);
                            vec[0] = vec[0] + 128;
                            vec[1] = vec[1] + 128;
                            break;
                        }
                        case 4: {
                            this.rgb2ycgco(rgb, vec);
                            vec[0] = vec[0] + 128;
                            vec[1] = vec[1] + 128;
                            break;
                        }
                        case 3: {
                            this.rgb2yiq(rgb, vec);
                            vec[0] = vec[0] + 128;
                            vec[1] = vec[1] + 128;
                            break;
                        }
                        case 5: {
                            this.rgb2hsb(rgb, vec);
                            break;
                        }
                        case 6: {
                            this.rgb2hsv(rgb, vec);
                            break;
                        }
                        case 7: {
                            this.rgb2hsl(rgb, vec);
                            break;
                        }
                        case 8: {
                            break;
                        }
                        case 9: {
                            this.rgb2lab(rgb, vec);
                            vec[0] = vec[0] + 128;
                            vec[1] = vec[1] + 128;
                            break;
                        }
                        case 10: {
                            this.rgb2luv(rgb, vec);
                            vec[0] = vec[0] + 128;
                            vec[1] = vec[1] + 128;
                        }
                    }
                    int r = vec[0];
                    int g = vec[1];
                    int b = vec[2];
                    int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                    int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                    b = b > 255 ? 255 : (b < 0 ? 0 : b);
                    pixelsDst[i] = 0xFF000000 | r << 16 | g << 8 | b;
                    continue;
                }
                pixelsDst[i] = c;
            }
        }

        public synchronized void convertColor(int c, int[] vec) {
            int[] rgb = new int[]{0, 0, 0};
            ColHash cv = new ColHash();
            rgb[0] = c >> 16 & 0xFF;
            rgb[1] = c >> 8 & 0xFF;
            rgb[2] = c & 0xFF;
            switch (Color_Inspector_3D.this.colorSpace) {
                case 0: {
                    cv.R = rgb[0];
                    cv.G = rgb[1];
                    cv.B = rgb[2];
                    break;
                }
                case 1: {
                    this.rgb2yuv(rgb, cv);
                    break;
                }
                case 13: {
                    this.rgb2klt(rgb, cv);
                    break;
                }
                case 2: {
                    this.rgb2ycbcr(rgb, cv);
                    break;
                }
                case 4: {
                    this.rgb2ycgco(rgb, cv);
                    break;
                }
                case 3: {
                    this.rgb2yiq(rgb, cv);
                    break;
                }
                case 5: {
                    this.rgb2hsb_(rgb, cv);
                    break;
                }
                case 6: {
                    this.rgb2hsv(rgb, cv);
                    break;
                }
                case 7: {
                    this.rgb2hsl(rgb, cv);
                    break;
                }
                case 8: {
                    this.rgb2hmmd(rgb, cv);
                    break;
                }
                case 9: {
                    this.rgb2lab(rgb, cv);
                    break;
                }
                case 10: {
                    this.rgb2luv(rgb, cv);
                    break;
                }
                case 11: {
                    this.rgb2xyy(rgb, cv);
                    break;
                }
                case 12: {
                    this.rgb2xyz(rgb, cv);
                }
            }
            vec[0] = cv.R;
            vec[1] = cv.G;
            vec[2] = cv.B;
        }

        public synchronized void convertPixelColorsBack(int[] pixelsSrc, int[] pixelsDst) {
            int[] rgb = new int[]{0, 0, 0};
            int[] vec = new int[]{0, 0, 0};
            if (Color_Inspector_3D.this.colorSpace == 13 && Color_Inspector_3D.this.kltColor == null) {
                Color_Inspector_3D.this.kltColor = new ColorKLT(((Color_Inspector_3D)Color_Inspector_3D.this).pic1.pixels);
                Color_Inspector_3D.access$8802(Color_Inspector_3D.this, ((Color_Inspector_3D)Color_Inspector_3D.this).kltColor.klt.m);
                Color_Inspector_3D.access$8902(Color_Inspector_3D.this, ((Color_Inspector_3D)Color_Inspector_3D.this).kltColor.mean);
            }
            for (int i = 0; i < this.pixels.length; ++i) {
                int c = pixelsSrc[i];
                if ((c & 0xFF000000) != -16777216) continue;
                vec[0] = c >> 16 & 0xFF;
                vec[1] = c >> 8 & 0xFF;
                vec[2] = c & 0xFF;
                switch (Color_Inspector_3D.this.colorSpace) {
                    case 0: {
                        rgb[0] = vec[0];
                        rgb[1] = vec[1];
                        rgb[2] = vec[2];
                        break;
                    }
                    case 1: {
                        vec[0] = vec[0] - 128;
                        vec[1] = vec[1] - 128;
                        this.yuv2rgb(vec, rgb);
                        break;
                    }
                    case 13: {
                        vec[0] = vec[0] - 128;
                        vec[1] = vec[1] - 128;
                        vec[2] = vec[2] - 128;
                        this.klt2rgb(vec, rgb);
                        break;
                    }
                    case 2: {
                        vec[0] = vec[0] - 128;
                        vec[1] = vec[1] - 128;
                        this.ycbcr2rgb(vec, rgb);
                        break;
                    }
                    case 4: {
                        vec[0] = vec[0] - 128;
                        vec[1] = vec[1] - 128;
                        this.ycgco2rgb(vec, rgb);
                        break;
                    }
                    case 3: {
                        vec[0] = vec[0] - 128;
                        vec[1] = vec[1] - 128;
                        this.yiq2rgb(vec, rgb);
                        break;
                    }
                    case 9: {
                        vec[0] = vec[0] - 128;
                        vec[1] = vec[1] - 128;
                        this.lab2rgb(vec, rgb);
                        break;
                    }
                    case 10: {
                        vec[0] = vec[0] - 128;
                        vec[1] = vec[1] - 128;
                        this.luv2rgb(vec, rgb);
                    }
                }
                int r = rgb[0];
                int g = rgb[1];
                int b = rgb[2];
                int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                b = b > 255 ? 255 : (b < 0 ? 0 : b);
                pixelsDst[i] = 0xFF000000 | r << 16 | g << 8 | b;
            }
        }

        public synchronized void convertColorBack(int[] vec, int[] rgb) {
            switch (Color_Inspector_3D.this.colorSpace) {
                case 0: {
                    vec[0] = (int)((double)vec[0] * Color_Inspector_3D.this.channelFactor[0]);
                    vec[1] = (int)((double)vec[1] * Color_Inspector_3D.this.channelFactor[1]);
                    vec[2] = (int)((double)vec[2] * Color_Inspector_3D.this.channelFactor[2]);
                    rgb[0] = vec[0];
                    rgb[1] = vec[1];
                    rgb[2] = vec[2];
                    break;
                }
                case 1: {
                    vec[0] = (int)((double)vec[0] * Color_Inspector_3D.this.channelFactor[1]);
                    vec[1] = (int)((double)vec[1] * Color_Inspector_3D.this.channelFactor[2]);
                    vec[2] = (int)((double)(vec[2] - 128) * Color_Inspector_3D.this.channelFactor[0] + 128.0);
                    this.yuv2rgb(vec, rgb);
                    break;
                }
                case 13: {
                    vec[0] = (int)((double)vec[0] * Color_Inspector_3D.this.channelFactor[1]);
                    vec[1] = (int)((double)vec[1] * Color_Inspector_3D.this.channelFactor[2]);
                    vec[2] = (int)((double)vec[2] * Color_Inspector_3D.this.channelFactor[0]);
                    this.klt2rgb(vec, rgb);
                    break;
                }
                case 2: {
                    vec[0] = (int)((double)vec[0] * Color_Inspector_3D.this.channelFactor[1]);
                    vec[1] = (int)((double)vec[1] * Color_Inspector_3D.this.channelFactor[2]);
                    vec[2] = (int)((double)(vec[2] - 128) * Color_Inspector_3D.this.channelFactor[0] + 128.0);
                    this.ycbcr2rgb(vec, rgb);
                    break;
                }
                case 4: {
                    vec[0] = (int)((double)vec[0] * Color_Inspector_3D.this.channelFactor[1]);
                    vec[1] = (int)((double)vec[1] * Color_Inspector_3D.this.channelFactor[2]);
                    vec[2] = (int)((double)(vec[2] - 128) * Color_Inspector_3D.this.channelFactor[0] + 128.0);
                    this.ycgco2rgb(vec, rgb);
                    break;
                }
                case 3: {
                    vec[0] = (int)((double)vec[0] * Color_Inspector_3D.this.channelFactor[1]);
                    vec[1] = (int)((double)vec[1] * Color_Inspector_3D.this.channelFactor[2]);
                    vec[2] = (int)((double)(vec[2] - 128) * Color_Inspector_3D.this.channelFactor[0] + 128.0);
                    this.yiq2rgb(vec, rgb);
                    break;
                }
                case 5: {
                    this.hsb2rgb_(vec, rgb);
                    break;
                }
                case 9: {
                    vec[0] = (int)((double)vec[0] * Color_Inspector_3D.this.channelFactor[1]);
                    vec[1] = (int)((double)vec[1] * Color_Inspector_3D.this.channelFactor[2]);
                    vec[2] = (int)((double)(vec[2] - 128) * Color_Inspector_3D.this.channelFactor[0] + 128.0);
                    this.lab2rgb(vec, rgb);
                    break;
                }
                case 10: {
                    vec[0] = (int)((double)vec[0] * Color_Inspector_3D.this.channelFactor[1]);
                    vec[1] = (int)((double)vec[1] * Color_Inspector_3D.this.channelFactor[2]);
                    vec[2] = (int)((double)(vec[2] - 128) * Color_Inspector_3D.this.channelFactor[0] + 128.0);
                    this.luv2rgb(vec, rgb);
                }
            }
        }

        public synchronized void checkDepth(boolean isOrig) {
            if (isOrig) {
                for (int i = 0; i < this.pixelsOverlay.length; ++i) {
                    this.pixelsOverlay[i] = 0;
                }
            } else {
                for (int i = 0; i < this.pixels.length; ++i) {
                    int c = this.pixels[i];
                    if ((c & 0xFF000000) != -16777216) continue;
                    int hash = (c & 0xFFFFFF) * 13 % Color_Inspector_3D.this.hashSize;
                    while (Color_Inspector_3D.this.colHash[hash] != null && ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].color != c) {
                        hash = (hash + 101) % Color_Inspector_3D.this.hashSize;
                    }
                    try {
                        this.R = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].R;
                        this.G = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].G;
                        this.B = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].B;
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                    this.xyzPosC();
                    this.pixelsOverlay[i] = this.Z >= Color_Inspector_3D.this.renderDepth ? Color_Inspector_3D.this.depthColorFar : Color_Inspector_3D.this.depthColorNear;
                }
            }
            this.image = Toolkit.getDefaultToolkit().createImage(this.memoryOverlayImageSource);
            this.imageRegion.setOverlayImage(this.image);
        }

        public synchronized void quantizeMedianCut(int numCols) {
            int[] pixelsTmp = new int[this.width * this.height];
            int cs = Color_Inspector_3D.this.colorSpace;
            if (cs != 5 && cs != 6 && cs != 7 && cs != 8 && cs != 11 && cs != 12) {
                this.convertPixelColors(this.pixels, pixelsTmp);
            } else {
                for (int i = 0; i < this.pixels.length; ++i) {
                    pixelsTmp[i] = this.pixels[i];
                }
            }
            Median_Cut mc = new Median_Cut(pixelsTmp, this.width, this.height);
            Image image = mc.convert(numCols);
            PixelGrabber pg = new PixelGrabber(image, 0, 0, this.width, this.height, pixelsTmp, 0, this.width);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (cs != 5 && cs != 6 && cs != 7 && cs != 8 && cs != 11 && cs != 12) {
                this.convertPixelColorsBack(pixelsTmp, this.pixels);
            } else {
                for (int i = 0; i < this.pixels.length; ++i) {
                    this.pixels[i] = pixelsTmp[i];
                }
            }
            for (int i = 0; i < this.pixels.length; ++i) {
                int c = this.pixelsOrig[i];
                if ((c & 0xFF000000) != -16777216) {
                    this.pixels[i] = this.pixelsOrig[i];
                    continue;
                }
                c = this.pixels[i];
            }
        }

        public synchronized void wu_quant(int numCols) {
            int i;
            int[] pixelsTmp = new int[this.width * this.height];
            int cs = Color_Inspector_3D.this.colorSpace;
            if (cs != 5 && cs != 6 && cs != 7 && cs != 8 && cs != 11 && cs != 12) {
                this.convertPixelColors(this.pixels, pixelsTmp);
            } else {
                for (int i2 = 0; i2 < this.pixels.length; ++i2) {
                    pixelsTmp[i2] = this.pixels[i2];
                }
            }
            WuCq wq = new WuCq(pixelsTmp, this.width * this.height, numCols);
            wq.main_();
            if (cs != 5 && cs != 6 && cs != 7 && cs != 8 && cs != 11 && cs != 12) {
                this.convertPixelColorsBack(pixelsTmp, this.pixels);
            } else {
                for (i = 0; i < this.pixels.length; ++i) {
                    this.pixels[i] = pixelsTmp[i];
                }
            }
            for (i = 0; i < this.pixels.length; ++i) {
                int c = this.pixelsOrig[i];
                if ((c & 0xFF000000) == -16777216) continue;
                this.pixels[i] = c;
            }
        }

        public void copyOrigPixels() {
            for (int i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = this.pixelsOrig[i];
            }
        }

        public synchronized void quantize() {
            this.changeColorHSB();
            this.selectChannels();
            if (Color_Inspector_3D.this.numberOfColorsOrig > 256) {
                int i;
                int[] pixelsTmp = new int[this.width * this.height];
                int cs = Color_Inspector_3D.this.colorSpace;
                if (cs != 5 && cs != 6 && cs != 7 && cs != 8 && cs != 11 && cs != 12) {
                    this.convertPixelColors(this.pixels, pixelsTmp);
                } else {
                    for (i = 0; i < this.pixels.length; ++i) {
                        pixelsTmp[i] = this.pixels[i];
                    }
                }
                for (i = 0; i < pixelsTmp.length; ++i) {
                    int c = pixelsTmp[i];
                    if ((c & 0xFF000000) == -16777216) {
                        int rq = this.quant(c >> 16 & 0xFF);
                        int gq = this.quant(c >> 8 & 0xFF);
                        int bq = this.quant(c & 0xFF);
                        c = 0xFF000000 | rq << 16 | gq << 8 | bq;
                    }
                    pixelsTmp[i] = c;
                }
                if (cs != 5 && cs != 6 && cs != 7 && cs != 8 && cs != 11 && cs != 12) {
                    this.convertPixelColorsBack(pixelsTmp, this.pixels);
                } else {
                    for (i = 0; i < this.pixels.length; ++i) {
                        this.pixels[i] = pixelsTmp[i];
                    }
                }
            }
        }

        synchronized void selectChannels() {
            if (Color_Inspector_3D.this.channelFactor[0] == 1.0 && Color_Inspector_3D.this.channelFactor[1] == 1.0 && Color_Inspector_3D.this.channelFactor[2] == 1.0) {
                return;
            }
            int[] vec = new int[3];
            int[] rgb = new int[3];
            for (int i = 0; i < this.pixels.length; ++i) {
                int c = this.pixels[i];
                if ((c & 0xFF000000) != -16777216) continue;
                this.convertColor(c, vec);
                this.convertColorBack(vec, rgb);
                int r = rgb[0];
                int g = rgb[1];
                int b = rgb[2];
                int n = r > 255 ? 255 : (r = r < 0 ? 0 : r);
                int n2 = g > 255 ? 255 : (g = g < 0 ? 0 : g);
                b = b > 255 ? 255 : (b < 0 ? 0 : b);
                this.pixels[i] = c = 0xFF000000 | r << 16 | g << 8 | b;
            }
            this.image = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
            this.imageRegion.setImage(this.image);
        }

        public void changeColorHSB() {
            Color_Inspector_3D.this.pause = true;
            float d255 = 0.003921569f;
            float d6 = 0.16666667f;
            float d3 = 0.33333334f;
            float d2 = 0.5f;
            for (int i = 0; i < this.pixels.length; ++i) {
                int c = this.pixelsOrig[i];
                if ((c & 0xFF000000) == -16777216) {
                    int r = c >> 16 & 0xFF;
                    int g = c >> 8 & 0xFF;
                    int b = c & 0xFF;
                    if (Color_Inspector_3D.this.contrast != 1.0f) {
                        r = (int)(Color_Inspector_3D.this.contrast * (float)(r - 127) + 127.0f);
                        g = (int)(Color_Inspector_3D.this.contrast * (float)(g - 127) + 127.0f);
                        b = (int)(Color_Inspector_3D.this.contrast * (float)(b - 127) + 127.0f);
                        if (r > 255) {
                            r = 255;
                        }
                        if (r < 0) {
                            r = 0;
                        }
                        if (g > 255) {
                            g = 255;
                        }
                        if (g < 0) {
                            g = 0;
                        }
                        if (b > 255) {
                            b = 255;
                        }
                        if (b < 0) {
                            b = 0;
                        }
                    }
                    if (Color_Inspector_3D.this.brightness != 0) {
                        g += Color_Inspector_3D.this.brightness;
                        b += Color_Inspector_3D.this.brightness;
                        if ((r += Color_Inspector_3D.this.brightness) > 255) {
                            r = 255;
                        }
                        if (r < 0) {
                            r = 0;
                        }
                        if (g > 255) {
                            g = 255;
                        }
                        if (g < 0) {
                            g = 0;
                        }
                        if (b > 255) {
                            b = 255;
                        }
                        if (b < 0) {
                            b = 0;
                        }
                    }
                    if (Color_Inspector_3D.this.hueChange != 0.0f || Color_Inspector_3D.this.saturation != 1.0f) {
                        float S;
                        float var_Max;
                        float var_Min;
                        float rf = (float)r * d255;
                        float gf = (float)g * d255;
                        float bf = (float)b * d255;
                        if (rf > gf) {
                            var_Min = gf;
                            var_Max = rf;
                        } else {
                            var_Min = rf;
                            var_Max = gf;
                        }
                        if (bf > var_Max) {
                            var_Max = bf;
                        }
                        if (bf < var_Min) {
                            var_Min = bf;
                        }
                        float del_Max = var_Max - var_Min;
                        float H = 0.0f;
                        float L = (var_Max + var_Min) * d2;
                        if (del_Max == 0.0f) {
                            H = 0.0f;
                            S = 0.0f;
                        } else {
                            float del_R;
                            float del_B;
                            S = (double)L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
                            if (rf == var_Max) {
                                float del_G = ((var_Max - gf) * d6 + del_Max * d2) / del_Max;
                                del_B = ((var_Max - bf) * d6 + del_Max * d2) / del_Max;
                                H = del_B - del_G;
                            } else if (gf == var_Max) {
                                del_R = ((var_Max - rf) * d6 + del_Max * d2) / del_Max;
                                del_B = ((var_Max - bf) * d6 + del_Max * d2) / del_Max;
                                H = d3 + del_R - del_B;
                            } else if (bf == var_Max) {
                                del_R = ((var_Max - rf) * d6 + del_Max * d2) / del_Max;
                                float del_G = ((var_Max - gf) * d6 + del_Max * d2) / del_Max;
                                H = 2.0f * d3 + del_G - del_R;
                            }
                        }
                        H += Color_Inspector_3D.this.hueChange;
                        if (H < 0.0f) {
                            H += 1.0f;
                        }
                        if (H > 1.0f) {
                            H -= 1.0f;
                        }
                        if (S == 0.0f) {
                            r = (int)(L * 255.0f);
                            g = (int)(L * 255.0f);
                            b = (int)(L * 255.0f);
                        } else {
                            float var_2 = (double)L < 0.5 ? L * (1.0f + S) : L + (S *= Color_Inspector_3D.this.saturation) - S * L;
                            float var_1 = 2.0f * L - var_2;
                            r = (int)(255.0f * this.Hue_2_RGB(var_1, var_2, H + d3));
                            g = (int)(255.0f * this.Hue_2_RGB(var_1, var_2, H));
                            b = (int)(255.0f * this.Hue_2_RGB(var_1, var_2, H - d3));
                        }
                    }
                    if (r > 255) {
                        r = 255;
                    }
                    if (r < 0) {
                        r = 0;
                    }
                    if (g > 255) {
                        g = 255;
                    }
                    if (g < 0) {
                        g = 0;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    if (b < 0) {
                        b = 0;
                    }
                    c = 0xFF000000 | r << 16 | g << 8 | b;
                }
                this.pixels[i] = c;
            }
            this.image = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
            this.imageRegion.setImage(this.image);
            Color_Inspector_3D.this.pause = false;
        }

        void HSLtoRGB(float H, float S, float L, int[] RGB) {
            if (S == 0.0f) {
                RGB[0] = (int)(L * 255.0f);
                RGB[1] = (int)(L * 255.0f);
                RGB[2] = (int)(L * 255.0f);
            } else {
                float var_2 = (double)L < 0.5 ? L * (1.0f + S) : L + S - S * L;
                float var_1 = 2.0f * L - var_2;
                RGB[0] = (int)(255.0f * this.Hue_2_RGB(var_1, var_2, H + 0.33333334f));
                RGB[1] = (int)(255.0f * this.Hue_2_RGB(var_1, var_2, H));
                RGB[2] = (int)(255.0f * this.Hue_2_RGB(var_1, var_2, H - 0.33333334f));
            }
        }

        float Hue_2_RGB(float v1, float v2, float vH) {
            if (vH < 0.0f) {
                vH += 1.0f;
            }
            if (vH > 1.0f) {
                vH -= 1.0f;
            }
            if (6.0f * vH < 1.0f) {
                return v1 + (v2 - v1) * 6.0f * vH;
            }
            if (2.0f * vH < 1.0f) {
                return v2;
            }
            if (3.0f * vH < 2.0f) {
                return v1 + (v2 - v1) * (0.6666667f - vH) * 6.0f;
            }
            return v1;
        }

        public synchronized void findUniqueColors() {
            Color_Inspector_3D.this.hashSize = 5 * Color_Inspector_3D.this.maskSize / 3 + 1;
            if (Color_Inspector_3D.this.hashSize % 101 == 0) {
                Color_Inspector_3D.this.hashSize++;
            }
            Color_Inspector_3D.this.numberOfColors = 0;
            Color_Inspector_3D.access$6802(Color_Inspector_3D.this, new ColHash[Color_Inspector_3D.this.hashSize]);
            for (int i = 0; i < this.pixels.length; ++i) {
                int c = this.pixels[i];
                if ((c & 0xFF000000) != -16777216) continue;
                int hash = (c & 0xFFFFFF) * 13 % Color_Inspector_3D.this.hashSize;
                while (Color_Inspector_3D.this.colHash[hash] != null && ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].color != c) {
                    hash = (hash + 101) % Color_Inspector_3D.this.hashSize;
                }
                if (Color_Inspector_3D.this.colHash[hash] == null) {
                    ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash] = new ColHash();
                    ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].color = c;
                    ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].R = (c >> 16 & 0xFF) - 128;
                    ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].G = (c >> 8 & 0xFF) - 128;
                    ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].B = (c & 0xFF) - 128;
                    Color_Inspector_3D.this.numberOfColors++;
                }
                ++((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].frequency;
            }
        }

        private int getFrequency(int c) {
            if ((c >> 24 & 0xFF) == 255) {
                int hash = (c & 0xFFFFFF) * 13 % Color_Inspector_3D.this.hashSize;
                while (Color_Inspector_3D.this.colHash[hash] != null && ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].color != c) {
                    hash = (hash + 101) % Color_Inspector_3D.this.hashSize;
                }
                return ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[hash].frequency;
            }
            return -1;
        }

        public int getColor(int x, int y) {
            int pos = y * this.width + x;
            if (pos >= 0 && pos < this.pixels.length) {
                return this.pixels[y * this.width + x];
            }
            return 0;
        }

        public String showColorDot(int c) {
            int r = c >> 16 & 0xFF;
            int g = c >> 8 & 0xFF;
            int b = c & 0xFF;
            String s = "      " + this.stringColor + ":  RGB(" + Misc.fm(3, r) + "," + Misc.fm(3, g) + "," + Misc.fm(3, b) + ")";
            int[] v = new int[4];
            switch (Color_Inspector_3D.this.colorSpace) {
                case 0: {
                    break;
                }
                case 1: {
                    this.rgb2yuv(r, g, b, v);
                    s = s + "  YUV(" + Misc.fm(3, v[2]) + "," + Misc.fm(4, v[0]) + "," + Misc.fm(4, v[1]) + ")";
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 3: {
                    this.rgb2yiq(r, g, b, v);
                    s = s + "  YIQ(" + Misc.fm(3, v[2]) + "," + Misc.fm(4, v[0]) + "," + Misc.fm(4, v[1]) + ")";
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 13: {
                    this.rgb2klt(r, g, b, v);
                    s = s + "  KLT(" + Misc.fm(3, v[2]) + "," + Misc.fm(4, v[0]) + "," + Misc.fm(4, v[1]) + ")";
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2] + 128;
                    break;
                }
                case 2: {
                    this.rgb2ycbcr(r, g, b, v);
                    s = s + "  YCbCr(" + Misc.fm(3, v[2]) + "," + Misc.fm(4, v[0]) + "," + Misc.fm(4, v[1]) + ")";
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 4: {
                    this.rgb2ycgco(r, g, b, v);
                    s = s + "  YCgCo(" + Misc.fm(3, v[2]) + "," + Misc.fm(4, v[0]) + "," + Misc.fm(4, v[1]) + ")";
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 5: {
                    this.rgb2hsb_(r, g, b, v);
                    s = s + "  HSB(" + Misc.fm(3, v[0]) + '\u00b0' + "," + Misc.fm(3, v[1]) + "%," + Misc.fm(3, v[2]) + "%)";
                    this.rgb2hsb(r, g, b, v);
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 6: {
                    this.rgb2hsv_(r, g, b, v);
                    s = s + "  HSV(" + Misc.fm(3, v[0]) + '\u00b0' + "," + Misc.fm(3, v[1]) + "%," + Misc.fm(3, v[2]) + "%)";
                    this.rgb2hsv(r, g, b, v);
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 7: {
                    this.rgb2hsl_(r, g, b, v);
                    s = s + "  HSL(" + Misc.fm(3, v[0]) + '\u00b0' + "," + Misc.fm(3, v[1]) + "%," + Misc.fm(3, v[2]) + "%)";
                    this.rgb2hsl(r, g, b, v);
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 8: {
                    this.rgb2hmmd_(r, g, b, v);
                    s = s + "  HMMD(" + Misc.fm(3, v[0]) + "," + Misc.fm(3, v[1]) + "," + Misc.fm(3, v[2]) + "," + Misc.fm(3, 2 * v[3]) + ")";
                    s = s + "  HSD(" + Misc.fm(3, v[0]) + "," + Misc.fm(3, (int)Math.round(((double)(v[1] + v[2]) + 0.5) / 2.0)) + "," + Misc.fm(3, 2 * v[3]) + ")";
                    this.rgb2hmmd(r, g, b, v);
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 9: {
                    this.rgb2lab(r, g, b, v);
                    s = s + "  Lab(" + Misc.fm(3, (int)((double)v[2] / 2.55 + 0.5)) + "," + Misc.fm(4, v[0]) + "," + Misc.fm(4, v[1]) + ")";
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 10: {
                    this.rgb2luv(r, g, b, v);
                    s = s + "  Luv(" + Misc.fm(3, (int)((double)v[2] / 2.55 + 0.5)) + "," + Misc.fm(4, v[0]) + "," + Misc.fm(4, v[1]) + ")";
                    r = v[0] + 128;
                    g = v[1] + 128;
                    b = v[2];
                    break;
                }
                case 11: {
                    this.rgb2xyy(r, g, b, v);
                    s = s + "  xyY(" + Misc.fm(5, (double)((int)((double)v[0] / 0.255)) / 1000.0) + "," + Misc.fm(5, (double)((int)((double)v[1] / 0.255)) / 1000.0) + "," + Misc.fm(5, (double)((int)(((double)v[2] + 0.5) / 0.255)) / 1000.0) + ")";
                    r = v[0];
                    g = v[1];
                    b = v[2];
                    break;
                }
                case 12: {
                    this.rgb2xyz(r, g, b, v);
                    s = s + "  XYZ(" + Misc.fm(5, (double)((int)((double)v[0] / 0.255)) / 1000.0) + "," + Misc.fm(5, (double)((int)((double)v[1] / 0.255)) / 1000.0) + "," + Misc.fm(5, (double)((int)(((double)v[2] + 0.5) / 0.255)) / 1000.0) + ")";
                    r = v[0];
                    g = v[1];
                    b = v[2];
                }
            }
            v = null;
            this.R = this.dotR = r - 128;
            this.G = this.dotG = g - 128;
            this.B = this.dotB = b - 128;
            this.xyzPos();
            this.imageRegion.setDot(this.X, this.Y);
            this.dot = true;
            int num = this.getFrequency(c);
            if (num >= 0) {
                int percent = 1000 * num / Color_Inspector_3D.this.maskSize;
                s = s + "      " + this.stringNumber + ": " + num + " (" + Misc.fm(3, (double)percent / 10.0) + "%)";
            } else {
                s = s + "  ---";
            }
            this.imageRegion.repaint();
            return s;
        }

        public void printLut() {
            if (Color_Inspector_3D.this.hist) {
                ResultsTable rt = new ResultsTable();
                for (int i = 0; i < Color_Inspector_3D.this.colHash.length; ++i) {
                    if (Color_Inspector_3D.this.colHash[i] == null) continue;
                    int c = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].color;
                    int frequency = this.getFrequency(c);
                    double percent = 0.0;
                    if (frequency >= 0 && (percent = 100.0 * (double)frequency / (double)Color_Inspector_3D.this.maskSize) < 0.001) {
                        percent = 0.0;
                    }
                    String str = this.showColorDot(c);
                    Pattern p = Pattern.compile("-?\\d+");
                    Matcher m = p.matcher(str);
                    ArrayList<String> allMatches = new ArrayList<String>();
                    while (m.find()) {
                        allMatches.add(m.group());
                    }
                    int offset = allMatches.size() > 6 ? 3 : 0;
                    rt.incrementCounter();
                    rt.addValue(stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][0], (String)allMatches.get(offset));
                    rt.addValue(stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][1], (String)allMatches.get(offset + 1));
                    rt.addValue(stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][2], (String)allMatches.get(offset + 2));
                    if (Color_Inspector_3D.this.english) {
                        rt.addValue("Frequency", (double)frequency);
                    } else {
                        rt.addValue("Anzahl", (double)frequency);
                    }
                    rt.addValue("%", percent);
                }
                rt.show("LUT");
            }
        }

        public synchronized void updateDisplay() {
            try {
                if (!Color_Inspector_3D.this.hist) {
                    switch (Color_Inspector_3D.this.mode) {
                        case 0: {
                            this.showColorsNoAlpha();
                            break;
                        }
                        case 1: {
                            this.showNoColorsNoAlpha();
                            break;
                        }
                        case 2: {
                            this.showColorsAlpha();
                            break;
                        }
                        case 3: {
                            this.showNoColorsAlpha();
                        }
                    }
                } else {
                    this.showColorsHist();
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            Image image = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
            this.imageRegion.setImage(image, this.pixelsZ);
        }

        boolean isInside(int[] p, int[] p1, int[] p2, int[] p3) {
            int x = p[0];
            int y = p[1];
            int x1 = p1[0];
            int y1 = p1[1];
            int x2 = p2[0];
            int y2 = p2[1];
            int x3 = p3[0];
            int y3 = p3[1];
            int a = (x2 - x1) * (y - y1) - (y2 - y1) * (x - x1);
            int b = (x3 - x2) * (y - y2) - (y3 - y2) * (x - x2);
            int c = (x1 - x3) * (y - y3) - (y1 - y3) * (x - x3);
            return a >= 0 && b >= 0 && c >= 0 || a <= 0 && b <= 0 && c <= 0;
        }

        private void setTextAndCube() {
            block30: {
                int z2;
                int y2;
                int x2;
                int z1;
                int y1;
                int x1;
                Color color;
                int i;
                int line;
                block35: {
                    int y2u;
                    int x2u;
                    int z1u;
                    int y1u;
                    int x1u;
                    int step;
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    int j;
                                    int i2;
                                    block29: {
                                        int k;
                                        for (int i3 = 0; i3 < this.textPositions[0].length; ++i3) {
                                            this.xyzPos(this.textPositions[Color_Inspector_3D.this.colorSpace][i3]);
                                            this.imageRegion.setTextPos(i3, this.X, this.Y, this.Z);
                                        }
                                        line = 0;
                                        if (Color_Inspector_3D.this.colorSpace == 9 || Color_Inspector_3D.this.colorSpace == 10) {
                                            for (i = 0; i < 3; ++i) {
                                                color = i == 0 ? this.cubeFrontColor : ((Color_Inspector_3D.this.mode & 1) == 0 ? Color.orange : Color.red);
                                                this.xyzPos(this.lineEndsLAB[i]);
                                                x1 = this.X;
                                                y1 = this.Y;
                                                z1 = this.Z;
                                                this.xyzPos(this.lineEndsLAB[i + 3]);
                                                x2 = this.X;
                                                y2 = this.Y;
                                                z2 = this.Z;
                                                this.imageRegion.setLine(line++, x1, y1, x2, y2, z1, z2, color);
                                            }
                                        }
                                        if (Color_Inspector_3D.this.colorSpace != 0 && Color_Inspector_3D.this.colorSpace != 9 && Color_Inspector_3D.this.colorSpace != 11 && Color_Inspector_3D.this.colorSpace != 10 && Color_Inspector_3D.this.colorSpace != 12) break block29;
                                        int[][] corner = new int[8][4];
                                        for (int i4 = 0; i4 < 8; ++i4) {
                                            this.xyzPos(this.cubeCornersRGB[i4]);
                                            corner[i4][0] = this.X;
                                            corner[i4][1] = this.Y;
                                            corner[i4][2] = this.Z;
                                        }
                                        Object cor = new int[3][];
                                        for (i2 = 0; i2 < 4; ++i2) {
                                            k = 0;
                                            for (int j2 = 4; j2 < 8; ++j2) {
                                                if (i2 + j2 == 7) continue;
                                                cor[k++] = corner[j2];
                                            }
                                            if (corner[i2][2] < corner[7 - i2][2] || !this.isInside(corner[i2], cor[0], cor[1], cor[2])) continue;
                                            corner[i2][3] = 1;
                                        }
                                        for (int j3 = 4; j3 < 8; ++j3) {
                                            k = 0;
                                            for (int i5 = 0; i5 < 4; ++i5) {
                                                if (i5 + j3 == 7) continue;
                                                cor[k++] = corner[i5];
                                            }
                                            if (corner[j3][2] < corner[7 - j3][2] || !this.isInside(corner[j3], cor[0], cor[1], cor[2])) continue;
                                            corner[j3][3] = 1;
                                        }
                                        for (i2 = 0; i2 < 4; ++i2) {
                                            for (j = 4; j < 8; ++j) {
                                                if (i2 + j == 7) continue;
                                                Color color2 = corner[i2][3] == 1 || corner[j][3] == 1 ? this.cubeBackColor : this.cubeFrontColor;
                                                this.imageRegion.setLine(line++, corner[i2][0], corner[i2][1], corner[j][0], corner[j][1], corner[i2][2], corner[j][2], color2);
                                            }
                                        }
                                        cor = null;
                                        corner = null;
                                        break block30;
                                    }
                                    if (Color_Inspector_3D.this.colorSpace != 2 && Color_Inspector_3D.this.colorSpace != 4 && Color_Inspector_3D.this.colorSpace != 1 && Color_Inspector_3D.this.colorSpace != 3) break block31;
                                    int[] yuv_i = new int[3];
                                    int[] yuv_j = new int[3];
                                    for (i2 = 0; i2 < 4; ++i2) {
                                        for (j = 4; j < 8; ++j) {
                                            if (i2 + j == 7) continue;
                                            Color color3 = Color.lightGray;
                                            if (Color_Inspector_3D.this.colorSpace == 2) {
                                                this.rgb2ycbcr(this.cubeCornersRGB[i2], yuv_i);
                                                this.rgb2ycbcr(this.cubeCornersRGB[j], yuv_j);
                                            } else if (Color_Inspector_3D.this.colorSpace == 4) {
                                                this.rgb2ycgco(this.cubeCornersRGB[i2], yuv_i);
                                                this.rgb2ycgco(this.cubeCornersRGB[j], yuv_j);
                                            } else if (Color_Inspector_3D.this.colorSpace == 1) {
                                                this.rgb2yuv(this.cubeCornersRGB[i2], yuv_i);
                                                this.rgb2yuv(this.cubeCornersRGB[j], yuv_j);
                                            } else if (Color_Inspector_3D.this.colorSpace == 3) {
                                                this.rgb2yiq(this.cubeCornersRGB[i2], yuv_i);
                                                this.rgb2yiq(this.cubeCornersRGB[j], yuv_j);
                                            }
                                            this.xyzPos(yuv_i);
                                            int x12 = this.X;
                                            int y12 = this.Y;
                                            int z12 = this.Z;
                                            this.xyzPos(yuv_j);
                                            int x22 = this.X;
                                            int y22 = this.Y;
                                            int z22 = this.Z;
                                            this.imageRegion.setLine(line++, x12, y12, x22, y22, z12, z22, color3);
                                        }
                                    }
                                    for (i2 = 0; i2 < 3; ++i2) {
                                        Color color4 = i2 == 0 ? this.cubeFrontColor : ((Color_Inspector_3D.this.mode & 1) == 0 ? Color.orange : Color.red);
                                        this.xyzPos(this.lineEndsYUV[i2]);
                                        int x13 = this.X;
                                        int y13 = this.Y;
                                        int z13 = this.Z;
                                        this.xyzPos(this.lineEndsYUV[i2 + 3]);
                                        int x23 = this.X;
                                        int y23 = this.Y;
                                        int z23 = this.Z;
                                        this.imageRegion.setLine(line++, x13, y13, x23, y23, z13, z23, color4);
                                    }
                                    yuv_i = null;
                                    yuv_j = null;
                                    break block30;
                                }
                                if (Color_Inspector_3D.this.colorSpace != 13) break block32;
                                for (i = 0; i < 3; ++i) {
                                    color = i == 0 ? this.cubeFrontColor : ((Color_Inspector_3D.this.mode & 1) == 0 ? Color.orange : Color.red);
                                    this.xyzPos(this.lineEndsKLT[i]);
                                    x1 = this.X;
                                    y1 = this.Y;
                                    z1 = this.Z;
                                    this.xyzPos(this.lineEndsKLT[i + 3]);
                                    x2 = this.X;
                                    y2 = this.Y;
                                    z2 = this.Z;
                                    this.imageRegion.setLine(line++, x1, y1, x2, y2, z1, z2, color);
                                }
                                break block30;
                            }
                            if (Color_Inspector_3D.this.colorSpace != 5 && Color_Inspector_3D.this.colorSpace != 7) break block33;
                            for (i = 0; i < 2; ++i) {
                                color = i == 0 ? this.cubeFrontColor : ((Color_Inspector_3D.this.mode & 1) == 0 ? Color.orange : Color.red);
                                this.xyzPos(this.lineEndsHSB[i]);
                                x1 = this.X;
                                y1 = this.Y;
                                z1 = this.Z;
                                this.xyzPos(this.lineEndsHSB[i + 2]);
                                x2 = this.X;
                                y2 = this.Y;
                                z2 = this.Z;
                                this.imageRegion.setLine(line++, x1, y1, x2, y2, z1, z2, color);
                            }
                            step = 15;
                            for (int i6 = 0; i6 < 360; i6 += step) {
                                float phi = (float)Math.toRadians(i6);
                                this.xyzPos((int)(128.0 * Math.cos(phi)), (int)(128.0 * Math.sin(phi)), 127);
                                x1u = this.X;
                                y1u = this.Y;
                                z1u = this.Z;
                                this.B = -128;
                                this.xyzPos();
                                int x1d = this.X;
                                int y1d = this.Y;
                                int z1d = this.Z;
                                phi = (float)Math.toRadians(i6 + step);
                                this.xyzPos((int)(128.0 * Math.cos(phi)), (int)(128.0 * Math.sin(phi)), 127);
                                int x2u2 = this.X;
                                int y2u2 = this.Y;
                                int z2u = this.Z;
                                this.B = -128;
                                this.xyzPos();
                                int x2d = this.X;
                                int y2d = this.Y;
                                int z2d = this.Z;
                                this.imageRegion.setLine(line++, x1u, y1u, x2u2, y2u2, z1u, z2u, this.cubeFrontColor);
                                this.imageRegion.setLine(line++, x1d, y1d, x2d, y2d, z1d, z2d, this.cubeFrontColor);
                                if (i6 % (2 * step) != step) continue;
                                this.B = 0;
                                this.xyzPos();
                                Color color5 = this.Z < 0 ? new Color(-4473925) : new Color(-10066330);
                                this.imageRegion.setLine(line++, x2u2, y2u2, x2d, y2d, this.Z, this.Z, color5);
                            }
                            break block30;
                        }
                        if (Color_Inspector_3D.this.colorSpace != 6) break block34;
                        for (i = 0; i < 2; ++i) {
                            color = i == 0 ? this.cubeFrontColor : ((Color_Inspector_3D.this.mode & 1) == 0 ? Color.orange : Color.red);
                            this.xyzPos(this.lineEndsHSV[i]);
                            x1 = this.X;
                            y1 = this.Y;
                            z1 = this.Z;
                            this.xyzPos(this.lineEndsHSV[i + 2]);
                            x2 = this.X;
                            y2 = this.Y;
                            z2 = this.Z;
                            this.imageRegion.setLine(line++, x1, y1, x2, y2, z1, z2, color);
                        }
                        step = 15;
                        for (int i7 = 0; i7 < 360; i7 += step) {
                            float phi = (float)Math.toRadians(i7);
                            this.xyzPos((int)(128.0 * Math.cos(phi)), (int)(128.0 * Math.sin(phi)), 127);
                            x1u = this.X;
                            y1u = this.Y;
                            z1u = this.Z;
                            this.B = -128;
                            this.xyzPos();
                            phi = (float)Math.toRadians(i7 + step);
                            this.xyzPos((int)(128.0 * Math.cos(phi)), (int)(128.0 * Math.sin(phi)), 127);
                            x2u = this.X;
                            y2u = this.Y;
                            int z2u = this.Z;
                            this.R = 0;
                            this.G = 0;
                            this.B = -128;
                            this.xyzPos();
                            int x2d = this.X;
                            int y2d = this.Y;
                            int z2d = this.Z;
                            this.imageRegion.setLine(line++, x1u, y1u, x2u, y2u, z1u, z2u, this.cubeFrontColor);
                            if (i7 % (2 * step) != step) continue;
                            this.B = 0;
                            this.xyzPos();
                            Color color6 = z2u < 0 ? new Color(-4473925) : new Color(-10066330);
                            this.imageRegion.setLine(line++, x2u, y2u, x2d, y2d, z2u, z2d, color6);
                        }
                        break block30;
                    }
                    if (Color_Inspector_3D.this.colorSpace != 14) break block35;
                    for (i = 0; i < 2; ++i) {
                        color = i == 0 ? this.cubeFrontColor : ((Color_Inspector_3D.this.mode & 1) == 0 ? Color.orange : Color.red);
                        this.xyzPos(this.lineEndsHSV[i]);
                        x1 = this.X;
                        y1 = this.Y;
                        z1 = this.Z;
                        this.xyzPos(this.lineEndsHSV[i + 2]);
                        x2 = this.X;
                        y2 = this.Y;
                        z2 = this.Z;
                        this.imageRegion.setLine(line++, x1, y1, x2, y2, z1, z2, color);
                    }
                    step = 15;
                    for (int i8 = 0; i8 < 360; i8 += step) {
                        float phi = (float)Math.toRadians(i8);
                        this.xyzPos((int)(128.0 * Math.cos(phi)), (int)(128.0 * Math.sin(phi)), 127);
                        x1u = this.X;
                        y1u = this.Y;
                        z1u = this.Z;
                        this.B = -128;
                        this.xyzPos();
                        phi = (float)Math.toRadians(i8 + step);
                        this.xyzPos((int)(128.0 * Math.cos(phi)), (int)(128.0 * Math.sin(phi)), 127);
                        x2u = this.X;
                        y2u = this.Y;
                        int z2u = this.Z;
                        this.R = 0;
                        this.G = 0;
                        this.B = -128;
                        this.xyzPos();
                        int x2d = this.X;
                        int y2d = this.Y;
                        int z2d = this.Z;
                        this.imageRegion.setLine(line++, x1u, y1u, x2u, y2u, z1u, z2u, this.cubeFrontColor);
                        if (i8 % (2 * step) != step) continue;
                        this.B = 0;
                        this.xyzPos();
                        Color color7 = z2u < 0 ? new Color(-4473925) : new Color(-10066330);
                        this.imageRegion.setLine(line++, x2u, y2u, x2d, y2d, z2u, z2d, color7);
                    }
                    break block30;
                }
                if (Color_Inspector_3D.this.colorSpace != 8) break block30;
                for (i = 0; i < 2; ++i) {
                    color = i == 0 ? this.cubeFrontColor : ((Color_Inspector_3D.this.mode & 1) == 0 ? Color.orange : Color.red);
                    this.xyzPos(this.lineEndsHMMD[i]);
                    x1 = this.X;
                    y1 = this.Y;
                    z1 = 1;
                    this.xyzPos(this.lineEndsHMMD[i + 2]);
                    x2 = this.X;
                    y2 = this.Y;
                    z2 = this.Z;
                    this.imageRegion.setLine(line++, x1, y1, x2, y2, z1, z2, color);
                }
                this.xyzPos(0, 0, 127);
                int x1u = this.X;
                int y1u = this.Y;
                this.xyzPos(0, 0, -128);
                int x1d = this.X;
                int y1d = this.Y;
                int step = 15;
                for (int i9 = 0; i9 < 360; i9 += step) {
                    float phi = (float)Math.toRadians(i9);
                    this.xyzPos((int)(128.0 * Math.cos(phi)), (int)(128.0 * Math.sin(phi)), 0);
                    int x14 = this.X;
                    int y14 = this.Y;
                    int z14 = this.Z;
                    phi = (float)Math.toRadians(i9 + step);
                    this.xyzPos((int)(128.0 * Math.cos(phi)), (int)(128.0 * Math.sin(phi)), 0);
                    int x24 = this.X;
                    int y24 = this.Y;
                    int z24 = this.Z;
                    this.imageRegion.setLine(line++, x14, y14, x24, y24, z14, z24, this.cubeFrontColor);
                    if (i9 % (2 * step) != step) continue;
                    this.B = 0;
                    this.xyzPos();
                    Color color8 = this.Z <= 0 ? new Color(-4473925) : new Color(-10066330);
                    this.imageRegion.setLine(line++, x1u, y1u, x14, y14, this.Z, this.Z, color8);
                    this.imageRegion.setLine(line++, x1d, y1d, x14, y14, this.Z, this.Z, color8);
                }
            }
        }

        public synchronized void showColorsNoAlpha() {
            int i;
            this.setTextAndCube();
            for (i = this.pixels.length - 1; i >= 0; --i) {
                this.pixels[i] = 0;
                this.pixelsZ[i] = 1000;
            }
            if (Color_Inspector_3D.this.numberOfColors > 256) {
                for (int i2 = Color_Inspector_3D.this.colHash.length - 1; i2 >= 0; --i2) {
                    int pos;
                    ColHash ch = Color_Inspector_3D.this.colHash[i2];
                    if (ch == null) continue;
                    this.R = ch.R;
                    this.G = ch.G;
                    this.B = ch.B;
                    this.xyzPosC();
                    if (this.Z < Color_Inspector_3D.this.renderDepth || (this.X & 0xFFFFFE00 | this.Y & 0xFFFFFE00) != 0 || this.Z >= this.pixelsZ[pos = this.Y << 9 | this.X]) continue;
                    this.pixelsZ[pos] = (short)this.Z;
                    this.pixels[pos] = ch.color;
                }
            } else {
                for (i = 0; i < Color_Inspector_3D.this.colHash.length; ++i) {
                    if (Color_Inspector_3D.this.colHash[i] == null) continue;
                    this.R = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].R;
                    this.G = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].G;
                    this.B = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].B;
                    this.xyzPosC();
                    if (this.Z < Color_Inspector_3D.this.renderDepth) continue;
                    for (int y = -4; y <= 4; ++y) {
                        int Yy = this.Y + y;
                        for (int x = -4; x <= 4; ++x) {
                            int pos;
                            int Xx;
                            if (x * x + y * y > 16 || ((Xx = this.X + x) & 0xFFFFFE00) != 0 || (Yy & 0xFFFFFE00) != 0 || this.Z >= this.pixelsZ[pos = Yy * this.width + Xx]) continue;
                            this.pixelsZ[pos] = (short)this.Z;
                            this.pixels[pos] = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].color;
                        }
                    }
                }
            }
        }

        public synchronized void showColorsHist() {
            this.setTextAndCube();
            for (int i = this.pixels.length - 1; i >= 0; --i) {
                this.pixels[i] = 0;
                this.pixelsZ[i] = 1000;
            }
            float rFactor = (float)(40.0 / Math.pow(Color_Inspector_3D.this.maskSize, 0.3333333333333333));
            for (int i = 0; i < Color_Inspector_3D.this.colHash.length; ++i) {
                long b;
                long g;
                long r;
                if (Color_Inspector_3D.this.colHash[i] == null) continue;
                this.R = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].R;
                this.G = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].G;
                this.B = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].B;
                this.xyzPosC();
                if (this.Z < Color_Inspector_3D.this.renderDepth) continue;
                int rad = (int)((double)1.1f * Math.pow(((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].frequency, 0.3333333333333333) * (double)rFactor);
                float sz = this.d / ((float)this.Z + this.d);
                rad = Math.max(Math.round((float)rad * sz), 1);
                if (Color_Inspector_3D.this.colorMode) {
                    int c = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].color;
                    r = c >> 16 & 0xFF;
                    g = c >> 8 & 0xFF;
                    b = c & 0xFF;
                } else {
                    b = 200L;
                    g = 200L;
                    r = 200L;
                }
                long rr = rad * rad + 1;
                for (int y = -rad; y <= rad; ++y) {
                    int Yy = this.Y + y;
                    for (int x = -rad; x <= rad; ++x) {
                        int pos;
                        int Xx;
                        long rxy = x * x + y * y;
                        if (rxy >= rr || ((Xx = this.X + x) & 0xFFFFFE00 | Yy & 0xFFFFFE00) != 0 || this.Z >= this.pixelsZ[pos = Yy * this.width + Xx]) continue;
                        this.pixelsZ[pos] = (short)this.Z;
                        float a = (float)(0.5 + 0.5 * (double)(rr * rr - rxy * rxy) / (double)(rr * rr));
                        int r_ = (int)(a * (float)r);
                        int g_ = (int)(a * (float)g);
                        int b_ = (int)(a * (float)b);
                        this.pixels[pos] = 0xFF000000 | r_ << 16 | g_ << 8 | b_;
                    }
                }
            }
        }

        public synchronized void showColorsAlpha() {
            int i;
            this.setTextAndCube();
            for (i = this.pixels.length - 1; i >= 0; --i) {
                this.pixels[i] = 0;
                this.pixelsAlpha[i] = 0;
            }
            if (Color_Inspector_3D.this.numberOfColors > 256) {
                for (int i2 = Color_Inspector_3D.this.colHash.length - 1; i2 >= 0; --i2) {
                    ColHash ch = Color_Inspector_3D.this.colHash[i2];
                    if (ch == null) continue;
                    this.R = ch.R;
                    this.G = ch.G;
                    this.B = ch.B;
                    this.xyzPosC();
                    if (this.Z < Color_Inspector_3D.this.renderDepth || (this.X & 0xFFFFFE00) != 0 || (this.Y & 0xFFFFFE00) != 0) continue;
                    int pos = this.Y << 9 | this.X;
                    int c_ = this.pixels[pos];
                    int alpha = this.pixelsAlpha[pos];
                    int R_ = c_ >> 16 & 0xFF;
                    int G_ = c_ >> 8 & 0xFF;
                    int B_ = c_ & 0xFF;
                    int f = (int)(Color_Inspector_3D.this.freqFactor * (float)((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i2].frequency);
                    f = f <= 255 ? f : 255;
                    float zs = (float)(Math.min(1.0, Math.max(0.0, ((double)(-this.Z) + 128.0) / 256.0)) * 0.9 + 0.1);
                    f = (int)((float)f * zs);
                    c_ = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i2].color;
                    this.R = c_ >> 16 & 0xFF;
                    this.G = c_ >> 8 & 0xFF;
                    this.B = c_ & 0xFF;
                    int ag = alpha + f;
                    this.pixelsAlpha[pos] = ag = ag == 0 ? 1 : ag;
                    this.R = (this.R * f + alpha * R_) / ag;
                    this.G = (this.G * f + alpha * G_) / ag;
                    this.B = (this.B * f + alpha * B_) / ag;
                    this.pixels[pos] = Math.min(ag, 255) << 24 | this.R << 16 | this.G << 8 | this.B;
                }
            } else {
                for (i = 0; i < this.pixels.length; ++i) {
                    this.pixelsZ[i] = 1000;
                }
                for (i = 0; i < Color_Inspector_3D.this.colHash.length; ++i) {
                    if (Color_Inspector_3D.this.colHash[i] == null) continue;
                    this.R = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].R;
                    this.G = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].G;
                    this.B = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].B;
                    this.xyzPosC();
                    if (this.Z < Color_Inspector_3D.this.renderDepth) continue;
                    int f = (int)(Color_Inspector_3D.this.freqFactor * (float)((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].frequency);
                    f = f <= 255 ? f : 255;
                    for (int y = -4; y <= 4; ++y) {
                        for (int x = -4; x <= 4; ++x) {
                            int pos;
                            if (x * x + y * y > 16) continue;
                            int Yy = this.Y + y;
                            int Xx = this.X + x;
                            if ((Xx & 0xFFFFFE00) != 0 || (Yy & 0xFFFFFE00) != 0 || this.Z >= this.pixelsZ[pos = Yy * this.width + Xx]) continue;
                            this.pixelsZ[pos] = (short)this.Z;
                            this.pixels[pos] = f << 24 | ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].color & 0xFFFFFF;
                        }
                    }
                }
            }
        }

        public synchronized void showNoColorsAlpha() {
            int i;
            this.setTextAndCube();
            for (i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = 0;
                this.pixelsAlpha[i] = 0;
            }
            if (Color_Inspector_3D.this.numberOfColors > 256) {
                for (i = 0; i < Color_Inspector_3D.this.colHash.length; ++i) {
                    if (Color_Inspector_3D.this.colHash[i] == null) continue;
                    this.R = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].R;
                    this.G = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].G;
                    this.B = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].B;
                    this.xyzPosC();
                    if (this.Z < Color_Inspector_3D.this.renderDepth) continue;
                    int pos = this.X + this.Y * this.width;
                    if ((this.X & 0xFFFFFE00) != 0 || (this.Y & 0xFFFFFE00) != 0) continue;
                    int alpha = this.pixelsAlpha[pos];
                    int f = (int)(Color_Inspector_3D.this.freqFactor * (float)((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].frequency);
                    f = f <= 255 ? f : 255;
                    int ag = alpha + (f = (int)((double)f * (Math.min(1.0, Math.max(0.0, ((double)(-this.Z) + 128.0) / 256.0)) * 0.9 + 0.1)));
                    if (ag == 0) {
                        ag = alpha == 0 ? 1 : alpha;
                    }
                    this.pixelsAlpha[pos] = ag;
                    this.pixels[pos] = Math.min(ag, 255) << 24;
                }
            } else {
                for (i = 0; i < this.pixels.length; ++i) {
                    this.pixelsZ[i] = 1000;
                }
                for (i = 0; i < Color_Inspector_3D.this.colHash.length; ++i) {
                    if (Color_Inspector_3D.this.colHash[i] == null) continue;
                    this.R = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].R;
                    this.G = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].G;
                    this.B = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].B;
                    this.xyzPosC();
                    if (this.Z < Color_Inspector_3D.this.renderDepth) continue;
                    int f = (int)(Color_Inspector_3D.this.freqFactor * (float)((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].frequency);
                    f = f <= 255 ? f : 255;
                    for (int y = -4; y <= 4; ++y) {
                        for (int x = -4; x <= 4; ++x) {
                            int pos;
                            if (x * x + y * y > 16) continue;
                            int Yy = this.Y + y;
                            int Xx = this.X + x;
                            if ((Xx & 0xFFFFFE00) != 0 || (Yy & 0xFFFFFE00) != 0 || this.Z >= this.pixelsZ[pos = Yy * this.width + Xx]) continue;
                            this.pixelsZ[pos] = (short)this.Z;
                            this.pixels[pos] = f << 24;
                        }
                    }
                }
            }
        }

        public synchronized void showNoColorsNoAlpha() {
            int i;
            this.setTextAndCube();
            for (i = 0; i < this.pixels.length; ++i) {
                this.pixels[i] = 0;
            }
            if (Color_Inspector_3D.this.numberOfColors > 256) {
                for (i = Color_Inspector_3D.this.colHash.length - 1; i >= 0; --i) {
                    if (Color_Inspector_3D.this.colHash[i] == null) continue;
                    this.R = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].R;
                    this.G = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].G;
                    this.B = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].B;
                    this.xyzPosC();
                    if (this.Z < Color_Inspector_3D.this.renderDepth || (this.X & 0xFFFFFE00) != 0 || (this.Y & 0xFFFFFE00) != 0) continue;
                    this.pixels[this.X + this.Y * this.width] = -16777216;
                }
            } else {
                for (i = 0; i < Color_Inspector_3D.this.colHash.length; ++i) {
                    if (Color_Inspector_3D.this.colHash[i] == null) continue;
                    this.R = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].R;
                    this.G = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].G;
                    this.B = ((Color_Inspector_3D)Color_Inspector_3D.this).colHash[i].B;
                    this.xyzPosC();
                    if (this.Z < Color_Inspector_3D.this.renderDepth) continue;
                    for (int y = -4; y <= 4; ++y) {
                        for (int x = -4; x <= 4; ++x) {
                            if (x * x + y * y > 16) continue;
                            int Yy = this.Y + y;
                            int Xx = this.X + x;
                            if ((Xx & 0xFFFFFE00) != 0 || (Yy & 0xFFFFFE00) != 0) continue;
                            this.pixels[Yy * this.width + Xx] = -16777216;
                        }
                    }
                }
            }
        }

        public void setD(float d) {
            this.d = d;
        }

        public int getX() {
            return this.X;
        }

        public int getY() {
            return this.Y;
        }

        static /* synthetic */ int[] access$6402(Picture x0, int[] x1) {
            x0.pixels = x1;
            return x1;
        }

        static /* synthetic */ int[] access$6502(Picture x0, int[] x1) {
            x0.pixelsAlpha = x1;
            return x1;
        }

        static /* synthetic */ short[] access$6602(Picture x0, short[] x1) {
            x0.pixelsZ = x1;
            return x1;
        }
    }

    class ImageRegion
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Image image;
        private Image imageOverlay;
        private int width;
        private int height;
        private float scale = 1.0f;
        private int xPos;
        private int yPos;
        private TextField[] textField = null;
        private Lines[] lines = null;
        private boolean dot = false;
        private Color planeColor = Color.lightGray;
        private Font font1 = new Font("Sans", 0, 18);
        private Font font2 = new Font("Sans", 0, 15);
        private int plotNumber = 1;
        private short[] pixelsZ = null;

        ImageRegion() {
        }

        public void setDot(int xPos, int yPos) {
            this.dot = true;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public void setDot(boolean b) {
            this.dot = b;
        }

        public void setPlaneColor(Color color) {
            this.planeColor = color;
        }

        public void newText(int n) {
            this.textField = new TextField[n];
            for (int i = 0; i < n; ++i) {
                this.textField[i] = new TextField();
            }
        }

        public void setText(String text, int i, int posx, int posy, int z, Color color) {
            this.textField[i].setText(text);
            this.textField[i].setXpos(posx);
            this.textField[i].setYpos(posy);
            this.textField[i].setColor(color);
        }

        public void setText(String text, int i, Color color) {
            this.textField[i].setText(text);
            this.textField[i].setColor(color);
        }

        public void setText(String text, int i) {
            this.textField[i].setText(text);
        }

        public void setTextPos(int i, int posx, int posy, int z) {
            this.textField[i].setXpos(posx);
            this.textField[i].setYpos(posy);
            this.textField[i].setZ(z);
        }

        public void newLines(int n) {
            this.lines = new Lines[n];
            for (int i = 0; i < n; ++i) {
                this.lines[i] = new Lines();
            }
        }

        public void setLine(int i, int x1, int y1, int x2, int y2, int z1, int z2, Color color) {
            this.lines[i].setPos(x1, y1, x2, y2, z1, z2, color);
        }

        public void setImage(Picture pic) {
            this.height = pic.getHeight();
            this.width = pic.getWidth();
            this.image = pic.getImage();
        }

        public void setImage(Image image) {
            this.image = image;
        }

        public void setImage(Image image, short[] pixelsZ) {
            this.image = image;
            this.pixelsZ = pixelsZ;
        }

        public void setOverlayImage(Image image) {
            this.imageOverlay = image;
        }

        void saveToImage(boolean name) {
            Color_Inspector_3D.this.pause = true;
            BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 1);
            this.paint(bufferedImage.createGraphics());
            Graphics2D g2d = bufferedImage.createGraphics();
            if (name) {
                g2d.setColor(Color.black);
                g2d.drawString("Color Inspector 3D", this.width - 150, this.height - 10);
            }
            g2d.dispose();
            String s = "Color Distribution " + this.plotNumber;
            ImagePlus plotImage = NewImage.createRGBImage((String)s, (int)this.width, (int)this.height, (int)1, (int)1);
            ImageProcessor ip = plotImage.getProcessor();
            int[] pixels = (int[])ip.getPixels();
            bufferedImage.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
            plotImage.show();
            plotImage.updateAndDraw();
            ++this.plotNumber;
            Color_Inspector_3D.this.pause = false;
        }

        @Override
        public synchronized void paintComponent(Graphics g1) {
            int i;
            Graphics2D g = (Graphics2D)g1;
            super.paintComponent(g);
            g.setColor(this.planeColor);
            g.fillRect(0, 0, this.width, this.height);
            g.setFont(this.font1);
            if (this.textField != null && Color_Inspector_3D.this.showText) {
                for (i = 0; i < this.textField.length; ++i) {
                    if (this.textField[i] == null || this.textField[i].getZ() <= 0) continue;
                    g.setColor(this.textField[i].getColor());
                    g.drawString(this.textField[i].getText(), this.textField[i].getXpos(), this.textField[i].getYpos());
                }
            }
            if (this.image != null) {
                int xstart = (int)(-((double)((this.scale - 1.0f) * (float)this.width) / 2.0));
                int ystart = (int)(-((double)((this.scale - 1.0f) * (float)this.height) / 2.0));
                g.drawImage(this.image, xstart, ystart, (int)(this.scale * (float)this.width), (int)(this.scale * (float)this.height), this);
                if (this.imageOverlay != null) {
                    g.drawImage(this.imageOverlay, xstart, ystart, (int)(this.scale * (float)this.width), (int)(this.scale * (float)this.height), this);
                }
            }
            if (this.lines != null && Color_Inspector_3D.this.showAxes) {
                for (i = 0; i < this.lines.length; ++i) {
                    if (this.lines[i] == null) continue;
                    float x1 = this.lines[i].x1;
                    float y1 = this.lines[i].y1;
                    float z1 = this.lines[i].z1;
                    float x2 = this.lines[i].x2;
                    float y2 = this.lines[i].y2;
                    float z2 = this.lines[i].z2;
                    float dx = x1 - x2;
                    float dy = y1 - y2;
                    float dz = z1 - z2;
                    float length = (float)Math.sqrt(dx * dx + dy * dy);
                    if (!(length > 0.0f)) continue;
                    dx /= length;
                    dy /= length;
                    dz /= length;
                    g.setColor(this.lines[i].color);
                    float x = x2;
                    float y = y2;
                    float z = z2;
                    int j = 0;
                    while ((float)j < length) {
                        int pos = (int)y * this.width + (int)x;
                        if (pos >= 0 && pos < this.pixelsZ.length && z <= (float)this.pixelsZ[pos]) {
                            g.drawLine((int)x, (int)y, (int)(x + dx), (int)(y + dy));
                        }
                        x += dx;
                        y += dy;
                        z += dz;
                        ++j;
                    }
                }
            }
            if (this.textField != null && Color_Inspector_3D.this.showText) {
                for (i = 0; i < this.textField.length; ++i) {
                    if (this.textField[i] == null || this.textField[i].getZ() > 0) continue;
                    if (i > 3) {
                        g.setFont(this.font2);
                    }
                    g.setColor(this.textField[i].getColor());
                    g.drawString(this.textField[i].getText(), this.textField[i].getXpos(), this.textField[i].getYpos());
                }
            }
            if (this.dot) {
                g.setColor(Color.orange);
                g.drawLine(this.xPos - 3, this.yPos - 2, this.xPos - 10, this.yPos - 2);
                g.drawLine(this.xPos - 3, this.yPos - 1, this.xPos - 10, this.yPos - 1);
                g.drawLine(this.xPos - 3, this.yPos + 2, this.xPos - 10, this.yPos + 2);
                g.drawLine(this.xPos - 3, this.yPos + 3, this.xPos - 10, this.yPos + 3);
                g.drawLine(this.xPos + 4, this.yPos - 2, this.xPos + 10, this.yPos - 2);
                g.drawLine(this.xPos + 4, this.yPos - 1, this.xPos + 10, this.yPos - 1);
                g.drawLine(this.xPos + 4, this.yPos + 2, this.xPos + 10, this.yPos + 2);
                g.drawLine(this.xPos + 4, this.yPos + 3, this.xPos + 10, this.yPos + 3);
                g.drawLine(this.xPos - 2, this.yPos - 3, this.xPos - 2, this.yPos - 10);
                g.drawLine(this.xPos - 1, this.yPos - 3, this.xPos - 1, this.yPos - 10);
                g.drawLine(this.xPos + 2, this.yPos - 3, this.xPos + 2, this.yPos - 10);
                g.drawLine(this.xPos + 3, this.yPos - 3, this.xPos + 3, this.yPos - 10);
                g.drawLine(this.xPos - 2, this.yPos + 4, this.xPos - 2, this.yPos + 10);
                g.drawLine(this.xPos - 1, this.yPos + 4, this.xPos - 1, this.yPos + 10);
                g.drawLine(this.xPos + 2, this.yPos + 4, this.xPos + 2, this.yPos + 10);
                g.drawLine(this.xPos + 3, this.yPos + 4, this.xPos + 3, this.yPos + 10);
                g.setColor(Color.black);
                g.drawLine(this.xPos - 3, this.yPos, this.xPos - 12, this.yPos);
                g.drawLine(this.xPos - 3, this.yPos + 1, this.xPos - 12, this.yPos + 1);
                g.drawLine(this.xPos + 4, this.yPos, this.xPos + 12, this.yPos);
                g.drawLine(this.xPos + 4, this.yPos + 1, this.xPos + 12, this.yPos + 1);
                g.drawLine(this.xPos, this.yPos - 3, this.xPos, this.yPos - 12);
                g.drawLine(this.xPos + 1, this.yPos - 3, this.xPos + 1, this.yPos - 12);
                g.drawLine(this.xPos, this.yPos + 4, this.xPos, this.yPos + 12);
                g.drawLine(this.xPos + 1, this.yPos + 4, this.xPos + 1, this.yPos + 12);
            }
        }

        @Override
        public synchronized void update(Graphics g) {
            this.paintComponent(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, this.height);
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }
    }

    class CustomWindow
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    ChangeListener,
    ActionListener {
        private final String stringBrightness;
        private final String stringContrast;
        private final String stringSaturation;
        private final String stringHueChange;
        private final String stringPerspective;
        private final String stringScale;
        private final String stringDisplay;
        private final String stringColorSpace;
        private final String stringDepth;
        protected Cursor defaultCursor;
        protected Cursor handCursor;
        protected Cursor moveCursor;
        private JPanel imagePanel;
        private JPanel displayPanel;
        private JScrollPane scrollPanel;
        private JComboBox displayChoice;
        private JComboBox colorSpaceChoice;
        private boolean drag;
        private int checkMove;
        private int xStart;
        private int yStart;
        private int xAct;
        private int yAct;
        private int xdiff;
        private int ydiff;
        private float dx;
        private float dy;
        private Dimension leftSize;
        private Dimension rightSize;
        private static final int H = 522;
        private static final int WL = 512;
        private static final int WR = 512;
        private static final int WD = 75;
        private TurnThread thread;
        private JButton button;

        CustomWindow() {
            this.stringBrightness = Color_Inspector_3D.this.english ? "Brightness" : "Helligkeit";
            this.stringContrast = Color_Inspector_3D.this.english ? "Contrast" : "Kontrast";
            this.stringSaturation = Color_Inspector_3D.this.english ? "Saturation" : "S\u00e4ttigung";
            this.stringHueChange = Color_Inspector_3D.this.english ? "Color Rotation" : "Farbrotation";
            this.stringPerspective = Color_Inspector_3D.this.english ? "Perspective" : "Perspektive";
            this.stringScale = Color_Inspector_3D.this.english ? "Scale" : "Skalierung";
            this.stringDisplay = Color_Inspector_3D.this.english ? "  Display Mode:" : "  Darstellungsart:";
            this.stringColorSpace = Color_Inspector_3D.this.english ? "Color Space:" : "Farbraum:";
            this.stringDepth = Color_Inspector_3D.this.english ? "Depth" : "Tiefe";
            this.defaultCursor = new Cursor(0);
            this.handCursor = new Cursor(12);
            this.moveCursor = new Cursor(13);
            this.drag = false;
            this.checkMove = 0;
            this.leftSize = new Dimension();
            this.rightSize = new Dimension();
        }

        void cleanup() {
            if (this.thread != null) {
                this.thread.interrupt();
            }
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (Color_Inspector_3D.this.pic1 != null) {
                Picture.access$6402(Color_Inspector_3D.this.pic1, null);
                Picture.access$6502(Color_Inspector_3D.this.pic1, null);
                Picture.access$6602(Color_Inspector_3D.this.pic1, null);
                Color_Inspector_3D.this.pic1 = null;
            }
            if (Color_Inspector_3D.this.pic2 != null) {
                Picture.access$6402(Color_Inspector_3D.this.pic2, null);
                Picture.access$6502(Color_Inspector_3D.this.pic2, null);
                Picture.access$6602(Color_Inspector_3D.this.pic2, null);
                Color_Inspector_3D.this.pic2 = null;
            }
            Color_Inspector_3D.this.colorSpace = 0;
            Color_Inspector_3D.access$6802(Color_Inspector_3D.this, null);
            this.imagePanel = null;
            Color_Inspector_3D.this.renderDepth = -222;
            Color_Inspector_3D.this.saturation = 1.0f;
            Color_Inspector_3D.this.brightness = 0;
            Color_Inspector_3D.this.contrast = 1.0f;
            Color_Inspector_3D.this.hueChange = 0.0f;
            Color_Inspector_3D.this.showAxes = true;
            Color_Inspector_3D.this.showText = true;
            Color_Inspector_3D.this.colorMode = true;
            Color_Inspector_3D.this.sliderValue0 = 100;
            Color_Inspector_3D.this.mode = 0;
            Color_Inspector_3D.this.shift = false;
            Color_Inspector_3D.this.hist = false;
            Color_Inspector_3D.this.pause = false;
            Color_Inspector_3D.this.move = false;
            Color_Inspector_3D.this.rotation = false;
            Color_Inspector_3D.this.fitImage = true;
            Color_Inspector_3D.this.displayOrig = true;
            Color_Inspector_3D.this.delta = 1.0f;
        }

        public void resetSliders() {
            Color_Inspector_3D.this.sliderFactor0.setValue(100);
            Color_Inspector_3D.this.sliderFactor1.setValue(100);
            Color_Inspector_3D.this.sliderFactor2.setValue(100);
            ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[2] = 1.0;
            ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[1] = 1.0;
            ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[0] = 1.0;
            String str = stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][0] + " ( x 1.0 )";
            this.setSliderTitle(Color_Inspector_3D.this.sliderFactor0, Color.black, str);
            str = stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][1] + " ( x 1.0 )";
            this.setSliderTitle(Color_Inspector_3D.this.sliderFactor1, Color.black, str);
            str = stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][2] + " ( x 1.0 )";
            this.setSliderTitle(Color_Inspector_3D.this.sliderFactor2, Color.black, str);
            if (Color_Inspector_3D.this.colorSpace == 6 || Color_Inspector_3D.this.colorSpace == 7 || Color_Inspector_3D.this.colorSpace == 8 || Color_Inspector_3D.this.colorSpace == 11 || Color_Inspector_3D.this.colorSpace == 12) {
                Color_Inspector_3D.this.sliderFactor0.setEnabled(false);
                Color_Inspector_3D.this.sliderFactor1.setEnabled(false);
                Color_Inspector_3D.this.sliderFactor2.setEnabled(false);
            } else {
                Color_Inspector_3D.this.sliderFactor0.setEnabled(true);
                Color_Inspector_3D.this.sliderFactor1.setEnabled(true);
                Color_Inspector_3D.this.sliderFactor2.setEnabled(true);
            }
            str = this.stringSaturation + " ( x " + (float)((int)(Color_Inspector_3D.this.saturation * 100.0f + 0.5f)) / 100.0f + ")";
            this.setSliderTitle(Color_Inspector_3D.this.sliderSaturation, Color_Inspector_3D.this.saturation == 1.0f ? Color.black : Color.blue, str);
            str = this.stringBrightness + " ( " + (Color_Inspector_3D.this.brightness >= 0 ? "+" : "") + Color_Inspector_3D.this.brightness + " )";
            this.setSliderTitle(Color_Inspector_3D.this.sliderBrightness, Color_Inspector_3D.this.brightness == 0 ? Color.black : Color.blue, str);
            str = this.stringContrast + " ( x " + (float)((int)(Color_Inspector_3D.this.contrast * 100.0f + 0.5f)) / 100.0f + " )";
            this.setSliderTitle(Color_Inspector_3D.this.sliderContrast, Color_Inspector_3D.this.contrast == 1.0f ? Color.black : Color.blue, str);
            str = this.stringHueChange + " ( " + (int)(Color_Inspector_3D.this.hueChange * 360.0f) + " " + '\u00b0' + " )";
            this.setSliderTitle(Color_Inspector_3D.this.sliderHueChange, Color_Inspector_3D.this.hueChange == 0.0f ? Color.black : Color.blue, str);
        }

        void init(ImagePlus imp) {
            this.cleanup();
            this.setLayout(new BoxLayout(this, 1));
            this.imagePanel = new JPanel();
            this.imagePanel.setBackground(Color.lightGray);
            this.imagePanel.setLayout(new BorderLayout());
            this.displayPanel = new JPanel();
            this.displayPanel.setBackground(Color.lightGray);
            this.displayPanel.setLayout(new BorderLayout());
            Color_Inspector_3D.this.imageRegion1 = new ImageRegion();
            Color_Inspector_3D.this.imageRegion1.addMouseMotionListener(this);
            Color_Inspector_3D.this.imageRegion1.addMouseListener(this);
            Color_Inspector_3D.this.pic1 = new Picture(imp);
            Color_Inspector_3D.this.imageRegion1.setImage(Color_Inspector_3D.this.pic1);
            Color_Inspector_3D.this.pic1.setImageRegion(Color_Inspector_3D.this.imageRegion1);
            Color_Inspector_3D.this.pic1.setupOverlayImage();
            this.leftSize.width = Math.min(512, Color_Inspector_3D.this.pic1.getWidth());
            this.leftSize.height = Math.min(522, Color_Inspector_3D.this.pic1.getHeight());
            if (Color_Inspector_3D.this.fitImage) {
                float scalew = (float)this.leftSize.width / (float)Color_Inspector_3D.this.pic1.getWidth();
                float scaleh = (float)this.leftSize.height / (float)Color_Inspector_3D.this.pic1.getHeight();
                float scale = Math.min(scaleh, scalew);
                this.leftSize.width = (int)(scale * (float)Color_Inspector_3D.this.pic1.getWidth());
                this.leftSize.height = (int)(scale * (float)Color_Inspector_3D.this.pic1.getHeight());
                Color_Inspector_3D.this.imageRegion1.setWidth(Math.min(this.leftSize.width, 512));
                Color_Inspector_3D.this.imageRegion1.setHeight(Math.min(this.leftSize.height, 522));
            } else {
                this.leftSize.width = Color_Inspector_3D.this.pic1.getWidth();
                this.leftSize.height = Color_Inspector_3D.this.pic1.getHeight();
                Color_Inspector_3D.this.imageRegion1.setWidth(this.leftSize.width);
                Color_Inspector_3D.this.imageRegion1.setHeight(this.leftSize.height);
            }
            Color_Inspector_3D.this.imageRegion1.setPreferredSize(new Dimension(this.leftSize.width, this.leftSize.height));
            this.scrollPanel = new JScrollPane(Color_Inspector_3D.this.imageRegion1);
            this.scrollPanel.setPreferredSize(new Dimension(Math.max(this.leftSize.width + 10, 300), 522));
            Color_Inspector_3D.this.imageRegion2 = new ImageRegion();
            Color_Inspector_3D.this.imageRegion2.setBackground(Color.lightGray);
            this.rightSize.width = 512;
            this.rightSize.height = 522;
            Color_Inspector_3D.this.imageRegion2.addMouseMotionListener(this);
            Color_Inspector_3D.this.imageRegion2.addMouseListener(this);
            Color_Inspector_3D.this.imageRegion2.setWidth(this.rightSize.width);
            Color_Inspector_3D.this.imageRegion2.setHeight(this.rightSize.height);
            Color_Inspector_3D.this.pic2 = new Picture(512, 522);
            Color_Inspector_3D.this.imageRegion2.setImage(Color_Inspector_3D.this.pic2);
            Color_Inspector_3D.this.imageRegion2.setPreferredSize(new Dimension(512, 522));
            Color_Inspector_3D.this.pic2.setImageRegion(Color_Inspector_3D.this.imageRegion2);
            Color_Inspector_3D.this.pic1.findUniqueColors();
            Color_Inspector_3D.this.numberOfColorsOrig = Color_Inspector_3D.this.numberOfColors;
            if (Color_Inspector_3D.this.numberOfColorsOrig <= 256) {
                Color_Inspector_3D.this.freqFactor = (float)Color_Inspector_3D.this.sliderValue0 * 1000.0f / (float)Color_Inspector_3D.this.maskSize;
            } else {
                Color_Inspector_3D.this.freqFactor = (float)Color_Inspector_3D.this.sliderValue0 * 200000.0f / (float)Color_Inspector_3D.this.maskSize;
            }
            JPanel depthPanel = new JPanel();
            depthPanel.setLayout(new GridLayout(3, 1));
            Color_Inspector_3D.this.sliderDepth = this.makeTitledVerticalSilder(this.stringDepth, Color.black, -222, 222, Color_Inspector_3D.this.renderDepth);
            depthPanel.add(Color_Inspector_3D.this.sliderDepth);
            Color_Inspector_3D.this.sliderPerspective = this.makeTitledVerticalSilder(this.stringPerspective + "", Color.black, 50, 118, 84);
            depthPanel.add(Color_Inspector_3D.this.sliderPerspective);
            Color_Inspector_3D.this.sliderScale = this.makeTitledVerticalSilder(this.stringScale + "", Color.black, 0, 30, 15);
            depthPanel.add(Color_Inspector_3D.this.sliderScale);
            depthPanel.setPreferredSize(new Dimension(75, 522));
            this.displayPanel.add((Component)this.scrollPanel, "West");
            this.displayPanel.add((Component)Color_Inspector_3D.this.imageRegion2, "Center");
            this.imagePanel.add((Component)this.displayPanel, "West");
            this.imagePanel.add((Component)depthPanel, "East");
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new GridLayout(2, 1));
            JPanel buttonPanel1 = new JPanel();
            buttonPanel1.setLayout(new FlowLayout(0, 5, 0));
            JLabel label2 = new JLabel(this.stringColorSpace);
            buttonPanel1.add(label2);
            this.colorSpaceChoice = new JComboBox<String>(stringColorSpaceNames);
            this.colorSpaceChoice.setMaximumRowCount(stringColorSpaceNames.length);
            this.colorSpaceChoice.addActionListener(this);
            buttonPanel1.add(this.colorSpaceChoice);
            JLabel label1 = new JLabel(this.stringDisplay);
            buttonPanel1.add(label1);
            this.displayChoice = new JComboBox<String>(Color_Inspector_3D.this.stringDisplayMode);
            this.displayChoice.addActionListener(this);
            buttonPanel1.add(this.displayChoice);
            Color_Inspector_3D.this.label0 = new JLabel("");
            buttonPanel1.add(Color_Inspector_3D.this.label0);
            Color_Inspector_3D.this.label0.setVisible(false);
            Color_Inspector_3D.this.jTextField = new JTextField();
            Color_Inspector_3D.this.jTextField.setColumns(3);
            buttonPanel1.add(Color_Inspector_3D.this.jTextField);
            Color_Inspector_3D.this.jTextField.setVisible(false);
            Color_Inspector_3D.this.slider0 = new JSlider(0, 1, 256, 100);
            Color_Inspector_3D.this.slider0.addChangeListener(this);
            Color_Inspector_3D.this.slider0.addMouseListener(this);
            Color_Inspector_3D.this.slider0.setVisible(false);
            buttonPanel1.add(Color_Inspector_3D.this.slider0);
            this.button = new JButton(Color_Inspector_3D.this.english ? "LUT" : "Liste");
            this.button.setVisible(false);
            this.button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Color_Inspector_3D.this.pic1.printLut();
                }
            });
            buttonPanel1.add(this.button);
            topPanel.add(buttonPanel1);
            JPanel buttonPanel0 = new JPanel();
            buttonPanel0.setLayout(new FlowLayout(0));
            Color_Inspector_3D.this.label = new JLabel();
            buttonPanel0.add(Color_Inspector_3D.this.label);
            Color_Inspector_3D.this.labelInfo = new JLabel("                                    ");
            buttonPanel0.add(Color_Inspector_3D.this.labelInfo);
            topPanel.add(buttonPanel0);
            JPanel sliderPanel = new JPanel();
            sliderPanel.setPreferredSize(new Dimension(900, 75));
            sliderPanel.setLayout(new GridLayout(1, 10, 0, 0));
            Color_Inspector_3D.this.sliderFactor0 = this.makeTitledSilder("R", Color.black, 0, 200, 100);
            sliderPanel.add(Color_Inspector_3D.this.sliderFactor0);
            Color_Inspector_3D.this.sliderFactor1 = this.makeTitledSilder("G", Color.black, 0, 200, 100);
            sliderPanel.add(Color_Inspector_3D.this.sliderFactor1);
            Color_Inspector_3D.this.sliderFactor2 = this.makeTitledSilder("B", Color.black, 0, 200, 100);
            sliderPanel.add(Color_Inspector_3D.this.sliderFactor2);
            Color_Inspector_3D.this.sliderBrightness = this.makeTitledSilder(this.stringBrightness, Color.black, 0, 510, 255);
            sliderPanel.add(Color_Inspector_3D.this.sliderBrightness);
            Color_Inspector_3D.this.sliderContrast = this.makeTitledSilder(this.stringContrast, Color.black, 0, 256, 128);
            sliderPanel.add(Color_Inspector_3D.this.sliderContrast);
            Color_Inspector_3D.this.sliderSaturation = this.makeTitledSilder(this.stringSaturation, Color.black, 0, 256, 128);
            sliderPanel.add(Color_Inspector_3D.this.sliderSaturation);
            Color_Inspector_3D.this.sliderHueChange = this.makeTitledSilder(this.stringHueChange, Color.black, 0, 256, 128);
            sliderPanel.add(Color_Inspector_3D.this.sliderHueChange);
            this.resetSliders();
            this.add(topPanel);
            this.add(this.imagePanel);
            this.add(sliderPanel);
            this.validate();
            Color_Inspector_3D.this.imageRegion2.newText(7);
            Color_Inspector_3D.this.imageRegion2.newLines(62);
            Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
            Color_Inspector_3D.this.pic2.updateDisplay();
            Color_Inspector_3D.this.imageRegion1.repaint();
            Color_Inspector_3D.this.imageRegion2.repaint();
            this.thread = new TurnThread();
            super.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.isShiftDown()) {
                        Color_Inspector_3D.this.shift = true;
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (!e.isShiftDown()) {
                        Color_Inspector_3D.this.shift = false;
                    }
                }
            });
            super.setCursor(this.defaultCursor);
        }

        private JSlider makeTitledSilder(String string, Color color, int minVal, int maxVal, int val) {
            JSlider slider = new JSlider(0, minVal, maxVal, val);
            TitledBorder tb = new TitledBorder(BorderFactory.createEtchedBorder(), "", 2, 4, new Font("Sans", 0, 11));
            tb.setTitle(string);
            tb.setTitleJustification(1);
            tb.setTitleColor(color);
            slider.setBorder(tb);
            slider.setMajorTickSpacing((maxVal - minVal) / 6);
            slider.setPaintTicks(true);
            slider.addChangeListener(this);
            slider.addChangeListener(this);
            slider.addMouseListener(this);
            return slider;
        }

        private JSlider makeTitledVerticalSilder(String string, Color color, int minVal, int maxVal, int val) {
            JSlider slider = new JSlider(1, minVal, maxVal, val);
            TitledBorder tb = new TitledBorder(BorderFactory.createEtchedBorder(), "", 2, 4, new Font("Sans", 0, 11));
            tb.setTitle(string);
            tb.setTitleColor(color);
            slider.setBorder(tb);
            slider.setMajorTickSpacing((maxVal - minVal) / 6);
            slider.setPaintTicks(true);
            slider.addChangeListener(this);
            slider.addChangeListener(this);
            slider.addMouseListener(this);
            return slider;
        }

        private void setSliderTitle(JSlider slider, Color color, String str) {
            TitledBorder tb = new TitledBorder(BorderFactory.createEtchedBorder(), "", 2, 4, new Font("Sans", 0, 11));
            tb.setTitleJustification(1);
            tb.setTitle(str);
            tb.setTitleColor(color);
            slider.setBorder(tb);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider slider = (JSlider)e.getSource();
            if (slider == Color_Inspector_3D.this.slider0) {
                Color_Inspector_3D.this.sliderValue0 = Color_Inspector_3D.this.slider0.getValue();
                if (Color_Inspector_3D.this.qMode > 1) {
                    Color_Inspector_3D.this.jTextField.setText("" + Color_Inspector_3D.this.sliderValue0);
                }
                if (!slider.getValueIsAdjusting() || Color_Inspector_3D.this.pic1.getPixels().length <= 262144) {
                    if (Color_Inspector_3D.this.numberOfColorsOrig <= 256) {
                        Color_Inspector_3D.this.freqFactor = (float)Color_Inspector_3D.this.sliderValue0 * 1000.0f / (float)Color_Inspector_3D.this.maskSize;
                    } else {
                        Color_Inspector_3D.this.freqFactor = (float)Color_Inspector_3D.this.sliderValue0 * 200000.0f / (float)Color_Inspector_3D.this.maskSize;
                    }
                    Color_Inspector_3D.this.pic1.changeColorHSB();
                    Color_Inspector_3D.this.pic1.selectChannels();
                    if (Color_Inspector_3D.this.qMode == 1) {
                        Color_Inspector_3D.this.delta = (float)(256.0 / Math.pow(6 * (Color_Inspector_3D.this.sliderValue0 + 3), 0.3333333333333333));
                        Color_Inspector_3D.this.pic1.quantize();
                    } else if (Color_Inspector_3D.this.qMode == 2) {
                        Color_Inspector_3D.this.pic1.quantizeMedianCut(Color_Inspector_3D.this.sliderValue0);
                    } else if (Color_Inspector_3D.this.qMode == 3) {
                        Color_Inspector_3D.this.pic1.wu_quant(Color_Inspector_3D.this.sliderValue0);
                    }
                    Color_Inspector_3D.this.pic1.findUniqueColors();
                    Color_Inspector_3D.this.imageRegion1.repaint();
                    Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
                    Color_Inspector_3D.this.pic2.computeColorSpaceCoordinates();
                    Color_Inspector_3D.this.pic2.updateDisplay();
                    Color_Inspector_3D.this.imageRegion2.repaint();
                }
            } else if (slider == Color_Inspector_3D.this.sliderPerspective || slider == Color_Inspector_3D.this.sliderScale) {
                if (slider == Color_Inspector_3D.this.sliderPerspective) {
                    float sliderValue1 = 75.0f - (float)Color_Inspector_3D.this.sliderPerspective.getValue() / 2.0f;
                    if (sliderValue1 == 50.0f) {
                        sliderValue1 = 100000.0f;
                    }
                    sliderValue1 *= sliderValue1;
                    Color_Inspector_3D.this.pic2.setD(sliderValue1);
                }
                if (slider == Color_Inspector_3D.this.sliderScale) {
                    float sliderValue2 = Color_Inspector_3D.this.sliderScale.getValue() - 15;
                    float scale = (float)Math.pow(1.05, sliderValue2);
                    Color_Inspector_3D.this.pic2.setScale(scale);
                }
                Color_Inspector_3D.this.pic2.updateDisplay();
                Color_Inspector_3D.this.imageRegion2.repaint();
            } else {
                String str;
                if (slider == Color_Inspector_3D.this.sliderFactor0) {
                    ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[0] = (double)Color_Inspector_3D.this.sliderFactor0.getValue() / 100.0;
                    str = stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][0] + " ( x " + Color_Inspector_3D.this.channelFactor[0] + ")";
                    this.setSliderTitle(Color_Inspector_3D.this.sliderFactor0, Color_Inspector_3D.this.channelFactor[0] == 1.0 ? Color.black : Color.blue, str);
                }
                if (slider == Color_Inspector_3D.this.sliderFactor1) {
                    ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[1] = (double)Color_Inspector_3D.this.sliderFactor1.getValue() / 100.0;
                    str = stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][1] + " ( x " + Color_Inspector_3D.this.channelFactor[1] + ")";
                    this.setSliderTitle(Color_Inspector_3D.this.sliderFactor1, Color_Inspector_3D.this.channelFactor[1] == 1.0 ? Color.black : Color.blue, str);
                }
                if (slider == Color_Inspector_3D.this.sliderFactor2) {
                    ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[2] = (double)Color_Inspector_3D.this.sliderFactor2.getValue() / 100.0;
                    str = stringColorSpaceLetters[Color_Inspector_3D.this.colorSpace][2] + " ( x" + Color_Inspector_3D.this.channelFactor[2] + ")";
                    this.setSliderTitle(Color_Inspector_3D.this.sliderFactor2, Color_Inspector_3D.this.channelFactor[2] == 1.0 ? Color.black : Color.blue, str);
                }
                if (slider == Color_Inspector_3D.this.sliderSaturation) {
                    Color_Inspector_3D.this.saturation = (float)Color_Inspector_3D.this.sliderSaturation.getValue() / 128.0f;
                    Color_Inspector_3D.this.saturation = Color_Inspector_3D.this.saturation * Color_Inspector_3D.this.saturation;
                    str = this.stringSaturation + " ( x " + (float)((int)(Color_Inspector_3D.this.saturation * 100.0f + 0.5f)) / 100.0f + ")";
                    this.setSliderTitle(Color_Inspector_3D.this.sliderSaturation, Color_Inspector_3D.this.saturation == 1.0f ? Color.black : Color.blue, str);
                }
                if (slider == Color_Inspector_3D.this.sliderBrightness) {
                    Color_Inspector_3D.this.brightness = Color_Inspector_3D.this.sliderBrightness.getValue() - 255;
                    str = this.stringBrightness + " ( " + (Color_Inspector_3D.this.brightness >= 0 ? "+" : "") + Color_Inspector_3D.this.brightness + " )";
                    this.setSliderTitle(Color_Inspector_3D.this.sliderBrightness, Color_Inspector_3D.this.brightness == 0 ? Color.black : Color.blue, str);
                }
                if (slider == Color_Inspector_3D.this.sliderContrast) {
                    Color_Inspector_3D.this.contrast = (float)Color_Inspector_3D.this.sliderContrast.getValue() / 128.0f;
                    if (Color_Inspector_3D.this.contrast < 1.0f) {
                        Color_Inspector_3D.this.contrast = (float)Math.pow(Color_Inspector_3D.this.contrast, 2.0);
                    } else if (Color_Inspector_3D.this.contrast < 2.0f) {
                        Color_Inspector_3D.this.contrast = (float)Math.pow(Color_Inspector_3D.this.contrast, 4.0);
                    } else {
                        Color_Inspector_3D.this.contrast = 256.0f;
                    }
                    str = this.stringContrast + " ( x " + (float)((int)(Color_Inspector_3D.this.contrast * 100.0f + 0.5f)) / 100.0f + " )";
                    this.setSliderTitle(Color_Inspector_3D.this.sliderContrast, Color_Inspector_3D.this.contrast == 1.0f ? Color.black : Color.blue, str);
                }
                if (slider == Color_Inspector_3D.this.sliderHueChange) {
                    Color_Inspector_3D.this.hueChange = (float)(Color_Inspector_3D.this.sliderHueChange.getValue() - 128) / 256.0f;
                    str = this.stringHueChange + " ( " + (int)(Color_Inspector_3D.this.hueChange * 360.0f) + " " + '\u00b0' + " )";
                    this.setSliderTitle(Color_Inspector_3D.this.sliderHueChange, Color_Inspector_3D.this.hueChange == 0.0f ? Color.black : Color.blue, str);
                }
                if (slider == Color_Inspector_3D.this.sliderDepth) {
                    TitledBorder empty = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder());
                    Color_Inspector_3D.this.renderDepth = Color_Inspector_3D.this.sliderDepth.getValue();
                    Color_Inspector_3D.this.pic2.updateDisplay();
                    Color_Inspector_3D.this.imageRegion2.repaint();
                    if (!slider.getValueIsAdjusting() || Color_Inspector_3D.this.pic1.getPixels().length <= 262144) {
                        Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                        Color_Inspector_3D.this.imageRegion1.repaint();
                    }
                    return;
                }
                if (!slider.getValueIsAdjusting() || Color_Inspector_3D.this.pic1.getPixels().length <= 262144) {
                    Color_Inspector_3D.this.pic1.changeColorHSB();
                    Color_Inspector_3D.this.pic1.selectChannels();
                    if (Color_Inspector_3D.this.hist) {
                        Color_Inspector_3D.this.sliderValue0 = Color_Inspector_3D.this.slider0.getValue();
                        if (Color_Inspector_3D.this.qMode == 1) {
                            Color_Inspector_3D.this.delta = (float)(256.0 / Math.pow(6 * (Color_Inspector_3D.this.sliderValue0 + 3), 0.3333333333333333));
                            Color_Inspector_3D.this.pic1.quantize();
                        } else if (Color_Inspector_3D.this.qMode == 2) {
                            Color_Inspector_3D.this.pic1.quantizeMedianCut(Color_Inspector_3D.this.sliderValue0);
                        } else if (Color_Inspector_3D.this.qMode == 3) {
                            Color_Inspector_3D.this.pic1.wu_quant(Color_Inspector_3D.this.sliderValue0);
                        }
                    }
                }
                if (!slider.getValueIsAdjusting() || Color_Inspector_3D.this.pic1.getPixels().length <= 262144) {
                    Color_Inspector_3D.this.pic1.findUniqueColors();
                    Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                    Color_Inspector_3D.this.imageRegion1.repaint();
                    Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
                    Color_Inspector_3D.this.pic2.computeColorSpaceCoordinates();
                    Color_Inspector_3D.this.pic2.updateDisplay();
                    Color_Inspector_3D.this.imageRegion2.repaint();
                }
            }
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            String name;
            String stringWeight = Color_Inspector_3D.this.english ? " Weight:" : " Gewichtung:";
            String stringCells = Color_Inspector_3D.this.english ? " # Color Cells:" : "Farbzellen:";
            String stringNumColors = Color_Inspector_3D.this.english ? " # Colors:" : " Farbanzahl:";
            JComboBox cb = (JComboBox)e.getSource();
            if (cb == this.displayChoice) {
                Color_Inspector_3D.this.move = false;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                name = (String)cb.getSelectedItem();
                Color_Inspector_3D.this.hist = true;
                Color_Inspector_3D.this.pic1.changeColorHSB();
                Color_Inspector_3D.this.pic1.selectChannels();
                boolean isSlider0 = true;
                if (name.equals(Color_Inspector_3D.this.stringDisplayMode[0])) {
                    Color_Inspector_3D.this.hist = false;
                    Color_Inspector_3D.this.mode = Color_Inspector_3D.this.mode & 1;
                    Color_Inspector_3D.this.label0.setVisible(false);
                    Color_Inspector_3D.this.jTextField.setVisible(false);
                    Color_Inspector_3D.this.slider0.setVisible(false);
                    this.button.setVisible(false);
                    Color_Inspector_3D.this.qMode = 0;
                } else if (name.equals(Color_Inspector_3D.this.stringDisplayMode[1])) {
                    Color_Inspector_3D.this.hist = false;
                    Color_Inspector_3D.this.mode = (Color_Inspector_3D.this.mode & 1) + 2;
                    Color_Inspector_3D.this.label0.setText(stringWeight);
                    Color_Inspector_3D.this.label0.setVisible(true);
                    Color_Inspector_3D.this.jTextField.setVisible(false);
                    Color_Inspector_3D.this.slider0.setVisible(true);
                    this.button.setVisible(false);
                    Color_Inspector_3D.this.qMode = 0;
                } else if (name.equals(Color_Inspector_3D.this.stringDisplayMode[2])) {
                    if (Color_Inspector_3D.this.numberOfColorsOrig > 256) {
                        Color_Inspector_3D.this.label0.setText(stringCells);
                        Color_Inspector_3D.this.label0.setVisible(isSlider0);
                        Color_Inspector_3D.this.slider0.setVisible(isSlider0);
                    } else {
                        Color_Inspector_3D.this.slider0.setVisible(false);
                        Color_Inspector_3D.this.label0.setVisible(false);
                    }
                    Color_Inspector_3D.this.jTextField.setVisible(false);
                    this.button.setVisible(true);
                    Color_Inspector_3D.this.qMode = 1;
                    Color_Inspector_3D.this.delta = (float)(256.0 / Math.pow(6 * (Color_Inspector_3D.this.slider0.getValue() + 3), 0.3333333333333333));
                    Color_Inspector_3D.this.pic1.quantize();
                } else {
                    this.button.setVisible(true);
                    Color_Inspector_3D.this.label0.setText(stringNumColors);
                    Color_Inspector_3D.this.jTextField.setVisible(true);
                    Color_Inspector_3D.this.jTextField.setText("" + Color_Inspector_3D.this.sliderValue0);
                    Color_Inspector_3D.this.jTextField.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Color_Inspector_3D.this.sliderValue0 = Integer.parseInt(Color_Inspector_3D.this.jTextField.getText());
                            Color_Inspector_3D.this.slider0.setValue(Color_Inspector_3D.this.sliderValue0);
                        }
                    });
                    if (name.equals(Color_Inspector_3D.this.stringDisplayMode[3])) {
                        Color_Inspector_3D.this.label0.setVisible(isSlider0);
                        Color_Inspector_3D.this.slider0.setVisible(isSlider0);
                        Color_Inspector_3D.this.qMode = 2;
                        Color_Inspector_3D.this.pic1.quantizeMedianCut(Color_Inspector_3D.this.slider0.getValue());
                    } else if (name.equals(Color_Inspector_3D.this.stringDisplayMode[4])) {
                        Color_Inspector_3D.this.label0.setVisible(isSlider0);
                        Color_Inspector_3D.this.slider0.setVisible(isSlider0);
                        Color_Inspector_3D.this.qMode = 3;
                        Color_Inspector_3D.this.pic1.wu_quant(Color_Inspector_3D.this.slider0.getValue());
                    }
                }
                Color_Inspector_3D.this.pic1.selectChannels();
                Color_Inspector_3D.this.pic1.findUniqueColors();
                Color_Inspector_3D.this.imageRegion1.repaint();
                Color_Inspector_3D.this.pic2.computeColorSpaceCoordinates();
            }
            if (cb == this.colorSpaceChoice) {
                name = (String)cb.getSelectedItem();
                for (int cs = 0; cs < stringColorSpaceNames.length; ++cs) {
                    if (!name.equals(stringColorSpaceNames[cs])) continue;
                    Color_Inspector_3D.this.colorSpace = cs;
                    this.resetSliders();
                    Color_Inspector_3D.this.move = false;
                    Color_Inspector_3D.this.pic2.computeColorSpaceCoordinates();
                    break;
                }
            }
            Color_Inspector_3D.this.pause = false;
            Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
            Color_Inspector_3D.this.imageRegion1.repaint();
            Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
            Color_Inspector_3D.this.pic2.updateDisplay();
            Color_Inspector_3D.this.imageRegion2.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            Component source = arg0.getComponent();
            if (source == Color_Inspector_3D.this.imageRegion1) {
                Color_Inspector_3D.this.move = false;
            } else if (source == Color_Inspector_3D.this.imageRegion2) {
                Color_Inspector_3D.this.move = false;
                if (arg0.getClickCount() > 1) {
                    Color_Inspector_3D.this.pic1.setMouseAngle(0.0f, 180.0f);
                    Color_Inspector_3D.this.pic2.setMouseAngle(0.0f, 180.0f);
                    Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                    Color_Inspector_3D.this.imageRegion1.repaint();
                    Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
                    Color_Inspector_3D.this.pic2.updateDisplay();
                    Color_Inspector_3D.this.imageRegion2.repaint();
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderFactor0) {
                if (arg0.getClickCount() > 1) {
                    ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[0] = 1.0;
                    Color_Inspector_3D.this.sliderFactor0.setValue(100);
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderFactor1) {
                if (arg0.getClickCount() > 1) {
                    ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[1] = 1.0;
                    Color_Inspector_3D.this.sliderFactor1.setValue(100);
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderFactor2) {
                if (arg0.getClickCount() > 1) {
                    ((Color_Inspector_3D)Color_Inspector_3D.this).channelFactor[2] = 1.0;
                    Color_Inspector_3D.this.sliderFactor2.setValue(100);
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderBrightness) {
                if (arg0.getClickCount() > 1) {
                    Color_Inspector_3D.this.brightness = 0;
                    Color_Inspector_3D.this.sliderBrightness.setValue(255);
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderContrast) {
                if (arg0.getClickCount() > 1) {
                    Color_Inspector_3D.this.contrast = 1.0f;
                    Color_Inspector_3D.this.sliderContrast.setValue(128);
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderSaturation) {
                if (arg0.getClickCount() > 1) {
                    Color_Inspector_3D.this.saturation = 1.0f;
                    Color_Inspector_3D.this.sliderSaturation.setValue(128);
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderHueChange) {
                if (arg0.getClickCount() > 1) {
                    Color_Inspector_3D.this.hueChange = 0.0f;
                    Color_Inspector_3D.this.sliderHueChange.setValue(128);
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderScale) {
                if (arg0.getClickCount() > 1) {
                    Color_Inspector_3D.this.pic2.setScale(1.0f);
                    Color_Inspector_3D.this.sliderScale.setValue(15);
                }
            } else if ((JSlider)source == Color_Inspector_3D.this.sliderPerspective && arg0.getClickCount() > 1) {
                Color_Inspector_3D.this.pic2.setD(1089.0f);
                Color_Inspector_3D.this.sliderPerspective.setValue(84);
            }
            super.requestFocus();
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
            Object source = arg0.getSource();
            if (source == Color_Inspector_3D.this.imageRegion2) {
                super.setCursor(this.moveCursor);
            } else if (source == Color_Inspector_3D.this.imageRegion1) {
                super.setCursor(this.handCursor);
            }
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
            Object source = arg0.getSource();
            if (source == Color_Inspector_3D.this.imageRegion1) {
                Color_Inspector_3D.this.imageRegion2.setDot(false);
                Color_Inspector_3D.this.imageRegion2.setText("", 6);
                Color_Inspector_3D.this.imageRegion2.repaint();
                Color_Inspector_3D.this.labelInfo.setText("");
            }
            super.setCursor(this.defaultCursor);
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            Object source = arg0.getSource();
            if (source == Color_Inspector_3D.this.imageRegion2) {
                this.checkMove = 0;
                this.xStart = arg0.getX();
                this.yStart = arg0.getY();
                this.drag = true;
                this.dy = 0.0f;
                this.dx = 0.0f;
                this.xdiff = 0;
                this.ydiff = 0;
            } else if (source == Color_Inspector_3D.this.imageRegion1) {
                int xPos = arg0.getX();
                int yPos = arg0.getY();
                if (xPos > 0 && xPos < this.leftSize.width && yPos > 0 && yPos < this.leftSize.height) {
                    if (Color_Inspector_3D.this.fitImage) {
                        xPos = xPos * Color_Inspector_3D.this.pic1.getWidth() / this.leftSize.width;
                        yPos = yPos * Color_Inspector_3D.this.pic1.getHeight() / this.leftSize.height;
                    }
                    int c = Color_Inspector_3D.this.pic1.getColor(xPos, yPos);
                    String string = "  Position x: " + xPos + " y: " + yPos;
                    String string2 = Color_Inspector_3D.this.pic2.showColorDot(c);
                    Color_Inspector_3D.this.labelInfo.setText(string + string2);
                } else {
                    Color_Inspector_3D.this.labelInfo.setText("");
                    Color_Inspector_3D.this.imageRegion2.setDot(false);
                    Color_Inspector_3D.this.imageRegion2.repaint();
                }
            } else if (source == Color_Inspector_3D.this.slider0 || source == Color_Inspector_3D.this.sliderSaturation || source == Color_Inspector_3D.this.sliderBrightness || source == Color_Inspector_3D.this.sliderContrast || source == Color_Inspector_3D.this.sliderHueChange) {
                Color_Inspector_3D.this.move = false;
            }
            super.requestFocus();
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            Object source = arg0.getSource();
            this.drag = false;
            if (source == Color_Inspector_3D.this.imageRegion2) {
                this.checkMove = 3;
            }
            Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
            Color_Inspector_3D.this.imageRegion1.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent arg0) {
            Object source = arg0.getSource();
            if (source == Color_Inspector_3D.this.imageRegion2) {
                if (this.drag) {
                    this.checkMove = 0;
                    Color_Inspector_3D.this.move = false;
                    this.xAct = arg0.getX();
                    this.yAct = arg0.getY();
                    this.xdiff = this.xAct - this.xStart;
                    this.ydiff = this.yAct - this.yStart;
                    this.dx = (5.0f * this.dx + (float)this.xdiff) / 6.0f;
                    this.dy = (5.0f * this.dy + (float)this.ydiff) / 6.0f;
                    if (!Color_Inspector_3D.this.shift) {
                        Color_Inspector_3D.this.pic1.setMouseMovement(this.xdiff, this.ydiff);
                        Color_Inspector_3D.this.pic2.setMouseMovement(this.xdiff, this.ydiff);
                    } else {
                        Color_Inspector_3D.this.pic2.setMouseMovementOffset(this.xdiff, this.ydiff);
                    }
                    this.xStart = this.xAct;
                    this.yStart = this.yAct;
                }
                if (Color_Inspector_3D.this.pic1.getPixels().length <= 262144) {
                    Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                    Color_Inspector_3D.this.imageRegion1.repaint();
                }
                Color_Inspector_3D.this.pic2.updateDisplay();
                Color_Inspector_3D.this.imageRegion2.repaint();
            } else if (source == Color_Inspector_3D.this.imageRegion1) {
                int xPos = arg0.getX();
                int yPos = arg0.getY();
                if (xPos > 0 && xPos < this.leftSize.width && yPos > 0 && yPos < this.leftSize.height) {
                    if (Color_Inspector_3D.this.fitImage) {
                        xPos = xPos * Color_Inspector_3D.this.pic1.getWidth() / this.leftSize.width;
                        yPos = yPos * Color_Inspector_3D.this.pic1.getHeight() / this.leftSize.height;
                    }
                    int c = Color_Inspector_3D.this.pic1.getColor(xPos, yPos);
                    String string = "  Position x: " + xPos + " y: " + yPos;
                    String string2 = Color_Inspector_3D.this.pic2.showColorDot(c);
                    Color_Inspector_3D.this.labelInfo.setText(string + string2);
                } else {
                    Color_Inspector_3D.this.labelInfo.setText("");
                    Color_Inspector_3D.this.imageRegion2.setDot(false);
                    Color_Inspector_3D.this.imageRegion2.repaint();
                }
            }
            super.requestFocus();
        }

        @Override
        public void mouseMoved(MouseEvent arg0) {
            Object source = arg0.getSource();
            if (source == Color_Inspector_3D.this.imageRegion1) {
                int xPos = arg0.getX();
                int yPos = arg0.getY();
                if (xPos >= 0 && xPos < Color_Inspector_3D.this.pic1.getWidth() && yPos >= 0 && yPos < Color_Inspector_3D.this.pic1.getHeight()) {
                    int c;
                    if (Color_Inspector_3D.this.fitImage) {
                        xPos = xPos * Color_Inspector_3D.this.pic1.getWidth() / this.leftSize.width;
                        yPos = yPos * Color_Inspector_3D.this.pic1.getHeight() / this.leftSize.height;
                    }
                    if ((c = Color_Inspector_3D.this.pic1.getColor(xPos, yPos)) != 0) {
                        String string = "  Position x: " + xPos + " y: " + yPos;
                        String string2 = Color_Inspector_3D.this.pic2.showColorDot(c);
                        Color_Inspector_3D.this.labelInfo.setText(string + string2);
                    }
                } else {
                    Color_Inspector_3D.this.labelInfo.setText("");
                    Color_Inspector_3D.this.imageRegion2.setDot(false);
                    Color_Inspector_3D.this.imageRegion2.repaint();
                }
            }
            if (source == Color_Inspector_3D.this.imageRegion2 && this.checkMove > 0 && (this.dx != 0.0f || this.dy != 0.0f) && Color_Inspector_3D.this.rotation) {
                Color_Inspector_3D.this.move = true;
            }
        }

        public void setDx(float dx) {
            this.dx = dx;
        }

        public void setDy(float dy) {
            this.dy = dy;
        }

        class TurnThread
        extends Thread {
            public TurnThread() {
                this.setPriority(1);
                this.start();
            }

            @Override
            public void run() {
                long tna = 0L;
                long tn = 0L;
                long tm = System.currentTimeMillis();
                float fps = 0.0f;
                int delay = 40;
                try {
                    while (!TurnThread.interrupted()) {
                        if (Color_Inspector_3D.this.move && !Color_Inspector_3D.this.pause) {
                            long dt;
                            delay = 40;
                            long l = dt = tna == 0L || tn == 0L ? 0L : tn - tna;
                            if (dt > 0L) {
                                fps = fps == 0.0f ? 10000.0f / (float)dt : (9.0f * fps + 10000.0f / (float)dt) / 10.0f;
                                Color_Inspector_3D.this.imageRegion2.setText(Misc.fm(4, (double)((int)fps) / 10.0) + " fps", 5);
                            }
                            Color_Inspector_3D.this.pic2.setMouseMovement((int)CustomWindow.this.dx, (int)CustomWindow.this.dy);
                            Color_Inspector_3D.this.pic1.setMouseMovement((int)CustomWindow.this.dx, (int)CustomWindow.this.dy);
                            Color_Inspector_3D.this.pic2.updateDisplay();
                            if (Color_Inspector_3D.this.imageRegion2.dot) {
                                Color_Inspector_3D.this.pic2.setDot();
                                Color_Inspector_3D.this.imageRegion2.setDot(Color_Inspector_3D.this.pic2.getX(), Color_Inspector_3D.this.pic2.getY());
                            }
                            Color_Inspector_3D.this.imageRegion2.repaint();
                            if (Color_Inspector_3D.this.pic1 != null && Color_Inspector_3D.this.pic1.getPixels().length <= 262144) {
                                Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                                Color_Inspector_3D.this.imageRegion1.repaint();
                            }
                            tna = tn;
                            tn = System.currentTimeMillis();
                        } else {
                            Color_Inspector_3D.this.imageRegion2.setText("", 5);
                            if (delay != 200) {
                                Color_Inspector_3D.this.imageRegion2.repaint();
                            }
                            delay = 200;
                            fps = 0.0f;
                            CustomWindow.this.checkMove--;
                        }
                        TurnThread.sleep(2L + Math.max(0L, (tm += (long)delay) - System.currentTimeMillis()));
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public class Menu
    extends JMenuBar {
        private String stringColor;
        private String stringText;
        private String stringAxes;
        private String stringRotation;
        private String stringResetManip;
        private String stringFitImage;
        private String stringEnglish;
        private String stringManual;
        private String stringError1;
        private String stringOpen;
        private String stringSaveVisualisation;
        private String stringSaveModified;
        private String stringDuplicateVisualisation;
        private String stringDuplicateModified;
        private String stringQuit;
        private String stringGradient;
        private String stringComic;
        private String stringStart;
        private String stringphoto;
        private String stringCG;
        private String stringPalette;
        private String stringWebColors;
        private String stringColorCube1;
        private String stringColorCube2;
        private String stringSeg1;
        private String stringSeg2;
        private String stringSeg3;
        private String stringSeg4;
        private String stringSeg5;
        private String stringSeg6;

        public Menu() {
            this.stringColor = Color_Inspector_3D.this.english ? "Colors" : "Farbig";
            this.stringText = Color_Inspector_3D.this.english ? "Legend" : "Beschriftungen";
            this.stringAxes = Color_Inspector_3D.this.english ? "Axes" : "Koordinatenachsen";
            this.stringRotation = Color_Inspector_3D.this.english ? "Automatic Rotation" : "automatische Rotation";
            this.stringResetManip = Color_Inspector_3D.this.english ? "Reset Color Manipulation" : "Farbmanipulationen zur\u00fccksetzen";
            this.stringFitImage = Color_Inspector_3D.this.english ? "Fit Image to Frame" : "Bild einpassen";
            this.stringEnglish = Color_Inspector_3D.this.english ? "Deutsche Menus" : "English Menus";
            this.stringManual = Color_Inspector_3D.this.english ? "Manual" : "Bedienungsanleitung";
            this.stringError1 = Color_Inspector_3D.this.english ? "Image is too huge, program will quit" : "Bild ist zu gro\u00df.\nProgramm wird beendet.";
            this.stringOpen = Color_Inspector_3D.this.english ? "Open ..." : "\u00d6ffnen ...";
            this.stringSaveVisualisation = Color_Inspector_3D.this.english ? "Save Visualisation" : "Visualisierung als Bild speichern";
            this.stringSaveModified = Color_Inspector_3D.this.english ? "Save Modified Image" : "Manipuliertes Bild speichern";
            this.stringDuplicateVisualisation = Color_Inspector_3D.this.english ? "Duplicate Visualisation" : "Visualisierung duplizieren";
            this.stringDuplicateModified = Color_Inspector_3D.this.english ? "Duplicate Modified Image" : "Manipuliertes Bild duplizieren";
            this.stringQuit = Color_Inspector_3D.this.english ? "Quit" : "Beenden";
            this.stringGradient = Color_Inspector_3D.this.english ? " Color Gradient" : " Farbverlauf";
            this.stringComic = " Comic";
            this.stringStart = Color_Inspector_3D.this.english ? " Start Image" : " Startbild";
            this.stringphoto = Color_Inspector_3D.this.english ? " Color Photo" : " Farbfoto";
            this.stringCG = Color_Inspector_3D.this.english ? " Computer Graphic" : " Computer Grafik";
            this.stringPalette = Color_Inspector_3D.this.english ? " Palletized Image" : " Palettenbild";
            this.stringWebColors = Color_Inspector_3D.this.english ? " Web Colors" : " Web-Farben";
            this.stringColorCube1 = Color_Inspector_3D.this.english ? " Color Cube 1" : "  Farbw\u00fcrfel 1";
            this.stringColorCube2 = Color_Inspector_3D.this.english ? " Color Cube 2" : "  Farbw\u00fcrfel 2";
            this.stringSeg1 = "Original";
            this.stringSeg2 = Color_Inspector_3D.this.english ? "Segmented: Black & White" : "Segmentiert: Scharz/Wei\u00df";
            this.stringSeg3 = Color_Inspector_3D.this.english ? "Segmented: Black & White (alpha =0.5)" : "Segmentiert: Scharz/Wei\u00df (alpha =0.5)";
            this.stringSeg4 = Color_Inspector_3D.this.english ? "Segmented: Original & White" : "Segmentiert: Original & Wei\u00df";
            this.stringSeg5 = Color_Inspector_3D.this.english ? "Segmented: Original & Black" : "Segmentiert: Original & Schwarz";
            this.stringSeg6 = Color_Inspector_3D.this.english ? "Segmented: Original & Blue" : "Segmentiert: Original & Blau";
            JMenu optionsMenu = new JMenu(Color_Inspector_3D.this.english ? "Options" : "Optionen");
            JMenu fileMenu = new JMenu(Color_Inspector_3D.this.english ? "File" : "Datei");
            JMenu segMenu = new JMenu(Color_Inspector_3D.this.english ? "Segmentation" : "Segmentierung");
            JMenu helpMenu = new JMenu(Color_Inspector_3D.this.english ? "Help" : "Hilfe");
            JMenu subMenu = new JMenu(Color_Inspector_3D.this.english ? "Open Sample Images" : "Beispielbilder \u00f6ffnen");
            ActionListener menuListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    String string = event.getActionCommand();
                    if (string.equals(Menu.this.stringSeg1)) {
                        Color_Inspector_3D.this.depthColorNear = 0;
                        Color_Inspector_3D.this.depthColorFar = 0;
                        Color_Inspector_3D.this.displayOrig = true;
                        Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                        Color_Inspector_3D.this.imageRegion1.repaint();
                    } else if (string.equals(Menu.this.stringSeg2)) {
                        Color_Inspector_3D.this.depthColorNear = -1;
                        Color_Inspector_3D.this.depthColorFar = -16777216;
                        Color_Inspector_3D.this.displayOrig = false;
                        Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                        Color_Inspector_3D.this.imageRegion1.repaint();
                    } else if (string.equals(Menu.this.stringSeg3)) {
                        Color_Inspector_3D.this.depthColorNear = -2130706433;
                        Color_Inspector_3D.this.depthColorFar = Integer.MIN_VALUE;
                        Color_Inspector_3D.this.displayOrig = false;
                        Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                        Color_Inspector_3D.this.imageRegion1.repaint();
                    } else if (string.equals(Menu.this.stringSeg4)) {
                        Color_Inspector_3D.this.depthColorNear = -1;
                        Color_Inspector_3D.this.depthColorFar = 0;
                        Color_Inspector_3D.this.displayOrig = false;
                        Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                        Color_Inspector_3D.this.imageRegion1.repaint();
                    } else if (string.equals(Menu.this.stringSeg5)) {
                        Color_Inspector_3D.this.depthColorNear = -16777216;
                        Color_Inspector_3D.this.depthColorFar = 0;
                        Color_Inspector_3D.this.displayOrig = false;
                        Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                        Color_Inspector_3D.this.imageRegion1.repaint();
                    } else if (string.equals(Menu.this.stringSeg6)) {
                        Color_Inspector_3D.this.depthColorNear = -16776961;
                        Color_Inspector_3D.this.depthColorFar = 0;
                        Color_Inspector_3D.this.displayOrig = false;
                        Color_Inspector_3D.this.pic1.checkDepth(Color_Inspector_3D.this.displayOrig);
                        Color_Inspector_3D.this.imageRegion1.repaint();
                    } else if (string.equals(Menu.this.stringColor)) {
                        Color_Inspector_3D.this.colorMode = !Color_Inspector_3D.this.colorMode;
                        Color_Inspector_3D.this.mode = (Color_Inspector_3D.this.mode & 2) + (Color_Inspector_3D.this.colorMode ? 0 : 1);
                        Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
                        Color_Inspector_3D.this.pic2.updateDisplay();
                        Color_Inspector_3D.this.imageRegion2.repaint();
                    } else if (string.equals(Menu.this.stringText)) {
                        Color_Inspector_3D.this.showText = !Color_Inspector_3D.this.showText;
                        Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
                        Color_Inspector_3D.this.pic2.updateDisplay();
                        Color_Inspector_3D.this.imageRegion2.repaint();
                    } else if (string.equals(Menu.this.stringAxes)) {
                        Color_Inspector_3D.this.showAxes = !Color_Inspector_3D.this.showAxes;
                        Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
                        Color_Inspector_3D.this.pic2.updateDisplay();
                        Color_Inspector_3D.this.imageRegion2.repaint();
                    } else if (string.equals(Menu.this.stringRotation)) {
                        Color_Inspector_3D.this.rotation = !Color_Inspector_3D.this.rotation;
                        if (Color_Inspector_3D.this.rotation) {
                            Color_Inspector_3D.this.move = true;
                            Color_Inspector_3D.this.cw.setDx(2.0f);
                            Color_Inspector_3D.this.cw.setDy(0.0f);
                        } else {
                            Color_Inspector_3D.this.move = false;
                        }
                    } else if (string.equals(Menu.this.stringFitImage)) {
                        int height;
                        int width;
                        Color_Inspector_3D.this.fitImage = !Color_Inspector_3D.this.fitImage;
                        if (Color_Inspector_3D.this.fitImage) {
                            width = Math.min(512, Color_Inspector_3D.this.pic1.getWidth());
                            float scalew = (float)width / (float)Color_Inspector_3D.this.pic1.getWidth();
                            height = Math.min(512, Color_Inspector_3D.this.pic1.getHeight());
                            float scaleh = (float)height / (float)Color_Inspector_3D.this.pic1.getHeight();
                            float scale = Math.min(scaleh, scalew);
                            width = (int)(scale * (float)Color_Inspector_3D.this.pic1.getWidth());
                            height = (int)(scale * (float)Color_Inspector_3D.this.pic1.getHeight());
                        } else {
                            width = Color_Inspector_3D.this.pic1.getWidth();
                            height = Color_Inspector_3D.this.pic1.getHeight();
                        }
                        Color_Inspector_3D.this.imageRegion1.setWidth(width);
                        Color_Inspector_3D.this.imageRegion1.setHeight(height);
                        Color_Inspector_3D.this.cw.scrollPanel.getViewport().add(Color_Inspector_3D.this.imageRegion1);
                        Color_Inspector_3D.this.cw.scrollPanel.validate();
                        Color_Inspector_3D.this.frame.pack();
                        Color_Inspector_3D.this.imageRegion1.repaint();
                    } else if (string.equals(Menu.this.stringEnglish)) {
                        Color_Inspector_3D.this.english = !Color_Inspector_3D.this.english;
                        Color_Inspector_3D.this.cw.cleanup();
                        Color_Inspector_3D.this.frame.dispose();
                        Color_Inspector_3D.this.run("");
                    } else if (string.equals(Menu.this.stringResetManip)) {
                        Color_Inspector_3D.this.brightness = 0;
                        Color_Inspector_3D.this.contrast = 1.0f;
                        Color_Inspector_3D.this.saturation = 1.0f;
                        Color_Inspector_3D.this.hueChange = 0.0f;
                        Color_Inspector_3D.this.pic2.setScale(1.0f);
                        Color_Inspector_3D.this.pic2.setD(1089.0f);
                        Color_Inspector_3D.this.cw.resetSliders();
                        Color_Inspector_3D.this.sliderHueChange.setValue(128);
                        Color_Inspector_3D.this.sliderBrightness.setValue(255);
                        Color_Inspector_3D.this.sliderContrast.setValue(128);
                        Color_Inspector_3D.this.sliderSaturation.setValue(128);
                        Color_Inspector_3D.this.sliderScale.setValue(15);
                        Color_Inspector_3D.this.sliderPerspective.setValue(84);
                        Color_Inspector_3D.this.pic1.resetToOriginalImage();
                        if (Color_Inspector_3D.this.hist) {
                            if (Color_Inspector_3D.this.qMode == 1) {
                                Color_Inspector_3D.this.delta = (float)(256.0 / Math.pow(6 * (Color_Inspector_3D.this.sliderValue0 + 3), 0.3333333333333333));
                                Color_Inspector_3D.this.pic1.quantize();
                            } else if (Color_Inspector_3D.this.qMode == 2) {
                                Color_Inspector_3D.this.pic1.quantizeMedianCut(Color_Inspector_3D.this.sliderValue0);
                            } else if (Color_Inspector_3D.this.qMode == 3) {
                                Color_Inspector_3D.this.pic1.wu_quant(Color_Inspector_3D.this.sliderValue0);
                            }
                        }
                        Color_Inspector_3D.this.pic1.selectChannels();
                        Color_Inspector_3D.this.pic1.findUniqueColors();
                        Color_Inspector_3D.this.imageRegion1.repaint();
                        Color_Inspector_3D.this.pic2.computeColorSpaceCoordinates();
                        Color_Inspector_3D.this.pic2.initTextsAndDrawColors();
                        Color_Inspector_3D.this.pic2.updateDisplay();
                        Color_Inspector_3D.this.imageRegion2.repaint();
                    } else if (string.startsWith(" ")) {
                        Color_Inspector_3D.this.kltColor = null;
                        String str = null;
                        if (string.equals(Menu.this.stringGradient)) {
                            str = "/images/verlauf2.jpg";
                        }
                        if (string.equals(Menu.this.stringComic)) {
                            str = "/images/lilo.jpg";
                        }
                        if (string.equals(Menu.this.stringStart)) {
                            str = "/images/titel.jpg";
                        }
                        if (string.equals(Menu.this.stringphoto)) {
                            str = "/images/baboon400.jpg";
                        }
                        if (string.equals(Menu.this.stringCG)) {
                            str = "/images/pool.jpg";
                        }
                        if (string.equals(Menu.this.stringPalette)) {
                            str = "/images/sail.gif";
                        }
                        if (string.equals(Menu.this.stringWebColors)) {
                            str = "/images/webcolors.gif";
                        }
                        if (string.equals(Menu.this.stringColorCube1)) {
                            str = "/images/cube6.png";
                        }
                        if (string.equals(Menu.this.stringColorCube2)) {
                            str = "/images/col65k.png";
                        }
                        URL url = null;
                        try {
                            url = this.getClass().getResource(str);
                            if (url != null) {
                                Color_Inspector_3D.this.cw.resetSliders();
                                Color_Inspector_3D.this.cw.cleanup();
                                Image image = Toolkit.getDefaultToolkit().getImage(url);
                                ImagePlus imp = new ImagePlus(str, image);
                                imp.show();
                                Color_Inspector_3D.this.frame.dispose();
                                Color_Inspector_3D.this.run("");
                            }
                        }
                        catch (Exception e) {
                            String msg = e.getMessage();
                            if (msg == null || msg.equals("")) {
                                msg = "" + e;
                            }
                            IJ.showMessage((String)"Color Inspector 3D", (String)(msg + "\n \n" + url));
                        }
                    } else if (string.equals(Menu.this.stringOpen)) {
                        Color_Inspector_3D.this.kltColor = null;
                        JFileChooser fc = new JFileChooser();
                        if (fc.showOpenDialog(Color_Inspector_3D.this.frame) == 0) {
                            Color_Inspector_3D.this.cw.cleanup();
                            Color_Inspector_3D.this.cw.resetSliders();
                            String str = fc.getSelectedFile().getPath();
                            try {
                                IJ.run((String)"Open...", (String)("path='" + str + "'"));
                                ImagePlus imp = WindowManager.getCurrentImage();
                                imp.show();
                                Color_Inspector_3D.this.cw.cleanup();
                                Color_Inspector_3D.this.xPos = Color_Inspector_3D.this.frame.getX();
                                Color_Inspector_3D.this.yPos = Color_Inspector_3D.this.frame.getY();
                                Color_Inspector_3D.this.frame.dispose();
                                try {
                                    Color_Inspector_3D.this.run("");
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    JOptionPane.showMessageDialog(null, Menu.this.stringError1, "ColorInspector 3D", -1);
                                }
                            }
                            catch (RuntimeException e) {
                                JOptionPane.showMessageDialog(null, "Bild kann nicht ge\u00f6ffnet werden", "ColorInspector 3D", -1);
                            }
                        }
                    } else if (string.equals(Menu.this.stringDuplicateVisualisation)) {
                        Color_Inspector_3D.this.imageRegion2.saveToImage(true);
                        ImagePlus imp = WindowManager.getCurrentImage();
                        imp.show();
                    } else if (string.equals(Menu.this.stringDuplicateModified)) {
                        Color_Inspector_3D.this.imageRegion1.saveToImage(false);
                        ImagePlus imp = WindowManager.getCurrentImage();
                        imp.show();
                    } else if (string.equals(Menu.this.stringSaveVisualisation)) {
                        JFileChooser fc = new JFileChooser();
                        fc.setSelectedFile(new File("color3d.tif"));
                        if (fc.showSaveDialog(Color_Inspector_3D.this.frame) == 0) {
                            String str = fc.getSelectedFile().getPath();
                            Color_Inspector_3D.this.imageRegion2.saveToImage(true);
                            ImagePlus imp = WindowManager.getCurrentImage();
                            new FileSaver(imp).saveAsTiff(str);
                            IJ.run((String)"Close");
                        }
                    } else if (string.equals(Menu.this.stringSaveModified)) {
                        JFileChooser fc = new JFileChooser();
                        fc.setSelectedFile(new File("modified.tif"));
                        if (fc.showSaveDialog(Color_Inspector_3D.this.frame) == 0) {
                            String str = fc.getSelectedFile().getPath();
                            Color_Inspector_3D.this.imageRegion1.saveToImage(false);
                            ImagePlus imp = WindowManager.getCurrentImage();
                            new FileSaver(imp).saveAsTiff(str);
                            IJ.run((String)"Close");
                        }
                    } else if (string.equals(Menu.this.stringQuit)) {
                        Color_Inspector_3D.this.cw.cleanup();
                        Color_Inspector_3D.this.frame.dispose();
                    } else if (string.equals(Menu.this.stringManual)) {
                        try {
                            String url = Color_Inspector_3D.this.english ? "http://home.htw-berlin.de/~barthel/ImageJ/ColorInspector/help.htm" : "http://home.htw-berlin.de/~barthel/ImageJ/ColorInspector/hilfe.htm";
                            BrowserLauncher.openURL((String)url);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else if (string.equals("Website")) {
                        try {
                            String url = "https://www.visual-computing.com";
                            BrowserLauncher.openURL((String)url);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };
            JMenuItem item = new JMenuItem(this.stringOpen);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            fileMenu.add(subMenu);
            item = new JMenuItem(this.stringphoto);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringComic);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringCG);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringGradient);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringStart);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringPalette);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringWebColors);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringColorCube1);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringColorCube2);
            subMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringSaveVisualisation);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new JMenuItem(this.stringDuplicateVisualisation);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new JMenuItem(this.stringSaveModified);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new JMenuItem(this.stringDuplicateModified);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            item = new JMenuItem(this.stringResetManip);
            fileMenu.add(item);
            item.addActionListener(menuListener);
            item.setSelected(true);
            item = new JMenuItem(this.stringQuit);
            item.addActionListener(menuListener);
            fileMenu.add(item);
            ButtonGroup buttonGroup = new ButtonGroup();
            item = new JRadioButtonMenuItem(this.stringSeg1);
            segMenu.add(item);
            buttonGroup.add(item);
            item.addActionListener(menuListener);
            item.setSelected(true);
            item = new JRadioButtonMenuItem(this.stringSeg2);
            segMenu.add(item);
            buttonGroup.add(item);
            item.addActionListener(menuListener);
            item = new JRadioButtonMenuItem(this.stringSeg3);
            segMenu.add(item);
            buttonGroup.add(item);
            item.addActionListener(menuListener);
            item = new JRadioButtonMenuItem(this.stringSeg4);
            segMenu.add(item);
            buttonGroup.add(item);
            item.addActionListener(menuListener);
            item = new JRadioButtonMenuItem(this.stringSeg5);
            segMenu.add(item);
            buttonGroup.add(item);
            item.addActionListener(menuListener);
            item = new JRadioButtonMenuItem(this.stringSeg6);
            segMenu.add(item);
            buttonGroup.add(item);
            item.addActionListener(menuListener);
            item = new JCheckBoxMenuItem(this.stringColor);
            optionsMenu.add(item);
            item.addActionListener(menuListener);
            item.setSelected(true);
            item = new JCheckBoxMenuItem(this.stringAxes);
            optionsMenu.add(item);
            item.addActionListener(menuListener);
            item.setSelected(true);
            item = new JCheckBoxMenuItem(this.stringText);
            optionsMenu.add(item);
            item.addActionListener(menuListener);
            item.setSelected(true);
            item = new JCheckBoxMenuItem(this.stringRotation);
            optionsMenu.add(item);
            item.setSelected(false);
            item.addActionListener(menuListener);
            if (Color_Inspector_3D.this.pic1.getHeight() > 512 || Color_Inspector_3D.this.pic1.getWidth() > 512) {
                item = new JCheckBoxMenuItem(this.stringFitImage);
                optionsMenu.add(item);
                item.setSelected(Color_Inspector_3D.this.fitImage);
                item.addActionListener(menuListener);
            }
            item = new JMenuItem(this.stringEnglish);
            optionsMenu.add(item);
            item.addActionListener(menuListener);
            item = new JMenuItem(this.stringManual);
            item.addActionListener(menuListener);
            helpMenu.add(item);
            item = new JMenuItem("Website");
            item.addActionListener(menuListener);
            helpMenu.add(item);
            this.add(fileMenu);
            this.add(optionsMenu);
            this.add(segMenu);
            this.add(helpMenu);
        }
    }
}

