/*
 * Decompiled with CFR 0.152.
 */
package hr.irb.fastRandomForest;

import hr.irb.fastRandomForest.DataCache;
import hr.irb.fastRandomForest.FastRandomTree;
import java.util.concurrent.Callable;
import weka.classifiers.Classifier;
import weka.core.Utils;

public class VotesCollectorDataCache
implements Callable<Double> {
    protected final Classifier[] m_Classifiers;
    protected final int instanceIdx;
    protected final DataCache data;
    protected final boolean[][] inBag;

    public VotesCollectorDataCache(Classifier[] m_Classifiers, int instanceIdx, DataCache data, boolean[][] inBag) {
        this.m_Classifiers = m_Classifiers;
        this.instanceIdx = instanceIdx;
        this.data = data;
        this.inBag = inBag;
    }

    @Override
    public Double call() throws Exception {
        double[] classProbs = null;
        classProbs = new double[this.data.numClasses];
        int numVotes = 0;
        for (int treeIdx = 0; treeIdx < this.m_Classifiers.length; ++treeIdx) {
            if (this.inBag[treeIdx][this.instanceIdx]) continue;
            ++numVotes;
            if (!(this.m_Classifiers[treeIdx] instanceof FastRandomTree)) {
                throw new IllegalArgumentException("Only FastRandomTrees accepted in the VotesCollector.");
            }
            FastRandomTree aTree = (FastRandomTree)this.m_Classifiers[treeIdx];
            double[] curDist = aTree.distributionForInstanceInDataCache(this.data, this.instanceIdx);
            for (int classIdx = 0; classIdx < curDist.length; ++classIdx) {
                int n = classIdx;
                classProbs[n] = classProbs[n] + curDist[classIdx];
            }
        }
        double vote = Utils.maxIndex((double[])classProbs);
        return vote;
    }
}

