/*
 * Decompiled with CFR 0.152.
 */
package trainableSegmentation.filters;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Rectangle;
import java.util.Date;

public class Lipschitz_
implements PlugInFilter {
    private static final String Lipschitz_Version = "0.1";
    private static final String Lipschitz_Date = "2006/02/03";
    private boolean m_Down = true;
    private boolean m_TopHat = false;
    public double m_Slope = 10.0;
    protected ImagePlus m_imp;
    private int m_scount;
    protected ImageStack m_stack;
    protected ImageStack m_stack_out;
    protected Rectangle m_roi;
    private int ImageHeight = -1;
    private int ImageWidth = -1;
    private int m_channels = 0;
    boolean m_short = false;
    boolean breaked = false;
    private ImageProcessor iptmp;
    private int[] pixel;

    public void setDownHat(boolean downHat) {
        this.m_Down = downHat;
    }

    public void setTopHat(boolean topHat) {
        this.m_TopHat = topHat;
    }

    public int setup(String arg, ImagePlus imp) {
        if (arg.equals("about")) {
            this.showAbout();
            return 4096;
        }
        this.m_imp = imp;
        IJ.resetEscape();
        return 405;
    }

    void showAbout() {
        IJ.showMessage((String)"About 2D Lipschitz filter", (String)"version 0.1 (2006/02/03)\nMikulas Stencel, Jiri Janacek GPL2\nBased on modul to Ellipse http://www.ellipse.sk/\n\nThis plugin is designed to filter images\nusing 2D Lipschitz filter.");
    }

    private boolean GUI() {
        GenericDialog gd = new GenericDialog("Lipschitz filter v0.1");
        gd.addNumericField("Slope", this.m_Slope, 2);
        String[] labels = new String[]{"TopDown", "TopHat"};
        boolean[] values = new boolean[]{this.m_Down, this.m_TopHat};
        gd.addCheckboxGroup(1, 2, labels, values);
        gd.addMessage("Incorrect values will be replaced by defaults.\nLabels are drawn in the foreground color.\nPress Esc to stop processing.");
        return this.getUserParams(gd);
    }

    private boolean getUserParams(GenericDialog gd) {
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.m_Slope = gd.getNextNumber();
        if (this.m_Slope <= 0.0) {
            this.m_Slope = 10.0;
        }
        this.m_Down = gd.getNextBoolean();
        this.m_TopHat = gd.getNextBoolean();
        return true;
    }

    public void run(ImageProcessor ip) {
        this.m_stack = this.m_imp.getStack();
        this.m_scount = this.m_stack.getSize();
        if (this.GUI()) {
            this.runLipschitz(ip);
        }
    }

    public void Lipschitz2D(ImageProcessor ip) {
        int p4;
        int p;
        int p1;
        int x;
        int p3;
        int p2;
        int z;
        int y;
        int ij;
        int ii;
        this.m_roi = ip.getRoi();
        this.ImageHeight = ip.getHeight();
        this.ImageWidth = ip.getWidth();
        this.m_channels = ip instanceof ColorProcessor ? 3 : 1;
        this.m_short = ip instanceof ShortProcessor;
        this.pixel = new int[this.m_channels];
        int[][] destPixels = new int[this.m_channels][this.ImageHeight * this.ImageWidth];
        int[][] srcPixels = new int[this.m_channels][this.ImageHeight * this.ImageWidth];
        byte[][] tmpBytePixels = new byte[this.m_channels][this.ImageHeight * this.ImageWidth];
        short[][] tmpShortPixels = new short[this.m_channels][this.ImageHeight * this.ImageWidth];
        if (this.m_channels == 1) {
            if (this.m_short) {
                tmpShortPixels[0] = (short[])ip.getPixels();
            } else {
                tmpBytePixels[0] = (byte[])ip.getPixels();
            }
        } else {
            ColorProcessor cip = (ColorProcessor)ip;
            cip.getRGB(tmpBytePixels[0], tmpBytePixels[1], tmpBytePixels[2]);
        }
        int sign = this.m_Down ? 1 : -1;
        int topdown = this.m_Down ? 0 : 255;
        for (ii = 0; ii < this.m_channels; ++ii) {
            for (ij = 0; ij < this.ImageHeight * this.ImageWidth; ++ij) {
                srcPixels[ii][ij] = this.m_short ? sign * (tmpShortPixels[ii][ij] & 0xFFFF) : sign * (tmpBytePixels[ii][ij] & 0xFF);
                destPixels[ii][ij] = srcPixels[ii][ij];
            }
        }
        int slope = (int)this.m_Slope;
        int slope1 = (int)((double)slope * Math.sqrt(2.0));
        int maxz = this.m_channels;
        for (y = this.m_roi.y; y < this.m_roi.y + this.m_roi.height; ++y) {
            IJ.showProgress((int)y, (int)(2 * this.ImageHeight));
            for (z = 0; z < this.m_channels; ++z) {
                p2 = sign * (topdown + sign * slope);
                p3 = sign * (topdown + sign * slope1);
                for (x = this.m_roi.x; x < this.m_roi.x + this.m_roi.width; ++x) {
                    p1 = p3 - slope1;
                    p = p2 - slope;
                    if (p1 > p) {
                        p = p1;
                    }
                    if ((p1 = (p3 = destPixels[z][x + this.ImageWidth * Math.max(y - 1, 0)]) - slope) > p) {
                        p = p1;
                    }
                    if ((p1 = (p4 = destPixels[z][Math.min(x + 1, this.ImageWidth - 1) + this.ImageWidth * Math.max(y - 1, 0)]) - slope1) > p) {
                        p = p1;
                    }
                    if (p <= (p2 = srcPixels[z][x + this.ImageWidth * y])) continue;
                    destPixels[z][x + this.ImageWidth * y] = p;
                    p2 = p;
                }
            }
        }
        for (y = this.m_roi.y + this.m_roi.height - 1; y >= this.m_roi.y; --y) {
            IJ.showProgress((int)(2 * this.ImageHeight - y - 1), (int)(2 * this.ImageHeight));
            for (z = 0; z < maxz; ++z) {
                p2 = sign * (topdown + sign * slope);
                p3 = sign * (topdown + sign * slope1);
                for (x = this.m_roi.x + this.m_roi.width - 1; x >= this.m_roi.x; --x) {
                    p1 = p3 - slope1;
                    p = p2 - slope;
                    if (p1 > p) {
                        p = p1;
                    }
                    if ((p1 = (p3 = destPixels[z][x + this.ImageWidth * Math.min(y + 1, this.ImageHeight - 1)]) - slope) > p) {
                        p = p1;
                    }
                    if ((p1 = (p4 = destPixels[z][Math.max(x - 1, 0) + this.ImageWidth * Math.min(y + 1, this.ImageHeight - 1)]) - slope1) > p) {
                        p = p1;
                    }
                    if (p <= (p2 = destPixels[z][x + this.ImageWidth * y])) continue;
                    destPixels[z][x + this.ImageWidth * y] = p;
                    p2 = p;
                }
            }
        }
        for (ii = 0; ii < this.m_channels; ++ii) {
            for (ij = 0; ij < this.ImageHeight * this.ImageWidth; ++ij) {
                if (this.m_TopHat) {
                    tmpBytePixels[ii][ij] = this.m_Down ? (byte)(srcPixels[ii][ij] - destPixels[ii][ij] + 255) : (byte)(destPixels[ii][ij] - srcPixels[ii][ij]);
                    continue;
                }
                if (this.m_short) {
                    tmpShortPixels[ii][ij] = (short)(sign * destPixels[ii][ij] & 0xFFFF);
                    continue;
                }
                tmpBytePixels[ii][ij] = (byte)(sign * destPixels[ii][ij]);
            }
        }
        if (this.m_channels == 1) {
            if (this.m_short) {
                ShortProcessor sip = (ShortProcessor)ip;
                sip.setPixels((Object)tmpShortPixels[0]);
            } else {
                ByteProcessor bip = (ByteProcessor)ip;
                bip.setPixels((Object)tmpBytePixels[0]);
            }
        } else {
            ColorProcessor cip = (ColorProcessor)ip;
            cip.setRGB(tmpBytePixels[0], tmpBytePixels[1], tmpBytePixels[2]);
        }
    }

    public void runLipschitz(ImageProcessor ip) {
        if (IJ.escapePressed()) {
            return;
        }
        this.breaked = false;
        Date d1 = new Date();
        IJ.showStatus((String)"Initializing...");
        this.m_stack_out = this.m_imp.createEmptyStack();
        ImagePlus imp2 = null;
        for (int i = 0; i < this.m_scount && !this.breaked; ++i) {
            if (this.m_scount > 1) {
                ip = this.m_stack.getProcessor(i + 1);
            }
            this.iptmp = ip.createProcessor(this.ImageWidth, this.ImageHeight);
            this.iptmp.copyBits(ip, 0, 0, 0);
            IJ.showStatus((String)("Filtering " + (i + 1) + "/" + this.m_scount + " slice."));
            this.Lipschitz2D(this.iptmp);
            this.m_stack_out.addSlice(this.m_imp.getShortTitle() + " " + (i + 1) + "/" + this.m_scount, this.iptmp);
            this.breaked = IJ.escapePressed();
            if (!this.breaked) continue;
            IJ.beep();
        }
        imp2 = new ImagePlus(this.m_imp.getShortTitle() + " Filtered (Lipschitz) Slope:" + this.m_Slope + " " + (this.m_Down ? " -Down" : " ") + " " + (this.m_TopHat ? " -TopHat" : " ") + (this.breaked ? " -INTERUPTED" : ""), this.m_stack_out);
        imp2.show();
        imp2.updateAndDraw();
        IJ.showProgress((double)1.0);
    }
}

