/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.PlotFrame;
import edu.mines.jtk.mosaic.PlotPanel;
import edu.mines.jtk.mosaic.SequenceView;
import edu.mines.jtk.util.ArrayMath;
import java.awt.Color;
import javax.swing.SwingUtilities;

public class SequenceViewTest {
    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SequenceViewTest.go();
            }
        });
    }

    private static void go() {
        int nx = 101;
        float dx = 0.1f;
        float fx = -0.5f * dx * (float)(nx - 1);
        Sampling sx = new Sampling(nx, dx, fx);
        float[] f1 = ArrayMath.rampfloat(fx, dx, nx);
        float[] f2 = ArrayMath.add(0.5f, ArrayMath.sin(f1));
        PlotPanel panel = new PlotPanel(2, 1);
        SequenceView sv1 = panel.addSequence(0, 0, sx, f1);
        sv1.setColor(Color.RED);
        SequenceView sv2 = panel.addSequence(1, 0, sx, f2);
        sv2.setZero(SequenceView.Zero.MIDDLE);
        PlotFrame frame = new PlotFrame(panel);
        frame.setDefaultCloseOperation(3);
        frame.setSize(950, 500);
        frame.setVisible(true);
        frame.paintToPng(300.0, 6.0, "junk.png");
    }
}

