/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.BlendState;
import edu.mines.jtk.sgl.ColorState;
import edu.mines.jtk.sgl.LightModelState;
import edu.mines.jtk.sgl.LineState;
import edu.mines.jtk.sgl.MaterialState;
import edu.mines.jtk.sgl.PointState;
import edu.mines.jtk.sgl.PolygonState;
import edu.mines.jtk.sgl.State;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StateSet
implements State {
    private Set<State> _states = new HashSet<State>();

    public static StateSet forTwoSidedShinySurface(Color color) {
        StateSet ss = new StateSet();
        if (color != null) {
            ColorState cs = new ColorState();
            cs.setColor(color);
            ss.add(cs);
        }
        LightModelState lms = new LightModelState();
        lms.setTwoSide(true);
        ss.add(lms);
        MaterialState ms = new MaterialState();
        ms.setColorMaterial(5634);
        ms.setSpecular(Color.white);
        ms.setShininess(100.0f);
        ss.add(ms);
        return ss;
    }

    public void add(State state) {
        this._states.add(state);
    }

    public void remove(State state) {
        this._states.remove(state);
    }

    public boolean contains(Class<?> stateClass) {
        return this.find(stateClass) != null;
    }

    public State find(Class<?> stateClass) {
        for (State s : this._states) {
            if (!s.getClass().equals(stateClass)) continue;
            return s;
        }
        return null;
    }

    public Iterator<State> getStates() {
        return this._states.iterator();
    }

    public BlendState getBlendState() {
        return (BlendState)this.find(BlendState.class);
    }

    public ColorState getColorState() {
        return (ColorState)this.find(ColorState.class);
    }

    public LightModelState getLightModelState() {
        return (LightModelState)this.find(LightModelState.class);
    }

    public LineState getLineState() {
        return (LineState)this.find(LineState.class);
    }

    public MaterialState getMaterialState() {
        return (MaterialState)this.find(MaterialState.class);
    }

    public PointState getPointState() {
        return (PointState)this.find(PointState.class);
    }

    public PolygonState getPolygonState() {
        return (PolygonState)this.find(PolygonState.class);
    }

    @Override
    public void apply() {
        for (State s : this._states) {
            s.apply();
        }
    }

    @Override
    public int getAttributeBits() {
        int attributeBits = 0;
        for (State state : this._states) {
            attributeBits |= state.getAttributeBits();
        }
        return attributeBits;
    }
}

