/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import org.ojalgo.access.Mutate1D;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.PlainArray;
import org.ojalgo.array.Primitive32Array;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.constant.PrimitiveMath;

public abstract class PrimitiveArray
extends PlainArray<Double>
implements Mutate1D.Sortable {
    public static PrimitiveArray make(int size) {
        return Primitive64Array.make(size);
    }

    public static PrimitiveArray wrap(double ... data) {
        return Primitive64Array.wrap(data);
    }

    public static PrimitiveArray wrap(float ... data) {
        return Primitive32Array.wrap(data);
    }

    PrimitiveArray(DenseArray.Factory<Double> factory, int size) {
        super(factory, size);
    }

    @Override
    public final void reset() {
        this.fillAll(PrimitiveMath.ZERO);
    }

    @Override
    final boolean isPrimitive() {
        return true;
    }
}

