/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.convex;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConvexSolver;

abstract class ConstrainedSolver
extends ConvexSolver {
    protected ConstrainedSolver(ConvexSolver.Builder matrices, Optimisation.Options solverOptions) {
        super(matrices, solverOptions);
    }

    @Override
    protected final Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationKKT() {
        PhysicalStore<Double> iterQ = this.getIterationQ();
        MatrixStore<Double> iterA = this.getIterationA();
        return iterQ.logical().right(new MatrixStore[]{iterA.transpose()}).below(iterA);
    }

    @Override
    protected final Access2D.Collectable<Double, ? super PhysicalStore<Double>> getIterationRHS() {
        MatrixStore<Double> iterC = this.getIterationC();
        MatrixStore<Double> iterB = this.getIterationB();
        return iterC.logical().below(iterB);
    }

    @Override
    protected boolean validate() {
        super.validate();
        MatrixStore<Double> iterA = this.getIterationA();
        MatrixStore<Double> iterB = this.getIterationB();
        if (iterA != null && iterB == null || iterA == null && iterB != null) {
            throw new IllegalArgumentException("Either A or B is null, and the other one is not!");
        }
        if (iterA != null) {
            this.computeGeneral(iterA.countRows() < iterA.countColumns() ? iterA.transpose() : iterA);
            if ((long)this.getRankGeneral() != iterA.countRows()) {
                throw new IllegalArgumentException("A must have full (row) rank!");
            }
        }
        this.setState(Optimisation.State.VALID);
        return true;
    }

    abstract int countIterationConstraints();

    abstract MatrixStore<Double> getIterationA();

    abstract MatrixStore<Double> getIterationB();

    abstract MatrixStore<Double> getIterationC();

    final PhysicalStore<Double> getIterationQ() {
        return this.getMatrixQ();
    }
}

