/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.tensor;

import org.ojalgo.access.AccessAnyD;
import org.ojalgo.algebra.NormedVectorSpace;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.tensor.AnyTensor;

public interface Tensor<N extends Number>
extends AccessAnyD<N>,
NormedVectorSpace<Tensor<N>, N> {
    public static <N extends Number> Tensor<N> make(DenseArray.Factory<N> arrayFactory, int rank, int dimensions) {
        return new AnyTensor<N>(rank, dimensions, arrayFactory);
    }

    public static Tensor<Double> makePrimitive(int rank, int dimensions) {
        return new AnyTensor<Double>(rank, dimensions, Primitive64Array.FACTORY);
    }

    @Override
    default public long count(int dimension) {
        return this.dimensions();
    }

    public int dimensions();

    @Override
    public int rank();
}

