/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.wizard.descriptors;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.detection.DetectionUtils;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.features.spot.SpotMorphologyAnalyzerFactory;
import fiji.plugin.trackmate.gui.components.FeatureDisplaySelector;
import fiji.plugin.trackmate.gui.components.FilterGuiPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.gui.wizard.WizardPanelDescriptor;
import fiji.plugin.trackmate.io.SettingsPersistence;
import fiji.plugin.trackmate.providers.SpotMorphologyAnalyzerProvider;
import fiji.plugin.trackmate.util.EverythingDisablerAndReenabler;
import java.awt.Container;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import org.scijava.Cancelable;

public class SpotFilterDescriptor
extends WizardPanelDescriptor {
    private static final String KEY = "SpotFilter";
    private final TrackMate trackmate;

    public SpotFilterDescriptor(TrackMate trackmate, List<FeatureFilter> filters, FeatureDisplaySelector featureSelector) {
        super(KEY);
        this.trackmate = trackmate;
        FilterGuiPanel component = new FilterGuiPanel(trackmate.getModel(), trackmate.getSettings(), DisplaySettings.TrackMateObject.SPOTS, filters, "QUALITY", featureSelector);
        component.addChangeListener(e -> this.filterSpots());
        this.targetPanel = component;
    }

    private void filterSpots() {
        FilterGuiPanel component = (FilterGuiPanel)this.targetPanel;
        this.trackmate.getSettings().setSpotFilters(component.getFeatureFilters());
        this.trackmate.execSpotFiltering(false);
    }

    @Override
    public Runnable getForwardRunnable() {
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                EverythingDisablerAndReenabler disabler = new EverythingDisablerAndReenabler((Container)SpotFilterDescriptor.this.targetPanel, new Class[]{JLabel.class});
                disabler.disable();
                try {
                    Model model = SpotFilterDescriptor.this.trackmate.getModel();
                    Logger logger = model.getLogger();
                    String str = "Initial thresholding with a quality threshold above " + String.format("%.1f", SpotFilterDescriptor.this.trackmate.getSettings().initialSpotFilterValue) + " ...\n";
                    logger.log(str, Logger.BLUE_COLOR);
                    int ntotal = model.getSpots().getNSpots(false);
                    SpotFilterDescriptor.this.trackmate.execInitialSpotFiltering();
                    int nselected = model.getSpots().getNSpots(false);
                    logger.log(String.format("Retained %d spots out of %d.\n", nselected, ntotal));
                    if (SpotFilterDescriptor.this.trackmate.getSettings().detectorFactory != null && SpotFilterDescriptor.this.trackmate.getSettings().detectorFactory.has2Dsegmentation() && DetectionUtils.is2D(SpotFilterDescriptor.this.trackmate.getSettings().imp)) {
                        logger.log("\nAdding morphology analyzers...\n", Logger.BLUE_COLOR);
                        Settings settings = SpotFilterDescriptor.this.trackmate.getSettings();
                        SpotMorphologyAnalyzerProvider spotMorphologyAnalyzerProvider = new SpotMorphologyAnalyzerProvider(settings.imp.getNChannels());
                        List<SpotMorphologyAnalyzerFactory> factories = spotMorphologyAnalyzerProvider.getKeys().stream().map(key -> spotMorphologyAnalyzerProvider.getFactory((String)key)).collect(Collectors.toList());
                        factories.forEach(settings::addSpotAnalyzerFactory);
                        StringBuilder strb = new StringBuilder();
                        Settings.prettyPrintFeatureAnalyzer(factories, strb);
                        logger.log(strb.toString());
                    }
                    FilterGuiPanel panel = (FilterGuiPanel)SpotFilterDescriptor.this.targetPanel;
                    panel.showProgressBar(true);
                    logger.log("\nCalculating spot features...\n", Logger.BLUE_COLOR);
                    long start = System.currentTimeMillis();
                    Logger oldLogger = SpotFilterDescriptor.this.trackmate.getModel().getLogger();
                    SpotFilterDescriptor.this.trackmate.getModel().setLogger(panel.getLogger());
                    SpotFilterDescriptor.this.trackmate.computeSpotFeatures(true);
                    long end = System.currentTimeMillis();
                    SpotFilterDescriptor.this.trackmate.getModel().setLogger(oldLogger);
                    if (SpotFilterDescriptor.this.trackmate.isCanceled()) {
                        logger.log("Spot feature calculation canceled.\nSome spots will have missing feature values.\n");
                    }
                    logger.log(String.format("Calculating features done in %.1f s.\n", Float.valueOf((float)(end - start) / 1000.0f)));
                    panel.showProgressBar(false);
                    panel.refreshValues();
                    SpotFilterDescriptor.this.filterSpots();
                }
                finally {
                    disabler.reenable();
                }
            }
        };
    }

    @Override
    public void displayingPanel() {
        FilterGuiPanel component = (FilterGuiPanel)this.targetPanel;
        this.trackmate.getSettings().setSpotFilters(component.getFeatureFilters());
        this.trackmate.execSpotFiltering(false);
    }

    @Override
    public void aboutToHidePanel() {
        Logger logger = this.trackmate.getModel().getLogger();
        logger.log("\nPerforming spot filtering on the following features:\n", Logger.BLUE_COLOR);
        Model model = this.trackmate.getModel();
        FilterGuiPanel component = (FilterGuiPanel)this.targetPanel;
        List<FeatureFilter> featureFilters = component.getFeatureFilters();
        this.trackmate.getSettings().setSpotFilters(featureFilters);
        this.trackmate.execSpotFiltering(false);
        int ntotal = model.getSpots().getNSpots(false);
        if (featureFilters == null || featureFilters.isEmpty()) {
            logger.log("No feature threshold set, kept the " + ntotal + " spots.\n");
        } else {
            for (FeatureFilter ft : featureFilters) {
                String str = "  - on " + this.trackmate.getModel().getFeatureModel().getSpotFeatureNames().get(ft.feature);
                str = ft.isAbove ? str + " above " : str + " below ";
                str = str + String.format("%.1f", ft.value);
                str = str + "\n";
                logger.log(str);
            }
            int nselected = model.getSpots().getNSpots(true);
            logger.log("Kept " + nselected + " spots out of " + ntotal + ".\n");
        }
        SettingsPersistence.saveLastUsedSettings(this.trackmate.getSettings(), logger);
    }

    @Override
    public Cancelable getCancelable() {
        return this.trackmate;
    }
}

