/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.util;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.util.SpotNeighborhoodCursor;
import fiji.plugin.trackmate.util.TMUtils;
import net.imagej.ImgPlus;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.region.localneighborhood.AbstractNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.EllipseNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.EllipsoidNeighborhood;
import net.imglib2.algorithm.region.localneighborhood.RectangleNeighborhoodGPL;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorExpWindowingFactory;
import net.imglib2.type.numeric.RealType;

public class SpotNeighborhood<T extends RealType<T>>
implements Neighborhood<T> {
    protected final double[] calibration;
    protected final AbstractNeighborhood<T> neighborhood;
    protected final long[] center;

    public SpotNeighborhood(Spot spot, ImgPlus<T> img) {
        this.calibration = TMUtils.getSpatialCalibration(img);
        this.center = new long[img.numDimensions()];
        for (int d = 0; d < this.center.length; ++d) {
            this.center[d] = Math.round(spot.getFeature(Spot.POSITION_FEATURES[d]) / this.calibration[d]);
        }
        long[] span = new long[img.numDimensions()];
        for (int d = 0; d < span.length; ++d) {
            span[d] = Math.round(spot.getFeature("RADIUS") / this.calibration[d]);
        }
        OutOfBoundsMirrorExpWindowingFactory oob = new OutOfBoundsMirrorExpWindowingFactory();
        if (img.numDimensions() == 2 && img.dimension(0) < 2L || img.dimension(1) < 2L) {
            if (img.dimension(0) < 2L) {
                span[0] = 0L;
            } else {
                span[1] = 0L;
            }
            this.neighborhood = new RectangleNeighborhoodGPL(img, (OutOfBoundsFactory)oob);
            this.neighborhood.setPosition(this.center);
            this.neighborhood.setSpan(span);
        } else if (img.numDimensions() == 2) {
            this.neighborhood = new EllipseNeighborhood(img, this.center, span, (OutOfBoundsFactory)oob);
        } else if (img.numDimensions() == 3) {
            this.neighborhood = new EllipsoidNeighborhood(img, this.center, span, (OutOfBoundsFactory)oob);
        } else {
            throw new IllegalArgumentException("Source input must be 1D, 2D or 3D, got nDims = " + img.numDimensions());
        }
    }

    public final SpotNeighborhoodCursor<T> cursor() {
        return new SpotNeighborhoodCursor(this);
    }

    public SpotNeighborhoodCursor<T> localizingCursor() {
        return this.cursor();
    }

    public long size() {
        return this.neighborhood.size();
    }

    public T firstElement() {
        return (T)((RealType)this.neighborhood.firstElement());
    }

    public Object iterationOrder() {
        return this.neighborhood.iterationOrder();
    }

    public double realMin(int d) {
        return this.neighborhood.realMin(d);
    }

    public void realMin(double[] min) {
        this.neighborhood.realMin(min);
    }

    public void realMin(RealPositionable min) {
        this.neighborhood.realMin(min);
    }

    public double realMax(int d) {
        return this.neighborhood.realMax(d);
    }

    public void realMax(double[] max) {
        this.neighborhood.realMax(max);
    }

    public void realMax(RealPositionable max) {
        this.neighborhood.realMax(max);
    }

    public int numDimensions() {
        return this.neighborhood.numDimensions();
    }

    public SpotNeighborhoodCursor<T> iterator() {
        return this.cursor();
    }

    public long min(int d) {
        return this.neighborhood.min(d);
    }

    public void min(long[] min) {
        this.neighborhood.min(min);
    }

    public void min(Positionable min) {
        this.neighborhood.min(min);
    }

    public long max(int d) {
        return this.neighborhood.max(d);
    }

    public void max(long[] max) {
        this.neighborhood.max(max);
    }

    public void max(Positionable max) {
        this.neighborhood.max(max);
    }

    public void dimensions(long[] dimensions) {
        this.neighborhood.dimensions(dimensions);
    }

    public long dimension(int d) {
        return this.neighborhood.dimension(d);
    }

    public void localize(int[] position) {
        for (int d = 0; d < position.length; ++d) {
            position[d] = (int)this.center[d];
        }
    }

    public void localize(long[] position) {
        for (int d = 0; d < position.length; ++d) {
            position[d] = this.center[d];
        }
    }

    public int getIntPosition(int d) {
        return (int)this.center[d];
    }

    public long getLongPosition(int d) {
        return this.center[d];
    }

    public void localize(float[] position) {
        for (int d = 0; d < position.length; ++d) {
            position[d] = this.center[d];
        }
    }

    public void localize(double[] position) {
        for (int d = 0; d < position.length; ++d) {
            position[d] = this.center[d];
        }
    }

    public float getFloatPosition(int d) {
        return this.center[d];
    }

    public double getDoublePosition(int d) {
        return this.center[d];
    }

    public Interval getStructuringElementBoundingBox() {
        long[] min = new long[this.numDimensions()];
        long[] max = new long[this.numDimensions()];
        this.min(min);
        this.max(max);
        FinalInterval interval = new FinalInterval(min, max);
        return interval;
    }
}

