/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Enumeration;
import org.scijava.java3d.LOD;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeRetained;
import org.scijava.java3d.Switch;
import org.scijava.java3d.SwitchRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TransformGroupRetained;
import org.scijava.java3d.View;
import org.scijava.java3d.ViewPlatform;
import org.scijava.java3d.ViewPlatformRetained;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Tuple3f;

public class DistanceLOD
extends LOD {
    private double[] distances;
    private Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    private Point3f center = new Point3f();
    private Point3f viewPosition = new Point3f();

    public DistanceLOD() {
        this.distances = new double[1];
        this.distances[0] = 0.0;
    }

    public DistanceLOD(float[] distances) {
        this.distances = new double[distances.length];
        for (int i = 0; i < distances.length; ++i) {
            this.distances[i] = distances[i];
        }
    }

    public DistanceLOD(float[] distances, Point3f position) {
        this.distances = new double[distances.length];
        for (int i = 0; i < distances.length; ++i) {
            this.distances[i] = distances[i];
        }
        this.position.set((Tuple3f)position);
    }

    public void setPosition(Point3f position) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            ((NodeRetained)this.retained).staticTransform.transform.transform(position, this.position);
        } else {
            this.position.set((Tuple3f)position);
        }
    }

    public void getPosition(Point3f position) {
        if (((NodeRetained)this.retained).staticTransform != null) {
            Transform3D invTransform = ((NodeRetained)this.retained).staticTransform.getInvTransform();
            invTransform.transform(this.position, position);
        } else {
            position.set((Tuple3f)this.position);
        }
    }

    public int numDistances() {
        return this.distances.length;
    }

    public double getDistance(int whichDistance) {
        return this.distances[whichDistance];
    }

    public void setDistance(int whichDistance, double distance) {
        this.distances[whichDistance] = distance;
    }

    @Override
    public void initialize() {
        this.wakeupOn(this.wakeupFrame);
    }

    @Override
    public void processStimulus(Enumeration criteria) {
        int i;
        View v = this.getView();
        if (v == null) {
            this.wakeupOn(this.wakeupFrame);
            return;
        }
        ViewPlatform vp = v.getViewPlatform();
        if (vp == null) {
            return;
        }
        double viewDistance = 0.0;
        int index = 0;
        Transform3D localToWorldTrans = new Transform3D();
        localToWorldTrans.set(((NodeRetained)this.retained).getCurrentLocalToVworld());
        localToWorldTrans.transform(this.position, this.center);
        this.viewPosition.x = (float)((ViewPlatformRetained)vp.retained).schedSphere.center.x;
        this.viewPosition.y = (float)((ViewPlatformRetained)vp.retained).schedSphere.center.y;
        this.viewPosition.z = (float)((ViewPlatformRetained)vp.retained).schedSphere.center.z;
        viewDistance = this.center.distance(this.viewPosition);
        viewDistance /= localToWorldTrans.getDistanceScale();
        int nSwitches = this.numSwitches();
        index = this.distances.length;
        if (viewDistance <= this.distances[0]) {
            index = 0;
        } else {
            for (i = 1; i < this.distances.length; ++i) {
                if (!(viewDistance > this.distances[i - 1]) || !(viewDistance <= this.distances[i])) continue;
                index = i;
                break;
            }
        }
        for (i = nSwitches - 1; i >= 0; --i) {
            Switch sw = this.getSwitch(i);
            if (((SwitchRetained)sw.retained).getWhichChild() == index) continue;
            sw.setWhichChild(index);
        }
        this.wakeupOn(this.wakeupFrame);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        DistanceLOD d = new DistanceLOD();
        d.duplicateNode(this, forceDuplicate);
        return d;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        DistanceLOD lod = (DistanceLOD)originalNode;
        int numD = lod.numDistances();
        this.distances = new double[numD];
        for (int i = 0; i < numD; ++i) {
            this.setDistance(i, lod.getDistance(i));
        }
        Point3f p = new Point3f();
        lod.getPosition(p);
        this.setPosition(p);
    }

    void mergeTransform(TransformGroupRetained xform) {
        xform.transform.transform(this.position, this.position);
    }
}

