/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.NodeComponent;
import org.scijava.java3d.TriangleArrayRetained;

public class TriangleArray
extends GeometryArray {
    TriangleArray() {
    }

    public TriangleArray(int vertexCount, int vertexFormat) {
        super(vertexCount, vertexFormat);
        if (vertexCount < 3 || vertexCount % 3 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("TriangleArray0"));
        }
    }

    public TriangleArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap);
        if (vertexCount < 3 || vertexCount % 3 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("TriangleArray0"));
        }
    }

    public TriangleArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes);
        if (vertexCount < 3 || vertexCount % 3 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("TriangleArray0"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new TriangleArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        TriangleArrayRetained rt = (TriangleArrayRetained)this.retained;
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        TriangleArray t = new TriangleArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes);
        t.duplicateNodeComponent(this);
        return t;
    }
}

