/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import levelsets.filter.Filter;

public class MedianFilter
implements Filter {
    private int maskradius = 0;
    private int[] pixel = new int[4];
    private ArrayList<Integer> sortlist = null;

    public MedianFilter(int maskradius) {
        this.maskradius = maskradius;
        this.sortlist = new ArrayList((int)Math.pow(maskradius * 2 + 1, 2.0));
    }

    @Override
    public BufferedImage filter(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getWidth(null), image.getHeight(null), image.getType());
        if (!(image instanceof WritableRenderedImage)) {
            return null;
        }
        WritableRaster in = image.getRaster();
        WritableRaster out = result.getRaster();
        int[] pixel = new int[4];
        for (int column = 0; column < in.getWidth(); ++column) {
            for (int line = 0; line < in.getHeight(); ++line) {
                int median;
                pixel[1] = pixel[2] = (median = this.getMedianForPixel(column, line, in));
                pixel[0] = pixel[2];
                out.setPixel(column, line, pixel);
            }
        }
        return result;
    }

    @Override
    public void filter(int width, int height, short[] source, short[] target) {
        int i = 0;
        for (int line = 0; line < height; ++line) {
            for (int column = 0; column < width; ++column) {
                target[i++] = this.getMedianForPixel(column, line, width, height, source);
            }
        }
    }

    private final int getMedianForPixel(int x, int y, Raster raster) {
        int radius = this.maskradius;
        if (x - radius < 0) {
            radius = x;
        }
        if (y - radius < 0) {
            radius = y;
        }
        if (x + radius > raster.getWidth() - 1) {
            radius = raster.getWidth() - 1 - x;
        }
        if (y + radius > raster.getHeight() - 1) {
            radius = raster.getHeight() - 1 - y;
        }
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int j = y - radius; j <= y + radius; ++j) {
                this.pixel = raster.getPixel(i, j, this.pixel);
                this.sortlist.add(new Integer(this.pixel[0]));
            }
        }
        Collections.sort(this.sortlist);
        int index = (this.sortlist.size() - 1) / 2;
        Integer result = this.sortlist.get(index);
        this.sortlist.clear();
        return result;
    }

    private final short getMedianForPixel(int x, int y, int width, int height, short[] source) {
        int radius = this.maskradius;
        if (x - radius < 0) {
            radius = x;
        }
        if (y - radius < 0) {
            radius = y;
        }
        if (x + radius > width - 1) {
            radius = width - 1 - x;
        }
        if (y + radius > height - 1) {
            radius = height - 1 - y;
        }
        short[] vals = new short[(2 * radius + 1) * (2 * radius + 1)];
        int k = 0;
        for (int i = x - radius; i <= x + radius; ++i) {
            for (int j = y - radius; j <= y + radius; ++j) {
                vals[k++] = source[i * width + j];
            }
        }
        Arrays.sort(vals);
        return vals[(vals.length - 1) / 2];
    }
}

