/*
 * Decompiled with CFR 0.152.
 */
package levelsets.filter;

import ij.process.ShortProcessor;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import levelsets.filter.Filter;

public class SUSAN
implements Filter {
    private int[][] usan = null;
    boolean[][] mask = null;
    private int radius = 0;
    private int uniValueThreshold = 0;
    private int[] pixel = null;
    private int maxUSAN = 0;

    public SUSAN(int radius, int uniValueThreshold) {
        this.radius = radius;
        this.uniValueThreshold = uniValueThreshold;
        this.mask = this.generateCircleMask();
    }

    @Override
    public final BufferedImage filter(BufferedImage image) {
        this.pixel = new int[image.getSampleModel().getNumBands()];
        this.usan = new int[image.getWidth()][image.getHeight()];
        this.calculateUSAN(image);
        return this.buildResponseImage();
    }

    @Override
    public void filter(int width, int height, short[] source, short[] target) {
        ShortProcessor sp = new ShortProcessor(width, height, source, null);
        BufferedImage bi = this.filter(sp.get16BitBufferedImage());
        DataBufferUShort db = (DataBufferUShort)bi.getData().getDataBuffer();
        System.arraycopy(target, 0, db.getData(), 0, target.length);
    }

    private final void calculateUSAN(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        WritableRaster raster = img.getRaster();
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                this.usan[i][j] = this.getUSANForPixel(i, j, raster);
            }
        }
    }

    private final int getUSANForPixel(int x, int y, Raster raster) {
        int blockradius = this.radius;
        int pixelUSAN = 0;
        if (x - blockradius < 0) {
            blockradius = x;
        }
        if (y - blockradius < 0) {
            blockradius = y;
        }
        if (x + blockradius > raster.getWidth() - 1) {
            blockradius = raster.getWidth() - 1 - x;
        }
        if (y + blockradius > raster.getHeight() - 1) {
            blockradius = raster.getHeight() - 1 - y;
        }
        raster.getPixel(x, y, this.pixel);
        int nucleusValue = this.pixel[0];
        for (int i = x - blockradius; i <= x + blockradius; ++i) {
            for (int j = y - blockradius; j <= y + blockradius; ++j) {
                if (i == x && j == y || !this.mask[i - x + blockradius][j - y + blockradius]) continue;
                raster.getPixel(i, j, this.pixel);
                if (Math.abs(this.pixel[0] - nucleusValue) >= this.uniValueThreshold) continue;
                ++pixelUSAN;
            }
        }
        return pixelUSAN;
    }

    private final boolean[][] generateCircleMask() {
        int size = this.radius * 2 + 1;
        boolean[][] mask = new boolean[size][size];
        this.maxUSAN = 0;
        Ellipse2D.Float circle = new Ellipse2D.Float(0.0f, 0.0f, size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                if (circle.contains(i, j)) {
                    mask[i][j] = true;
                    ++this.maxUSAN;
                    System.out.print(" * ");
                    continue;
                }
                mask[i][j] = false;
                System.out.print(" - ");
            }
            System.out.println();
        }
        return mask;
    }

    private final BufferedImage buildResponseImage() {
        BufferedImage image = new BufferedImage(this.usan.length, this.usan[0].length, 1);
        WritableRaster raster = image.getRaster();
        int[] rgbpixel = new int[3];
        int max = 3 * this.maxUSAN / 4;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                rgbpixel[1] = rgbpixel[2] = 255 - (max - this.usan[i][j]);
                rgbpixel[0] = rgbpixel[2];
                raster.setPixel(i, j, rgbpixel);
            }
        }
        return image;
    }
}

