/*
 * Decompiled with CFR 0.152.
 */
package color;

public class CIELAB {
    static final float luminance = 0.54f;
    static final float xn = 0.31382f;
    static final float yn = 0.331f;
    static final float Yn = 0.54f;
    static final float Xn = 0.51197225f;
    static final float Zn = 0.57944775f;
    static float[] tmp = new float[3];

    public static final float power3(float t) {
        if (t > 0.008856f) {
            return (float)Math.exp(Math.log(t) * 3.0);
        }
        return (t - 0.13793103f) / 7.787f;
    }

    public static final float root3(float t) {
        if (t > CIELAB.power3(0.008856f)) {
            return (float)Math.exp(Math.log(t) / 3.0);
        }
        return 7.787f * t + 0.13793103f;
    }

    public static final void XYZ2CIELAB(float[] xyz, float[] lab) {
        lab[0] = 116.0f * CIELAB.root3(xyz[1] / 0.54f) - 16.0f;
        lab[1] = 500.0f * (CIELAB.root3(xyz[0] / 0.51197225f) - CIELAB.root3(xyz[1] / 0.54f));
        lab[2] = 200.0f * (CIELAB.root3(xyz[1] / 0.54f) - CIELAB.root3(xyz[2] / 0.57944775f));
    }

    public static final void CIELAB2XYZ(float[] lab, float[] xyz) {
        float fy = (lab[0] + 16.0f) / 116.0f;
        xyz[0] = 0.51197225f * CIELAB.power3(lab[1] / 500.0f + fy);
        xyz[1] = 0.54f * CIELAB.power3(fy);
        xyz[2] = 0.57944775f * CIELAB.power3(fy - lab[2] / 200.0f);
    }

    public static final float linear2gamma(float t) {
        return (double)t <= 0.0031308 ? 12.92f * t : (float)(1.055 * Math.exp(Math.log(t) / 2.4) - 0.055);
    }

    public static final float gamma2linear(float t) {
        return (double)t <= 0.04045 ? t / 12.92f : (float)Math.exp(Math.log(((double)t + 0.055) / 1.055) * 2.4);
    }

    public static final void sRGB2XYZ(float[] rgb, float[] xyz) {
        rgb[0] = CIELAB.gamma2linear(rgb[0]);
        rgb[1] = CIELAB.gamma2linear(rgb[1]);
        rgb[2] = CIELAB.gamma2linear(rgb[2]);
        xyz[0] = 0.4124f * rgb[0] + 0.3576f * rgb[1] + 0.1805f * rgb[2];
        xyz[1] = 0.2126f * rgb[0] + 0.7152f * rgb[1] + 0.0722f * rgb[2];
        xyz[2] = 0.0193f * rgb[0] + 0.1192f * rgb[1] + 0.9505f * rgb[2];
    }

    public static final void XYZ2sRGB(float[] xyz, float[] rgb) {
        rgb[0] = 3.241f * xyz[0] - 1.5374f * xyz[1] - 0.4986f * xyz[2];
        rgb[1] = -0.9692f * xyz[0] + 1.876f * xyz[1] + 0.0416f * xyz[2];
        rgb[2] = 0.0556f * xyz[0] - 0.204f * xyz[1] + 1.057f * xyz[2];
        rgb[0] = CIELAB.linear2gamma(rgb[0]);
        rgb[1] = CIELAB.linear2gamma(rgb[1]);
        rgb[2] = CIELAB.linear2gamma(rgb[2]);
    }

    public static final void CIELAB2sRGB(float[] lab, float[] rgb) {
        float[] xyz = new float[3];
        CIELAB.CIELAB2XYZ(lab, xyz);
        CIELAB.XYZ2sRGB(xyz, rgb);
    }

    public static final void sRGB2CIELAB(float[] rgb, float[] lab) {
        float[] xyz = new float[3];
        CIELAB.sRGB2XYZ(rgb, xyz);
        CIELAB.XYZ2CIELAB(xyz, lab);
    }

    public static final float norm(float f) {
        return f / 255.0f;
    }

    public static final int unnorm(float f) {
        return f < 0.0f ? 0 : (f > 1.0f ? 255 : Math.round(f * 255.0f));
    }

    public static final void int2sRGB(int v, float[] rgb) {
        rgb[0] = CIELAB.norm(v >> 16 & 0xFF);
        rgb[1] = CIELAB.norm(v >> 8 & 0xFF);
        rgb[2] = CIELAB.norm(v & 0xFF);
    }

    public static final int sRGB2int(float[] rgb) {
        return CIELAB.unnorm(rgb[0]) << 16 | CIELAB.unnorm(rgb[1]) << 8 | CIELAB.unnorm(rgb[2]);
    }
}

