/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.options;

import java.util.LinkedList;
import net.imagej.ChannelCollection;
import org.scijava.event.SciJavaEvent;
import org.scijava.options.OptionsPlugin;
import org.scijava.options.event.OptionsEvent;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ColorRGB;
import org.scijava.util.Colors;
import org.scijava.util.Prefs;

@Plugin(type=OptionsPlugin.class, menu={@Menu(label="Edit", weight=1.0, mnemonic=101), @Menu(label="Options", mnemonic=111), @Menu(label="Channels...", weight=9.0)}, attrs={@Attr(name="no-legacy")})
public class OptionsChannels
extends OptionsPlugin {
    private static final String LAST_FG_RED = "lastFgColor.red";
    private static final String LAST_FG_GREEN = "lastFgColor.green";
    private static final String LAST_FG_BLUE = "lastFgColor.blue";
    private static final String LAST_BG_RED = "lastBgColor.red";
    private static final String LAST_BG_GREEN = "lastBgColor.green";
    private static final String LAST_BG_BLUE = "lastBgColor.blue";
    @Parameter(label="Foreground values")
    private String fgValuesString = "255,255,255";
    @Parameter(label="Background values")
    private String bgValuesString = "0,0,0";
    private ColorRGB lastFgColor = Colors.WHITE;
    private ColorRGB lastBgColor = Colors.BLACK;
    private ChannelCollection fgValues;
    private ChannelCollection bgValues;

    public ChannelCollection getFgValues() {
        return this.fgValues;
    }

    public ChannelCollection getBgValues() {
        return this.bgValues;
    }

    public void setFgValues(ChannelCollection vals) {
        this.fgValues = vals;
        this.fgValuesString = this.encode(this.fgValues);
    }

    public void setBgValues(ChannelCollection vals) {
        this.bgValues = vals;
        this.bgValuesString = this.encode(this.bgValues);
    }

    public ColorRGB getLastFgColor() {
        return this.lastFgColor;
    }

    public ColorRGB getLastBgColor() {
        return this.lastBgColor;
    }

    public void setLastFgColor(ColorRGB c) {
        this.setLastFgColor(c, true);
    }

    public void setLastFgColor(ColorRGB c, boolean notifyIJ1) {
        this.lastFgColor = c;
        if (notifyIJ1) {
            this.eventService.publish((SciJavaEvent)new OptionsEvent((OptionsPlugin)this));
        }
    }

    public void setLastBgColor(ColorRGB c) {
        this.setLastBgColor(c, true);
    }

    public void setLastBgColor(ColorRGB c, boolean notifyIJ1) {
        this.lastBgColor = c;
        if (notifyIJ1) {
            this.eventService.publish((SciJavaEvent)new OptionsEvent((OptionsPlugin)this));
        }
    }

    public void load() {
        super.load();
        this.fgValues = this.decode(this.fgValuesString);
        this.bgValues = this.decode(this.bgValuesString);
        int r = Prefs.getInt(((Object)((Object)this)).getClass(), (String)LAST_FG_RED, (int)255);
        int g = Prefs.getInt(((Object)((Object)this)).getClass(), (String)LAST_FG_GREEN, (int)255);
        int b = Prefs.getInt(((Object)((Object)this)).getClass(), (String)LAST_FG_BLUE, (int)255);
        this.lastFgColor = new ColorRGB(r, g, b);
        r = Prefs.getInt(((Object)((Object)this)).getClass(), (String)LAST_BG_RED, (int)0);
        g = Prefs.getInt(((Object)((Object)this)).getClass(), (String)LAST_BG_GREEN, (int)0);
        b = Prefs.getInt(((Object)((Object)this)).getClass(), (String)LAST_BG_BLUE, (int)0);
        this.lastBgColor = new ColorRGB(r, g, b);
    }

    public void save() {
        Prefs.put(((Object)((Object)this)).getClass(), (String)LAST_FG_RED, (int)this.lastFgColor.getRed());
        Prefs.put(((Object)((Object)this)).getClass(), (String)LAST_FG_GREEN, (int)this.lastFgColor.getGreen());
        Prefs.put(((Object)((Object)this)).getClass(), (String)LAST_FG_BLUE, (int)this.lastFgColor.getBlue());
        Prefs.put(((Object)((Object)this)).getClass(), (String)LAST_BG_RED, (int)this.lastBgColor.getRed());
        Prefs.put(((Object)((Object)this)).getClass(), (String)LAST_BG_GREEN, (int)this.lastBgColor.getGreen());
        Prefs.put(((Object)((Object)this)).getClass(), (String)LAST_BG_BLUE, (int)this.lastBgColor.getBlue());
        this.cleanStrings();
        super.save();
    }

    private ChannelCollection decode(String channelString) {
        String[] values;
        LinkedList<Double> collection = new LinkedList<Double>();
        for (String value : values = channelString.split(",")) {
            double val;
            try {
                val = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                val = 0.0;
            }
            collection.add(val);
        }
        return new ChannelCollection(collection);
    }

    private String encode(ChannelCollection chans) {
        StringBuilder builder = new StringBuilder();
        long count = chans.getChannelCount();
        for (long i = 0L; i < count; ++i) {
            double value = chans.getChannelValue(i);
            String valString = value == Math.floor(value) ? String.format("%d", (long)value) : String.format("%f", value);
            if (i != 0L) {
                builder.append(",");
            }
            builder.append(valString);
        }
        return builder.toString();
    }

    private void cleanStrings() {
        this.fgValuesString = this.goodFormat(this.fgValuesString) ? this.noWhitespace(this.fgValuesString) : this.encode(this.fgValues);
        this.bgValuesString = this.goodFormat(this.bgValuesString) ? this.noWhitespace(this.bgValuesString) : this.encode(this.bgValues);
    }

    private boolean goodFormat(String valuesString) {
        String[] values;
        for (String value : values = valuesString.split(",")) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private String noWhitespace(String str) {
        StringBuilder builder = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            builder.append(ch);
        }
        return builder.toString();
    }
}

